/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.PolyLine;

public class PolyLineDialog
extends QbDialog {
    ChartMain chartMain;
    PolyLine dLine;
    JRadioButton cbSolid;
    JRadioButton cbDotted;
    JRadioButton cbDash;
    JRadioButton cbCustomize;
    JCheckBox drawStartArrow;
    JCheckBox drawEndArrow;
    JCheckBox fillArea;
    SpinBox sbFill;
    SpinBox sbEmpty;
    SpinBox sbThick;
    JButton okButton;
    JButton cancelButton;
    int lineStyleSave;
    int pointStyleSave;
    int thicknessSave;

    public PolyLineDialog(ChartMain chartMain, PolyLine dLine) {
        super(chartMain, LanguageEncoder.getText("Define Line Style..."), true);
        this.chartMain = chartMain;
        this.dLine = dLine;
        this.lineStyleSave = dLine.getLineStyle();
        this.pointStyleSave = this.lineStyleSave % 256;
        this.thicknessSave = dLine.getThickness();
        this.init();
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel stylePanel = new JPanel(new BorderLayout());
        BorderPanel standardPanel = new BorderPanel(LanguageEncoder.getText("Standard Style"));
        standardPanel.setLayout(new GridLayout(2, 2));
        this.cbSolid = new JRadioButton(LanguageEncoder.getText("Solid"), true);
        standardPanel.add(this.cbSolid);
        this.cbDotted = new JRadioButton(LanguageEncoder.getText("Dotted"), false);
        standardPanel.add(this.cbDotted);
        this.cbDash = new JRadioButton(LanguageEncoder.getText("Dash"), false);
        standardPanel.add(this.cbDash);
        this.cbCustomize = new JRadioButton(LanguageEncoder.getText("Customize"), false);
        standardPanel.add(this.cbCustomize);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.cbSolid);
        bg.add(this.cbDotted);
        bg.add(this.cbDash);
        bg.add(this.cbCustomize);
        this.cbSolid.addItemListener(this);
        this.cbDotted.addItemListener(this);
        this.cbDash.addItemListener(this);
        this.cbCustomize.addItemListener(this);
        stylePanel.add("North", standardPanel);
        BorderPanel customizePanel = new BorderPanel(LanguageEncoder.getText("Customize"));
        customizePanel.setLayout(new GridLayout(2, 2));
        customizePanel.add(new JLabel(LanguageEncoder.getText("Fill pixel")));
        this.sbFill = new SpinBox(0, 255);
        customizePanel.add(this.sbFill);
        customizePanel.add(new JLabel(LanguageEncoder.getText("Empty pixel")));
        this.sbEmpty = new SpinBox(0, 255);
        customizePanel.add(this.sbEmpty);
        stylePanel.add("Center", customizePanel);
        mainPanel.add("North", stylePanel);
        JPanel thicknessPanel = new JPanel();
        thicknessPanel.setLayout(new GridLayout(3, 2));
        thicknessPanel.add(new JLabel(LanguageEncoder.getText("Line thickness")));
        this.sbThick = new SpinBox(1, 100);
        thicknessPanel.add(this.sbThick);
        this.drawStartArrow = new JCheckBox(LanguageEncoder.getText("Show Start Point Arrow"));
        thicknessPanel.add(this.drawStartArrow);
        this.drawEndArrow = new JCheckBox(LanguageEncoder.getText("Show End Point Arrow"));
        thicknessPanel.add(this.drawEndArrow);
        this.fillArea = new JCheckBox(LanguageEncoder.getText("Fill Area"));
        thicknessPanel.add(this.fillArea);
        thicknessPanel.add(new JLabel(""));
        this.fillArea.addItemListener(this);
        mainPanel.add("Center", thicknessPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        mainPanel.add("South", buttonPanel);
        this.initStates();
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            int newStyle = (this.sbFill.getValue() * 256 + this.sbEmpty.getValue()) * 256 + this.pointStyleSave;
            int newThickness = this.sbThick.getValue();
            if (newStyle != this.lineStyleSave || newThickness != this.thicknessSave) {
                this.dLine.setLineStyle(newStyle);
                this.dLine.setThickness(newThickness);
            }
            this.dLine.setArrowAtStartPointVisible(this.drawStartArrow.isSelected());
            this.dLine.setArrowAtEndPointVisible(this.drawEndArrow.isSelected());
            this.dLine.setFillArea(this.fillArea.isSelected());
            this.chartMain.setModified();
            this.chartMain.qbpaint();
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.dLine.getPoints().size() < 3 && this.fillArea.isSelected()) {
            new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show("fillArea cannot be enabled when there     are fewer than 3 points!");
            this.fillArea.setSelected(false);
        } else {
            this.setStates();
        }
    }

    private void initStates() {
        this.sbThick.setValue(this.thicknessSave);
        this.drawStartArrow.setSelected(this.dLine.isArrowAtStartPointVisible());
        this.drawEndArrow.setSelected(this.dLine.isArrowAtEndPointVisible());
        this.fillArea.setSelected(this.dLine.isFillArea());
        if (this.lineStyleSave == 0) {
            this.cbSolid.setSelected(true);
        } else if (this.lineStyleSave == 1312000) {
            this.cbDash.setSelected(true);
        } else if (this.lineStyleSave == 328960) {
            this.cbDotted.setSelected(true);
        } else {
            this.cbCustomize.setSelected(true);
            int fillValue = this.lineStyleSave / 256 / 256;
            int emptyValue = this.lineStyleSave / 256 % 256;
            this.sbFill.setValue(fillValue);
            this.sbEmpty.setValue(emptyValue);
        }
        this.setStates();
    }

    private void setStates() {
        if (this.cbCustomize.isSelected()) {
            this.sbFill.setEnabled(true);
            this.sbEmpty.setEnabled(true);
        } else {
            this.sbFill.setEnabled(false);
            this.sbEmpty.setEnabled(false);
            int style = -1;
            if (this.cbSolid.isSelected()) {
                style = 0;
                this.pointStyleSave = style % 256;
            } else if (this.cbDash.isSelected()) {
                style = 1312000;
                this.pointStyleSave = style % 256;
            } else if (this.cbDotted.isSelected()) {
                style = 328960;
                this.pointStyleSave = style % 256;
            }
            int fillValue = style / 256 / 256;
            int emptyValue = style / 256 % 256;
            this.sbFill.setValue(fillValue);
            this.sbEmpty.setValue(emptyValue);
        }
        this.sbFill.setEnabled(!this.fillArea.isSelected());
        this.sbEmpty.setEnabled(!this.fillArea.isSelected());
        this.cbSolid.setEnabled(!this.fillArea.isSelected());
        this.cbDash.setEnabled(!this.fillArea.isSelected());
        this.cbDotted.setEnabled(!this.fillArea.isSelected());
        this.cbCustomize.setEnabled(!this.fillArea.isSelected());
        this.sbThick.setEnabled(!this.fillArea.isSelected());
        this.drawStartArrow.setEnabled(!this.fillArea.isSelected());
        this.drawEndArrow.setEnabled(!this.fillArea.isSelected());
    }
}

