/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import quadbase.chart.Axis;
import quadbase.chart.CAnnotation;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.chart.FaceData;
import quadbase.chart.GraphicsTable;
import quadbase.chart.Grid;
import quadbase.chart.HorzVertLine;
import quadbase.chart.MultiDimData;
import quadbase.chart.Ticker;
import quadbase.chart.TrendLine;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.ControlRange;
import quadbase.util.PolyLine;

class PopupMenuForChart
extends JPopupMenu
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(PopupMenuForChart.class.getName());
    protected ChartPanel chartPanel;
    protected ChartMain chartMain;
    protected Object selectobj;
    protected Chart chart;
    protected boolean isReady = false;

    public PopupMenuForChart(ChartPanel chartPanel) {
        this.chartPanel = chartPanel;
    }

    public void addMenu(ChartMain chartMain) {
        this.chartMain = chartMain;
        this.selectobj = this.chartPanel.selectobj;
        this.chart = this.chartPanel.chart;
        this.isReady = false;
        this.removeAll();
        if (this.isData()) {
            this.addDataMenu();
        } else if (this.isBackground()) {
            this.addBackgroundMenu();
        } else if (this.isPlotArea()) {
            this.addPlotAreaMenu();
        } else if (this.isAxis()) {
            this.addAxisMenu();
        } else if (this.isLegend()) {
            this.addLegendMenu();
        } else if (this.isTable()) {
            this.addTableMenu();
        } else if (this.isAnnotation()) {
            this.addAnnotationMenu();
        } else if (this.isTopLabel()) {
            this.addTopLabelMenu();
        } else if (this.isTrendLine()) {
            this.addTrendLineMenu();
        } else if (this.isHVLine()) {
            this.addHVLineMenu();
        } else if (this.isControlLine()) {
            this.addControlLineMenu();
        } else if (this.isControlArea()) {
            this.addControlAreaMenu();
        } else if (this.isPolyLine()) {
            this.addPolyLineMenu();
        } else {
            this.addBackgroundMenu();
        }
        this.isReady = true;
    }

    private void addDataMenu() {
        if (this.isChartOptionEnabled()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Chart Options"), "ChartOptions"));
        }
        this.add(this.newMenuItem(LanguageEncoder.getText("Data Properties"), "DataProperties"));
        if (this.chart.chartType != 12) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Data Order"), "DataOrder"));
        }
        if (this.is2DChart()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Line And Points"), "LineAndPoints"));
        }
        this.addSeparator();
        this.add(this.newMenuItem(LanguageEncoder.getText("Insert Link"), "HyperLink"));
        if (!TrendLine.invalidchart(this.chart)) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Insert TrendLine"), "InsertTrendLine"));
        }
        if (!HorzVertLine.invalidchart(this.chart)) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Insert Horz/Vert Line"), "InsertHVLine"));
        }
        if (this.chart.isControlRangeEnabled()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Insert Control Area"), "InsertControlArea"));
        }
        this.addSeparator();
        this.add(this.newMenuItem(LanguageEncoder.getText("Rendering Options"), "Rendering"));
        if (!this.is2DChart()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("3D Display Options"), "3DDisplay"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Lighting Options"), "LightingOptions"));
        }
        if (this.isBackEnabled()) {
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Back"), "Back"));
        }
    }

    private void addBackgroundMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Insert Title"), "InsertTitle"));
        this.add(this.newMenuItem(LanguageEncoder.getText("Insert Text"), "InsertText"));
        this.add(this.newMenuItem(LanguageEncoder.getText("Insert Line"), "InsertLine"));
        this.add(this.newMenuItem(LanguageEncoder.getText("Insert Table"), "InsertTable"));
        this.addSeparator();
        this.add(this.newMenuItem(LanguageEncoder.getText("Canvas Properties"), "CanvasProperties"));
        if (this.is2DChart()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Plot Area Properties"), "PlotAreaProperties"));
        }
        this.add(this.newMenuItem(LanguageEncoder.getText("Text Properties"), "TextProperties"));
        this.addSeparator();
        this.add(this.newMenuItem(LanguageEncoder.getText("Rendering Options"), "Rendering"));
        if (!this.is2DChart()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("3D Display Options"), "3DDisplay"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Lighting Options"), "LightingOptions"));
        }
        if (this.isBackEnabled()) {
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Back"), "Back"));
        }
    }

    private void addPlotAreaMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Plot Area"), "PlotAreaProperties"));
        if (this.isChartOptionEnabled()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Chart Options"), "ChartOptions"));
        }
        this.addSeparator();
        if (TrendLine.invalidchart(this.chart)) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Insert TrendLine"), "InsertTrendLine"));
        }
        if (HorzVertLine.invalidchart(this.chart)) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Insert Horz/Vert Line"), "InsertHVLine"));
        }
        if (this.chart.isControlRangeEnabled()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Insert Control Area"), "InsertControlArea"));
        }
        this.addSeparator();
        this.add(this.newMenuItem(LanguageEncoder.getText("Rendering Options"), "Rendering"));
        if (!this.is2DChart()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("3D Display Options"), "3DDisplay"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Lighting Options"), "LightingOptions"));
        }
        if (this.isBackEnabled()) {
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Back"), "Back"));
        }
    }

    private void addAxisMenu() {
        if (this.isAxisScaleEnabled()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Axis Scale"), "AxisScale"));
        } else if (this.chart.chartType != 12) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Data Order"), "DataOrder"));
        }
        this.add(this.newMenuItem(LanguageEncoder.getText("Axis Properties"), "AxisProperties"));
        this.addSeparator();
        if (!this.is2DChart()) {
            if (HorzVertLine.invalidchart(this.chart)) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Insert Horz/Vert Line"), "HVLine"));
                this.addSeparator();
            }
            if (this.isChartOptionEnabled()) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Chart Options"), "ChartOptions"));
            }
            this.add(this.newMenuItem(LanguageEncoder.getText("Rendering Options"), "Rendering"));
            this.add(this.newMenuItem(LanguageEncoder.getText("3D Display Options"), "3DDisplay"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Lighting Options"), "LightingOptions"));
            if (this.isBackEnabled()) {
                this.addSeparator();
                this.add(this.newMenuItem(LanguageEncoder.getText("Back"), "Back"));
            }
        }
    }

    private void addLegendMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Legend Properties"), "LegendProperties"));
    }

    private void addTableMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Table Properties"), "TableProperties"));
    }

    private void addTopLabelMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Data Properties"), "DataProperties"));
    }

    private void addAnnotationMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Edit Text"), "EditText"));
    }

    private void addTrendLineMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Edit TrendLine"), "EditTrendLine"));
    }

    private void addHVLineMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Edit Horz/Vert Line"), "EditHVLine"));
    }

    private void addControlLineMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Edit Control Line"), "EditControlLine"));
    }

    private void addPolyLineMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Edit PolyLine"), "EditPolyLine"));
    }

    private void addControlAreaMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Edit Control Area"), "EditControlArea"));
    }

    private boolean isChartOptionEnabled() {
        if (!this.chart.is2DimChart() && !this.chart.isCircularChart() && this.chart.chartType != 10 && this.chart.chartType != 0) {
            return false;
        }
        if (this.chart.isCircularChart()) {
            return true;
        }
        if (this.chart.chartType == 10 && this.chart.comboType == 3) {
            return true;
        }
        if (this.chart.chartType == 10) {
            if (this.chart.getComboType() == 0 && this.chart.getSubValueMap() != -1) {
                return true;
            }
            return true;
        }
        if (this.chart.chartType == 0 && this.chart.dataDim == 2) {
            return true;
        }
        if (this.chart.chartType == 13) {
            return true;
        }
        if (this.chart.chartType == 17) {
            return true;
        }
        if (this.chart.chartType == 19) {
            return true;
        }
        if (this.chart.chartType == 16) {
            return true;
        }
        if (this.chart.chartType == 18) {
            return true;
        }
        if (this.chart.chartType == 15) {
            return true;
        }
        if (this.chart.chartType == 2) {
            return true;
        }
        if (this.chart.chartType == 3) {
            return this.chart.dataDim >= 2 && this.chart.mDataLen[0] >= 2 || this.chart.dataDim == 1;
        }
        if (this.chart.getComboType() == 0 && this.chart.getSubValueMap() != -1 && this.chart.getChartType() != 8 && this.chart.chartType != 14) {
            return true;
        }
        if (this.chart.chartType == 8 && this.chart.comboType == 3) {
            return true;
        }
        if (this.chart.chartType == 8 && this.chart.comboType == 0) {
            return true;
        }
        if (this.chart.chartType == 14) {
            return true;
        }
        if (this.chart.comboType == 3) {
            return true;
        }
        return this.chart.getChartType() == 8 || this.chart.getComboType() == 1;
    }

    private boolean isData() {
        return this.selectobj instanceof MultiDimData || this.selectobj instanceof FaceData;
    }

    private boolean isLegend() {
        return this.isLegend1() || this.isLegend2();
    }

    private boolean isLegend1() {
        return this.selectobj == this.chartPanel.chart.legend.area || this.selectobj == this.chartPanel.chart.legend.framearea || this.selectobj == this.chartPanel.chart.legend;
    }

    private boolean isLegend2() {
        return this.selectobj == this.chartPanel.chart.legend2.area || this.selectobj == this.chartPanel.chart.legend2.framearea || this.selectobj == this.chartPanel.chart.legend2;
    }

    private boolean isPlotArea() {
        return this.selectobj == this.chart.background || this.selectobj == this.chart.border;
    }

    private boolean isBackground() {
        return !this.isData() && !this.isLegend() && !this.isPlotArea() && !this.isTable() && !this.isAnnotation() && !this.isTopLabel() && !this.isAxis();
    }

    private boolean isTable() {
        return this.selectobj instanceof GraphicsTable;
    }

    private boolean isAnnotation() {
        return this.selectobj instanceof CAnnotation;
    }

    private boolean isTrendLine() {
        return this.selectobj instanceof TrendLine;
    }

    private boolean isHVLine() {
        return this.selectobj instanceof HorzVertLine;
    }

    private boolean isControlLine() {
        return this.selectobj instanceof ControlLine;
    }

    private boolean isControlArea() {
        return this.selectobj instanceof ControlRange;
    }

    private boolean isPolyLine() {
        return this.selectobj instanceof PolyLine;
    }

    private boolean isTopLabel() {
        return this.isTopLabel1() || this.isTopLabel2();
    }

    private boolean isTopLabel1() {
        return this.selectobj == this.chart.topLabels;
    }

    private boolean isTopLabel2() {
        return this.selectobj == this.chart.topLabels2;
    }

    private boolean isAxis() {
        for (int i = 0; i < 4; ++i) {
            if (this.selectobj != this.chart.axis[i]) continue;
            return true;
        }
        if ((this.chart.getChartType() == 14 || this.chart.colDataAxis != null) && this.chart.colDataAxis != null) {
            for (Axis colDataAxi : this.chart.colDataAxis) {
                if (colDataAxi == null || this.selectobj != colDataAxi) continue;
                return true;
            }
        }
        if (this.selectobj instanceof Ticker) {
            return true;
        }
        return this.selectobj instanceof Grid;
    }

    private boolean isAxisScaleEnabled() {
        if (this.selectobj instanceof Axis) {
            return ((Axis)this.selectobj).stepsize != null;
        }
        if (this.selectobj instanceof Ticker) {
            return ((Ticker)this.selectobj).axis.stepsize != null;
        }
        return false;
    }

    private int getAxisIndex() {
        int i;
        if (this.chart.getChartType() == 19) {
            return 0;
        }
        for (i = 0; i < 4; ++i) {
            if (this.selectobj != this.chart.axis[i] && this.selectobj != this.chart.axis[i].ticker) continue;
            return i;
        }
        if (this.chart.getChartType() == 14 || this.chart.colDataAxis != null) {
            for (i = 0; i < this.chart.colDataAxis.length; ++i) {
                if (this.chart.colDataAxis[i] == null || this.selectobj != this.chart.colDataAxis[i] && this.selectobj != this.chart.colDataAxis[i].ticker) continue;
                return i + 4;
            }
        }
        return 0;
    }

    private boolean isBackEnabled() {
        return this.chartMain.isGoBackLinkEnabled() || this.chartMain.isPreviousDrillDownEnabled();
    }

    private boolean is2DChart() {
        return this.chart.is2DChart;
    }

    private JMenuItem newMenuItem(String s, String command) {
        JMenuItem m = new JMenuItem(s);
        m.setActionCommand(command);
        m.addActionListener(this);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        this.chartMain.createBackupChart();
        String cmd = e.getActionCommand();
        if (cmd.equals("InsertTable")) {
            this.chartMain.do_TableDirection();
        } else if (cmd.equals("LegendProperties")) {
            if (this.isLegend1()) {
                this.chartMain.do_Legend(this.chart.legend);
            } else if (this.isLegend2()) {
                this.chartMain.do_Legend(this.chart.legend2);
            }
        } else if (cmd.equals("Back")) {
            if (this.chartMain.isPreviousDrillDownEnabled()) {
                this.chartMain.previousDrillDown();
            } else if (this.chartMain.isGoBackLinkEnabled()) {
                this.chartMain.do_goback();
            }
        } else if (cmd.equals("ChartOptions")) {
            this.chartMain.do_ChartOption();
        } else if (cmd.equals("TableProperties")) {
            this.chartMain.do_TableDirection();
        } else if (cmd.equals("DataProperties")) {
            this.chartMain.do_DataProp();
        } else if (cmd.equals("DataOrder")) {
            int idx = this.getAxisIndex();
            if (idx == 0) {
                idx = -1;
            }
            this.chartMain.do_DataOrder(idx);
        } else if (cmd.equals("LineAndPoints")) {
            this.chartMain.do_PointLine();
        } else if (cmd.equals("HyperLink")) {
            this.chartMain.do_DefineHyperLink(this.chart.pickdata, false);
        } else if (cmd.equals("EditTrendLine")) {
            this.chartMain.do_DefineTrendLine((TrendLine)this.selectobj);
        } else if (cmd.equals("EditHVLine")) {
            this.chartMain.do_DefineHorzVertLine((HorzVertLine)this.selectobj);
        } else if (cmd.equals("EditControlLine")) {
            this.chartMain.do_DefineHorzVertLine((ControlLine)this.selectobj);
        } else if (cmd.equals("EditControlArea")) {
            this.chartMain.do_DefineControlRange((ControlRange)this.selectobj);
        } else if (cmd.equals("EditPolyLine")) {
            this.chartMain.do_PointLine();
        } else if (cmd.equals("InsertTrendLine")) {
            this.chartMain.do_DefineTrendLine();
        } else if (cmd.equals("InsertHVLine")) {
            this.chartMain.do_DefineHorzVertLine();
        } else if (cmd.equals("InsertControlArea")) {
            this.chartMain.do_DefineControlRange();
        } else if (cmd.equals("Rendering")) {
            this.chartMain.do_RenderingOption();
        } else if (cmd.equals("3DDisplay")) {
            this.chartMain.do_3DOption();
        } else if (cmd.equals("LightingOptions")) {
            this.chartMain.do_Lightmodel();
        } else if (cmd.equals("InsertTitle")) {
            this.chartMain.do_Titles();
        } else if (cmd.equals("InsertText")) {
            this.chartMain.do_Text();
        } else if (cmd.equals("InsertLine")) {
            this.chartMain.do_AddLine();
        } else if (cmd.equals("CanvasProperties")) {
            this.chartMain.do_CanvasSize();
        } else if (cmd.equals("PlotAreaProperties")) {
            this.chartMain.do_PlotArea();
        } else if (cmd.equals("TextProperties")) {
            this.chartMain.do_TextProperties();
        } else if (cmd.equals("AxisScale")) {
            this.chartMain.do_AxisDialog(this.getAxisIndex());
        } else if (cmd.equals("AxisProperties")) {
            this.chartMain.do_FormatValue(this.getAxisIndex());
        } else if (cmd.equals("EditText")) {
            this.chartMain.do_Text((CAnnotation)this.selectobj);
        } else {
            LOGGER.finest("ActionPerform:" + cmd);
        }
    }
}

