/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartPanel;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.IByPassSaveAsForChart;
import quadbase.chart.designer.IChartIO;
import quadbase.chart.designer.InitPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.MessageDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDebug;
import quadbase.datasourcemanager.manager.DataSourceManagerListener;

public class QbChartDesigner {
    private static final Logger LOGGER = Logger.getLogger(QbChartDesigner.class.getName());
    private ChartMain chartMain;
    private boolean openFile = false;
    private boolean init = false;
    private boolean newChart = false;
    private boolean exitOnCancel = false;
    private String userName = "";
    private String password = "";
    private boolean isLogin = false;

    public static void setDebugMode(int mode) {
        QbDebug.setDebugMode(mode);
    }

    public static void setDebugMode(String mode) {
        QbDebug.setDebugMode(mode);
    }

    public QbChartDesigner(Object parent, ChartMain chartMain) {
        this.chartMain = chartMain;
        this.init = true;
    }

    public QbChartDesigner(Object parent) {
        this(parent, (String)null);
    }

    public QbChartDesigner(Object parent, String chtFile) {
        this(parent, null, null);
    }

    public QbChartDesigner(Object parent, String chtFile, String[] imagesPath) {
        if (imagesPath != null && imagesPath.length == 2) {
            if (!imagesPath[0].endsWith("/")) {
                imagesPath[0] = imagesPath[0] + "/";
            }
            if (!imagesPath[1].endsWith("/")) {
                imagesPath[1] = imagesPath[1] + "/";
            }
            ServerMessage.imagesPath = imagesPath[0];
            ServerMessage.backgroundImagesPath = imagesPath[1];
        }
        if (ServerMessage.getParent() == null) {
            ServerMessage.useServer = true;
            ServerMessage.setParent(parent);
        }
        this.startProgram();
        if (this.chartMain == null) {
            return;
        }
        if (chtFile != null && this.chartMain.do_openChart(chtFile)) {
            this.openFile = true;
        }
    }

    public QbChartDesigner(Object parent, DBInfoBasic dbInfo, boolean newChart) {
        this(parent, dbInfo, null, newChart);
    }

    public QbChartDesigner(Object parent, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newChart) {
        this(parent, dbInfo, null, newChart, null);
    }

    public QbChartDesigner(Object parent, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newChart, String[] imagesPath) {
        if (imagesPath != null && imagesPath.length == 2) {
            if (!imagesPath[0].endsWith("/")) {
                imagesPath[0] = imagesPath[0] + "/";
            }
            if (!imagesPath[1].endsWith("/")) {
                imagesPath[1] = imagesPath[1] + "/";
            }
            ServerMessage.imagesPath = imagesPath[0];
            ServerMessage.backgroundImagesPath = imagesPath[1];
        }
        if (ServerMessage.getParent() == null) {
            ServerMessage.useServer = true;
            ServerMessage.setParent(parent);
        }
        this.startProgram();
        if (this.chartMain == null) {
            return;
        }
        this.chartMain.setPresetDBInfo(dbInfo);
        this.chartMain.setPresetQueryInParamSet(inSet);
        this.newChart = newChart;
    }

    public QbChartDesigner(Object parent, String dataRegistry, boolean newChart) {
        this(parent, dataRegistry, newChart, null);
    }

    public QbChartDesigner(Object parent, String dataRegistry, boolean newChart, String[] imagesPath) {
        if (imagesPath != null && imagesPath.length == 2) {
            if (!imagesPath[0].endsWith("/")) {
                imagesPath[0] = imagesPath[0] + "/";
            }
            if (!imagesPath[1].endsWith("/")) {
                imagesPath[1] = imagesPath[1] + "/";
            }
            ServerMessage.imagesPath = imagesPath[0];
            ServerMessage.backgroundImagesPath = imagesPath[1];
        }
        ServerMessage.useServer = true;
        ServerMessage.setParent(parent);
        this.startProgram();
        if (this.chartMain == null) {
            return;
        }
        this.chartMain.setPresetDataRegistry(dataRegistry);
        this.newChart = newChart;
    }

    public void setDataRegistry(String dataRegistry) {
        this.chartMain.setPresetDataRegistry(dataRegistry);
    }

    public void setChartIO(IChartIO chartIO) {
        this.chartMain.setChartIO(chartIO);
    }

    public void setByPassSaveAsIO(IByPassSaveAsForChart saveAsIO) {
        this.chartMain.setByPassSaveAsIO(saveAsIO);
    }

    private void startProgram() {
        try {
            this.chartMain = new ChartMain(new ChartPanel(null));
            this.chartMain.setQbChartDesigner(this);
            this.chartMain.init();
            this.chartMain.setLoginUser(this.userName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Cannot start program!", ex);
            new MessageDialog(ServerMessage.getFrame(), LanguageEncoder.getText("Error")).show(ex.toString());
        }
    }

    public JFrame getDesigner() {
        if (!this.isLogin()) {
            return null;
        }
        if (!this.openFile && !this.init) {
            ChartWizard wizard = new ChartWizard(this.chartMain, this.chartMain.getPresetDBInfo(), this.chartMain.getPresetQueryInParamSet(), this.newChart, false, this.exitOnCancel);
            wizard.init();
            if (!this.newChart || this.chartMain.getPresetDBInfo() != null) {
                wizard.setVisible(true);
            }
            this.init = true;
        }
        return this.chartMain;
    }

    public void setVisible(boolean b) {
        if (!this.isLogin()) {
            return;
        }
        this.chartMain.setVisible(b);
        if (b && !this.openFile && !this.init) {
            ChartWizard wizard = new ChartWizard(this.chartMain, this.chartMain.getPresetDBInfo(), this.chartMain.getPresetQueryInParamSet(), this.newChart);
            wizard.init();
            if (!this.newChart || this.chartMain.getPresetDataRegistry() == null) {
                wizard.setVisible(true);
            }
            wizard.toFront();
            this.init = true;
        }
    }

    public void login(String userName, String password) {
        if (userName != null) {
            this.userName = userName;
        }
        if (password != null) {
            this.password = password;
        }
    }

    public void login(String designerPassword) {
        this.login("", designerPassword);
    }

    private boolean isLogin() {
        if (this.isLogin) {
            return false;
        }
        String errStr = null;
        try {
            errStr = InitPanel.login(this.userName, this.password, false, true, null);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Log in failed", ex);
            errStr = ex.toString();
        }
        if (errStr != null) {
            new MessageDialog(ServerMessage.getFrame(), LanguageEncoder.getText("Error")).show(errStr);
            return false;
        }
        this.isLogin = true;
        return true;
    }

    void cleanup() {
        try {
            InitPanel.logoutFromServer(false, true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't log out from server", ex);
        }
    }

    public void setRootDirectoryForBrowse(String browseRoot) {
        BrowseDialog.setPresetDirectory(browseRoot);
        BrowseDialog.setGoUpEnabled(ServerMessage.isAdmin());
    }

    public BrowseDirectories getBrowseDirectories() {
        return this.chartMain.getBrowseDirectories();
    }

    public JMenuBar getChartMenuBar() {
        return this.chartMain.menubar;
    }

    public JToolBar getChartToolBar() {
        return this.chartMain.toolbar;
    }

    public void dispose() {
        this.chartMain.dispose();
    }

    public void saveAs() {
        this.chartMain.do_SaveAs();
    }

    public void save() {
        this.chartMain.onDocSave();
    }

    public void save(String fileLocation) {
        this.chartMain.do_saveChart(fileLocation, false, 0, false, false);
    }

    public boolean exit() throws Exception {
        return this.chartMain.do_exit();
    }

    public void setExitOnCancel(boolean state) {
        this.exitOnCancel = state;
    }

    public boolean isExitOnCancel() {
        return this.exitOnCancel;
    }

    public void setSaveOnExitEnabled(boolean b) {
        this.chartMain.setSaveOnExitEnabled(b);
    }

    public boolean isSaveOnExitEnabled() {
        return this.chartMain.isSaveOnExitEnabled();
    }

    public void setDefaultParamNames(String[] names) {
        this.chartMain.setDefaultParamNames(names);
    }

    public String[] getDefaultParamNames() {
        return this.chartMain.getDefaultParamNames();
    }

    public void addDataSourceManagerListener(DataSourceManagerListener listener) {
        this.chartMain.addDataSourceManagerListener(listener);
    }

    public void removeDataSourceManagerListener(DataSourceManagerListener listener) {
        this.chartMain.removeDataSourceManagerListener(listener);
    }

    public static void setServerAddress(String address) throws UnknownHostException {
        ServerMessage.setAddress(address);
    }

    public static void setServerPortNumber(int port) {
        ServerMessage.setPortNumber(port);
    }

    public static void setServerHosts(Vector hostnames) {
        ServerMessage.setHosts(hostnames);
    }

    public static void setServletContext(String context) {
        ServerMessage.setServletContext(context);
    }

    public static String getServletContext() {
        return ServerMessage.getServletContext();
    }

    public static void setServletRunner(String comm_url) {
        ServerMessage.setConnectServlet(comm_url);
    }

    public static void useServlet(boolean b) {
        if (b) {
            ServerMessage.useServlet();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static void setImagePath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ServerMessage.imagesPath = path;
    }

    public static void setBackgroundImagePath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ServerMessage.backgroundImagesPath = path;
    }
}

