/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class RadarDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(RadarDialog.class.getName());
    JCheckBox checkSynchronizeAllAxes;
    JCheckBox checkCircularGrid;
    JTextField cutOffPointField;
    boolean synAxes = true;
    boolean circularGrid = false;
    Double cutOffPt = null;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;

    public RadarDialog(JFrame frame, Chart chart) {
        super(frame, LanguageEncoder.getText("Radar Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        BorderPanel mainPanel = new BorderPanel(LanguageEncoder.getText("Radar Options"));
        mainPanel.setLayout(new BorderLayout());
        this.checkSynchronizeAllAxes = new JCheckBox(LanguageEncoder.getText("Synchronize All Axes"));
        mainPanel.add("North", this.checkSynchronizeAllAxes);
        this.checkCircularGrid = new JCheckBox(LanguageEncoder.getText("Draw Circular Grid"));
        mainPanel.add("Center", this.checkCircularGrid);
        this.checkSynchronizeAllAxes.addItemListener(this);
        JPanel cutOffPanel = new JPanel(new FlowLayout(0));
        cutOffPanel.add(new JLabel(LanguageEncoder.getText("Cut Off Point:")));
        this.cutOffPointField = new JTextField(5);
        cutOffPanel.add(this.cutOffPointField);
        mainPanel.add("South", cutOffPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.getValues();
    }

    private void getValues() {
        this.synAxes = this.chart.isSynchronizeRadarAxis();
        this.cutOffPt = this.chart.getAreaCutOffPoint();
        this.checkSynchronizeAllAxes.setSelected(this.synAxes);
        if (this.synAxes) {
            this.circularGrid = this.chart.isDrawCircularGrid();
            this.checkCircularGrid.setSelected(this.circularGrid);
            this.cutOffPt = this.chart.getAreaCutOffPoint();
            if (this.cutOffPt != null) {
                this.cutOffPointField.setText("" + this.cutOffPt);
            } else {
                this.cutOffPointField.setText("N/A");
            }
        }
        this.itemStateChanged(null);
    }

    private void setValues() {
        this.chart.setSynchronizeRadarAxis(this.checkSynchronizeAllAxes.isSelected());
        if (this.checkSynchronizeAllAxes.isSelected()) {
            this.chart.setDrawCircularGrid(this.checkCircularGrid.isSelected());
            String tmp = this.cutOffPointField.getText();
            if (tmp == null || tmp.trim().equals("")) {
                this.chart.setAreaCutOffPoint(null);
            } else {
                try {
                    this.chart.setAreaCutOffPoint(Double.parseDouble(tmp));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINEST, "Area cutoff point: invalid number", ex);
                    this.chart.setAreaCutOffPoint(null);
                }
            }
        }
    }

    private boolean isModified() {
        String tmp = this.cutOffPointField.getText();
        double val = 0.0;
        if (tmp != null) {
            try {
                val = Double.parseDouble(tmp);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Invalid number", ex);
                tmp = null;
            }
        }
        if (tmp == null && this.cutOffPt != null || tmp != null && this.cutOffPt == null) {
            return true;
        }
        if (tmp != null && val != this.cutOffPt) {
            return true;
        }
        return this.checkSynchronizeAllAxes.isSelected() != this.synAxes || this.checkCircularGrid.isSelected() != this.circularGrid;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.checkCircularGrid.setEnabled(this.checkSynchronizeAllAxes.isSelected());
        this.cutOffPointField.setEnabled(this.checkSynchronizeAllAxes.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            if (this.isModified()) {
                this.setValues();
                this.chartMain.setModified();
                this.chartMain.qbpaint();
            }
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

