/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import quadbase.chart.ColData;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.QueryResultPanel;
import quadbase.chart.designer.YAStatusBar;
import quadbase.common.client.FileInfo;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbBrowseDirectories;
import quadbase.common.util.internal.QbUtil;

public class RecordFrame
extends JFrame
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(RecordFrame.class.getName());
    static final int TABLESIZE = 20;
    JPanel switchPanel;
    JPanel someDataPanel;
    JPanel allDataPanel;
    CardLayout card;
    JCheckBox showAllCheckbox;
    JButton okButton;
    JButton exportButton;
    YAStatusBar statusBar;
    ChartMain chartMain;
    ColData[] colData;
    boolean showingSomeData;

    public RecordFrame(ChartMain chartMain, String title, ColData[] colData) {
        super(title);
        this.chartMain = chartMain;
        this.colData = colData;
        this.setBackground(Color.lightGray);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(new EmptyBorder(10, 10, 5, 10));
        contentPane.setLayout(new BorderLayout());
        this.card = new CardLayout();
        this.switchPanel = new JPanel(this.card);
        boolean bl = this.showingSomeData = colData[0].getSize() > 20;
        if (this.showingSomeData) {
            this.someDataPanel = new QueryResultPanel(colData, 20);
            this.switchPanel.add("colDataSome", this.someDataPanel);
        } else {
            this.someDataPanel = new QueryResultPanel(colData);
            this.switchPanel.add("colDataAll", this.someDataPanel);
        }
        contentPane.add("Center", this.switchPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel butpanel = new JPanel();
        butpanel.setLayout(new FlowLayout(2));
        if (this.showingSomeData) {
            this.showAllCheckbox = new JCheckBox(LanguageEncoder.getText("Show All Records"), false);
            butpanel.add(this.showAllCheckbox);
            this.showAllCheckbox.addItemListener(this);
        }
        this.exportButton = new JButton(LanguageEncoder.getText("Export to CSV"));
        butpanel.add(this.exportButton);
        this.exportButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("Close"));
        butpanel.add(this.okButton);
        this.okButton.addActionListener(this);
        bottomPanel.add("Center", butpanel);
        if (this.showingSomeData) {
            this.statusBar = new YAStatusBar();
            this.statusBar.setDelay(30000L);
            bottomPanel.add("South", this.statusBar);
        }
        contentPane.add("South", bottomPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RecordFrame.this.close();
            }
        });
        this.centerFrame();
    }

    private void centerFrame() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 480);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.okButton) {
            this.close();
        } else if (target == this.exportButton) {
            this.exportToCSV();
        }
    }

    private void close() {
        this.chartMain.recordFrame = null;
        this.setVisible(false);
        this.dispose();
    }

    private void exportToCSV() {
        QbBrowseDirectories browseDir = new QbBrowseDirectories();
        String[] ext = new String[]{"CSV"};
        OpenFileDialog fDialog = new OpenFileDialog(this, LanguageEncoder.getText("Export..."), browseDir.getQueryExportDir(), ext, browseDir.getQueryExportDir(), true);
        fDialog.setVisible(true);
        String tmp = fDialog.getSelectedFile();
        if (tmp == null) {
            return;
        }
        try {
            tmp = new FileInfo(tmp).getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        browseDir.setQueryExportDir(fDialog.getCurrentDirectory());
        try {
            QbUtil.exportDataFile(tmp, 1, 0, this.colData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean showState;
        this.disableComponents();
        boolean bl = showState = this.showAllCheckbox != null && this.showAllCheckbox.isSelected() || !this.showingSomeData;
        if (showState && this.allDataPanel == null) {
            this.showBuildMessage();
            try {
                this.allDataPanel = new QueryResultPanel(this.colData);
                this.switchPanel.add("colDataAll", this.allDataPanel);
            }
            catch (Error er) {
                LOGGER.log(Level.FINE, "Cannot build table", er);
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Cannot build table") + "\n" + er.toString());
                this.setVisible(false);
                this.dispose();
                return;
            }
        }
        if (showState) {
            this.card.show(this.switchPanel, "colDataAll");
        } else {
            this.card.show(this.switchPanel, "colDataSome");
        }
        this.enableComponents();
    }

    private void enableComponents() {
        this.showAllCheckbox.setEnabled(true);
        this.okButton.setEnabled(true);
        this.exportButton.setEnabled(true);
        this.statusBar.showHint("");
    }

    private void disableComponents() {
        this.showAllCheckbox.setEnabled(false);
        this.okButton.setEnabled(false);
        this.exportButton.setEnabled(false);
    }

    private void showBuildMessage() {
        this.statusBar.showHint(LanguageEncoder.getText("Building table, please wait..."));
    }
}

