/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.GradientDialog;
import quadbase.chart.designer.IGradientDialog;
import quadbase.common.swing.ArrowSlideBar;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class RenderingDialog
extends QbDialog
implements IGradientDialog {
    ChartMain chartMain;
    JButton okButton;
    JButton cancelButton;
    JButton gradientOption;
    JButton gradientOption2;
    JCheckBox enableAntiAlias;
    JRadioButton chartAndText;
    JRadioButton chartOnly;
    JCheckBox enableGradient;
    JCheckBox enableGradient2;
    JCheckBox isAdjustFont;
    JCheckBox checkTranslucent;
    ArrowSlideBar translucentValue;
    GradientDialog gradientDialog;
    GradientDialog gradientDialog2;
    boolean enable3DShading = false;

    public RenderingDialog(ChartMain parent, String title) {
        super(parent, title, true);
        this.chartMain = parent;
        this.init();
    }

    private void init() {
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        BorderPanel aliasPanel = new BorderPanel(LanguageEncoder.getText("Anti-Alias"));
        aliasPanel.setLayout(new GridLayout(2, 0));
        this.enableAntiAlias = new JCheckBox(LanguageEncoder.getText("Enable Anti-Alias"), this.chartMain.chart.isAntiAliasEnabled());
        this.enableAntiAlias.addItemListener(this);
        aliasPanel.add(this.enableAntiAlias);
        JPanel simplePanel = new JPanel();
        simplePanel.setLayout(new FlowLayout(0));
        this.chartAndText = new JRadioButton(LanguageEncoder.getText("Chart and Text"), true);
        simplePanel.add(this.chartAndText);
        this.chartOnly = new JRadioButton(LanguageEncoder.getText("Chart Only"), false);
        simplePanel.add(this.chartOnly);
        ButtonGroup gp1 = new ButtonGroup();
        gp1.add(this.chartAndText);
        gp1.add(this.chartOnly);
        if (this.chartMain.chart.setAntiAliasForChartOnly) {
            this.chartOnly.setSelected(true);
        }
        aliasPanel.add(simplePanel);
        this.chartOnly.setEnabled(this.enableAntiAlias.isSelected());
        this.chartAndText.setEnabled(this.enableAntiAlias.isSelected());
        BorderPanel adjustFontPanel = new BorderPanel(LanguageEncoder.getText("Adjust Font"));
        adjustFontPanel.setLayout(new FlowLayout(0));
        this.isAdjustFont = new JCheckBox(LanguageEncoder.getText("Adjust Font"), this.chartMain.chart.isAdjustFont());
        adjustFontPanel.add(this.isAdjustFont);
        BorderPanel transPanel = new BorderPanel(LanguageEncoder.getText("Translucent"));
        transPanel.setLayout(new GridLayout(2, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(0));
        this.checkTranslucent = new JCheckBox(LanguageEncoder.getText("Set Translucent"), this.chartMain.chart.isTranslucent());
        panel1.add(this.checkTranslucent);
        this.checkTranslucent.setSelected(this.chartMain.chart.isTranslucent());
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(0));
        panel2.add(new JLabel(LanguageEncoder.getText("0%")));
        this.translucentValue = new ArrowSlideBar(0.0, 1.0, true);
        panel2.add(this.translucentValue);
        this.translucentValue.setFValue(this.chartMain.chart.getTranslucentValue());
        this.translucentValue.setEnabled(this.checkTranslucent.isSelected());
        this.checkTranslucent.addItemListener(this);
        panel2.add(new JLabel(LanguageEncoder.getText("100%")));
        transPanel.add(panel1);
        transPanel.add(panel2);
        BorderPanel gradientPanel = new BorderPanel(LanguageEncoder.getText("Gradient"));
        gradientPanel.setLayout(new BoxLayout(gradientPanel, 1));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout(0));
        this.gradientOption = new JButton(LanguageEncoder.getText("Customize..."));
        this.enableGradient2 = new JCheckBox(LanguageEncoder.getText("Enable Gradient Secondary Data"), this.chartMain.chart.getSecondaryDataGradientSupport().isGradientEnabled());
        this.gradientOption2 = new JButton(LanguageEncoder.getText("Customize..."));
        this.enableGradient2.addItemListener(this);
        this.gradientOption2.setEnabled(this.enableGradient2.isSelected());
        if (this.chartMain.chart.mData2 != null) {
            this.enableGradient = new JCheckBox(LanguageEncoder.getText("Enable Gradient For Primary Data"), this.chartMain.chart.getPrimaryDataGradientSupport().isGradientEnabled());
            JPanel subPanel1 = new JPanel();
            subPanel1.setLayout(new GridLayout(2, 1, 1, 1));
            subPanel1.add(this.enableGradient);
            subPanel1.add(this.enableGradient2);
            JPanel subPanel2 = new JPanel();
            subPanel2.setLayout(new GridLayout(2, 1, 1, 1));
            subPanel2.add(this.gradientOption);
            subPanel2.add(this.gradientOption2);
            panel3.add(subPanel1);
            panel3.add(subPanel2);
        } else {
            this.enableGradient = new JCheckBox(LanguageEncoder.getText("Enable Gradient"), this.chartMain.chart.getPrimaryDataGradientSupport().isGradientEnabled());
            panel3.add(this.enableGradient);
            panel3.add(this.gradientOption);
        }
        this.enableGradient.addItemListener(this);
        this.gradientOption.setEnabled(this.enableGradient.isSelected());
        gradientPanel.add(panel3);
        if (this.chartMain.chart.is2DChart) {
            this.enable3DShading = this.chartMain.chart.getChartType() == 1 || this.chartMain.chart.getChartType() == 0 || this.chartMain.chart.getChartType() == 4 || this.chartMain.chart.getChartType() == 5 || this.chartMain.chart.getChartType() == 11;
        }
        this.gradientOption.addActionListener(this);
        this.gradientOption2.addActionListener(this);
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(aliasPanel);
        newPanel.add(adjustFontPanel);
        int chartType = this.chartMain.chart.getChartType();
        if (!this.chartMain.chart.is2DimChart() || this.chartMain.chart.dataDim > 1 && (chartType == 7 || chartType == 14 || chartType == 16 || chartType == 18)) {
            newPanel.add(transPanel);
        }
        newPanel.add(gradientPanel);
        cop.add("Center", newPanel);
        cop.add("South", buttonPanel);
        this.itemStateChanged(null);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void resetGradientDialog() {
        this.gradientDialog = null;
    }

    @Override
    public double getGradientStartX() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().getGradientStartX();
    }

    @Override
    public double getGradientStartY() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().getGradientStartY();
    }

    @Override
    public double getGradientEndX() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().getGradientEndX();
    }

    @Override
    public double getGradientEndY() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().getGradientEndY();
    }

    @Override
    public Color getGradientDesColor() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().getGradientDesColor();
    }

    @Override
    public int getGradientShade() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().getGradientShade();
    }

    @Override
    public boolean isGradientCyclic() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().isGradientCyclic();
    }

    @Override
    public boolean is3DShadingEnabled() {
        return this.chartMain.chart.getPrimaryDataGradientSupport().is3DShadingEnabled();
    }

    @Override
    public boolean isGradientEnabled() {
        return true;
    }

    @Override
    public void setValues(GradientDialog gDialog) {
        this.chartMain.chart.getPrimaryDataGradientSupport().setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.chartMain.chart.getPrimaryDataGradientSupport().setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.chartMain.chart.getPrimaryDataGradientSupport().setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.chartMain.chart.getPrimaryDataGradientSupport().setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.chartMain.chart.getPrimaryDataGradientSupport().setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.chartMain.chart.getPrimaryDataGradientSupport().setGradientDesColor(null);
        } else {
            this.chartMain.chart.getPrimaryDataGradientSupport().setGradientDesColor(gDialog.getButtonColor());
        }
        this.chartMain.chart.getPrimaryDataGradientSupport().setGradientCyclic(gDialog.checkCyclic.isSelected());
        if (this.enable3DShading) {
            this.chartMain.chart.getPrimaryDataGradientSupport().set3DShadingEnabled(gDialog.enable3DShading.isSelected());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.chartOnly.setEnabled(this.enableAntiAlias.isSelected());
        this.chartAndText.setEnabled(this.enableAntiAlias.isSelected());
        this.translucentValue.setEnabled(this.checkTranslucent.isSelected());
        this.gradientOption.setEnabled(this.enableGradient.isSelected());
        this.gradientOption2.setEnabled(this.enableGradient2.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.chartMain.chart.setAntiAliasEnabled(this.enableAntiAlias.isSelected());
            this.chartMain.chart.setAntiAliasForChartOnly = this.chartOnly.isSelected();
            this.chartMain.chart.setAdjustFont(this.isAdjustFont.isSelected());
            this.chartMain.chart.getPrimaryDataGradientSupport().setGradientEnabled(this.enableGradient.isSelected());
            if (this.chartMain.chart.mData2 != null) {
                this.chartMain.chart.getSecondaryDataGradientSupport().setGradientEnabled(this.enableGradient2.isSelected());
            }
            this.chartMain.chart.setTranslucent(this.checkTranslucent.isSelected());
            this.chartMain.chart.setTranslucentValue(this.translucentValue.getFValue());
            if (this.gradientDialog != null) {
                this.gradientDialog.setValues();
            }
            if (this.gradientDialog2 != null) {
                this.gradientDialog2.setValues();
            }
            this.chartMain.setGouraudButtonEnabled();
            this.chartMain.setModified();
        } else {
            if (e.getSource() == this.gradientOption) {
                if (this.gradientDialog == null) {
                    this.gradientDialog = new GradientDialog(this.chartMain, this, "Gradient Options", this.enable3DShading);
                }
                this.gradientDialog.setVisible(true);
                return;
            }
            if (e.getSource() == this.gradientOption2) {
                if (this.gradientDialog2 == null) {
                    this.gradientDialog2 = new GradientDialog(this.chartMain, new SecondaryData(), "Gradient Options");
                }
                this.gradientDialog2.setVisible(true);
                return;
            }
        }
        this.chartMain.chart.newSurface();
        this.chartMain.invalidateLegend();
        this.chartMain.chartPanel.repaint();
        this.dispose();
    }

    public class SecondaryData
    implements IGradientDialog {
        @Override
        public void setValues(GradientDialog gDialog) {
            RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientStartX((double)gDialog.startX.getValue() / 100.0);
            RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientStartY((double)gDialog.startY.getValue() / 100.0);
            RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientEndX((double)gDialog.endX.getValue() / 100.0);
            RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientEndY((double)gDialog.endY.getValue() / 100.0);
            if (gDialog.shading.isSelected()) {
                RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
                RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientDesColor(null);
            } else {
                RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientDesColor(gDialog.getButtonColor());
            }
            RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().setGradientCyclic(gDialog.checkCyclic.isSelected());
            if (RenderingDialog.this.enable3DShading) {
                RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().set3DShadingEnabled(gDialog.enable3DShading.isSelected());
            }
        }

        @Override
        public void resetGradientDialog() {
            RenderingDialog.this.gradientDialog2 = null;
        }

        @Override
        public double getGradientStartX() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().getGradientStartX();
        }

        @Override
        public double getGradientStartY() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().getGradientStartY();
        }

        @Override
        public double getGradientEndX() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().getGradientEndX();
        }

        @Override
        public double getGradientEndY() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().getGradientEndY();
        }

        @Override
        public Color getGradientDesColor() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().getGradientDesColor();
        }

        @Override
        public int getGradientShade() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().getGradientShade();
        }

        @Override
        public boolean isGradientCyclic() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().isGradientCyclic();
        }

        @Override
        public boolean is3DShadingEnabled() {
            return RenderingDialog.this.chartMain.chart.getSecondaryDataGradientSupport().is3DShadingEnabled();
        }

        @Override
        public boolean isGradientEnabled() {
            return true;
        }
    }
}

