/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.designer.ChartWizard;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class SaveQueryFileDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(SaveQueryFileDialog.class.getName());
    ChartWizard wizard;
    QueryFileInfo queryFileInfo;
    boolean hasError;
    String queryFilename = "";
    JTextField tf;
    JButton okButton;
    JButton cancelButton;

    public SaveQueryFileDialog(ChartWizard wizard, QueryFileInfo queryFileInfo) {
        super(QbDialog.findFrame(wizard), LanguageEncoder.getText("Saving Query File (*.qry)"), true);
        this.wizard = wizard;
        this.queryFileInfo = queryFileInfo;
        this.setBackground(Color.lightGray);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel filenamePanel = new JPanel(new FlowLayout(0));
        filenamePanel.add(new JLabel(LanguageEncoder.getText("Filename:")));
        this.tf = new JTextField(wizard.queryFilename, 42);
        filenamePanel.add(this.tf);
        this.tf.addActionListener(this);
        mainPanel.add("North", filenamePanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        mainPanel.add("South", buttonPanel);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", mainPanel);
        Dimension screensize = this.getToolkit().getScreenSize();
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
    }

    public String getQueryFilename() {
        return this.queryFilename;
    }

    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton || source == this.tf) {
            this.saveQueryFileInfo();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.hasError = this.wizard.queryFilename == null || this.wizard.queryFilename.equals("");
        }
    }

    private void saveQueryFileInfo() {
        this.queryFilename = "";
        this.hasError = false;
        String filename = "";
        try {
            filename = this.tf.getText().trim();
            if (filename.equals("")) {
                new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter a filename"));
                return;
            }
            if (!filename.endsWith(".qry")) {
                filename = filename + ".qry";
            }
            if (!OverWriteDialog.continueSave(this.wizard.chartmain, filename)) {
                this.hasError = true;
                return;
            }
            this.queryFileInfo.saveFile(filename);
        }
        catch (Exception ex) {
            this.hasError = true;
            LOGGER.log(Level.FINE, "Cannot save file: " + filename, ex);
            String message = LanguageEncoder.getText("Cannot save file") + " " + filename + " \n " + ex.toString();
            new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show(message);
            return;
        }
        this.queryFilename = filename;
        this.setVisible(false);
    }
}

