/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class ScheduleDialog
extends QbDialog {
    SpinBox spinhour;
    SpinBox spinminute;
    SpinBox spinsecond;
    JCheckBox chkbox;
    JButton okButton;
    JButton cancelButton;
    ChartMain chartmain;
    boolean isListenerEnabled = true;

    public ScheduleDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.setBackground(Color.lightGray);
        this.chartmain = frame;
        this.spinhour = new SpinBox(0, 240);
        this.spinminute = new SpinBox(0, 60);
        this.spinsecond = new SpinBox(0, 60);
        this.chkbox = new JCheckBox(LanguageEncoder.getText("Disable Scheduler"));
        this.chkbox.addItemListener(this);
        JPanel paneltime = new JPanel();
        JPanel panelbutton = new JPanel();
        paneltime.setLayout(new GridLayout(2, 3));
        panelbutton.setLayout(new FlowLayout(2));
        paneltime.add(new JLabel(LanguageEncoder.getText("hour")));
        paneltime.add(new JLabel(LanguageEncoder.getText("minute")));
        paneltime.add(new JLabel(LanguageEncoder.getText("second")));
        paneltime.add(this.spinhour);
        paneltime.add(this.spinminute);
        paneltime.add(this.spinsecond);
        BorderPanel centerpanel = new BorderPanel(LanguageEncoder.getText("Interval between data refresh"));
        centerpanel.setLayout(new BorderLayout());
        JPanel spanel = new JPanel();
        spanel.add("West", paneltime);
        spanel.add("Center", new JLabel("   "));
        centerpanel.add("North", spanel);
        centerpanel.add("South", this.chkbox);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        panelbutton.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        panelbutton.add(this.cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", centerpanel);
        cop.add("South", panelbutton);
        this.setSize(250, 200);
        this.spinsecond.requestFocus();
        long interval = this.chartmain.chart.refreshInterval / 1000L;
        long hour = interval / 3600L;
        this.spinhour.setValue((int)hour);
        this.spinminute.setValue((int)((interval - hour * 3600L) / 60L));
        this.spinsecond.setValue((int)(interval % 60L));
        this.setState(this.chartmain.chart.disableSchedule);
    }

    private void setState(boolean disable) {
        if (!this.isListenerEnabled) {
            return;
        }
        this.isListenerEnabled = false;
        this.chkbox.setSelected(disable);
        this.chartmain.chart.disableSchedule = disable;
        boolean b = !disable;
        this.spinhour.setEnabled(b);
        this.spinminute.setEnabled(b);
        this.spinsecond.setEnabled(b);
        this.isListenerEnabled = true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
        }
        super.setVisible(b);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setState(this.chkbox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
        if (e.getSource() == this.okButton) {
            this.chartmain.chart.refreshInterval = ((this.spinhour.getValue() * 60 + this.spinminute.getValue()) * 60 + this.spinsecond.getValue()) * 1000;
        }
    }
}

