/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.GradientDialog;
import quadbase.chart.designer.IGradientDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class SizeDialog
extends QbDialog
implements DocumentListener,
IGradientDialog {
    private static final Logger LOGGER = Logger.getLogger(SizeDialog.class.getName());
    ChartMain chartMain;
    JButton okButton;
    JButton cancelButton;
    JRadioButton[] checkbox;
    JRadioButton[] unitbox;
    JTextField twidth;
    JTextField theight;
    JCheckBox enableGradient;
    JButton gradientOption;
    int width;
    int height;
    int widthSave;
    int heightSave;
    int scrollOption;
    int displayUnit;
    JCheckBox maintainRatio;
    double ratio;
    GradientDialog gradientDialog;

    public SizeDialog(ChartMain parent, int w, int h) {
        super(parent, LanguageEncoder.getText("Canvas Option"), true);
        this.chartMain = parent;
        this.widthSave = this.width = w;
        this.heightSave = this.height = h;
        this.scrollOption = this.chartMain.chartPanel.scrollBarOption;
        this.displayUnit = this.chartMain.displayUnit;
        this.init();
    }

    void init() {
        this.setBackground(Color.lightGray);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        BorderPanel sizeBorderPanel = new BorderPanel(LanguageEncoder.getText("Canvas Size"));
        sizeBorderPanel.setLayout(new BorderLayout());
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new GridLayout(2, 2, 5, 5));
        sizePanel.add(new JLabel(LanguageEncoder.getText("Width :")));
        this.twidth = new JTextField(this.width + "", 5);
        sizePanel.add(this.twidth);
        this.twidth.getDocument().addDocumentListener(this);
        sizePanel.add(new JLabel(LanguageEncoder.getText("Height :")));
        this.theight = new JTextField(this.height + "", 5);
        sizePanel.add(this.theight);
        this.theight.getDocument().addDocumentListener(this);
        sizeBorderPanel.add("Center", sizePanel);
        JPanel unitPanel = new JPanel();
        this.unitbox = new JRadioButton[3];
        ButtonGroup unitGroup = new ButtonGroup();
        this.unitbox[0] = new JRadioButton(LanguageEncoder.getText("Pixel"), true);
        this.unitbox[1] = new JRadioButton(LanguageEncoder.getText("Inch"), false);
        this.unitbox[2] = new JRadioButton(LanguageEncoder.getText("Cm"), false);
        unitGroup.add(this.unitbox[0]);
        unitGroup.add(this.unitbox[1]);
        unitGroup.add(this.unitbox[2]);
        this.unitbox[0].addItemListener(this);
        this.unitbox[1].addItemListener(this);
        this.unitbox[2].addItemListener(this);
        unitPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        unitPanel.add((Component)this.unitbox[0], c);
        c.insets = new Insets(5, 20, 0, 20);
        c.gridx = 1;
        unitPanel.add((Component)this.unitbox[1], c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridx = 2;
        unitPanel.add((Component)this.unitbox[2], c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 1;
        this.maintainRatio = new JCheckBox("Maintain Ratio");
        unitPanel.add((Component)this.maintainRatio, c);
        this.maintainRatio.setSelected(true);
        try {
            this.ratio = (double)this.width / (double)this.height;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Ratio: Invalid number, using 0", ex);
            this.ratio = 0.0;
        }
        this.maintainRatio.addItemListener(this);
        sizeBorderPanel.add("South", unitPanel);
        BorderPanel checkBorderPanel = new BorderPanel(LanguageEncoder.getText("Display Scroll Bar"));
        checkBorderPanel.setLayout(new BorderLayout());
        JPanel checkPanel = new JPanel();
        this.checkbox = new JRadioButton[3];
        this.checkbox[0] = new JRadioButton(LanguageEncoder.getText("As Needed"), true);
        this.checkbox[1] = new JRadioButton(LanguageEncoder.getText("Always"), false);
        this.checkbox[2] = new JRadioButton(LanguageEncoder.getText("Never"), false);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.checkbox[0]);
        bg2.add(this.checkbox[1]);
        bg2.add(this.checkbox[2]);
        this.checkbox[0].addItemListener(this);
        this.checkbox[1].addItemListener(this);
        this.checkbox[2].addItemListener(this);
        checkPanel.setLayout(new GridLayout(3, 1, 5, 5));
        checkPanel.add(this.checkbox[0]);
        checkPanel.add(this.checkbox[1]);
        checkPanel.add(this.checkbox[2]);
        checkBorderPanel.add("Center", checkPanel);
        BorderPanel gradientPanel = new BorderPanel(LanguageEncoder.getText("Gradient"));
        gradientPanel.setLayout(new FlowLayout(0));
        this.enableGradient = new JCheckBox(LanguageEncoder.getText("Enable Gradient"), this.chartMain.chart.desktopArea.isGradientEnabled());
        this.gradientOption = new JButton(LanguageEncoder.getText("Customize..."));
        this.enableGradient.addItemListener(this);
        this.gradientOption.setEnabled(this.enableGradient.isSelected());
        gradientPanel.add(this.enableGradient);
        gradientPanel.add(this.gradientOption);
        this.gradientOption.addActionListener(this);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BoxLayout(cop, 1));
        cop.add(sizeBorderPanel);
        cop.add(checkBorderPanel);
        cop.add(gradientPanel);
        cop.add(buttonPanel);
        this.updateText();
        this.setUnitBox();
        this.setCheckBox();
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void resetGradientDialog() {
        this.gradientDialog = null;
    }

    @Override
    public double getGradientStartX() {
        return this.chartMain.chart.desktopArea.getGradientStartX();
    }

    @Override
    public double getGradientStartY() {
        return this.chartMain.chart.desktopArea.getGradientStartY();
    }

    @Override
    public double getGradientEndX() {
        return this.chartMain.chart.desktopArea.getGradientEndX();
    }

    @Override
    public double getGradientEndY() {
        return this.chartMain.chart.desktopArea.getGradientEndY();
    }

    @Override
    public Color getGradientDesColor() {
        return this.chartMain.chart.desktopArea.getGradientDesColor();
    }

    @Override
    public int getGradientShade() {
        return this.chartMain.chart.desktopArea.getGradientShade();
    }

    @Override
    public boolean isGradientCyclic() {
        return this.chartMain.chart.desktopArea.isGradientCyclic();
    }

    void setCheckBox() {
        if (this.scrollOption == 0) {
            this.checkbox[0].setSelected(true);
        } else if (this.scrollOption == 1) {
            this.checkbox[1].setSelected(true);
        } else if (this.scrollOption == 2) {
            this.checkbox[2].setSelected(true);
        }
    }

    private void setUnitBox() {
        if (this.displayUnit == 0) {
            this.unitbox[0].setSelected(true);
        } else if (this.displayUnit == 1) {
            this.unitbox[1].setSelected(true);
        } else if (this.displayUnit == 2) {
            this.unitbox[2].setSelected(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.gradientOption.setEnabled(this.enableGradient.isSelected());
        Object target = e.getSource();
        if (target == this.checkbox[0]) {
            this.scrollOption = 0;
        } else if (target == this.checkbox[1]) {
            this.scrollOption = 1;
        } else if (target == this.checkbox[2]) {
            this.scrollOption = 2;
        } else if (target == this.unitbox[0]) {
            this.displayUnit = 0;
            this.updateText();
        } else if (target == this.unitbox[1]) {
            this.displayUnit = 1;
            this.updateText();
        } else if (target == this.unitbox[2]) {
            this.displayUnit = 2;
            this.updateText();
        } else if (target == this.maintainRatio) {
            if (this.maintainRatio.isSelected()) {
                try {
                    double w = Double.parseDouble(this.twidth.getText());
                    double h = Double.parseDouble(this.theight.getText());
                    this.ratio = w / h;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Ratio: invalid number, using 0", ex);
                    this.ratio = 0.0;
                }
            } else {
                this.ratio = 0.0;
            }
        }
    }

    @Override
    public void setValues(GradientDialog gDialog) {
        this.chartMain.chart.desktopArea.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.chartMain.chart.desktopArea.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.chartMain.chart.desktopArea.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.chartMain.chart.desktopArea.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.chartMain.chart.desktopArea.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.chartMain.chart.desktopArea.setGradientDesColor(null);
        } else {
            this.chartMain.chart.desktopArea.setGradientDesColor(gDialog.getButtonColor());
        }
        this.chartMain.chart.desktopArea.setGradientCyclic(gDialog.checkCyclic.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.okButton) {
            this.processTextField(this.twidth);
            this.processTextField(this.theight);
            String msg = null;
            if (this.width <= 0) {
                msg = LanguageEncoder.getText("Error: Invalid width input!");
            }
            if (this.height <= 0) {
                msg = LanguageEncoder.getText("Error: Invalid height input!");
            }
            if (msg != null) {
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(msg);
                return;
            }
            if (this.width != this.widthSave || this.height != this.heightSave) {
                this.chartMain.setModified();
                this.chartMain.chartPanel.chart.newSurface();
                this.chartMain.chartPanel.setSize(this.width, this.height, true);
                this.chartMain.chartPanel.update();
            }
            if (this.chartMain.chartPanel.scrollBarOption != this.scrollOption) {
                this.chartMain.setModified();
                this.chartMain.chartPanel.chart.setScrollBarOption(this.scrollOption);
                this.chartMain.chart = this.chartMain.chartPanel.chart;
                this.chartMain.setChartPanel(this.chartMain.chart);
            }
            if (this.enableGradient.isEnabled()) {
                this.chartMain.chart.desktopArea.setGradientEnabled(this.enableGradient.isSelected());
            } else {
                this.chartMain.chart.desktopArea.setGradientEnabled(false);
            }
            if (this.gradientDialog != null) {
                this.gradientDialog.setValues();
            }
            if (this.chartMain.displayUnit != this.displayUnit) {
                this.chartMain.displayUnit = this.displayUnit;
                this.chartMain.sizelabel.repaint();
            }
            this.chartMain.chart.newSurface();
            this.chartMain.invalidateLegend();
            this.chartMain.chartPanel.repaint();
        } else if (e.getSource() == this.gradientOption) {
            if (this.gradientDialog == null) {
                this.gradientDialog = new GradientDialog(this.chartMain, this, "Gradient Options");
            }
            this.gradientDialog.setVisible(true);
            return;
        }
        this.dispose();
    }

    private void updateText() {
        if (this.displayUnit == 0) {
            this.twidth.setText(Integer.valueOf(this.width).toString());
            this.theight.setText(Integer.valueOf(this.height).toString());
        } else if (this.displayUnit == 1) {
            this.twidth.setText(quadbase.util.internal.QbUtil.roundUp(QbUtil.toInch(this.width)) + "");
            this.theight.setText(quadbase.util.internal.QbUtil.roundUp(QbUtil.toInch(this.height)) + "");
        } else {
            this.twidth.setText(quadbase.util.internal.QbUtil.roundUp(QbUtil.toInch(this.width) * 2.54) + "");
            this.theight.setText(quadbase.util.internal.QbUtil.roundUp(QbUtil.toInch(this.height) * 2.54) + "");
        }
    }

    private void processTextField(JTextField txt) {
        try {
            int newvalue = 0;
            double dblvalue = Double.valueOf(txt.getText());
            newvalue = this.displayUnit == 0 ? (int)dblvalue : (this.displayUnit == 1 ? QbUtil.toPixel(dblvalue) : QbUtil.toPixel(dblvalue / 2.54));
            if (newvalue < 1 || newvalue > 10000) {
                txt.setText(Integer.valueOf(txt == this.twidth ? this.width : this.height).toString());
            } else if (txt == this.twidth) {
                this.width = newvalue;
            } else {
                this.height = newvalue;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error processing text field. Invalid number?", ex);
            txt.setText(Integer.valueOf(txt == this.twidth ? this.width : this.height).toString());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doUpdate(e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doUpdate(DocumentEvent e) {
        if (this.twidth == null || this.theight == null || this.ratio == 0.0) {
            return;
        }
        if (e.getDocument() == this.twidth.getDocument()) {
            try {
                if (e.getDocument().getText(0, e.getDocument().getLength()) == null || e.getDocument().getText(0, e.getDocument().getLength()).equals("")) return;
                String numStr = e.getDocument().getText(0, e.getDocument().getLength());
                double orgval = Double.parseDouble(numStr);
                double val = orgval / this.ratio;
                if ((int)val == 0) {
                    val = 1.0;
                }
                if (this.displayUnit == 0) {
                    this.theight.setText("" + (int)val);
                    return;
                }
                this.theight.setText("" + quadbase.util.internal.QbUtil.roundUp(val));
                return;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't get height value", ex);
                return;
            }
        }
        if (e.getDocument() != this.theight.getDocument()) return;
        try {
            if (e.getDocument().getText(0, e.getDocument().getLength()) == null || e.getDocument().getText(0, e.getDocument().getLength()).equals("")) return;
            String numStr = e.getDocument().getText(0, e.getDocument().getLength());
            double orgval = Double.parseDouble(numStr);
            double val = orgval * this.ratio;
            if ((int)val == 0) {
                val = 1.0;
            }
            if (this.displayUnit == 0) {
                this.twidth.setText("" + (int)val);
                return;
            } else {
                this.twidth.setText("" + quadbase.util.internal.QbUtil.roundUp(val));
            }
            return;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't get width value", ex);
            return;
        }
    }

    @Override
    public boolean is3DShadingEnabled() {
        return false;
    }

    @Override
    public boolean isGradientEnabled() {
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doUpdate(e);
    }
}

