/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class SizeLabel
extends JPanel {
    ChartMain chartmain;
    int h = 10;
    int w = 90;

    public SizeLabel(ChartMain chartmain) {
        this.chartmain = chartmain;
        Font f = new Font("Default", 0, 12);
        FontMetrics fm = this.getFontMetrics(f);
        if (fm.stringWidth("size : 99999x99999") > this.w) {
            this.w = fm.stringWidth("size : 99999x99999");
        }
        if (fm.getHeight() + 3 > this.h) {
            this.h = fm.getHeight() + 3;
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.black);
        if (this.chartmain.displayUnit == 0) {
            g.drawString(LanguageEncoder.getText("size:") + " " + this.chartmain.chartPanel.width + "x" + this.chartmain.chartPanel.height + " " + LanguageEncoder.getText("Pixel"), 0, 10);
        } else if (this.chartmain.displayUnit == 1) {
            String strWidth = Double.valueOf(QbUtil.toInch(this.chartmain.chartPanel.width)).toString();
            String strHeight = Double.valueOf(QbUtil.toInch(this.chartmain.chartPanel.height)).toString();
            int tmpInt = strWidth.indexOf(46);
            tmpInt = tmpInt + 3 > strWidth.length() ? strWidth.length() : tmpInt + 3;
            strWidth = strWidth.substring(0, tmpInt);
            tmpInt = strHeight.indexOf(46);
            tmpInt = tmpInt + 3 > strHeight.length() ? strHeight.length() : tmpInt + 3;
            strHeight = strHeight.substring(0, tmpInt);
            g.drawString(LanguageEncoder.getText("size:") + " " + strWidth + "x" + strHeight + LanguageEncoder.getText("Inch"), 0, 10);
        } else {
            String strWidth = Double.valueOf(QbUtil.toInch(this.chartmain.chartPanel.width) * 2.54).toString();
            String strHeight = Double.valueOf(QbUtil.toInch(this.chartmain.chartPanel.height) * 2.54).toString();
            int tmpInt = strWidth.indexOf(46);
            tmpInt = tmpInt + 3 > strWidth.length() ? strWidth.length() : tmpInt + 3;
            strWidth = strWidth.substring(0, tmpInt);
            tmpInt = strHeight.indexOf(46);
            tmpInt = tmpInt + 3 > strHeight.length() ? strHeight.length() : tmpInt + 3;
            strHeight = strHeight.substring(0, tmpInt);
            g.drawString(LanguageEncoder.getText("size:") + " " + strWidth + "x" + strHeight + LanguageEncoder.getText("cm"), 0, 10);
        }
    }

    public void setSize() {
        this.paint(this.getGraphics());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.w, this.h);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

