/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class StackAreaPanel
extends BorderPanel {
    JComboBox[] choice;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;
    JCheckBox[] hideArea;

    public StackAreaPanel(JFrame frame, Chart chart) {
        super(LanguageEncoder.getText("Stack Area Options"));
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setLayout(new GridLayout(0, 2, 5, 5));
        boolean[] hide = this.chart.getHideDataItems(this.chart.mDataMap[1]);
        Object[] fieldName = this.chart.colData[this.chart.mDataMap[1]].getFieldName();
        this.hideArea = new JCheckBox[hide.length];
        for (int i = 0; i < hide.length; ++i) {
            this.add(new JLabel(fieldName[i].toString()));
            this.hideArea[i] = new JCheckBox(LanguageEncoder.getText("Hide Area"), hide[i]);
            this.add(this.hideArea[i]);
        }
    }

    public void setValues() {
        boolean[] hide = new boolean[this.hideArea.length];
        for (int i = 0; i < this.hideArea.length; ++i) {
            hide[i] = this.hideArea[i].isSelected();
        }
        this.chart.setHideDataItems(this.chart.mDataMap[1], hide);
        this.chartMain.invalidateLegend();
    }
}

