/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Coordinate;
import quadbase.chart.HiLowData;
import quadbase.chart.HiLowMap;
import quadbase.chart.MultiDimData;
import quadbase.chart.PlotData;

public class TableResultPanel
extends JPanel {
    static final String headstr = "HEADING";
    static final String contentstr = "CONTENT";
    static final String[] axisName = new String[]{"X", "Y", "Z"};
    MultiDimData rootData;

    public TableResultPanel(Chart chart, MultiDimData root) {
        this.rootData = root;
        if (chart.chartType == 19) {
            if (chart.dataDim == 1) {
                this.show_polar(chart);
            } else {
                this.show_series_polar(chart);
            }
        } else if (Chart.isCoordinateType(chart.chartType)) {
            if (chart.dataDim == 1) {
                this.show_scatter(chart);
            } else {
                this.show_series_scatter(chart);
            }
        } else if (chart.isHiLow() && root == chart.mData) {
            if (chart.dataDim == 1) {
                this.show_hilow(chart);
            } else {
                this.show_series_hilow(chart);
            }
        } else if (chart.getChartType() == 15 && root == chart.mData) {
            this.show_boxData(chart);
        } else {
            switch (this.rootData.chart.dataDim) {
                case 1: {
                    this.show_category(this.rootData.chart);
                    break;
                }
                case 2: {
                    if (chart.isStackType()) {
                        this.show_series_category2(this.rootData.chart);
                        break;
                    }
                    this.show_series_category(this.rootData.chart);
                    break;
                }
                case 3: {
                    this.show_sum_series_category(this.rootData.chart);
                    break;
                }
            }
        }
    }

    private Vector<String> setHeadingColumn(String firstname, Object[] names) {
        return this.setHeadingColumn(firstname, names, false);
    }

    private Vector<String> setHeadingColumn(String firstname, Object[] names, boolean isSum) {
        Vector<String> tmp = new Vector<String>();
        tmp.addElement(firstname);
        for (Object name2 : names) {
            tmp.addElement(name2.toString());
        }
        if (isSum) {
            tmp.addElement(" Sum ");
        }
        return tmp;
    }

    private Vector<String> setContentColumn(String firstname, MultiDimData[] data) {
        return this.setContentColumn(firstname, data, false, 0);
    }

    private Vector<String> setContentColumn(String firstname, MultiDimData[] data, boolean isSum) {
        return this.setContentColumn(firstname, data, isSum, 0);
    }

    private Vector<String> setContentColumn(String firstname, MultiDimData[] data, boolean isSum, int valueType) {
        Vector<String> row = new Vector<String>();
        row.addElement(firstname);
        double sumValue = 0.0;
        String rec = "";
        for (MultiDimData element : data) {
            PlotData pd = element.plotData;
            if (pd.isEmpty()) {
                row.addElement(null);
                continue;
            }
            double val = pd.getValue(valueType);
            rec = val + "";
            sumValue += val;
            row.addElement(rec);
        }
        if (isSum) {
            rec = sumValue + "";
            row.addElement(rec);
        }
        return row;
    }

    private JTable setTableAttr(JTable table) {
        table.setCellSelectionEnabled(true);
        table.getTableHeader().setReorderingAllowed(false);
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        DefaultCellEditor noEditor = new DefaultCellEditor(notEditableField);
        table.setCellEditor(noEditor);
        MyRenderer myRenderer = new MyRenderer();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).setCellRenderer(myRenderer);
            table.getColumnModel().getColumn(i).setCellEditor(noEditor);
        }
        table.setAutoResizeMode(0);
        return table;
    }

    private void show_category(Chart chart) {
        ColData cdata = chart.colData[chart.mDataMap[0]];
        Vector<String> name = this.setHeadingColumn(cdata.getName(), cdata.fieldName);
        if (chart.getPieGroupOthersLimit() > 0.0 && chart.isCircularChart()) {
            name.removeElementAt(name.size() - 1);
        }
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        data.addElement(this.setContentColumn(chart.colData[chart.valueCol].getName(), this.rootData.multiData));
        JTable table = new JTable(data, name);
        table.setGridColor(Color.lightGray);
        table = this.setTableAttr(table);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(table);
        scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", scroller);
    }

    private void show_series_category(Chart chart) {
        int i;
        ColData cdata = chart.colData[chart.mDataMap[1]];
        ColData cdata2 = chart.colData[chart.mDataMap[0]];
        Vector<String> name = this.setHeadingColumn(cdata2.getName() + " \\ " + cdata.getName(), cdata.fieldName);
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        int len = chart.mDataLen[0];
        if (chart.getPieGroupOthersLimit() > 0.0 && chart.isCircularChart()) {
            --len;
        }
        if (chart.getChartType() == 14) {
            for (i = 0; i < len; ++i) {
                data.addElement(this.setContentColumn(cdata2.fieldName[i].toString(), this.rootData.multiData[i].multiData, false, 0));
            }
        } else {
            for (i = 0; i < len; ++i) {
                data.addElement(this.setContentColumn(cdata2.fieldName[i].toString(), this.rootData.multiData[i].multiData));
            }
        }
        JTable table = new JTable(data, name);
        table.setGridColor(Color.lightGray);
        table = this.setTableAttr(table);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(table);
        scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", scroller);
    }

    private void show_boxData(Chart chart) {
        ColData cdata = chart.colData[chart.mDataMap[0]];
        Vector<String> name = this.setHeadingColumn(cdata.getName(), cdata.fieldName);
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        data.addElement(this.setContentColumn("MIN", this.rootData.multiData, false, 2));
        data.addElement(this.setContentColumn("25%", this.rootData.multiData, false, 3));
        data.addElement(this.setContentColumn("50%", this.rootData.multiData, false, 4));
        data.addElement(this.setContentColumn("75%", this.rootData.multiData, false, 5));
        data.addElement(this.setContentColumn("MAX", this.rootData.multiData, false, 1));
        JTable table = new JTable(data, name);
        table.setGridColor(Color.lightGray);
        table = this.setTableAttr(table);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(table);
        scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", scroller);
    }

    private void show_series_category2(Chart chart) {
        ColData cdata = chart.colData[chart.mDataMap[1]];
        ColData cdata2 = chart.colData[chart.mDataMap[0]];
        Vector<String> name = this.setHeadingColumn(cdata2.getName() + " \\ " + cdata.getName(), cdata.fieldName, true);
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        for (int i = 0; i < chart.mDataLen[0]; ++i) {
            data.addElement(this.setContentColumn(cdata2.fieldName[i].toString(), this.rootData.multiData[i].multiData, true));
        }
        JTable table = new JTable(data, name);
        table.setGridColor(Color.lightGray);
        table = this.setTableAttr(table);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(table);
        scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", scroller);
    }

    private void show_sum_series_category(Chart chart) {
        JTabbedPane tabPanel = new JTabbedPane();
        int len = this.rootData.multiData.length;
        ColData seriesCol = chart.colData[chart.mDataMap[0]];
        for (int i = 0; i < len; ++i) {
            ColData cdata = chart.colData[chart.mDataMap[2]];
            ColData cdata2 = chart.colData[chart.mDataMap[1]];
            Vector<String> name = this.setHeadingColumn(cdata2.getName() + " \\ " + cdata.getName(), cdata.fieldName, true);
            Vector<Vector<String>> data = new Vector<Vector<String>>();
            for (int j = 0; j < chart.mDataLen[1]; ++j) {
                data.addElement(this.setContentColumn(cdata2.fieldName[j].toString(), this.rootData.multiData[i].multiData[j].multiData, true));
            }
            JTable table = new JTable(data, name);
            table.setGridColor(Color.lightGray);
            table = this.setTableAttr(table);
            JScrollPane scroller = new JScrollPane();
            scroller.getViewport().add(table);
            scroller.getViewport().setBackground(table.getBackground());
            tabPanel.add(seriesCol.fieldName[i].toString(), scroller);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", tabPanel);
    }

    private void show_scatter(Chart chart) {
        int len = this.rootData.multiData.length;
        int col = chart.bcoordCol[2] ? 3 : 2;
        Object[] name = new String[col];
        for (int i = 0; i < col; ++i) {
            name[i] = chart.colData[chart.coordCol[i]].getName() + " (" + axisName[i] + ")";
        }
        Vector<String> label = this.setHeadingColumn("No. / Axis", name);
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        for (int i = 0; i < len; ++i) {
            data.addElement(this.setScatterRow(i, this.rootData.multiData[i].plotData, col));
        }
        JTable table = new JTable(data, label);
        table.setGridColor(Color.lightGray);
        table = this.setTableAttr(table);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(table);
        scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", scroller);
    }

    private void show_polar(Chart chart) {
        int len = this.rootData.multiData.length;
        int col = 2;
        Object[] name = new String[col];
        String[] header = new String[]{"Angle", "Radius"};
        for (int i = 0; i < col; ++i) {
            name[i] = chart.colData[chart.coordCol[i]].getName() + " (" + header[i] + ")";
        }
        Vector<String> label = this.setHeadingColumn("No. / Data", name);
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        for (int i = 0; i < len; ++i) {
            data.addElement(this.setScatterRow(i, this.rootData.multiData[i].plotData, col));
        }
        JTable table = new JTable(data, label);
        table.setGridColor(Color.lightGray);
        table = this.setTableAttr(table);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(table);
        scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", scroller);
    }

    private Vector<String> setScatterRow(int row, PlotData pd, int col) {
        String rec = row + 1 + "";
        Vector<String> rowV = new Vector<String>();
        if (pd.isEmpty()) {
            for (int i = 0; i < col; ++i) {
                rowV.addElement(null);
            }
        } else {
            rowV.addElement(rec);
            if (pd.element instanceof Coordinate) {
                Coordinate coord = (Coordinate)pd.element;
                rec = coord.getx() + "";
                rowV.addElement(rec);
                rec = coord.gety() + "";
                rowV.addElement(rec);
                if (col == 3) {
                    rec = coord.getz() + "";
                    rowV.addElement(rec);
                }
            }
        }
        return rowV;
    }

    private void show_series_scatter(Chart chart) {
        JTabbedPane tabPanel = new JTabbedPane();
        int len = this.rootData.multiData.length;
        int col = chart.bcoordCol[2] ? 3 : 2;
        ColData seriesCol = chart.colData[chart.mDataMap[0]];
        Object[] name = new String[col];
        String[] header = new String[]{"Angle", "Radius"};
        for (int j = 0; j < col; ++j) {
            name[j] = chart.colData[chart.coordCol[j]].getName();
            if (chart.getChartType() != 19) continue;
            name[j] = name[j] + " (" + header[j] + ")";
        }
        for (int i = 0; i < len; ++i) {
            int len2 = this.rootData.multiData[i].multiData.length;
            Vector<String> label = this.setHeadingColumn("No. / Axis", name);
            Vector<Vector<String>> data = new Vector<Vector<String>>();
            int k = 0;
            for (int j = 0; j < len2; ++j) {
                Vector<String> vec = this.setScatterRow(k, this.rootData.multiData[i].multiData[j].plotData, col);
                if (!this.isDataRow(vec)) continue;
                data.addElement(vec);
                ++k;
            }
            JTable table = new JTable(data, label);
            table.setGridColor(Color.lightGray);
            table = this.setTableAttr(table);
            JScrollPane scroller = new JScrollPane();
            scroller.getViewport().add(table);
            scroller.getViewport().setBackground(table.getBackground());
            tabPanel.add(seriesCol.fieldName[i].toString(), scroller);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", tabPanel);
    }

    private void show_series_polar(Chart chart) {
        JTabbedPane tabPanel = new JTabbedPane();
        int len = this.rootData.multiData.length;
        int col = 2;
        ColData seriesCol = chart.colData[chart.mDataMap[0]];
        Object[] name = new String[col];
        String[] header = new String[]{"Angle", "Radius"};
        for (int j = 0; j < col; ++j) {
            name[j] = chart.colData[chart.coordCol[j]].getName() + " (" + header[j] + ")";
        }
        for (int i = 0; i < len; ++i) {
            int len2 = this.rootData.multiData[i].multiData.length;
            Vector<String> label = this.setHeadingColumn("No. / Axis", name);
            Vector<Vector<String>> data = new Vector<Vector<String>>();
            int k = 0;
            for (int j = 0; j < len2; ++j) {
                Vector<String> vec = this.setScatterRow(k, this.rootData.multiData[i].multiData[j].plotData, col);
                if (!this.isDataRow(vec)) continue;
                data.addElement(vec);
                ++k;
            }
            JTable table = new JTable(data, label);
            table.setGridColor(Color.lightGray);
            table = this.setTableAttr(table);
            JScrollPane scroller = new JScrollPane();
            scroller.getViewport().add(table);
            scroller.getViewport().setBackground(table.getBackground());
            tabPanel.add(seriesCol.fieldName[i].toString(), scroller);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", tabPanel);
    }

    private boolean isDataRow(Vector<String> vec) {
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.elementAt(i) == null) continue;
            return true;
        }
        return false;
    }

    private void show_hilow(Chart chart) {
        int len = this.rootData.multiData.length;
        int col = 2;
        HiLowMap hilow = chart.hilowCol;
        if (hilow.close >= 0) {
            ++col;
        }
        if (hilow.open >= 0) {
            ++col;
        }
        Object[] name = new String[col];
        name[0] = chart.colData[hilow.hi].getName() + " (High)";
        name[1] = chart.colData[hilow.low].getName() + " (Low)";
        if (hilow.close >= 0) {
            name[2] = chart.colData[hilow.close].getName() + " (Close)";
        }
        if (hilow.open >= 0) {
            name[3] = chart.colData[hilow.open].getName() + " (Open)";
        }
        Vector<String> label = this.setHeadingColumn("No. / Value", name);
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        for (int i = 0; i < len; ++i) {
            data.addElement(this.setHiLowRow(i, this.rootData.multiData[i].plotData, col));
        }
        JTable table = new JTable(data, label);
        table.setGridColor(Color.lightGray);
        table = this.setTableAttr(table);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(table);
        scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", scroller);
    }

    private Vector<String> setHiLowRow(int row, PlotData pd, int col) {
        Vector<String> rowV = new Vector<String>();
        String rec = row + 1 + "";
        rowV.addElement(rec);
        if (pd.isEmpty()) {
            for (int i = 0; i < col; ++i) {
                rowV.addElement(null);
            }
        } else if (pd.element instanceof HiLowData) {
            HiLowData hilow = (HiLowData)pd.element;
            rec = hilow.vhi + "";
            rowV.addElement(rec);
            rec = hilow.vlow + "";
            rowV.addElement(rec);
            if (col >= 3) {
                rec = hilow.vclose + "";
                rowV.addElement(rec);
                if (col >= 4) {
                    rec = hilow.vopen + "";
                    rowV.addElement(rec);
                }
            }
        }
        return rowV;
    }

    private void show_series_hilow(Chart chart) {
        JTabbedPane tabPanel = new JTabbedPane();
        int len = this.rootData.multiData.length;
        int col = 2;
        HiLowMap hilow = chart.hilowCol;
        if (chart.getChartType() == 10) {
            if (hilow.close >= 0) {
                ++col;
            }
            if (hilow.open >= 0) {
                ++col;
            }
        }
        ColData seriesCol = chart.colData[chart.mDataMap[0]];
        Object[] name = new String[col];
        name[0] = chart.colData[hilow.hi].getName() + " (High)";
        name[1] = chart.colData[hilow.low].getName() + " (Low)";
        if (chart.getChartType() == 10) {
            if (hilow.close >= 0) {
                name[2] = chart.colData[hilow.close].getName() + " (Close)";
            }
            if (hilow.open >= 0) {
                name[3] = chart.colData[hilow.open].getName() + " (Open)";
            }
        }
        for (int i = 0; i < len; ++i) {
            int len2 = this.rootData.multiData[i].multiData.length;
            Vector<String> label = this.setHeadingColumn("No. / Values", name);
            Vector<Vector<String>> data = new Vector<Vector<String>>();
            for (int j = 0; j < len2; ++j) {
                data.addElement(this.setHiLowRow(j, this.rootData.multiData[i].multiData[j].plotData, col));
            }
            JTable table = new JTable(data, label);
            table.setGridColor(Color.lightGray);
            table = this.setTableAttr(table);
            JScrollPane scroller = new JScrollPane();
            scroller.getViewport().add(table);
            scroller.getViewport().setBackground(table.getBackground());
            tabPanel.add(seriesCol.fieldName[i].toString(), scroller);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", tabPanel);
    }

    private class MyRenderer
    implements TableCellRenderer {
        private JTextField text = new JTextField("TEMP");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                return new JButton(value != null ? value.toString() : "NULL");
            }
            JLabel label = new JLabel(value != null ? value.toString() : "NULL");
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(this.text.getSelectionColor());
                label.setForeground(this.text.getSelectedTextColor());
            } else {
                label.setBackground(table.getBackground());
                label.setForeground(table.getForeground());
            }
            if (value == null) {
                label.setForeground(Color.blue);
            }
            return label;
        }
    }
}

