/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import quadbase.chart.Area;
import quadbase.chart.CAnnotation;
import quadbase.chart.Chart;
import quadbase.chart.designer.AreaOptionPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.GradientDialog;
import quadbase.chart.designer.IGradientDialog;
import quadbase.chart.designer.IVariableDialogOwner;
import quadbase.chart.designer.VariableDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IReferenceObj;
import quadbase.util.Point_2D;
import quadbase.util.Position;

public class TextDialog
extends QbDialog
implements IVariableDialogOwner,
IGradientDialog {
    static CAnnotation saveAnno;
    static int saveAnnoHeight;
    static int saveAnnoWidth;
    ChartMain chartMain;
    Chart chart;
    CAnnotation anno;
    IReferenceObj refObj;
    UndoTextArea textArea;
    AreaOptionPanel areaPanel;
    JCheckBox ck_background;
    JCheckBox ck_border;
    JCheckBox ck_attach;
    JButton variableButton;
    JButton okButton;
    JButton cancelButton;
    VariableDialog variableDialog;
    String text;
    boolean showBackground;
    boolean showBorder;
    boolean raise;
    boolean lower;
    boolean shadow;
    boolean none;
    boolean attach;
    boolean isGradientOn;
    int depth;
    double gradientStartX;
    double gradientStartY;
    double gradientEndX;
    double gradientEndY;
    Color desColor;
    int shade;
    boolean gradientCyclic;
    JCheckBox enableGradient;
    JButton gradientOption;
    GradientDialog gradientDialog;

    public TextDialog(ChartMain chartMain, CAnnotation anno, IReferenceObj refObj) {
        super(chartMain, LanguageEncoder.getText("Define Text..."), true);
        this.chartMain = chartMain;
        this.chart = chartMain.chartPanel.chart;
        this.anno = anno;
        this.refObj = refObj;
        this.init();
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel mainPanel = new JPanel(new BorderLayout());
        BorderPanel textPanel = new BorderPanel(LanguageEncoder.getText("Text"));
        textPanel.setLayout(new BorderLayout());
        this.textArea = new UndoTextArea(this.anno == null ? LanguageEncoder.getText("New Text") : this.anno.getOriginalValue(), 5, 20);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        textPanel.add("Center", scrollPane);
        mainPanel.add("North", textPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        BorderPanel displayPanel = new BorderPanel(LanguageEncoder.getText("Display"));
        this.ck_background = new JCheckBox(LanguageEncoder.getText("Background"));
        this.ck_background.setSelected(this.anno == null ? false : this.anno.area.drawArea);
        this.ck_border = new JCheckBox(LanguageEncoder.getText("Border"));
        this.ck_border.setSelected(this.anno == null ? false : this.anno.framearea.drawBorder);
        displayPanel.setLayout(new GridLayout(2, 1));
        displayPanel.add(this.ck_border);
        displayPanel.add(this.ck_background);
        bottomPanel.add("West", displayPanel);
        Area tempArea = null;
        if (this.anno == null) {
            tempArea = this.chart.newArea();
            tempArea.drawArea = true;
            tempArea.areaColor = Color.lightGray;
        } else {
            tempArea = this.anno.area;
        }
        this.areaPanel = new AreaOptionPanel(tempArea, LanguageEncoder.getText("3D Effect"));
        bottomPanel.add("East", this.areaPanel);
        BorderPanel gradientPanel = new BorderPanel(LanguageEncoder.getText("Gradient"));
        gradientPanel.setLayout(new FlowLayout(0));
        this.enableGradient = new JCheckBox(LanguageEncoder.getText("Enable Gradient"), this.areaPanel.area.isGradientEnabled());
        this.gradientOption = new JButton(LanguageEncoder.getText("Customize..."));
        this.enableGradient.addItemListener(this);
        this.gradientOption.setEnabled(this.enableGradient.isSelected());
        gradientPanel.add(this.enableGradient);
        gradientPanel.add(this.gradientOption);
        this.gradientOption.addActionListener(this);
        JPanel attachPanel = new JPanel(new FlowLayout(0));
        this.ck_attach = this.anno != null && this.anno.getReferenceObject() != null && !(this.anno.getReferenceObject() instanceof Chart) || this.refObj != null && !(this.refObj instanceof Chart) ? new JCheckBox(LanguageEncoder.getText("Attach to selected object")) : new JCheckBox(LanguageEncoder.getText("Attach to chart"));
        this.ck_attach.setSelected(this.refObj != null || this.anno != null && this.anno.getReferenceObject() != null);
        attachPanel.add(this.ck_attach);
        this.ck_background.addItemListener(this);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BorderLayout());
        subPanel.add("Center", gradientPanel);
        subPanel.add("South", attachPanel);
        bottomPanel.add("South", subPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.variableButton = new JButton(LanguageEncoder.getText("Variables..."));
        buttonPanel.add(this.variableButton);
        this.variableButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        mainPanel.add("North", textPanel);
        mainPanel.add("Center", bottomPanel);
        mainPanel.add("South", buttonPanel);
        this.saveStates();
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", mainPanel);
        this.itemStateChanged(null);
    }

    @Override
    public ChartMain getChartMain() {
        return this.chartMain;
    }

    @Override
    public void resetVariableDialog() {
        this.variableDialog = null;
    }

    @Override
    public void insertSelectedString() {
        int selEnd;
        String newStr = this.variableDialog.getSelectedString();
        String str = this.textArea.getText();
        int selStart = this.textArea.getSelectionStart();
        if (selStart != (selEnd = this.textArea.getSelectionEnd())) {
            if (str.length() > selEnd && str.charAt(selEnd) != ' ') {
                newStr = newStr + " ";
            }
            this.textArea.replaceRange(newStr, selStart, selEnd);
        } else {
            int pos = this.textArea.getCaretPosition();
            if (str.length() > pos && str.charAt(pos) != ' ') {
                newStr = newStr + " ";
            }
            this.textArea.insert(newStr, pos);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableGradient.setEnabled(this.ck_background.isSelected());
        this.gradientOption.setEnabled(this.ck_background.isSelected() && this.enableGradient.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.variableButton) {
            if (this.variableDialog == null) {
                this.variableDialog = new VariableDialog(this);
                this.variableDialog.setVisible(true);
            } else {
                this.variableDialog.toFront();
            }
        } else {
            if (e.getSource() == this.gradientOption) {
                if (this.gradientDialog == null) {
                    this.gradientDialog = new GradientDialog(this.chartMain, this, "Gradient Options");
                }
                this.gradientDialog.setVisible(true);
                return;
            }
            if (source == this.okButton) {
                if (this.isChanged()) {
                    this.setStates();
                }
                if (this.variableDialog != null) {
                    this.variableDialog.close();
                }
                this.close();
            } else if (source == this.cancelButton) {
                if (this.variableDialog != null) {
                    this.variableDialog.close();
                }
                this.close();
            }
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void saveStates() {
        this.text = this.textArea.getText();
        this.showBackground = this.ck_background.isSelected();
        this.showBorder = this.ck_border.isSelected();
        this.raise = this.areaPanel.ck_raise.isSelected();
        this.lower = this.areaPanel.ck_lower.isSelected();
        this.shadow = this.areaPanel.ck_shadow.isSelected();
        this.none = this.areaPanel.ck_none.isSelected();
        this.depth = this.areaPanel.spinDepth.getValue();
        this.attach = this.ck_attach.isSelected();
        this.isGradientOn = this.areaPanel.area.isGradientEnabled();
        this.gradientStartX = this.areaPanel.area.getGradientStartX();
        this.gradientStartY = this.areaPanel.area.getGradientStartY();
        this.gradientEndX = this.areaPanel.area.getGradientEndX();
        this.gradientEndY = this.areaPanel.area.getGradientEndY();
        this.desColor = this.areaPanel.area.getGradientDesColor();
        this.shade = this.areaPanel.area.getGradientShade();
        this.gradientCyclic = this.areaPanel.area.isGradientCyclic();
    }

    private boolean isChanged() {
        boolean isChanged;
        boolean bl = this.anno == null || !this.text.equals(this.textArea.getText()) || this.showBackground != this.ck_background.isSelected() || this.showBorder != this.ck_border.isSelected() || this.raise != this.areaPanel.ck_raise.isSelected() || this.lower != this.areaPanel.ck_lower.isSelected() || this.shadow != this.areaPanel.ck_shadow.isSelected() || this.none != this.areaPanel.ck_none.isSelected() || this.depth != this.areaPanel.spinDepth.getValue() || this.attach != this.ck_attach.isSelected() || this.isGradientOn != (this.enableGradient.isSelected() && this.enableGradient.isEnabled()) ? true : (isChanged = false);
        if (isChanged) {
            return true;
        }
        if (this.gradientDialog != null) {
            int tmp_gShade = 0;
            Color tmp_desColor = null;
            if (this.gradientDialog.shading.isSelected()) {
                tmp_gShade = this.gradientDialog.shadeValue.getValue() * (this.gradientDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1);
            } else {
                tmp_desColor = this.gradientDialog.getButtonColor();
            }
            return !this.text.equals(this.textArea.getText()) || this.gradientStartX != (double)this.gradientDialog.startX.getValue() || this.gradientStartY != (double)this.gradientDialog.startY.getValue() || this.gradientEndX != (double)this.gradientDialog.endX.getValue() || this.gradientEndY != (double)this.gradientDialog.endY.getValue() || this.desColor != tmp_desColor || this.shade != tmp_gShade || this.gradientCyclic != this.gradientDialog.checkCyclic.isSelected();
        }
        return false;
    }

    private void getInitPosition() {
        this.chartMain.statusBar.showHint(LanguageEncoder.getText("Press left mouse button to set initial position"));
        saveAnno = this.anno;
        saveAnnoHeight = (int)(this.anno.getRelativeHeight() * (float)this.chart.winHeight);
        saveAnnoWidth = (int)(this.anno.getRelativeWidth() * (float)this.chart.winWidth);
        this.chartMain.chartPanel.setMode(3);
        this.chartMain.chartPanel.setCursor(Cursor.getPredefinedCursor(2));
        this.setVisible(false);
    }

    private void setStates() {
        IReferenceObj temp;
        String text = this.textArea.getText().trim();
        if (text.equals("")) {
            if (this.anno != null) {
                IReferenceObj temp2 = this.anno.getReferenceObject();
                if (temp2 != null) {
                    temp2.removeAnnotation(this.anno);
                } else {
                    this.chart.removeAnnotation(this.anno);
                }
            }
            this.chartMain.setModified();
            this.chartMain.qbpaint();
            return;
        }
        if (!this.ck_attach.isSelected()) {
            if (this.anno != null && (temp = this.anno.getReferenceObject()) != null) {
                Position annoPos = this.anno.getPosition();
                temp.removeAnnotation(this.anno);
                this.chart.addAnnotation(this.anno);
                this.anno.setRelativePosition(new Point_2D(annoPos.getX(), annoPos.getY()));
            }
            this.refObj = null;
        } else {
            if (this.anno != null) {
                if (this.refObj == null && this.anno.getReferenceObject() == null) {
                    this.refObj = this.chart;
                }
                if ((temp = this.anno.getReferenceObject()) == null) {
                    Position annoPos = this.anno.getPosition();
                    Position refPos = this.refObj.getReferencePosition();
                    if (!(this.refObj instanceof Chart)) {
                        this.refObj.addAnnotation(this.anno);
                    }
                    this.anno.setRelativePosition(new Point_2D(annoPos.getX() - refPos.getX(), annoPos.getY() - refPos.getY()));
                }
            }
            if (this.anno != null && this.refObj == null) {
                this.refObj = this.anno.getReferenceObject();
            }
        }
        boolean createAnno = false;
        if (this.anno == null) {
            this.anno = new CAnnotation(this.chart, this.refObj, text);
            createAnno = true;
        } else {
            this.anno.setReferenceObject(this.refObj);
            this.anno.setValue(text);
        }
        this.anno.area = this.areaPanel.getArea();
        this.anno.setBackgroundVisible(this.ck_background.isSelected());
        this.anno.setBorderVisible(this.ck_border.isSelected());
        if (this.enableGradient.isEnabled()) {
            this.anno.area.setGradientEnabled(this.enableGradient.isSelected());
        } else {
            this.anno.area.setGradientEnabled(false);
        }
        if (this.gradientDialog != null) {
            this.gradientDialog.setValues();
        }
        if (createAnno && (this.refObj == null || this.refObj == this.chart)) {
            this.getInitPosition();
        } else {
            if (createAnno) {
                if (this.refObj != null) {
                    this.refObj.addAnnotation(this.anno);
                } else {
                    this.chart.addAnnotation(this.anno);
                }
            }
            this.chartMain.setModified();
            this.chartMain.qbpaint();
        }
    }

    @Override
    public void resetGradientDialog() {
        this.gradientDialog = null;
    }

    @Override
    public double getGradientStartX() {
        return this.anno == null ? 0.0 : this.anno.area.getGradientStartX();
    }

    @Override
    public double getGradientStartY() {
        return this.anno == null ? 0.0 : this.anno.area.getGradientStartY();
    }

    @Override
    public double getGradientEndX() {
        return this.anno == null ? 100.0 : this.anno.area.getGradientEndX();
    }

    @Override
    public double getGradientEndY() {
        return this.anno == null ? 100.0 : this.anno.area.getGradientEndY();
    }

    @Override
    public Color getGradientDesColor() {
        return this.anno == null ? null : this.anno.area.getGradientDesColor();
    }

    @Override
    public int getGradientShade() {
        return this.anno == null ? -2 : this.anno.area.getGradientShade();
    }

    @Override
    public boolean isGradientCyclic() {
        return this.anno == null ? false : this.anno.area.isGradientCyclic();
    }

    @Override
    public void setValues(GradientDialog gDialog) {
        this.anno.area.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.anno.area.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.anno.area.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.anno.area.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.anno.area.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.anno.area.setGradientDesColor(null);
        } else {
            this.anno.area.setGradientDesColor(gDialog.getButtonColor());
        }
        this.anno.area.setGradientCyclic(gDialog.checkCyclic.isSelected());
        this.anno.area.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.anno.area.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.anno.area.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.anno.area.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.anno.area.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.anno.area.setGradientDesColor(null);
        } else {
            this.anno.area.setGradientDesColor(gDialog.getButtonColor());
        }
        this.anno.area.setGradientCyclic(gDialog.checkCyclic.isSelected());
    }

    @Override
    public boolean is3DShadingEnabled() {
        return false;
    }

    @Override
    public boolean isGradientEnabled() {
        return false;
    }
}

