/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.TextReplacementList;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class TextPropertiesDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(TextPropertiesDialog.class.getName());
    static final int LEN = 15;
    JTextField ratioText;
    JTextField maxDisplayChar;
    JTextField originalText;
    JTextField replacingText;
    TextReplacementList textList;
    JButton okButton;
    JButton cancelButton;
    JButton listButton;
    JCheckBox checkJ2DRotate;
    JCheckBox checkMaxDisplayChar;
    Chart chart;
    ChartMain chartMain;
    private boolean disableListener = false;
    Vector<String> deleteList = new Vector();

    public TextPropertiesDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartMain = frame;
        this.chart = this.chartMain.chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.ratioText = new JTextField(Float.valueOf(this.chart.getFontResizeRatio()).toString(), 5);
        this.maxDisplayChar = new JTextField(Integer.valueOf(this.chart.getCutOffThresholdForText()).toString(), 5);
        this.checkJ2DRotate = new JCheckBox(LanguageEncoder.getText("use Java 2D Rotate Text"), this.chart.isJ2DRotateEnabled());
        this.checkMaxDisplayChar = new JCheckBox(LanguageEncoder.getText("Set Max Display Characters"), this.chart.getCutOffThresholdForText() >= 0);
        this.originalText = new JTextField(15);
        this.replacingText = new JTextField(15);
        this.listButton = new JButton(LanguageEncoder.getText("List..."));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.ratioText.addActionListener(this);
        this.maxDisplayChar.addActionListener(this);
        this.checkJ2DRotate.addItemListener(this);
        this.checkMaxDisplayChar.addItemListener(this);
        this.originalText.addActionListener(this);
        this.replacingText.addActionListener(this);
        this.listButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        BorderPanel resizePanel = new BorderPanel(LanguageEncoder.getText("Font Resize"));
        resizePanel.setLayout(new FlowLayout(1));
        resizePanel.add(new Label(LanguageEncoder.getText("Resize Ratio"), 0));
        resizePanel.add(this.ratioText);
        BorderPanel rotatePanel = new BorderPanel(LanguageEncoder.getText("Rotate"));
        rotatePanel.setLayout(new FlowLayout(1));
        rotatePanel.add(this.checkJ2DRotate);
        BorderPanel maxCharPanel = new BorderPanel(LanguageEncoder.getText("Max Display Characters"));
        maxCharPanel.setLayout(new FlowLayout(1));
        maxCharPanel.add(this.checkMaxDisplayChar);
        maxCharPanel.add(this.maxDisplayChar);
        BorderPanel titlePanel = new BorderPanel(LanguageEncoder.getText("Runtime Text Substitution"));
        titlePanel.setLayout(new GridLayout(2, 1));
        titlePanel.add(new JLabel(LanguageEncoder.getText("Original Text"), 2));
        titlePanel.add(this.originalText);
        titlePanel.add(new JLabel(LanguageEncoder.getText("Subsitute With (Runtime Only)"), 2));
        titlePanel.add(this.replacingText);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.listButton);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel topPanel = new JPanel(new GridLayout(3, 1));
        topPanel.add(resizePanel);
        topPanel.add(rotatePanel);
        topPanel.add(maxCharPanel);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("North", topPanel);
        cop.add("Center", titlePanel);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.itemStateChanged(null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.disableListener) {
            return;
        }
        this.disableListener = true;
        this.setRotateEnabled(this.checkJ2DRotate.isSelected());
        this.maxDisplayChar.setEnabled(this.checkMaxDisplayChar.isSelected());
        this.disableListener = false;
    }

    public void setRotateEnabled(boolean b) {
        this.checkJ2DRotate.setSelected(b);
        this.chart.setJ2DRotateEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.listButton) {
            if (this.textList == null) {
                this.deleteList = new Vector();
                this.textList = new TextReplacementList(this);
                this.textList.setVisible(true);
            } else {
                this.textList.setVisible(true);
                this.textList.toFront();
            }
            return;
        }
        if (source == this.okButton) {
            if (this.textList != null) {
                this.textList.close();
            }
            if (this.deleteList != null) {
                for (int i = 0; i < this.deleteList.size(); ++i) {
                    this.chart.valueTable.addUniqueKeyValue(this.deleteList.elementAt(i), this.deleteList.elementAt(i));
                }
            }
            this.chart.valueTable.addUniqueKeyValue(this.originalText.getText(), this.replacingText.getText());
            try {
                this.chart.setFontResizeRatio(Float.parseFloat(this.ratioText.getText()));
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Invalid number, keeping old resize ratio", ex);
            }
            if (this.checkMaxDisplayChar.isSelected()) {
                try {
                    this.chart.setCutOffThresholdForText(Integer.parseInt(this.maxDisplayChar.getText()));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINEST, "Invalid number, keeping old cutoff threshold", ex);
                }
            } else {
                this.chart.setCutOffThresholdForText(-1);
            }
            this.chartMain.setModified();
            this.setVisible(false);
            this.dispose();
            this.chartMain.chartPanel.chart.legend.invalidate();
            this.chartMain.chartPanel.chart.legend2.invalidate();
            this.chartMain.chartPanel.paint();
            return;
        }
        if (source == this.cancelButton) {
            if (this.textList != null) {
                this.textList.close();
            }
            this.setVisible(false);
            this.dispose();
            return;
        }
    }
}

