/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import quadbase.chart.designer.TextPropertiesDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class TextReplacementList
extends JDialog
implements ActionListener {
    TextPropertiesDialog td;
    JButton closeButton;
    JButton modButton;
    JButton undoButton;
    JPanel listPanel;
    JList replaceList;
    Vector<Object> data;

    public TextReplacementList(TextPropertiesDialog td) {
        super(td.chartMain, LanguageEncoder.getText("Replaced Text..."), true);
        this.td = td;
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(new JLabel(LanguageEncoder.getText("(Original Text)     Replaced Text")));
        this.replaceList = new JList();
        this.setList();
        this.setBackground(Color.lightGray);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.modButton = new JButton(LanguageEncoder.getText("Modify"));
        buttonPanel.add(this.modButton);
        this.undoButton = new JButton(LanguageEncoder.getText("Delete"));
        buttonPanel.add(this.undoButton);
        this.closeButton = new JButton(LanguageEncoder.getText("Close"));
        buttonPanel.add(this.closeButton);
        this.modButton.addActionListener(this);
        this.undoButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("North", labelPanel);
        cop.add("Center", this.replaceList);
        cop.add("South", buttonPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TextReplacementList.this.close();
            }
        });
        this.pack();
        Dimension dim = this.getPreferredSize();
        Rectangle tdPos = td.getBounds();
        int x = tdPos.x + tdPos.width + 20;
        int y = tdPos.y + (tdPos.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.closeButton) {
            this.close();
        } else if (target == this.undoButton) {
            if (this.replaceList.getSelectedValue() == null) {
                return;
            }
            String str = this.replaceList.getSelectedValue().toString();
            str = str.substring(1, str.indexOf(")     "));
            if (this.td.deleteList == null) {
                this.td.deleteList = new Vector();
            }
            this.td.deleteList.add(str);
            this.data.remove(this.replaceList.getSelectedValue());
            this.replaceList.setListData(this.data);
        } else if (target == this.modButton) {
            if (this.replaceList.getSelectedValue() == null) {
                return;
            }
            String str = this.replaceList.getSelectedValue().toString();
            String str1 = str.substring(1, str.indexOf(")     "));
            String str2 = str.substring(str.indexOf(")     ") + 6);
            this.td.originalText.setText(str1);
            this.td.replacingText.setText(str2);
        }
    }

    public void close() {
        this.setVisible(false);
    }

    private void setList() {
        if (this.td.chart.valueTable == null) {
            return;
        }
        Enumeration<String> key = this.td.chart.valueTable.getUniqueKeyList();
        Enumeration<String> element = this.td.chart.valueTable.getUniqueElementList();
        if (key == null || element == null) {
            return;
        }
        this.data = new Vector();
        while (key.hasMoreElements()) {
            this.data.addElement("(" + key.nextElement() + ")     " + element.nextElement());
        }
        this.replaceList.setListData(this.data);
    }
}

