/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.IVariableDialogOwner;
import quadbase.chart.designer.VariableDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class TitleDialog
extends QbDialog
implements FocusListener,
IVariableDialogOwner {
    static final int LEN = 30;
    JTextField mainTitle;
    JTextField xtitle;
    JTextField ytitle;
    JTextField ztitle;
    JTextField stitle;
    JTextField currentField;
    JButton okButton;
    JButton cancelButton;
    JButton variableButton;
    VariableDialog variableDialog;
    Chart chart;
    ChartMain chartMain;

    public TitleDialog(ChartMain frame, Chart chart) {
        super(frame, LanguageEncoder.getText("Chart Titles"), true);
        this.chartMain = frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.mainTitle = new JTextField(30);
        this.xtitle = new JTextField(30);
        this.ytitle = new JTextField(30);
        this.ztitle = new JTextField(30);
        this.stitle = new JTextField(30);
        this.variableButton = new JButton(LanguageEncoder.getText("Variables..."));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.mainTitle.addActionListener(this);
        this.xtitle.addActionListener(this);
        this.ytitle.addActionListener(this);
        this.stitle.addActionListener(this);
        this.ztitle.addActionListener(this);
        this.variableButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.mainTitle.addFocusListener(this);
        this.xtitle.addFocusListener(this);
        this.ytitle.addFocusListener(this);
        this.ztitle.addFocusListener(this);
        this.stitle.addFocusListener(this);
        BorderPanel titlePanel = new BorderPanel(LanguageEncoder.getText("Titles"));
        titlePanel.setLayout(new GridLayout(0, 1));
        FlowLayout flowLayout = new FlowLayout();
        JPanel mainTitlePanel = new JPanel();
        mainTitlePanel.setLayout(flowLayout);
        mainTitlePanel.add(new JLabel(LanguageEncoder.getText("Chart :"), 2));
        mainTitlePanel.add(this.mainTitle);
        JPanel xTitlePanel = new JPanel();
        xTitlePanel.setLayout(flowLayout);
        xTitlePanel.add(new JLabel(LanguageEncoder.getText("X-axis :"), 2));
        xTitlePanel.add(this.xtitle);
        JPanel yTitlePanel = new JPanel();
        yTitlePanel.setLayout(flowLayout);
        int chartType = this.chart.getChartType();
        if (chartType == 19) {
            yTitlePanel.add(new JLabel(LanguageEncoder.getText("Axis :"), 2));
        } else {
            yTitlePanel.add(new JLabel(LanguageEncoder.getText("Y-axis :"), 2));
        }
        yTitlePanel.add(this.ytitle);
        JPanel zTitlePanel = new JPanel();
        zTitlePanel.setLayout(flowLayout);
        zTitlePanel.add(new JLabel(LanguageEncoder.getText("Z-axis :"), 2));
        zTitlePanel.add(this.ztitle);
        JPanel sTitlePanel = new JPanel();
        sTitlePanel.setLayout(flowLayout);
        sTitlePanel.add(new JLabel(LanguageEncoder.getText("2nd-axis :"), 2));
        sTitlePanel.add(this.stitle);
        titlePanel.add(mainTitlePanel);
        this.currentField = this.mainTitle;
        if (!Chart.isCircularChart(chartType) && chartType != 17) {
            if (chartType != 16 && chartType != 19) {
                titlePanel.add(xTitlePanel);
            }
            titlePanel.add(yTitlePanel);
            if (!this.chart.is2DimChart()) {
                titlePanel.add(zTitlePanel);
            }
        }
        if (!Chart.isCircularChart(chartType) && !Chart.isCoordinateType(chartType) && this.chart.subvalueCol >= 0) {
            titlePanel.add(sTitlePanel);
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.variableButton);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", titlePanel);
        cop.add("South", buttonPanel);
        this.setSize(this.getPreferredSize());
        this.getValues();
    }

    @Override
    public ChartMain getChartMain() {
        return this.chartMain;
    }

    @Override
    public void resetVariableDialog() {
        this.variableDialog = null;
    }

    @Override
    public void insertSelectedString() {
        String str1;
        String newStr = this.variableDialog.getSelectedString();
        String str = this.currentField.getText();
        String str2 = null;
        if (this.currentField.getSelectedText() != null) {
            str1 = str.substring(0, this.currentField.getSelectionStart());
            str2 = str.substring(this.currentField.getSelectionEnd());
        } else {
            str1 = str.substring(0, this.currentField.getCaretPosition());
            str2 = str.substring(this.currentField.getCaretPosition());
        }
        if (str2 != null && str2.length() > 0 && str2.charAt(0) != ' ') {
            str2 = " " + str2;
        }
        this.currentField.setText(str1 + newStr + str2);
    }

    private void getValues() {
        this.mainTitle.setText(this.chart.getTitle());
        this.xtitle.setText(this.chart.getAxisTitle(0));
        this.ytitle.setText(this.chart.getAxisTitle(1));
        this.ztitle.setText(this.chart.getAxisTitle(2));
        this.stitle.setText(this.chart.getAxisTitle(3));
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object target = e.getSource();
        if (target == this.mainTitle) {
            this.currentField = this.mainTitle;
        } else if (target == this.xtitle) {
            this.currentField = this.xtitle;
        } else if (target == this.ytitle) {
            this.currentField = this.ytitle;
        } else if (target == this.ztitle) {
            this.currentField = this.ztitle;
        } else if (target == this.stitle) {
            this.currentField = this.stitle;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.variableButton) {
            if (this.variableDialog == null) {
                this.variableDialog = new VariableDialog(this);
                this.variableDialog.setVisible(true);
            } else {
                this.variableDialog.toFront();
            }
        } else if (source == this.okButton) {
            if (this.variableDialog != null) {
                this.variableDialog.close();
            }
            this.setTitles();
            this.chartMain.setModified();
            this.chartMain.qbpaint();
            this.dispose();
        } else if (source == this.cancelButton) {
            if (this.variableDialog != null) {
                this.variableDialog.close();
            }
            this.dispose();
        }
    }

    private void setTitles() {
        this.chart.setTitle(this.mainTitle.getText());
        this.chart.setAxisTitle(this.xtitle.getText(), 0);
        this.chart.setAxisTitle(this.ytitle.getText(), 1);
        this.chart.setAxisTitle(this.ztitle.getText(), 2);
        this.chart.setAxisTitle(this.stitle.getText(), 3);
    }
}

