/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import quadbase.chart.CAnnotation;
import quadbase.chart.Chart;
import quadbase.chart.HiLowMap;
import quadbase.chart.TrendLine;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IAnnotation;

public class TrendDialog
extends QbDialog {
    Chart chart;
    ChartMain chartmain;
    JComboBox ch_series;
    JComboBox ch_value;
    JComboBox ch_linetype;
    SpinBox spin_thickness;
    SpinBox spin_order;
    SpinBox spin_period;
    JCheckBox checktitle;
    JCheckBox checkanno;
    JCheckBox checksubValue;
    JRadioButton check_pos;
    JRadioButton check_neg;
    JTextField txt_title;
    JButton okButton;
    JButton cancelButton;
    Color linecolor = Color.black;
    TrendLine curDataLine = null;
    int[] linetypeMap = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 17};
    String labelSave;
    String lineValueSave;
    int lineTypeSave;
    int hiLowSave;
    int thickSave;
    int seriesSave;
    int hilowValueSave;
    int coeffSave;
    boolean positiveSave;
    boolean subValueSave;
    boolean initializing = true;

    public TrendDialog(ChartMain chartmain, TrendLine cLine) {
        super(chartmain, LanguageEncoder.getText("Define Trendlines..."), true);
        this.setBackground(Color.lightGray);
        this.chart = chartmain.chart;
        this.chartmain = chartmain;
        this.curDataLine = cLine;
        BorderPanel hpanel = new BorderPanel(LanguageEncoder.getText("TrendLine"));
        hpanel.setLayout(new BoxLayout(hpanel, 1));
        this.txt_title = new JTextField("New Line", 20);
        this.addComponent(hpanel, this.txt_title, LanguageEncoder.getText("Label"));
        this.spin_order = new SpinBox(0, 100);
        this.addComponent(hpanel, this.spin_order, LanguageEncoder.getText("Polynomial curve order :"));
        this.spin_period = new SpinBox(1, 9999);
        this.addComponent(hpanel, this.spin_period, LanguageEncoder.getText("Moving average period :"));
        this.spin_period.setValue(2);
        if (this.chart.dataDim > 1 && !this.chart.isStackType() || this.chart.dataDim > 2 && this.chart.isStackType()) {
            Object[] name;
            this.ch_series = new JComboBox();
            this.addComponent(hpanel, this.ch_series, LanguageEncoder.getText("Series :"));
            for (Object element : name = this.chart.colData[this.chart.mDataMap[0]].getFieldName()) {
                this.ch_series.addItem(element.toString());
            }
        }
        if (this.chart.isHiLow()) {
            this.ch_value = new JComboBox();
            this.addComponent(hpanel, this.ch_value, LanguageEncoder.getText("Value :"));
            this.addHiLowValue(this.ch_value, this.chart.hilowCol.hi);
            this.addHiLowValue(this.ch_value, this.chart.hilowCol.low);
            this.addHiLowValue(this.ch_value, this.chart.hilowCol.close);
            this.addHiLowValue(this.ch_value, this.chart.hilowCol.open);
        }
        if (this.chart.isStackType()) {
            this.check_pos = new JRadioButton(LanguageEncoder.getText("Positive"), true);
            this.check_neg = new JRadioButton(LanguageEncoder.getText("Negative"), false);
            this.addComponent(hpanel, this.check_pos, this.check_neg, LanguageEncoder.getText("Stack line :"));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.check_pos);
            bg.add(this.check_neg);
        }
        this.spin_thickness = new SpinBox(1, 100);
        this.addComponent(hpanel, this.spin_thickness, LanguageEncoder.getText("Line thickness :"));
        this.ch_linetype = new JComboBox();
        this.addComponent(hpanel, this.ch_linetype, LanguageEncoder.getText("Line type :"));
        this.ch_linetype.addItemListener(this);
        int nLineType = this.linetypeMap.length;
        if (!this.supportNormalCurve()) {
            --nLineType;
        }
        for (int i = 0; i < nLineType; ++i) {
            this.ch_linetype.addItem(this.getDefaultName(this.linetypeMap[i]));
        }
        this.checktitle = new JCheckBox(LanguageEncoder.getText("Show label in legend"));
        this.addComponent(hpanel, this.checktitle, null);
        this.checkanno = new JCheckBox(LanguageEncoder.getText("Show attached text"));
        this.checkanno.setHorizontalAlignment(2);
        this.addComponent(hpanel, this.checkanno, null);
        if (this.showSubValue()) {
            this.checksubValue = new JCheckBox(LanguageEncoder.getText("Use secondary axis value"));
            this.checksubValue.setHorizontalAlignment(2);
            this.addComponent(hpanel, this.checksubValue, null);
        }
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        p2.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        p2.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        hpanel.add(p2);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", hpanel);
        this.setOrderAverageChoice();
        this.saveStates();
        this.displayLine(this.curDataLine);
        this.initializing = false;
        this.txt_title.setSelectionStart(0);
        this.txt_title.setSelectionEnd(this.txt_title.getText().length());
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private boolean supportNormalCurve() {
        if (this.chart.dataDim != 1 || this.chart.subvalueCol >= 0) {
            return false;
        }
        int categoryType = this.chart.getCategoryType();
        return this.chart.isHistogram() && categoryType != 12 && categoryType != -1 && categoryType != 91 && categoryType != 92 && categoryType != 93 && categoryType != 16 && categoryType != -7 && categoryType != 1;
    }

    private void saveStates() {
        this.labelSave = this.txt_title.getText();
        this.lineTypeSave = this.ch_linetype.getSelectedIndex();
        this.thickSave = this.spin_thickness.getValue();
        this.coeffSave = this.getCoeff();
        if (this.chart.dataDim > 1 && !this.chart.isStackType() || this.chart.dataDim > 2 && this.chart.isStackType()) {
            this.seriesSave = this.ch_series.getSelectedIndex();
        }
        if (this.chart.isHiLow()) {
            this.hilowValueSave = this.ch_value.getSelectedIndex();
        }
        if (this.chart.isStackType()) {
            this.positiveSave = this.check_pos.isSelected();
        }
        if (this.showSubValue()) {
            this.subValueSave = this.checksubValue.isSelected();
        }
    }

    private boolean showSubValue() {
        return this.chart.mData2 != null;
    }

    private void invalidateLegend() {
        this.chartmain.invalidateLegend();
    }

    private void setOrderAverageChoice() {
        this.spin_order.setEnabled(false);
        this.spin_period.setEnabled(false);
        int tp = this.ch_linetype.getSelectedIndex();
        if (this.ch_series != null) {
            this.ch_series.setEnabled(true);
        }
        if (this.ch_value != null) {
            this.ch_value.setEnabled(true);
        }
        if (tp == 0) {
            this.spin_order.setEnabled(true);
        } else if (tp > 3 && tp <= 6) {
            this.spin_period.setEnabled(true);
        }
    }

    private void displayLine(TrendLine tline) {
        if (tline == null) {
            this.ch_linetype.setSelectedIndex(0);
            this.txt_title.setText(LanguageEncoder.getText("New Line"));
            this.spin_order.setValue(0);
            this.spin_period.setValue(0);
            this.spin_thickness.setValue(1);
            this.linecolor = Color.black;
            if (this.showSubValue()) {
                this.checksubValue.setSelected(false);
            }
        } else {
            this.txt_title.setText(tline.getTitle());
            this.ch_linetype.setSelectedIndex(this.getChoiceIndex(tline.getLineType()));
            this.setOrderAverageChoice();
            if (this.ch_series != null) {
                this.ch_series.setSelectedItem(tline.getSeries());
            }
            if (this.ch_value != null) {
                String s = this.findColumnName(tline.getValueColumn());
                if (s != null) {
                    this.ch_value.setSelectedItem(s);
                } else {
                    this.ch_value.setSelectedIndex(0);
                }
            }
            if (this.ch_linetype.getSelectedIndex() < 4) {
                this.spin_order.setValue(tline.getCoeff());
            } else {
                this.spin_period.setValue(tline.getCoeff());
            }
            this.linecolor = tline.getColor();
            this.spin_thickness.setValue(tline.getThickness());
            if (this.check_pos != null) {
                this.check_pos.setSelected(tline.getStackChartLine());
                this.check_neg.setSelected(!tline.getStackChartLine());
            }
            this.checktitle.setSelected(tline.isTitleVisibleInLegend());
            Vector<IAnnotation> annoVector = tline.getAnnotations();
            if (annoVector == null || annoVector.size() == 0) {
                this.checkanno.setSelected(false);
            } else {
                this.checkanno.setSelected(annoVector.elementAt(0).isVisible());
            }
            if (this.showSubValue()) {
                this.checksubValue.setSelected(tline.isSecondaryValueUsed());
            }
            this.txt_title.requestFocus();
        }
        this.setOrderAverageChoice();
        this.saveStates();
    }

    private int getCoeff() {
        return this.ch_linetype.getSelectedIndex() < 4 ? this.spin_order.getValue() : this.spin_period.getValue();
    }

    TrendLine getTrendLine() {
        return this.curDataLine;
    }

    private TrendLine updateTrendLine() {
        int linetype = this.linetypeMap[this.ch_linetype.getSelectedIndex()];
        String label = this.txt_title.getText();
        TrendLine tline = null;
        tline = this.curDataLine;
        tline.setTitle(label);
        tline.setLineType(linetype);
        tline.setCoeff(this.getCoeff());
        if (this.ch_value != null) {
            tline.setValueColumn(this.findColumn(this.ch_value.getSelectedItem().toString()));
        }
        if (this.ch_series != null) {
            tline.setSeries(this.ch_series.getSelectedItem().toString());
        }
        tline.setThickness(this.spin_thickness.getValue());
        if (this.check_pos != null) {
            tline.setStackChartLine(this.check_pos.isSelected());
        }
        tline.setTitleVisibleInLegend(this.checktitle.isSelected());
        boolean showAnnotation = this.checkanno.isSelected();
        Vector<IAnnotation> annoVector = tline.getAnnotations();
        if (annoVector != null) {
            int nAnno = annoVector.size();
            for (int i = 0; i < nAnno; ++i) {
                ((CAnnotation)annoVector.elementAt(i)).setVisible(showAnnotation);
            }
        }
        tline.setColor(this.linecolor);
        if (this.showSubValue()) {
            tline.useSecondaryValue(this.checksubValue.isSelected());
        }
        return tline;
    }

    private int findColumn(String s) {
        HiLowMap col = this.chart.hilowCol;
        if (col.close >= 0 && this.chart.colData[col.close].getName().equals(s)) {
            return 2;
        }
        if (this.chart.colData[col.low].getName().equals(s)) {
            return 1;
        }
        if (col.open >= 0 && this.chart.colData[col.open].getName().equals(s)) {
            return 3;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.initializing) {
            return;
        }
        Object target = e.getSource();
        if (target == this.okButton) {
            this.updateTrendLine();
            this.invalidateLegend();
            this.chartmain.setModified();
            this.chartmain.qbrepaint();
            this.setVisible(false);
            this.dispose();
        } else if (target == this.cancelButton) {
            this.curDataLine = null;
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.curDataLine = null;
        super.windowClosing(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.initializing) {
            return;
        }
        Object source = e.getSource();
        if (source == this.ch_linetype) {
            this.setOrderAverageChoice();
        }
    }

    private void addHiLowValue(JComboBox choice, int v) {
        if (v >= 0 && v < this.chart.colData.length) {
            choice.addItem(this.chart.colData[v].getName());
        }
    }

    private void addComponent(JPanel p, Component c, String label) {
        this.addComponent(p, c, null, label);
    }

    private void addComponent(JPanel p, Component c, Component c2, String label) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        if (label != null) {
            panel.add(new JLabel(label));
        }
        panel.add(c);
        if (c2 != null) {
            panel.add(c2);
        }
        p.add(panel);
    }

    private String findColumnName(int v) {
        int no;
        switch (v) {
            case 2: {
                no = this.chart.hilowCol.close;
                break;
            }
            case 3: {
                no = this.chart.hilowCol.open;
                break;
            }
            case 1: {
                no = this.chart.hilowCol.low;
                break;
            }
            default: {
                no = this.chart.hilowCol.hi;
            }
        }
        if (no >= this.chart.colData.length) {
            return null;
        }
        return this.chart.colData[no].getName();
    }

    private int getChoiceIndex(int linetype) {
        int nLineType = this.linetypeMap.length;
        if (!this.supportNormalCurve()) {
            --nLineType;
        }
        for (int i = 0; i < nLineType; ++i) {
            if (linetype != this.linetypeMap[i]) continue;
            return i;
        }
        return -1;
    }

    private String getDefaultName(int lineType) {
        for (int i = 0; i < TrendLine.lineTypeMap.length; ++i) {
            if (TrendLine.lineTypeMap[i] != lineType) continue;
            return TrendLine.defaultNames[i];
        }
        return "";
    }
}

