/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.chart.Chart;
import quadbase.chart.DataLineSet;
import quadbase.chart.TrendLine;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.TrendDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class TrendLineListDialog
extends QbDialog
implements ListSelectionListener {
    ChartMain chartmain;
    JList datalist;
    DefaultListModel listModel;
    JButton editButton;
    JButton addButton;
    JButton removeButton;
    JButton butcancel;
    JButton butOK;
    Chart chart;
    Vector<TrendLine> list;
    static final short width = 225;
    static final short height = 275;
    boolean inProcess = false;

    public TrendLineListDialog(ChartMain frame) {
        super(frame, LanguageEncoder.getText("Trendline Options"), true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.setBackground(Color.lightGray);
        BorderPanel orderpanel = new BorderPanel(LanguageEncoder.getText("Trendline List"));
        this.listModel = new DefaultListModel();
        this.list = this.chart.dataLineSet.getTrendLineList();
        for (int j = 0; j < this.list.size(); ++j) {
            this.listModel.addElement(this.list.get(j).getTitle());
        }
        this.datalist = new JList(this.listModel);
        this.datalist.setSelectionMode(0);
        this.editButton = new JButton(LanguageEncoder.getText("Edit"));
        this.addButton = new JButton(LanguageEncoder.getText("Insert"));
        this.removeButton = new JButton(LanguageEncoder.getText("Remove"));
        this.editButton.setEnabled(this.list.size() > 0);
        this.removeButton.setEnabled(this.list.size() > 0);
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addButton.addActionListener(this);
        orderpanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.datalist);
        orderpanel.add("Center", scrollPane);
        JPanel spanel = new JPanel();
        spanel.setLayout(new GridLayout(3, 1));
        spanel.add(this.addButton);
        spanel.add(this.editButton);
        spanel.add(this.removeButton);
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new BorderLayout());
        bpanel.add("North", spanel);
        bpanel.add("West", new JLabel("  "));
        orderpanel.add("East", bpanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        this.butcancel.addActionListener(this);
        this.butOK.addActionListener(this);
        buttonPanel.add(this.butOK);
        buttonPanel.add(this.butcancel);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("South", buttonPanel);
        cop.add("Center", orderpanel);
        Dimension screensize = this.getToolkit().getScreenSize();
        this.datalist.addListSelectionListener(this);
        this.enableButtons();
        this.setBounds((screensize.width - 225) / 2, (screensize.height - 275) / 2, 225, 275);
    }

    void show(TrendLine tline) {
        int currentRecord = -1;
        if (tline != null && (currentRecord = DataLineSet.findDataLine(this.chart.dataLineSet.getTrendLineList(), tline)) >= 0) {
            this.datalist.setSelectedIndex(currentRecord);
        } else {
            this.datalist.clearSelection();
        }
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableButtons();
    }

    private void enableButtons() {
        if (this.list.size() == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        this.editButton.setEnabled(this.datalist.getSelectedIndex() >= 0);
        this.removeButton.setEnabled(this.datalist.getSelectedIndex() >= 0);
    }

    private void insertItem() {
        TrendLine c = this.chart.dataLineSet.newTrendLine(0, 0, "New Line");
        TrendDialog cDialog = new TrendDialog(this.chartmain, c);
        cDialog.setVisible(true);
        c = cDialog.getTrendLine();
        if (c != null) {
            this.listModel.addElement(c.getTitle());
            this.list.add(c);
            this.datalist.validate();
            this.datalist.repaint();
        }
        this.enableButtons();
    }

    private void editItem() {
        int idx = this.datalist.getSelectedIndex();
        TrendLine c = this.list.get(idx);
        c = (TrendLine)c.clone();
        TrendDialog cDialog = new TrendDialog(this.chartmain, c);
        cDialog.setVisible(true);
        c = cDialog.getTrendLine();
        if (c != null) {
            this.listModel.setElementAt(c.getTitle(), idx);
            this.list.setElementAt(c, idx);
            this.datalist.validate();
            this.datalist.repaint();
        }
    }

    private void removeItem() {
        int i = this.datalist.getSelectedIndex();
        if (i >= 0) {
            this.listModel.remove(i);
            this.list.remove(i);
            this.chartmain.invalidateLegend();
            this.chartmain.chartPanel.repaint();
            this.datalist.validate();
            this.datalist.repaint();
        }
        this.enableButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.inProcess = true;
        Object target = e.getSource();
        String msg = null;
        if (target == this.butOK) {
            msg = this.setValues(this.list);
            if (msg != null) {
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(msg);
                this.inProcess = false;
                return;
            }
            this.chartmain.setModified();
            this.chartmain.invalidateLegend();
            this.chartmain.chartPanel.repaint();
            this.setVisible(false);
            this.dispose();
        } else if (target == this.butcancel) {
            this.chartmain.invalidateLegend();
            this.chartmain.chartPanel.repaint();
            this.setVisible(false);
            this.dispose();
            this.inProcess = false;
        } else if (target == this.addButton) {
            this.insertItem();
        } else if (target == this.removeButton) {
            this.removeItem();
        } else if (target == this.editButton) {
            this.editItem();
        }
        this.inProcess = false;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.inProcess = true;
        this.chartmain.invalidateLegend();
        this.chartmain.chartPanel.repaint();
        this.setVisible(false);
        this.dispose();
        this.inProcess = false;
    }

    private String setValues(Vector<TrendLine> v) {
        this.chart.dataLineSet.setTrendLineList(v);
        return null;
    }
}

