/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Dialog;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ModifyWizard;
import quadbase.chart.designer.WizardStep41;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.SimpleDbJndiDialog;

public class UpdateDatabaseWizard
extends ModifyWizard {
    private static final Logger LOGGER = Logger.getLogger(UpdateDatabaseWizard.class.getName());

    public UpdateDatabaseWizard(ChartMain f) {
        super(f, true);
        this.setTitle(LanguageEncoder.getText("Modify Database Infomation"));
        this.chart = this.chartmain.chart;
        this.stepMultiOp = false;
    }

    public void updateChart(boolean promptRetrieveData) {
        if (this.chart.sourceData != 1 && (this.chart.sourceData != 0 || this.chart.getOriginalSourceData() != 1)) {
            return;
        }
        int sourceType = this.chart.getDBSourceType();
        this.registryID = this.chartmain.chart.registryID;
        this.dataSourceID = this.chartmain.chart.dataSourceID;
        this.dataSourceLoc = this.chartmain.chart.dataSourceLoc;
        if (sourceType == Manager.QUERY) {
            this.dbSourceType = Manager.QUERY;
        } else if (sourceType == Manager.DATAVIEW) {
            this.dbSourceType = Manager.DATAVIEW;
        }
        this.dbFileBytes = this.chart.getQueryFileBytes();
        DBInfoBasic tmpdbInfo = this.doDatabaseInfo();
        if (tmpdbInfo != null) {
            if (promptRetrieveData) {
                JMessageDialog msgDialog = new JMessageDialog((Dialog)this, "Verification", LanguageEncoder.getText("Do you want to verify data?"), 1);
                int response = msgDialog.getResponse();
                if (response == 5) {
                    UpdateDatabaseWizard.doUpdateChart(this.chart, tmpdbInfo);
                    return;
                }
                if (response == 7) {
                    LOGGER.finest("Cancel");
                    return;
                }
            }
            this.validateQuery(tmpdbInfo);
            this.prepareResultSet();
        }
    }

    private DBInfoBasic doDatabaseInfo() {
        SimpleDbJndiDialog dbDialog = new SimpleDbJndiDialog(this.chartmain, this.chart.dbInfo, this.chartmain.getChangeDataRegObj(), this.chartmain.getChangeDataRegPlusObj());
        dbDialog.setBrowseDirectories(this.chartmain.getBrowseDirectories());
        dbDialog.setVisible(true);
        if (dbDialog.isModified()) {
            return dbDialog.getDBInfo();
        }
        return null;
    }

    private void displayResult() {
        if (this.chartmain != null && this.chartmain.chart != null) {
            this.isTransposed = this.chartmain.chart.isTransposed();
            this.transposeCol = this.chartmain.chart.getTransposeColumn();
        }
        this.step41 = new WizardStep41(this, false);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.step41);
        this.pack();
        this.validate();
        this.setpos();
        this.setVisible(true);
    }

    private void validateQuery(DBInfoBasic tempdbInfo) {
        block7: {
            String query = this.chart.dbInfo.getQuery();
            tempdbInfo.setQuery(query);
            if (QueryParser.hasParameters(query)) {
                QueryInParamSet paramSet = this.chart.getQueryFileInfo().getInSet();
                boolean initializationRequired = QueryParser.initializationRequired(paramSet = QueryParser.filterParameters(query, paramSet));
                if (initializationRequired) {
                    try {
                        QueryFileInfo tempqInfo = new QueryFileInfo("", 0, tempdbInfo, paramSet);
                        INParametersDialog pDialog = new INParametersDialog(this.manager, tempqInfo, false, 0);
                        pDialog.setVisible(true);
                        if (!pDialog.isModified()) break block7;
                        QueryFileInfo qinfo = pDialog.getQueryFileInfo();
                        if (qinfo != null) {
                            this.dbInfo = qinfo;
                            this.dbInfo.setUseJNDIDataSource(tempdbInfo.getJNDIName() != null);
                            break block7;
                        }
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to initialize parameters for parameterized query", ex);
                        new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                    }
                } else {
                    this.dbInfo = new QueryFileInfo("", 0, tempdbInfo, paramSet);
                    this.dbInfo.setUseJNDIDataSource(tempdbInfo.getJNDIName() != null);
                }
            } else {
                this.dbInfo = tempdbInfo;
                this.dbInfo.setUseJNDIDataSource(tempdbInfo.getJNDIName() != null);
            }
        }
    }

    public static void doUpdateChart(Chart chart, DBInfoBasic tdbInfo) {
        try {
            chart.dbInfo.setURLString(tdbInfo.getURLString());
            chart.dbInfo.setDriverName(tdbInfo.getDriverName());
            chart.dbInfo.setUserID(tdbInfo.getUserID());
            chart.dbInfo.setPassword(tdbInfo.getPassword());
            chart.dbInfo.setJNDIName(tdbInfo.getJNDIName());
            chart.dbInfo.setEnvProperties(tdbInfo.getEnvProperties());
            chart.dbInfo.setUseJNDIDataSource(tdbInfo.getJNDIName() != null);
            chart.setOriginalSourceData(-1);
            chart.sourceData = 1;
            chart.originalColDataFromMemSource = null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to set database settings", ex);
        }
    }

    private void prepareResultSet() {
        if (this.dbInfo == null) {
            return;
        }
        this.sourceData = 1;
        ColData[] colData2 = null;
        try {
            if (this.dbInfo instanceof QueryFileInfo) {
                QueryInParam[] paramarray;
                for (QueryInParam element : paramarray = ((QueryFileInfo)this.dbInfo).getInSet().getParameter()) {
                    element.setValue(null);
                }
                QueryFileInfo.setParentDialog(this.manager);
                this.sqlParams = QueryFileInfo.getParameter((QueryFileInfo)this.dbInfo, true);
                if (this.sqlParams == null) {
                    return;
                }
            } else {
                this.sqlParams = null;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get parameter value(s)", ex);
            this.sqlParams = null;
        }
        try {
            colData2 = DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, 0, -1);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to retrieve result set from database", ex);
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString());
            super.doneWizard(this.chart);
            return;
        }
        this.colData = colData2;
        this.displayResult();
    }

    @Override
    public void back() {
    }

    @Override
    public void next() {
    }

    @Override
    public void setPresetDataRegistry(String data) {
    }

    @Override
    public String getPresetDataRegistry() {
        return null;
    }

    @Override
    public void setDataRegistryHiddenNodes(Vector<String> data) {
    }

    @Override
    public Vector<String> getDataRegistryHiddenNodes() {
        return null;
    }
}

