/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Dialog;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ModifyWizard;
import quadbase.chart.designer.WizardStep41;
import quadbase.common.client.FileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.CopyFile;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.EnterSQLDialog;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.ReadXMLTable;
import quadbase.datasourcemanager.manager.WriteXMLDataSources;
import quadbase.querybuilder.designer.ConditionDialog;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SaveBackToRegistryDialog;

public class UpdateQueryWizard
extends ModifyWizard {
    private static final Logger LOGGER = Logger.getLogger(UpdateQueryWizard.class.getName());
    private QueryMain queryMain = null;
    private ConditionDialog cDialog = null;
    private final String DATAVIEWFILEEXT = ".dvw";
    private final String QUERYFILEEXT = ".qry";

    public UpdateQueryWizard(ChartMain f) {
        super(f, true);
        this.setTitle(LanguageEncoder.getText("Modify Query"));
        this.chart = this.chartmain.chart;
        this.stepMultiOp = false;
    }

    public void updateChart() {
        if (this.chart.sourceData != 1 && (this.chart.sourceData != 0 || this.chart.getOriginalSourceData() != 1)) {
            return;
        }
        this.registryID = this.chartmain.chart.registryID;
        this.dataSourceID = this.chartmain.chart.dataSourceID;
        this.dataSourceLoc = this.chartmain.chart.dataSourceLoc;
        boolean failed = true;
        int sourceType = this.chart.getDBSourceType();
        byte[][] fileBytes = this.chart.getQueryFileBytes();
        if (sourceType == Manager.QUERY && fileBytes != null && fileBytes.length == 1) {
            this.dbSourceType = Manager.QUERY;
            this.dbFileBytes = new byte[1][];
            this.dbFileBytes[0] = fileBytes[0];
            failed = !this.doQueryBuilder();
        } else if (sourceType == Manager.DATAVIEW && fileBytes != null && fileBytes.length == 2) {
            this.dbSourceType = Manager.DATAVIEW;
            this.dbFileBytes = new byte[2][];
            this.dbFileBytes[0] = fileBytes[0];
            this.dbFileBytes[1] = fileBytes[1];
            try {
                this.doDataView();
                failed = false;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to get data from data view", ex);
            }
        }
        if (failed) {
            this.dbSourceType = -1;
            this.dbFileBytes = null;
            this.doSQLStatement();
            this.prepareResultSet();
        }
    }

    private void displayResult() {
        this.step41 = new WizardStep41(this, false);
        this.step41.presetValue(this.chart);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.step41);
        this.pack();
        this.validate();
        this.setpos();
        this.setVisible(true);
    }

    private void doSQLStatement() {
        block17: {
            this.queryMain = new QueryMain(this, this);
            this.queryMain.setBrowseDirectories(this.getBrowseDirectories());
            this.queryMain.setDefaultParamNames(this.chartmain.getDefaultParamNames());
            if (this.chart.dbInfo instanceof QueryFileInfo) {
                this.queryMain.setInSet(((QueryFileInfo)this.chart.dbInfo).getInSet());
            }
            QueryInParamSet paramSet = null;
            if (QueryParser.hasParameters(this.chart.dbInfo.getQuery()) && this.chart.dbInfo instanceof QueryFileInfo) {
                paramSet = ((QueryFileInfo)this.chart.dbInfo).getInSet();
            }
            EnterSQLDialog sqlDialog = new EnterSQLDialog(this.chartmain, this.queryMain, this.chart.dbInfo, this.chart.dbInfo.getQuery(), paramSet);
            sqlDialog.setVisible(true);
            if (!sqlDialog.isModified()) {
                this.dbInfo = null;
                return;
            }
            String query = sqlDialog.getSQLStatement();
            if (QueryParser.hasParameters(query)) {
                boolean initializationRequired;
                if (sqlDialog.getInSet() != null) {
                    paramSet = sqlDialog.getInSet();
                }
                if (initializationRequired = QueryParser.initializationRequired(paramSet = QueryParser.filterParameters(query, paramSet))) {
                    try {
                        DBInfoBasic newDBInfo = this.chart.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.chart.dbInfo.getJNDIName(), query, this.chart.dbInfo.getEnvProperties()) : new DBInfoBasic(this.chart.dbInfo.getURLString(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), query, this.chart.dbInfo.getAdditionalDb());
                        INParametersDialog pDialog = new INParametersDialog(this.manager, new QueryFileInfo("", 0, newDBInfo, paramSet), false, this.queryMain.getTableNameFormat());
                        pDialog.setVisible(true);
                        if (!pDialog.isModified()) break block17;
                        QueryFileInfo qinfo = pDialog.getQueryFileInfo();
                        if (qinfo != null) {
                            this.dbInfo = qinfo;
                            break block17;
                        }
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to initialize parameters for parameterized query", ex);
                        new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                    }
                } else {
                    DBInfoBasic newDBInfo = this.chart.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.chart.dbInfo.getJNDIName(), query, this.chart.dbInfo.getEnvProperties()) : new DBInfoBasic(this.chart.dbInfo.getURLString(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), query, this.chart.dbInfo.getAdditionalDb());
                    this.dbInfo = new QueryFileInfo("", 0, newDBInfo, paramSet);
                }
            } else {
                this.dbInfo = this.chart.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.chart.dbInfo.getJNDIName(), query, this.chart.dbInfo.getEnvProperties()) : new DBInfoBasic(this.chart.dbInfo.getURLString(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), query, this.chart.dbInfo.getAdditionalDb());
            }
        }
        if (!this.isReadOnly()) {
            SaveBackToRegistryDialog dialog = new SaveBackToRegistryDialog(this);
            dialog.setVisible(true);
            if (dialog.isOverwrite()) {
                this.overwriteQuery(true);
            } else if (dialog.isSaveAsNew()) {
                this.saveAsNewQuery(true);
            } else if (dialog.isCancelled()) {
                this.dbInfo = null;
            }
        }
    }

    private boolean doQueryBuilder() {
        boolean state;
        this.queryMain = new QueryMain(this, this);
        this.queryMain.setBrowseDirectories(this.getBrowseDirectories());
        this.queryMain.setDefaultParamNames(this.chartmain.getDefaultParamNames());
        this.queryMain.setQueryFileBytes(this.dbFileBytes[0]);
        if (this.chart.dbInfo instanceof QueryFileInfo) {
            this.queryMain.setInSet(((QueryFileInfo)this.chart.dbInfo).getInSet());
        }
        if (!(state = this.queryMain.openQuery(LanguageEncoder.getText("Internal Query"), this.chart.dbInfo.isUseJNDIDataSource(), this.chart.dbInfo.getJNDIName(), this.chart.dbInfo.getEnvProperties(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getURLString(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), this.chart.dbInfo.getQuery()))) {
            return false;
        }
        this.queryMain.setVisible(true);
        return true;
    }

    private void doDataView() throws Exception {
        this.cDialog = new ConditionDialog(this.chartmain, this.chart.dbInfo.isUseJNDIDataSource(), this.chart.dbInfo.getJNDIName(), this.chart.dbInfo.getEnvProperties(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getURLString(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), this.chart.dbInfo.getAdditionalDb(), this.dbFileBytes);
        this.cDialog.setDefaultParamNames(this.chartmain.getDefaultParamNames());
        this.cDialog.setVisible(true);
        if (!this.cDialog.isModified()) {
            return;
        }
        String query = this.cDialog.getQuery();
        if (QueryParser.hasParameters(query)) {
            DBInfoBasic newDBInfo = this.chart.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.chart.dbInfo.getJNDIName(), query, this.chart.dbInfo.getEnvProperties()) : new DBInfoBasic(this.chart.dbInfo.getURLString(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), query, this.chart.dbInfo.getAdditionalDb());
            this.dbInfo = new QueryFileInfo("", 0, newDBInfo, this.cDialog.getInSet());
        } else {
            this.dbInfo = this.chart.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.chart.dbInfo.getJNDIName(), query, this.chart.dbInfo.getEnvProperties()) : new DBInfoBasic(this.chart.dbInfo.getURLString(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), query, this.chart.dbInfo.getAdditionalDb());
        }
        this.dbFileBytes = this.cDialog.getFileBytes();
        if (!this.isReadOnly()) {
            SaveBackToRegistryDialog dialog = new SaveBackToRegistryDialog(this);
            dialog.setVisible(true);
            if (dialog.isOverwrite()) {
                this.overwriteQuery();
            } else if (dialog.isSaveAsNew()) {
                this.saveAsNewQuery();
            } else if (dialog.isCancelled()) {
                this.dbInfo = null;
            }
        }
        this.prepareResultSet();
    }

    private void prepareResultSet() {
        if (this.dbInfo == null) {
            return;
        }
        this.sourceData = 1;
        ColData[] colData2 = null;
        try {
            if (this.dbInfo instanceof QueryFileInfo) {
                QueryInParam[] paramarray;
                for (QueryInParam element : paramarray = ((QueryFileInfo)this.dbInfo).getInSet().getParameter()) {
                    element.setValue(null);
                }
                QueryFileInfo.setParentDialog(this.manager);
                this.sqlParams = QueryFileInfo.getParameter((QueryFileInfo)this.dbInfo, true);
                if (this.sqlParams == null) {
                    return;
                }
            } else {
                this.sqlParams = null;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get parameter value(s)", ex);
            this.sqlParams = null;
        }
        try {
            colData2 = DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, 0, -1);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to retrieve result set from database", ex);
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString());
            super.doneWizard(this.chart);
            return;
        }
        this.colData = colData2;
        this.displayResult();
    }

    @Override
    public void back() {
    }

    @Override
    public void setPresetDataRegistry(String data) {
    }

    @Override
    public String getPresetDataRegistry() {
        return null;
    }

    @Override
    public void setDataRegistryHiddenNodes(Vector<String> data) {
    }

    @Override
    public Vector<String> getDataRegistryHiddenNodes() {
        return null;
    }

    @Override
    public void next() {
        this.queryMain.setVisible(false);
        String query = this.queryMain.getSQL();
        if (QueryParser.hasParameters(query)) {
            DBInfoBasic newDBInfo = this.chart.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.chart.dbInfo.getJNDIName(), query, this.chart.dbInfo.getEnvProperties()) : new DBInfoBasic(this.chart.dbInfo.getURLString(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), query, this.chart.dbInfo.getAdditionalDb());
            this.dbInfo = new QueryFileInfo("", 0, newDBInfo, this.queryMain.getInSet());
        } else {
            this.dbInfo = this.chart.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.chart.dbInfo.getJNDIName(), query, this.chart.dbInfo.getEnvProperties()) : new DBInfoBasic(this.chart.dbInfo.getURLString(), this.chart.dbInfo.getDriverName(), this.chart.dbInfo.getUserID(), this.chart.dbInfo.getPassword(), query, this.chart.dbInfo.getAdditionalDb());
        }
        this.dbFileBytes[0] = this.queryMain.getQueryFileBytes();
        if (!this.isReadOnly()) {
            SaveBackToRegistryDialog dialog = new SaveBackToRegistryDialog(this);
            dialog.setVisible(true);
            if (dialog.isOverwrite()) {
                this.overwriteQuery();
            } else if (dialog.isSaveAsNew()) {
                this.saveAsNewQuery();
            } else if (dialog.isCancelled()) {
                this.dbInfo = null;
            }
        }
        this.prepareResultSet();
    }

    public void overwriteQuery() {
        this.overwriteQuery(false);
    }

    private boolean isReadOnly() {
        if (!this.chartmain.canModify()) {
            return true;
        }
        try {
            ReadXMLTable readxml = new ReadXMLTable();
            String file = this.chartmain.chart.dataSourceLoc;
            if (!new FileInfo(file).exists()) {
                return true;
            }
            readxml.getDataSources(file);
            String message = readxml.isReadOnly();
            return message != null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to read data", ex);
            return true;
        }
    }

    public void overwriteQuery(boolean sqlStatement) {
        ReadXMLTable readxml = new ReadXMLTable();
        try {
            String file = this.chartmain.chart.dataSourceLoc;
            DefaultDataSourceNode root = (DefaultDataSourceNode)readxml.getDataSources(file);
            this.overwriteQuery(root, root, sqlStatement);
            LOGGER.finest("overwriteQuery");
            WriteXMLDataSources.writeDataSources(file, root);
            LOGGER.finest("writeDataSource");
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to overwrite query file", ex);
        }
    }

    void overwriteQuery(DefaultDataSourceNode node, DefaultDataSourceNode root, boolean sqlStatement) {
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            DefaultDataSourceNode child = (DefaultDataSourceNode)node.getChildAt(i);
            if (this.dataSourceID.equals(child.getID()) && this.registryID.equals(root.getRegistryID())) {
                if (child instanceof QueryNode) {
                    ((QueryNode)child).setSQL(this.dbInfo.getQuery());
                    if (this.dbFileBytes != null) {
                        ((QueryNode)child).setBytes(this.dbFileBytes[0]);
                    }
                    if (this.dbInfo instanceof QueryFileInfo) {
                        ((QueryNode)child).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                    }
                    if (this.queryMain == null || sqlStatement) continue;
                    this.queryMain.saveFile(QueryMain.QUERYDIR + ((QueryNode)child).getQueryFile() + ".qry", true);
                    continue;
                }
                if (!(child instanceof DataViewQueryNode)) continue;
                ((DataViewQueryNode)child).setSQL(this.dbInfo.getQuery());
                ((DataViewQueryNode)child).setBytes(this.dbFileBytes);
                if (this.dbInfo instanceof QueryFileInfo) {
                    ((DataViewQueryNode)child).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                }
                this.cDialog.setDataViewQueryNode((DataViewQueryNode)child);
                this.cDialog.doSaveQuery();
                continue;
            }
            this.overwriteQuery(child, root, sqlStatement);
        }
    }

    public void saveAsNewQuery() {
        this.saveAsNewQuery(false);
    }

    public void saveAsNewQuery(boolean sqlStatement) {
        ReadXMLTable readxml = new ReadXMLTable();
        try {
            String file = this.chartmain.chart.dataSourceLoc;
            DefaultDataSourceNode root = (DefaultDataSourceNode)readxml.getDataSources(file);
            this.saveAsNewQuery(root, root, sqlStatement);
            WriteXMLDataSources.writeDataSources(file, root);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to save query", ex);
        }
    }

    public void saveAsNewQuery(DefaultDataSourceNode node, DefaultDataSourceNode root, boolean sqlStatement) {
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            DefaultDataSourceNode child = (DefaultDataSourceNode)node.getChildAt(i);
            if (this.dataSourceID.equals(child.getID()) && this.registryID.equals(root.getRegistryID())) {
                String id;
                DefaultDataSourceNode newNode = null;
                if (child instanceof QueryNode) {
                    newNode = this.getNewQueryNode((QueryNode)child, this.getNewFileName(node, ((QueryNode)child).getName()));
                    id = Long.valueOf(Long.parseLong(root.getLastID()) + 1L).toString();
                    root.setLastID(id);
                    ((QueryNode)newNode).setID(id);
                    ((QueryNode)newNode).setSQL(this.dbInfo.getQuery());
                    if (this.dbFileBytes != null) {
                        ((QueryNode)newNode).setBytes(this.dbFileBytes[0]);
                    }
                    if (this.dbInfo instanceof QueryFileInfo) {
                        ((QueryNode)newNode).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                    }
                    if (this.queryMain != null && !sqlStatement) {
                        this.queryMain.saveFile(QueryMain.QUERYDIR + ((QueryNode)newNode).getQueryFile() + ".qry", true);
                    }
                } else if (child instanceof DataViewQueryNode) {
                    newNode = this.getNewDataViewQueryNode((DataViewQueryNode)child, this.getNewFileName(node, ((DataViewQueryNode)child).getName()));
                    id = Long.valueOf(Long.parseLong(root.getLastID()) + 1L).toString();
                    root.setLastID(id);
                    ((DataViewQueryNode)newNode).setID(id);
                    ((DataViewQueryNode)newNode).setSQL(this.dbInfo.getQuery());
                    ((DataViewQueryNode)newNode).setBytes(this.dbFileBytes);
                    if (this.dbInfo instanceof QueryFileInfo) {
                        ((DataViewQueryNode)newNode).setInSet(((QueryFileInfo)this.dbInfo).getInSet());
                    }
                    this.cDialog.setDataViewQueryNode((DataViewQueryNode)newNode);
                    this.cDialog.doSaveQuery();
                }
                node.add(newNode);
                if (newNode == null) continue;
                this.chartmain.chart.dataSourceID = newNode.getID();
                this.dataSourceID = newNode.getID();
                continue;
            }
            this.saveAsNewQuery(child, root, sqlStatement);
        }
    }

    private QueryNode getNewQueryNode(QueryNode oldNode, String newNodeName) {
        QueryNode newQueryNode = new QueryNode(newNodeName);
        newQueryNode.setSQL(oldNode.getSQL());
        newQueryNode.setQueryBuilderUsed(oldNode.isQueryBuilderUsed());
        String oldQueryFile = oldNode.getQueryFile();
        if (oldNode.isQueryBuilderUsed() && oldQueryFile != null) {
            String newQueryFile = this.getNewQueryFile(oldNode, newNodeName, false, false);
            newQueryNode.setQueryFile(newQueryFile);
            CopyFile.copy(QueryMain.QUERYDIR + oldQueryFile + ".qry", QueryMain.QUERYDIR + newQueryFile + ".qry");
        }
        newQueryNode.setDictionaryCompatible(oldNode.isDictionaryCompatible());
        newQueryNode.setInSet(oldNode.getInSet());
        return newQueryNode;
    }

    private DataViewQueryNode getNewDataViewQueryNode(DataViewQueryNode oldNode, String newNodeName) {
        String newQueryFile;
        DataViewQueryNode dvQueryNode = new DataViewQueryNode(newNodeName);
        dvQueryNode.setSQL(oldNode.getSQL());
        String newDataViewFile = this.getNewQueryFile(oldNode, newNodeName, false, true);
        dvQueryNode.setDataViewFile(newDataViewFile);
        String oldQueryFile = oldNode.getQueryFile();
        String oldDataViewFile = oldNode.getDataViewFile();
        String tmp = newQueryFile = newDataViewFile + "_query";
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + ".dvw").exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error choosing file name", ex);
        }
        newQueryFile = QueryMain.QUERYDIR + newQueryFile;
        dvQueryNode.setQueryFile(newQueryFile);
        CopyFile.copy(QueryMain.QUERYDIR + oldDataViewFile + ".dvw", QueryMain.QUERYDIR + newDataViewFile + ".dvw");
        CopyFile.copy(oldQueryFile + ".dvw", newQueryFile + ".dvw");
        return dvQueryNode;
    }

    private String getNewQueryFile(DefaultDataSourceNode oldNode, String newNodeName, boolean forDataViewNode, boolean forDataViewQueryNode) {
        String ext = forDataViewNode || forDataViewQueryNode ? ".dvw" : ".qry";
        String fileprefix = this.chartmain.chart.dataSourceLoc;
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
        fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
        fileprefix = forDataViewQueryNode ? fileprefix + "_" + ((DataViewNode)oldNode.getParent()).getName() + "_" : fileprefix + "_" + ((DatabaseNode)oldNode.getParent().getParent()).getName() + "_";
        String newQueryFile = fileprefix + newNodeName;
        String tmp = newQueryFile = newQueryFile.replace(' ', '_');
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + ext).exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error choosing file name", ex);
        }
        return newQueryFile;
    }

    private String getNewFileName(DefaultDataSourceNode parent, String fileName) {
        int len;
        int ct = 0;
        for (len = fileName.length(); Character.isDigit(fileName.charAt(len - 1)) && len > 1; --len) {
        }
        if (len < fileName.length()) {
            String ctstring = fileName.substring(len, fileName.length());
            ct = Integer.parseInt(ctstring);
        }
        String tmp = fileName.substring(0, len);
        String newFile = tmp + ct;
        try {
            boolean exist = true;
            while (exist) {
                exist = false;
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    if (!((String)((DefaultDataSourceNode)parent.getChildAt(i)).getUserObject()).equals(newFile)) continue;
                    exist = true;
                    break;
                }
                if (!exist) continue;
                newFile = tmp + ct++;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error choosing file name", ex);
        }
        return newFile;
    }
}

