/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import quadbase.chart.designer.IVariableDialogOwner;
import quadbase.common.util.internal.LanguageEncoder;

public class VariableDialog
extends JDialog
implements ActionListener {
    IVariableDialogOwner td;
    JButton insertButton;
    JButton closeButton;
    JList variableList;

    public VariableDialog(IVariableDialogOwner td) {
        super(td.getChartMain(), LanguageEncoder.getText("Variables..."), true);
        this.setBackground(Color.lightGray);
        this.td = td;
        this.variableList = new JList();
        this.getVariables(this.variableList);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.variableList);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.insertButton = new JButton(LanguageEncoder.getText("Insert"));
        buttonPanel.add(this.insertButton);
        this.insertButton.addActionListener(this);
        this.closeButton = new JButton(LanguageEncoder.getText("Close"));
        buttonPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        cop.add("South", buttonPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VariableDialog.this.close();
            }
        });
        this.pack();
        Dimension dim = this.getPreferredSize();
        Rectangle tdPos = td.getBounds();
        int x = tdPos.x + tdPos.width + 20;
        int y = tdPos.y + (tdPos.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.closeButton) {
            this.close();
        } else if (target == this.insertButton && this.variableList.getSelectedValue() != null) {
            this.td.insertSelectedString();
            this.close();
        }
    }

    public void close() {
        this.td.resetVariableDialog();
        this.setVisible(false);
        this.dispose();
    }

    public String getSelectedString() {
        return this.variableList.getSelectedValue().toString();
    }

    private void getVariables(JList variableList) {
        String[] variable = this.td.getChartMain().chartPanel.chart.valueTable.getAllVariables();
        String[] varList = new String[variable.length];
        int nVariable = variable.length;
        for (int i = 0; i < nVariable; ++i) {
            varList[i] = "&" + variable[i];
        }
        variableList.setListData(varList);
        if (variable.length > 0) {
            variableList.setSelectedIndex(0);
        }
    }
}

