/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.TableResultPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class ViewTableFrame
extends JFrame
implements ActionListener {
    ChartMain chartMain;

    public ViewTableFrame(ChartMain chartMain, String title, Chart chart) {
        super(title);
        this.chartMain = chartMain;
        this.setBackground(Color.lightGray);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setBorder(new EmptyBorder(10, 10, 5, 10));
        cop.setLayout(new BorderLayout());
        if (chart.showLegend2()) {
            JTabbedPane tabPanel = new JTabbedPane();
            tabPanel.add(LanguageEncoder.getText("Primary axis"), new TableResultPanel(chart, chart.mData));
            tabPanel.add(LanguageEncoder.getText("Secondary axis"), new TableResultPanel(chart, chart.mData2));
            cop.add("Center", tabPanel);
        } else {
            cop.add("Center", new TableResultPanel(chart, chart.mData));
        }
        JPanel butpanel = new JPanel();
        butpanel.setLayout(new FlowLayout(2));
        JButton but = new JButton(LanguageEncoder.getText("Close"));
        but.addActionListener(this);
        butpanel.add(but);
        cop.add("South", butpanel);
        but.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ViewTableFrame.this.close();
            }
        });
        this.centerFrame();
    }

    private void centerFrame() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 480);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.close();
    }

    private void close() {
        this.chartMain.viewTableFrame = null;
        this.setVisible(false);
        this.dispose();
    }
}

