/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.designer.ChartWizard;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.LanguageEncoder;

public class WizardStep2
extends PanelAction {
    JRadioButton cb_fromDB;
    JRadioButton cb_fromFile;
    ChartWizard wizard;
    JButton nextButton;
    JButton prevButton;
    JButton cancelButton;
    static final int width = 220;
    static final int height = 10;

    public WizardStep2(ChartWizard wizard, boolean showBackButton) {
        this.wizard = wizard;
        this.setBackground(Color.lightGray);
        BorderPanel bpanel = new BorderPanel(LanguageEncoder.getText("Please select the source of data"));
        bpanel.setLayout(new BorderLayout());
        this.cb_fromDB = new JRadioButton(LanguageEncoder.getText("From Database"), true);
        this.cb_fromFile = new JRadioButton(LanguageEncoder.getText("From File"), false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.cb_fromDB);
        bg.add(this.cb_fromFile);
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new GridLayout(2, 1));
        gridpanel.add(this.cb_fromDB);
        gridpanel.add(this.cb_fromFile);
        bpanel.add("Center", gridpanel);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        if (showBackButton) {
            this.prevButton = new JButton(LanguageEncoder.getText("<< Back"));
            okpanel.add(this.prevButton);
            this.prevButton.addActionListener(this);
        }
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        okpanel.add(this.cancelButton);
        this.nextButton = new JButton(LanguageEncoder.getText("Next >>"));
        okpanel.add(this.nextButton);
        this.cancelButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.nextButton.requestFocus();
        bpanel.add("South", okpanel);
        this.setLayout(new BorderLayout());
        this.add("Center", bpanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.nextButton) {
            if (this.cb_fromDB.isSelected()) {
                this.wizard.getFromDB();
            } else {
                this.wizard.getFromFile();
            }
        } else if (source == this.prevButton) {
            this.wizard.getStep1(true);
        } else {
            this.wizard.cancel();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension defaultDim = super.getPreferredSize();
        int defaultWidth = defaultDim.width;
        return new Dimension(Math.max(defaultWidth, 220), defaultDim.height);
    }
}

