/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.DBPanel;
import quadbase.chart.designer.YAStatusBar;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.CanShowHint;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.LanguageEncoder;

public class WizardStep3
extends PanelAction {
    private static final Logger LOGGER = Logger.getLogger(WizardStep3.class.getName());
    JButton nextButton;
    JButton prevButton;
    JButton cancelButton;
    ChartWizard wizard;
    static final int width = 560;
    static final int height = 485;
    CanShowHint statusBar;
    DBPanel dbpanel;

    public WizardStep3(ChartWizard wizard) {
        this.wizard = wizard;
        this.setBackground(Color.lightGray);
        String url = "jdbc:odbc:";
        String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
        String username = "";
        String password = "";
        String query = "";
        DBInfoBasic dbInfo = new DBInfoBasic(url, driver, username, password, query);
        this.dbpanel = new DBPanel(dbInfo);
        this.setLayout(new BorderLayout());
        this.add("North", this.dbpanel);
        JPanel butpanel = new JPanel();
        butpanel.setLayout(new FlowLayout(2));
        this.prevButton = new JButton("<< Back");
        butpanel.add(this.prevButton);
        this.cancelButton = new JButton("Cancel");
        butpanel.add(this.cancelButton);
        this.nextButton = new JButton("Next >>");
        butpanel.add(this.nextButton);
        this.prevButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.add("Center", butpanel);
        this.statusBar = new YAStatusBar();
        ((YAStatusBar)this.statusBar).setDelay(30000L);
        this.add("South", (Component)((Object)this.statusBar));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nextButton) {
            this.wizard.sourceData = 1;
            this.wizard.queryFilename = this.dbpanel.getQueryFilename();
            this.wizard.dbInfo = this.dbpanel.getDBInfo();
            if (this.hasParameters()) {
                this.gotoStep32();
            } else {
                this.gotoStep4();
            }
        } else if (e.getSource() == this.prevButton) {
            this.wizard.getStep2(true);
        } else {
            this.wizard.cancel();
        }
    }

    private void gotoStep32() {
        this.wizard.getStep32(true);
    }

    private void gotoStep4() {
        this.disableComponents();
        ColData[] colData = null;
        this.statusBar.showHint("Fetching result, please wait...");
        try {
            colData = DBAccess.retrieveResult(null, this.wizard.dbInfo, true, false, null, null, null);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot retrieve result from database", ex);
            String message = "Cannot retrieve result from database \n " + ex.toString();
            new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show(message);
            this.enableComponents();
            return;
        }
        this.wizard.colData = colData;
        this.enableComponents();
        this.statusBar.showHint("Displaying result, please wait...");
        this.wizard.displayResult(this);
    }

    DBPanel getDBPanel() {
        return this.dbpanel;
    }

    QueryFileInfo getQueryFileInfo() {
        return this.dbpanel.getQueryFileInfo();
    }

    private boolean hasParameters() {
        String query = this.dbpanel.sqlText.getText().trim();
        if (query == null || query.equals("")) {
            return false;
        }
        return QueryParser.hasParameters(query);
    }

    private void disableComponents() {
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.dbpanel.disableComponents();
    }

    private void enableComponents() {
        this.nextButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.statusBar.showHint("");
        this.dbpanel.enableComponents();
    }
}

