/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DataFileInput;
import quadbase.chart.LoadChart;
import quadbase.chart.ReadDataFile;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.YAStatusBar;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.CanShowHint;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.IOUtil;

public class WizardStep31
extends PanelAction {
    private static final Logger LOGGER = Logger.getLogger(WizardStep31.class.getName());
    protected JTextField tf;
    ChartWizard wizard;
    JButton okButton;
    JButton prevButton;
    JButton cancelButton;
    JButton browseButton = null;
    static final int width = 400;
    static final int height = 170;
    CanShowHint statusbar;
    boolean openfile;
    JFileChooser fDialog = null;
    BrowseDialog bDialog = null;

    public WizardStep31(ChartWizard wizard) {
        this(wizard, false);
    }

    public WizardStep31(ChartWizard wizard, boolean openfile) {
        this.wizard = wizard;
        this.openfile = openfile;
        this.setBackground(Color.lightGray);
        BorderPanel bpanel = new BorderPanel("Please input the filename");
        bpanel.setLayout(new FlowLayout(0));
        this.tf = new JTextField("", 45);
        this.tf.addActionListener(this);
        bpanel.add("Center", this.tf);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.browseButton = new JButton("Browse...");
        okpanel.add(this.browseButton);
        this.browseButton.addActionListener(this);
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            this.fDialog = new JFileChooser();
            if (wizard.chartmain.lastDir == "") {
                this.fDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
            } else {
                try {
                    this.fDialog.setCurrentDirectory(new File(wizard.chartmain.lastDir));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Error setting current directory, using user.dir", ex);
                    this.fDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
                }
            }
            if (openfile) {
                ExtensionFilter fileFilter = new ExtensionFilter(new String[0]);
                this.fDialog.setFileFilter(fileFilter);
            }
            wizard.chartmain.lastDir = this.fDialog.getCurrentDirectory().getAbsolutePath();
        }
        this.prevButton = new JButton("<< Back");
        okpanel.add(this.prevButton);
        this.cancelButton = new JButton("Cancel");
        okpanel.add(this.cancelButton);
        this.okButton = new JButton("Next >>");
        okpanel.add(this.okButton);
        this.prevButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("North", bpanel);
        this.add("Center", okpanel);
        this.statusbar = new YAStatusBar();
        ((YAStatusBar)this.statusbar).setDelay(30000L);
        this.add("South", (Component)((Object)this.statusbar));
        this.tf.requestFocus();
    }

    private void setEnabledButtons(boolean option) {
        if (this.okButton != null) {
            this.okButton.setEnabled(option);
        }
        if (this.prevButton != null) {
            this.prevButton.setEnabled(option);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(option);
        }
        if (this.browseButton != null) {
            this.browseButton.setEnabled(option);
        }
    }

    private String loadFile() {
        if (this.bDialog == null) {
            if (this.openfile) {
                String[] ext = new String[]{".TPL", ".CHT", ".XML"};
                this.bDialog = BrowseDialog.create(this.wizard.chartmain, this.wizard.chartmain.getBrowseDialogDefaultDirectory(), ext);
            } else {
                this.bDialog = BrowseDialog.create(this.wizard.chartmain, this.wizard.chartmain.getBrowseDialogDefaultDirectory());
            }
        }
        this.bDialog.setVisible(true);
        this.wizard.chartmain.lastDir = this.bDialog.getCurrentDirectory();
        return this.bDialog.getSelectedFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.browseButton) {
            if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
                this.loadFile();
            } else {
                this.fDialog.showDialog(this.wizard, null);
            }
        } else if (target == this.okButton || target == this.tf) {
            this.setEnabledButtons(false);
            this.statusbar.showHint("Opening file...");
            String file = this.tf.getText();
            if (file == null) {
                return;
            }
            file = this.wizard.chartmain.getPath(file);
            if (!this.openfile) {
                ColData[] colData = null;
                try {
                    colData = new DataFileInput().readProcessedData(file, false, null, null, null);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Error reading processed data", ex);
                    new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show(ex.toString());
                    this.statusbar.showHint("");
                    this.setEnabledButtons(true);
                    return;
                }
                this.wizard.colData = colData;
                this.wizard.sourceFile = file;
                this.wizard.sourceData = 2;
                this.statusbar.showHint("");
                this.setEnabledButtons(true);
                this.wizard.displayResult(this);
            } else {
                Chart chart;
                if (!(file.endsWith(".tpl") || file.endsWith(".cht") || file.endsWith(".xml"))) {
                    file = file + ".cht";
                }
                DataInputStream din = null;
                ReadDataFile readfile = new ReadDataFile();
                if (IOUtil.isXMLFormat(file)) {
                    try {
                        chart = readfile.createXMLChart(file, this.wizard.chartmain.chartPanel);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Cannot create chart", ex);
                        new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show("Cannot create chart!\n" + ex.getMessage());
                        this.statusbar.showHint("");
                        this.setEnabledButtons(true);
                        return;
                    }
                }
                try {
                    din = readfile.getInputStream(file);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to open file: " + file, ex);
                    new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show("Failed to open file " + file);
                    this.statusbar.showHint("");
                    this.setEnabledButtons(true);
                    return;
                }
                try {
                    chart = new LoadChart().load(this.wizard.chartmain.chartPanel, din, file.endsWith(".tpl"), null);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Invalid file format", ex);
                    new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show("Invalid file format !\n" + ex.getMessage());
                    try {
                        readfile.close();
                    }
                    catch (Exception ex2) {
                        LOGGER.log(Level.FINEST, "Can't close file", ex2);
                    }
                    this.statusbar.showHint("");
                    this.setEnabledButtons(true);
                    return;
                }
                try {
                    readfile.close();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Can't close file", ex);
                }
                this.wizard.doneloading(chart, file);
            }
        } else if (target == this.prevButton) {
            if (!this.openfile) {
                this.wizard.getStep2(false);
            } else {
                this.wizard.getStep1(false);
            }
        } else {
            this.wizard.cancel();
        }
    }
}

