/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.SaveQueryFileDialog;
import quadbase.common.paramquery.AvailColumn;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class WizardStep32
extends JPanel
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(WizardStep32.class.getName());
    JDialog dialog;
    ChartWizard wizard;
    QueryFileInfo queryFileInfo;
    protected JPanel mainPanel;
    JPanel subPanel1b;
    JPanel subPanel2a;
    JCheckBox mapDBcheckbox;
    JComboBox paramChoice;
    JComboBox columnChoice;
    JComboBox typeChoice;
    JComboBox defaultChoice;
    JButton prevParamButton;
    JButton nextParamButton;
    JButton prevPanelButton;
    JButton cancelButton;
    JButton nextPanelButton;
    JTextField promptText;
    JTextField defaultText;
    Vector<AvailColumn> availColumn = null;
    Vector<Object> distinctValue;
    boolean showingDefaultText;
    boolean isCallableStmt;
    boolean[] isParamInitialized;
    int nParam;
    int prevParamIndex = 0;
    int[] choiceMapToType = new int[]{-7, -6, 5, 4, -5, 6, 7, 8, 2, 3, 1, 12, -1, 91, 92, 93};
    String query;
    QueryInParam[] queryInParam;
    int[][] inParamMap;
    Vector<Integer> inParamType;
    QueryInParamSet setSave;

    public WizardStep32(JDialog dialog, QueryFileInfo queryFileInfo) throws Exception {
        this.dialog = dialog;
        this.queryFileInfo = queryFileInfo;
        this.query = queryFileInfo.getQuery();
        this.inParamMap = QueryInParamSet.makeParamMap(this.query);
        this.isCallableStmt = QueryParser.isCallableStmt(this.query);
        this.inParamType = QueryParser.getParamTypes(queryFileInfo);
        this.setSave = queryFileInfo.getInSet() == null ? null : (QueryInParamSet)queryFileInfo.getInSet().clone();
        this.setBackground(Color.lightGray);
        this.makeMainPanel();
        if (queryFileInfo.getInSet() != null) {
            this.queryInParam = queryFileInfo.getInSet().getParameter();
            for (int i = 0; i < this.nParam; ++i) {
                this.isParamInitialized[i] = true;
            }
            this.resetAttributePanel();
        }
    }

    public WizardStep32(ChartWizard wizard, QueryFileInfo queryFileInfo) throws Exception {
        this((JDialog)wizard, queryFileInfo);
        this.wizard = wizard;
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.prevPanelButton = new JButton(LanguageEncoder.getText("<< Back"));
        okPanel.add(this.prevPanelButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        okPanel.add(this.cancelButton);
        this.nextPanelButton = new JButton(LanguageEncoder.getText("Next >>"));
        okPanel.add(this.nextPanelButton);
        this.prevPanelButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.nextPanelButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("North", this.mainPanel);
        this.add("Center", okPanel);
    }

    private void makeMainPanel() throws Exception {
        int i;
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("IN parameters")));
        this.mainPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel sqlPanel = new JPanel();
        sqlPanel.setLayout(new BorderLayout());
        sqlPanel.add("North", new JLabel(LanguageEncoder.getText("SQL Statement :")));
        JTextArea sqlText = new JTextArea(this.breakQuery(this.query), 4, 50);
        sqlPanel.add("Center", sqlText);
        sqlText.setEditable(false);
        topPanel.add("North", sqlPanel);
        JPanel paramPanel = new JPanel();
        this.paramChoice = new JComboBox();
        String[] paramName = QueryParser.getAllParameters(this.query);
        this.nParam = paramName.length;
        for (i = 0; i < this.nParam; ++i) {
            this.paramChoice.addItem(paramName[i]);
        }
        this.isParamInitialized = new boolean[this.nParam];
        this.isParamInitialized[0] = true;
        for (i = 1; i < this.nParam; ++i) {
            this.isParamInitialized[i] = false;
        }
        this.queryInParam = new QueryInParam[this.nParam];
        paramPanel.setLayout(new FlowLayout(0));
        paramPanel.add(new JLabel(LanguageEncoder.getText("Parameter")));
        paramPanel.add(this.paramChoice);
        this.paramChoice.addItemListener(this);
        topPanel.add("Center", paramPanel);
        JPanel attributePanel = new JPanel();
        attributePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Attributes")));
        attributePanel.setLayout(new GridLayout(0, 1, 5, 5));
        JPanel subPanel1 = new JPanel(new FlowLayout(0));
        JPanel subPanel1a = new JPanel();
        this.mapDBcheckbox = new JCheckBox(LanguageEncoder.getText("Map to database column"));
        subPanel1a.add(this.mapDBcheckbox);
        this.mapDBcheckbox.addItemListener(this);
        this.columnChoice = new JComboBox();
        this.subPanel1b = new JPanel();
        this.subPanel1b.add(this.columnChoice);
        this.availColumn = AvailColumn.makeArray(this.queryFileInfo, (String)this.paramChoice.getItemAt(0));
        this.mapDBcheckbox.setEnabled(this.availColumn.size() > 0);
        this.setupColumnChoice();
        this.columnChoice.addItemListener(this);
        this.columnChoice.setEnabled(this.mapDBcheckbox.isSelected());
        subPanel1.add(subPanel1a);
        subPanel1.add(this.subPanel1b);
        attributePanel.add(subPanel1);
        JPanel subPanel2 = new JPanel(new BorderLayout());
        this.subPanel2a = new JPanel(new FlowLayout());
        this.subPanel2a.add(new JLabel(LanguageEncoder.getText("Default Value")));
        this.defaultText = new JTextField(10);
        this.subPanel2a.add(this.defaultText);
        this.showingDefaultText = true;
        this.defaultChoice = new JComboBox();
        JPanel subPanel2b = new JPanel(new FlowLayout());
        subPanel2b.add(new JLabel(LanguageEncoder.getText("Data Type")));
        this.typeChoice = new JComboBox();
        subPanel2b.add(this.typeChoice);
        this.addAllTypes(this.typeChoice);
        this.setParamTypeForProcedure();
        subPanel2.add("West", this.subPanel2a);
        subPanel2.add("East", subPanel2b);
        attributePanel.add(subPanel2);
        JPanel UIpanel = new JPanel(new FlowLayout(0));
        UIpanel.setBorder(new TitledBorder(LanguageEncoder.getText("User Interface")));
        UIpanel.add(new JLabel(LanguageEncoder.getText("Prompt Name:")));
        this.promptText = new JTextField((String)this.paramChoice.getItemAt(0), 20);
        UIpanel.add(this.promptText);
        JPanel bodyPanel = new JPanel(new BorderLayout());
        bodyPanel.add("North", attributePanel);
        bodyPanel.add("Center", UIpanel);
        JPanel flowPanel = new JPanel(new FlowLayout(2));
        this.prevParamButton = new JButton(LanguageEncoder.getText("Previous Parameter"));
        flowPanel.add(this.prevParamButton);
        this.nextParamButton = new JButton(LanguageEncoder.getText("Next Parameter"));
        flowPanel.add(this.nextParamButton);
        this.prevParamButton.addActionListener(this);
        this.nextParamButton.addActionListener(this);
        this.setFlowButtons();
        this.mainPanel.add("North", topPanel);
        this.mainPanel.add("Center", bodyPanel);
        this.mainPanel.add("South", flowPanel);
    }

    private AvailColumn getAvailColumn(int index) {
        return this.availColumn.elementAt(index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.paramChoice) {
            if (this.makeQueryInParam(this.prevParamIndex)) {
                this.prevParamIndex = this.paramChoice.getSelectedIndex();
                this.resetAttributePanel();
            }
        } else if (source == this.mapDBcheckbox) {
            this.typeChoice.setEnabled(!this.mapDBcheckbox.isSelected());
            this.selectColumnChoice();
            this.setDefaultValueUI();
        } else if (source == this.columnChoice) {
            this.setTypeChoice();
            this.resetDefaultChoice();
            this.setDefaultValueUI();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int index = this.paramChoice.getSelectedIndex();
        if (source == this.prevParamButton || source == this.nextParamButton) {
            if (this.makeQueryInParam(index)) {
                this.isParamInitialized[index] = true;
                if (e.getSource() == this.prevParamButton && index > 0) {
                    this.paramChoice.setSelectedIndex(--index);
                    this.prevParamIndex = index;
                    this.resetAttributePanel();
                } else if (e.getSource() == this.nextParamButton && index < this.nParam - 1) {
                    this.paramChoice.setSelectedIndex(++index);
                    this.prevParamIndex = index;
                    this.resetAttributePanel();
                }
            }
        } else if (source == this.prevPanelButton) {
            this.wizard.getStep3(this);
        } else if (source == this.nextPanelButton) {
            if (this.makeQueryInParam(index)) {
                QueryInParamSet set = this.getQueryInParamSet();
                if (set == null) {
                    String paramString = "";
                    int count = 0;
                    for (int i = 0; i < this.isParamInitialized.length; ++i) {
                        if (this.isParamInitialized[i]) continue;
                        paramString = paramString + (String)this.paramChoice.getItemAt(i) + ", ";
                        ++count;
                    }
                    paramString = paramString.substring(0, paramString.length() - 2);
                    String message = count == 1 ? LanguageEncoder.getText("Parameter:") + " " + paramString + " " + LanguageEncoder.getText("is not initialized") : LanguageEncoder.getText("Parameter:") + " " + paramString + " " + LanguageEncoder.getText("are not initialized");
                    new JMessageDialog((Dialog)this.wizard, LanguageEncoder.getText("Error"), message);
                } else {
                    this.gotoNextStep(this.getQueryFileInfo());
                }
            }
        } else if (source == this.cancelButton) {
            this.cancel();
        }
    }

    private void setTypeChoice() {
        boolean mapState = this.mapDBcheckbox.isSelected();
        this.typeChoice.setEnabled(!mapState);
        int index = this.columnChoice.getSelectedIndex();
        if (mapState && index == 0) {
            ++index;
            this.selectColumnChoice();
        }
        for (int i = 0; i < this.choiceMapToType.length; ++i) {
            if (this.getAvailColumn(index - 1).getSqlType() != this.choiceMapToType[i]) continue;
            this.typeChoice.setSelectedIndex(i);
        }
    }

    private String breakQuery(String query) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(query, " \t\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("from") || token.equalsIgnoreCase("where") || token.equalsIgnoreCase("group") || token.equalsIgnoreCase("having") || token.equalsIgnoreCase("order")) {
                sb.append("\n");
            }
            sb.append(token);
            sb.append(" ");
        }
        return sb.toString();
    }

    private void addAllTypes(JComboBox choice) {
        choice.addItem(DataType.getTypeName(-7));
        choice.addItem(DataType.getTypeName(-6));
        choice.addItem(DataType.getTypeName(5));
        choice.addItem(DataType.getTypeName(4));
        choice.addItem(DataType.getTypeName(-5));
        choice.addItem(DataType.getTypeName(6));
        choice.addItem(DataType.getTypeName(7));
        choice.addItem(DataType.getTypeName(8));
        choice.addItem(DataType.getTypeName(2));
        choice.addItem(DataType.getTypeName(3));
        choice.addItem(DataType.getTypeName(1));
        choice.addItem(DataType.getTypeName(12));
        choice.addItem(DataType.getTypeName(-1));
        choice.addItem(DataType.getTypeName(91));
        choice.addItem(DataType.getTypeName(92));
        choice.addItem(DataType.getTypeName(93));
        if (this.availColumn.size() > 0) {
            int target = this.getAvailColumn(0).getSqlType();
            for (int i = 0; i < this.choiceMapToType.length; ++i) {
                if (target != this.choiceMapToType[i]) continue;
                choice.setSelectedIndex(i);
            }
        }
    }

    private void setFlowButtons() {
        int nParameter = this.paramChoice.getItemCount();
        int index = this.paramChoice.getSelectedIndex();
        this.prevParamButton.setEnabled(index > 0);
        this.nextParamButton.setEnabled(index < nParameter - 1);
    }

    private void setDefaultValueUI() {
        if (this.mapDBcheckbox.isSelected() && this.showingDefaultText) {
            this.removeDefaultText();
        } else if (!this.mapDBcheckbox.isSelected() && !this.showingDefaultText) {
            this.removeDefaultChoice();
        } else if (!this.showingDefaultText) {
            this.resetDefaultChoice();
        }
    }

    private void removeDefaultText() {
        this.resetDefaultChoice();
    }

    private void removeDefaultChoice() {
        boolean saveState = this.mapDBcheckbox.isEnabled();
        this.setEnableState(false);
        this.showingDefaultText = true;
        this.subPanel2a.remove(this.defaultChoice);
        this.defaultText.setText("");
        this.subPanel2a.add(this.defaultText);
        this.dialog.pack();
        this.dialog.validate();
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(saveState);
    }

    private void resetDefaultChoice() {
        Object defaultValue;
        boolean saveState = this.mapDBcheckbox.isEnabled();
        this.setEnableState(false);
        if (this.showingDefaultText) {
            this.subPanel2a.remove(this.defaultText);
            this.showingDefaultText = false;
        } else {
            this.subPanel2a.remove(this.defaultChoice);
        }
        this.defaultChoice.removeItemListener(this);
        this.defaultChoice = new JComboBox();
        AvailColumn temp = this.getAvailColumn(this.columnChoice.getSelectedIndex() - 1);
        this.distinctValue = QueryParser.getDistinctValues(this.queryFileInfo, temp.getTableName(), temp.getColumnName());
        int size = this.distinctValue.size();
        for (int i = 0; i < size; ++i) {
            this.defaultChoice.addItem(this.distinctValue.elementAt(i).toString());
        }
        QueryInParam currParam = this.queryInParam[this.paramChoice.getSelectedIndex()];
        if (currParam != null && (defaultValue = currParam.getDefaultValue(this.queryFileInfo)) != null) {
            String defaultString = defaultValue.toString();
            for (int i = 0; i < size; ++i) {
                if (!((String)this.defaultChoice.getItemAt(i)).equals(defaultString)) continue;
                this.defaultChoice.setSelectedIndex(i);
                break;
            }
        }
        this.subPanel2a.add(this.defaultChoice);
        this.dialog.pack();
        this.dialog.validate();
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(saveState);
    }

    private boolean areAllInitialized() {
        for (int i = 0; i < this.isParamInitialized.length; ++i) {
            if (this.isParamInitialized[i]) continue;
            return false;
        }
        return true;
    }

    private Object makeDefaultValue() {
        if (this.showingDefaultText) {
            return this.makeDefaultValueFromText();
        }
        return this.makeDefaultValueFromChoice();
    }

    private Object makeDefaultValueFromChoice() {
        return this.distinctValue.elementAt(this.defaultChoice.getSelectedIndex());
    }

    private Object makeDefaultValueFromText() throws IllegalArgumentException, NumberFormatException {
        String text = this.defaultText.getText();
        text = text.trim();
        int dataType = DataType.mapType(this.choiceMapToType[this.typeChoice.getSelectedIndex()]);
        if (text.equals("") && dataType != 7) {
            return null;
        }
        return DataType.createObject(text, dataType);
    }

    public QueryFileInfo getQueryFileInfo() {
        if (!this.areAllInitialized()) {
            return null;
        }
        QueryInParamSet inSet = new QueryInParamSet(this.queryInParam);
        this.queryFileInfo.setInSet(inSet);
        return this.queryFileInfo;
    }

    public QueryInParamSet getQueryInParamSet() {
        if (!this.areAllInitialized()) {
            return null;
        }
        return new QueryInParamSet(this.queryInParam);
    }

    private boolean makeQueryInParam(int paramIndex) {
        Object defaultValue;
        String columnName;
        String tableName;
        String paramName = (String)this.paramChoice.getItemAt(paramIndex);
        String promptName = this.promptText.getText();
        boolean mapToColumn = this.mapDBcheckbox.isSelected();
        if (mapToColumn) {
            int columnIndex = this.columnChoice.getSelectedIndex() - 1;
            tableName = this.getAvailColumn(columnIndex).getTableName();
            columnName = this.getAvailColumn(columnIndex).getColumnName();
        } else {
            tableName = "";
            columnName = "";
        }
        int sqlType = this.choiceMapToType[this.typeChoice.getSelectedIndex()];
        try {
            defaultValue = this.makeDefaultValue();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Default value doesn't match data type", ex);
            new JMessageDialog((Dialog)this.dialog, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Default value doesn't match data type"));
            this.isParamInitialized[paramIndex] = false;
            return false;
        }
        this.queryInParam[paramIndex] = new QueryInParam(this.inParamMap[paramIndex], paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, null);
        this.isParamInitialized[paramIndex] = true;
        return true;
    }

    private void resetAttributePanel() {
        this.setFlowButtons();
        int paramIndex = this.paramChoice.getSelectedIndex();
        this.resetColumnChoice(paramIndex);
        if (this.isParamInitialized[paramIndex]) {
            int i;
            int choiceSize;
            QueryInParam currParam = this.queryInParam[paramIndex];
            this.promptText.setText(currParam.getPromptName());
            boolean state = currParam.isMapToColumn();
            this.mapDBcheckbox.setSelected(state);
            if (state) {
                this.selectColumnChoice();
                choiceSize = this.columnChoice.getItemCount() - 1;
                for (i = 0; i < choiceSize; ++i) {
                    if (!currParam.getCompleteName().equals(this.columnChoice.getItemAt(i + 1))) continue;
                    this.columnChoice.setSelectedIndex(i + 1);
                }
            } else {
                this.columnChoice.setSelectedIndex(0);
            }
            this.columnChoice.setEnabled(state);
            choiceSize = this.choiceMapToType.length;
            for (i = 0; i < choiceSize; ++i) {
                if (this.choiceMapToType[i] != currParam.getSqlType()) continue;
                this.typeChoice.setSelectedIndex(i);
            }
            this.typeChoice.setEnabled(!state);
            this.setDefaultValueUI();
            Object defaultValue = currParam.getDefaultValue(this.queryFileInfo);
            this.defaultText.setText(defaultValue == null ? "" : defaultValue.toString());
        } else {
            this.promptText.setText((String)this.paramChoice.getItemAt(paramIndex));
            this.mapDBcheckbox.setSelected(false);
            this.resetColumnChoice(paramIndex);
            if (this.availColumn.size() > 0) {
                int target = this.getAvailColumn(0).getSqlType();
                for (int i = 0; i < this.choiceMapToType.length; ++i) {
                    if (target != this.choiceMapToType[i]) continue;
                    this.typeChoice.setSelectedIndex(i);
                }
            }
            this.setParamTypeForProcedure();
            this.setDefaultValueUI();
            this.defaultText.setText("");
            this.isParamInitialized[paramIndex] = true;
        }
    }

    private void resetColumnChoice(int paramIndex) {
        boolean saveState = this.mapDBcheckbox.isEnabled();
        this.setEnableState(false);
        this.subPanel1b.remove(this.columnChoice);
        this.columnChoice.removeItemListener(this);
        this.columnChoice = new JComboBox();
        try {
            this.availColumn = AvailColumn.makeArray(this.queryFileInfo, (String)this.paramChoice.getItemAt(paramIndex));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to create list of available columns", ex);
            new JMessageDialog((Dialog)this.dialog, LanguageEncoder.getText("Error"), ex.toString());
            this.cancel();
        }
        this.mapDBcheckbox.setEnabled(this.availColumn.size() > 0);
        this.typeChoice.setEnabled(!this.mapDBcheckbox.isSelected());
        this.setupColumnChoice();
        this.columnChoice.setSelectedIndex(0);
        this.columnChoice.setEnabled(false);
        this.columnChoice.addItemListener(this);
        this.subPanel1b.add(this.columnChoice);
        this.dialog.pack();
        this.dialog.validate();
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(saveState);
    }

    private void setParamTypeForProcedure() {
        if (this.isCallableStmt) {
            int index = this.paramChoice.getSelectedIndex();
            if (this.inParamType.size() > index) {
                int dataType = this.inParamType.elementAt(index);
                for (int i = 0; i < this.choiceMapToType.length; ++i) {
                    if (dataType != this.choiceMapToType[i]) continue;
                    this.typeChoice.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    private void gotoNextStep(QueryFileInfo queryFileInfo) {
        if (this.setSave != null && this.setSave.exactEquals(queryFileInfo.getInSet())) {
            this.wizard.getStep33();
        } else {
            SaveQueryFileDialog saveDialog = new SaveQueryFileDialog(this.wizard, queryFileInfo);
            saveDialog.setVisible(true);
            String tempFilename = saveDialog.getQueryFilename();
            if (!tempFilename.equals("")) {
                this.wizard.queryFilename = tempFilename;
            }
            if (!saveDialog.hasError()) {
                this.setSave = (QueryInParamSet)queryFileInfo.getInSet().clone();
                this.wizard.getStep33();
            } else {
                this.cancel();
            }
        }
    }

    private void setupColumnChoice() {
        int size = this.availColumn.size();
        this.columnChoice.addItem(LanguageEncoder.getText("Not Applicable"));
        for (int i = 0; i < size; ++i) {
            this.columnChoice.addItem(this.getAvailColumn(i).getCompleteName());
        }
        this.selectColumnChoice();
    }

    private void selectColumnChoice() {
        boolean mapState = this.mapDBcheckbox.isSelected();
        this.columnChoice.setEnabled(mapState);
        if (!mapState) {
            this.columnChoice.setSelectedIndex(0);
            return;
        }
        boolean findColumn = false;
        int size = this.availColumn.size();
        for (int i = 0; i < size; ++i) {
            if (!this.getAvailColumn(i).isDefaultColumn()) continue;
            this.columnChoice.setSelectedIndex(i + 1);
            if (this.typeChoice != null) {
                this.setTypeChoice();
            }
            findColumn = true;
            break;
        }
        if (!findColumn) {
            if (this.columnChoice.getItemCount() == 1) {
                this.columnChoice.setSelectedIndex(0);
            } else {
                this.columnChoice.setSelectedIndex(1);
                if (this.typeChoice != null) {
                    this.setTypeChoice();
                }
            }
        }
    }

    private void cancel() {
        if (this.wizard != null) {
            this.wizard.cancel();
        } else {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void setEnableState(boolean state) {
        this.mapDBcheckbox.setEnabled(state);
        if (this.prevPanelButton != null) {
            this.prevPanelButton.setEnabled(state);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(state);
        }
        if (this.nextPanelButton != null) {
            this.nextPanelButton.setEnabled(state);
        }
    }
}

