/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.YAStatusBar;
import quadbase.chartviewer.swing.EnterInParamPanel;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.CanShowHint;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.LanguageEncoder;

public class WizardStep33
extends PanelAction {
    private static final Logger LOGGER = Logger.getLogger(WizardStep33.class.getName());
    ChartWizard wizard;
    QueryFileInfo queryFileInfo;
    EnterInParamPanel editPanel;
    CanShowHint statusBar;
    JButton prevPanelButton;
    JButton cancelButton;
    JButton nextPanelButton;
    QueryInParam[] queryInParam;

    public WizardStep33(ChartWizard wizard, QueryFileInfo queryFileInfo) {
        this.wizard = wizard;
        this.queryFileInfo = queryFileInfo;
        this.setLayout(new BorderLayout());
        try {
            this.editPanel = new EnterInParamPanel(queryFileInfo, false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to initialize EnterInParamPanel", ex);
        }
        String label = null;
        label = queryFileInfo.getInParam().length > 1 ? "Please enter values" : "Please enter value";
        BorderPanel mainPanel = new BorderPanel(label);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("Center", this.editPanel);
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.prevPanelButton = new JButton("<< Back");
        okPanel.add(this.prevPanelButton);
        this.cancelButton = new JButton("Cancel");
        okPanel.add(this.cancelButton);
        this.nextPanelButton = new JButton("Next >>");
        okPanel.add(this.nextPanelButton);
        this.prevPanelButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.nextPanelButton.addActionListener(this);
        this.statusBar = new YAStatusBar();
        ((YAStatusBar)this.statusBar).setDelay(30000L);
        this.add("North", mainPanel);
        this.add("Center", okPanel);
        this.add("South", (Component)((Object)this.statusBar));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.prevPanelButton) {
            this.wizard.getStep32(false);
        } else if (source == this.nextPanelButton) {
            this.queryInParam = this.editPanel.getQueryInParam();
            if (this.queryInParam != null) {
                this.queryFileInfo.getInSet().setParameter(this.queryInParam);
                this.gotoStep4();
            }
        } else {
            this.wizard.cancel();
        }
    }

    private void gotoStep4() {
        this.setEnabled(false);
        Vector<QueryInParamSet> inOutParam = this.queryFileInfo.makeVector();
        String driver = this.queryFileInfo.getDriverName();
        String url = this.queryFileInfo.getURLString();
        String userid = this.queryFileInfo.getUserID();
        String password = this.queryFileInfo.getPassword();
        String query = this.queryFileInfo.getQuery();
        Vector<String> addDb = this.queryFileInfo.getAdditionalDb();
        this.statusBar.showHint("Fetching result...");
        ColData[] colData = null;
        try {
            DBInfoBasic dbInfo = this.queryFileInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.queryFileInfo.getJNDIName(), query, this.queryFileInfo.getEnvProperties()) : new DBInfoBasic(url, driver, userid, password, query, addDb);
            colData = DBAccess.retrieveResult(inOutParam, dbInfo, true, false, null, null, null);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error in SQL", ex);
            this.statusBar.showHint("Error in SQL");
            new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show(ex.toString());
            this.statusBar.showHint("");
            this.setEnabled(true);
            return;
        }
        this.wizard.colData = colData;
        this.wizard.sourceData = 1;
        this.statusBar.showHint("");
        this.setEnabled(true);
        this.wizard.displayResult(this);
    }

    @Override
    public void setEnabled(boolean state) {
        this.prevPanelButton.setEnabled(state);
        this.cancelButton.setEnabled(state);
        this.nextPanelButton.setEnabled(state);
        this.editPanel.setEnabled(state);
        if (state) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public QueryFileInfo getQueryFileInfo() {
        return this.queryFileInfo;
    }

    public QueryInParamSet getQueryInParamSet() {
        if (this.queryInParam == null) {
            return null;
        }
        return new QueryInParamSet(this.queryInParam);
    }
}

