/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.ModifyWizard;
import quadbase.chart.designer.QueryResultPanel;
import quadbase.chart.designer.YAStatusBar;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.TransposeRS;

public class WizardStep41
extends PanelAction
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(WizardStep41.class.getName());
    static int width = 600;
    static final int height = 480;
    static final int TABLESIZE = 20;
    ChartWizard wizard;
    JPanel okpanel;
    JPanel originalAllPanel;
    JPanel originalSomePanel;
    JPanel transposedAllPanel;
    JPanel transposedSomePanel;
    JButton okButton;
    JButton prevButton;
    JButton cancelButton;
    JCheckBox showAllCheckbox;
    YAStatusBar statusBar;
    JPanel switchPanel;
    CardLayout card;
    ColData[] originalData;
    ColData[] transposedData;
    boolean[] transposeCol;
    boolean doPrevious = true;
    boolean processing = false;

    public WizardStep41(ChartWizard wizard) {
        this(wizard, true);
    }

    public WizardStep41(ChartWizard wizard, boolean doPrevious) {
        boolean showSomeData;
        this.wizard = wizard;
        this.doPrevious = doPrevious;
        this.originalData = wizard.colData;
        this.transposedData = null;
        this.setBackground(Color.lightGray);
        BorderPanel bpanel = new BorderPanel(LanguageEncoder.getText("Query Result"));
        bpanel.setLayout(new BorderLayout());
        this.card = new CardLayout();
        this.switchPanel = new JPanel(this.card);
        boolean bl = showSomeData = this.originalData[0].getSize() > 20;
        if (showSomeData) {
            this.originalSomePanel = new QueryResultPanel(this.originalData, 20);
            this.switchPanel.add("originalSome", this.originalSomePanel);
        } else {
            this.originalSomePanel = new QueryResultPanel(this.originalData);
            this.switchPanel.add("originalAll", this.originalSomePanel);
        }
        bpanel.add("Center", this.switchPanel);
        this.okpanel = new JPanel(new FlowLayout(2));
        if (showSomeData) {
            this.showAllCheckbox = new JCheckBox(LanguageEncoder.getText("Show All Records"), false);
            this.okpanel.add(this.showAllCheckbox);
            this.showAllCheckbox.addItemListener(this);
        }
        this.prevButton = new JButton(LanguageEncoder.getText("<< Back"));
        if (doPrevious) {
            this.okpanel.add(this.prevButton);
        }
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okpanel.add(this.cancelButton);
        this.okButton = new JButton(LanguageEncoder.getText("Next >>"));
        this.okpanel.add(this.okButton);
        this.prevButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.statusBar = new YAStatusBar();
        this.statusBar.setDelay(30000L);
        if (showSomeData) {
            this.statusBar.showHint(LanguageEncoder.getText("Showing the first 20 of") + this.originalData[0].getSize() + " " + LanguageEncoder.getText("records"));
        }
        bpanel.add("South", this.okpanel);
        this.setLayout(new BorderLayout());
        this.add("Center", bpanel);
        this.add("South", this.statusBar);
        this.addFocusListener(this);
        if (wizard.isTransposed) {
            try {
                this.transposedData = ColData.getColData(TransposeRS.doTranspose(this.originalData, wizard.transposeCol));
                this.transposedSomePanel = new QueryResultPanel(this.transposedData, 20);
                wizard.colData = this.transposedData;
                wizard.isTransposed = true;
                wizard.transposeCol = this.transposeCol;
                this.card.show(this.switchPanel, "transposedSome");
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to set transposing", ex);
                wizard.isTransposed = false;
                wizard.transposeCol = null;
            }
        } else {
            wizard.transposeCol = null;
        }
    }

    public void presetValue(Chart chart) {
        boolean transposeState = chart.isTransposed();
        LOGGER.finest("IS TRANSPOSE = " + transposeState);
        if (!transposeState) {
            return;
        }
        this.transposeCol = chart.getTransposeColumn();
        try {
            this.transposedData = ColData.getColData(TransposeRS.doTranspose(this.originalData, this.transposeCol));
            this.transposedSomePanel = new QueryResultPanel(this.transposedData, 20);
            this.wizard.colData = this.transposedData;
            this.wizard.isTransposed = true;
            this.wizard.transposeCol = this.transposeCol;
            this.card.show(this.switchPanel, "transposedSome");
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to set transposing", ex);
            this.transposedData = null;
            this.transposeCol = null;
            this.transposedSomePanel = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        width = Math.max(width, super.getPreferredSize().width);
        return new Dimension(width, 480);
    }

    private void newchart() {
        if (this.wizard instanceof ModifyWizard) {
            ((ModifyWizard)this.wizard).redoDataMapping(this);
        } else {
            this.statusBar.showHint("");
            this.wizard.newchartType(true, this);
            this.statusBar.showHint(LanguageEncoder.getText("Loading icons, please wait..."));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            if (this.wizard.sourceData == 3 || !this.wizard.stepMultiOp) {
                this.newchart();
                this.wizard.stepMultiOp = true;
            } else {
                this.wizard.getMultiSource(this);
            }
        } else if (source == this.prevButton) {
            this.wizard.getStep3(this);
        } else if (source == this.cancelButton) {
            this.wizard.cancel();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.processing) {
            return;
        }
        this.processing = true;
        this.disableComponents();
        boolean showState = this.showAllCheckbox == null || this.showAllCheckbox.isSelected() || this.wizard.colData[0].getSize() <= 20;
        this.transposedData = null;
        this.transposedSomePanel = null;
        this.transposedAllPanel = null;
        if (showState && this.originalAllPanel == null) {
            this.showBuildMessage();
            try {
                this.originalAllPanel = new QueryResultPanel(this.originalData);
            }
            catch (Error er) {
                LOGGER.log(Level.FINE, "Cannot build table", er);
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Cannot build table") + "\n" + er.toString());
                this.showAllCheckbox.setSelected(false);
                this.enableComponents();
                this.processing = false;
                return;
            }
            this.switchPanel.add("originalAll", this.originalAllPanel);
        } else if (!showState && this.originalSomePanel == null) {
            this.showBuildMessage();
            try {
                this.originalSomePanel = new QueryResultPanel(this.originalData, 20);
            }
            catch (Error er) {
                LOGGER.log(Level.FINE, "Cannot build table", er);
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Cannot build table") + "\n" + er.toString());
                this.showAllCheckbox.setSelected(true);
                this.enableComponents();
                this.processing = false;
                return;
            }
            this.switchPanel.add("originalSome", this.originalSomePanel);
        }
        this.wizard.colData = this.originalData;
        this.wizard.isTransposed = false;
        this.wizard.transposeCol = null;
        if (showState) {
            this.card.show(this.switchPanel, "originalAll");
        } else {
            this.card.show(this.switchPanel, "originalSome");
        }
        this.wizard.chart = null;
        this.enableComponents();
        this.processing = false;
    }

    private void enableComponents() {
        if (this.showAllCheckbox != null) {
            this.showAllCheckbox.setEnabled(true);
        }
        this.okButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.statusBar.showHint("");
    }

    private void disableComponents() {
        if (this.showAllCheckbox != null) {
            this.showAllCheckbox.setEnabled(false);
        }
        this.okButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
    }

    private void showBuildMessage() {
        this.statusBar.showHint(LanguageEncoder.getText("Building table, please wait..."));
    }
}

