/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartOption;
import quadbase.chart.designer.ChartWizard;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class WizardStep5
extends PanelAction {
    private static final Logger LOGGER = Logger.getLogger(WizardStep5.class.getName());
    ChartWizard wizard;
    static final int width = 950;
    static final int height = 600;
    ChartOption choption;

    public WizardStep5(ChartWizard wizard, int ctype, boolean is2D, String gaugeTemplate) throws Exception {
        this(wizard, ctype, is2D, null, gaugeTemplate);
    }

    public WizardStep5(ChartWizard wizard, int ctype, boolean is2D, Chart oldChart) throws Exception {
        this(wizard, ctype, is2D, oldChart, "");
    }

    public WizardStep5(ChartWizard wizard, int ctype, boolean is2D, Chart oldChart, String gaugeTemplate) throws Exception {
        this.wizard = wizard;
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.choption = new ChartOption(null, true);
        this.choption.addActionListener(this);
        wizard.chart = Chart.createChart(wizard.chartmain.chartPanel, ctype, is2D, null, wizard.colData, null);
        wizard.chart.setTransposed(wizard.isTransposed, wizard.transposeCol);
        this.choption.originalData = wizard.originalData;
        if (oldChart != null) {
            oldChart.get_directExport("temp", null, 5, oldChart.winWidth, oldChart.winHeight, this, false, 99);
            wizard.chart = wizard.chart.loadTemplate("temp.tpl");
        }
        this.choption.chart = wizard.chart;
        if (gaugeTemplate != null && gaugeTemplate.length() > 0) {
            this.applyTemplate(this.choption.chart, gaugeTemplate);
            if (wizard.chartmain != null && wizard.chartmain.getURL("lib") != null) {
                if (this.choption.chart.getDialPlotBGImage() != null && this.choption.chart.getDialPlotBGImage().getRelativeUrl() != null && wizard.chartmain.getURL(this.choption.chart.getDialPlotBGImage().getRelativeUrl()) != null) {
                    this.choption.chart.getDialPlotBGImage().setAppletDesigner(true);
                    this.choption.chart.setDialPlotBGImage(new URL(wizard.chartmain.getURL(this.choption.chart.getDialPlotBGImage().getRelativeUrl())), this.choption.chart.getDialPlotBGImage().getRelativeUrl(), this.choption.chart.getDialPlotBGImage().getOption());
                }
                if (this.choption.chart.getDialPlotFGImage() != null && this.choption.chart.getDialPlotFGImage().getRelativeUrl() != null && wizard.chartmain.getURL(this.choption.chart.getDialPlotBGImage().getRelativeUrl()) != null) {
                    this.choption.chart.getDialPlotFGImage().setAppletDesigner(true);
                    this.choption.chart.setDialPlotFGImage(new URL(wizard.chartmain.getURL(this.choption.chart.getDialPlotFGImage().getRelativeUrl())), this.choption.chart.getDialPlotFGImage().getRelativeUrl(), this.choption.chart.getDialPlotFGImage().getOption());
                }
            } else if (ServerMessage.getApplet() != null) {
                if (this.choption.chart.getDialPlotBGImage() != null && this.choption.chart.getDialPlotBGImage().getRelativeUrl() != null) {
                    this.choption.chart.getDialPlotBGImage().setAppletDesigner(true);
                    this.choption.chart.setDialPlotBGImage(new URL(IOUtil.getCodeBase(ServerMessage.getApplet()) + this.choption.chart.getDialPlotBGImage().getRelativeUrl()), this.choption.chart.getDialPlotBGImage().getRelativeUrl(), this.choption.chart.getDialPlotBGImage().getOption());
                }
                if (this.choption.chart.getDialPlotFGImage() != null && this.choption.chart.getDialPlotFGImage().getRelativeUrl() != null) {
                    this.choption.chart.getDialPlotFGImage().setAppletDesigner(true);
                    this.choption.chart.setDialPlotFGImage(new URL(IOUtil.getCodeBase(ServerMessage.getApplet()) + this.choption.chart.getDialPlotFGImage().getRelativeUrl()), this.choption.chart.getDialPlotFGImage().getRelativeUrl(), this.choption.chart.getDialPlotFGImage().getOption());
                }
            }
        }
        this.choption.initialize(ctype, is2D, wizard.colData);
        this.choption.chartPanel.progressiveDraw = true;
        this.choption.chartPanel.setDialog(wizard);
        this.choption.chart.sourceData = wizard.sourceData;
        if (this.choption.chart.sourceData == 1) {
            this.choption.chart.queryFilename = wizard.queryFilename;
            if (QueryParser.hasParameters(wizard.dbInfo.getQuery()) && wizard.dbInfo instanceof QueryFileInfo) {
                this.choption.chart.setQueryFileInfo((QueryFileInfo)wizard.dbInfo);
            }
        } else if (this.choption.chart.sourceData == 3) {
            this.choption.chart.sourceList = new Object[wizard.sourceInfo.size()];
            this.choption.chart.sourceType = new int[wizard.sourceInfo.size()];
            this.choption.chart.doTranspose = new boolean[wizard.sourceInfo.size()];
            this.choption.chart.transposeColList = new Object[wizard.sourceInfo.size()];
            for (int i = 0; i < wizard.sourceInfo.size(); ++i) {
                this.choption.chart.sourceList[i] = wizard.sourceInfo.elementAt(i);
                this.choption.chart.sourceType[i] = wizard.sourceType.elementAt(i);
                this.choption.chart.doTranspose[i] = wizard.doTranspose.elementAt(i);
                this.choption.chart.transposeColList[i] = wizard.transposeColList.elementAt(i);
            }
        } else {
            this.choption.chart.sourceFile = wizard.sourceFile;
        }
        this.add("Center", this.choption);
        wizard.chart = this.choption.chart;
        wizard.chart.setTransposed(this.choption.chart.isTransposed, this.choption.chart.transposeCol);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(950, 600);
    }

    private void applyTemplate(Chart chart, String template) {
        try {
            chart.loadTemplate(template);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to apply template", e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        int subValueMap = -1;
        boolean secondaryAxis = false;
        if (target instanceof JButton) {
            if (((JButton)target).getText().equals(LanguageEncoder.getText("<< Back"))) {
                this.wizard.chart = this.choption.chart;
                this.wizard.colData = this.choption.chart.colData;
                this.wizard.getStep4();
            } else if (((JButton)target).getText().equals(LanguageEncoder.getText("Cancel"))) {
                this.wizard.cancel();
            } else {
                int categoryType = this.choption.chart.getCategoryType();
                subValueMap = this.choption.chart.getSubValueMap();
                secondaryAxis = subValueMap >= 0;
                switch (categoryType) {
                    case 92: {
                        LOGGER.finest("Category type is: Types.TIME");
                        break;
                    }
                    case 91: {
                        LOGGER.finest("Category type is: Types.DATE");
                        break;
                    }
                    case 93: {
                        LOGGER.finest("Category type is: Types.TIMESTAMP");
                        break;
                    }
                    default: {
                        LOGGER.finest("Unknown category type");
                    }
                }
                this.wizard.doneWizard(this.choption.chart);
                if (!(this.choption.chart.colData[this.choption.chart.valueCol].dataType == 0 || this.choption.chart.subvalueCol >= 0 && this.choption.chart.colData[this.choption.chart.subvalueCol].dataType == 0 || this.wizard.chartmain.isReportVersion() || this.choption.chart.colData[this.choption.chart.valueCol].getSize() < 250 || categoryType != 92 && categoryType != 91 && categoryType != 93)) {
                    this.wizard.launchAggregateDialog(secondaryAxis, categoryType);
                }
            }
        }
    }
}

