/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.ColData;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.ModifyWizard;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.LanguageEncoder;

public class WizardStepMultiData
extends PanelAction {
    private static final Logger LOGGER = Logger.getLogger(WizardStepMultiData.class.getName());
    JRadioButton cb_Yes;
    JRadioButton cb_No;
    ChartWizard wizard;
    JButton nextButton;
    JButton prevButton;
    JButton cancelButton;
    static final int width = 220;
    static final int height = 10;
    int prevSourceData = -1;

    public WizardStepMultiData(ChartWizard wizard) {
        this.wizard = wizard;
        this.setBackground(Color.lightGray);
        BorderPanel bpanel = new BorderPanel(LanguageEncoder.getText("Merge Data From Other Source"));
        bpanel.setLayout(new BorderLayout());
        this.cb_Yes = new JRadioButton(LanguageEncoder.getText("Get Other Data Source"), false);
        this.cb_No = new JRadioButton(LanguageEncoder.getText("Process Data"), true);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.cb_Yes);
        bg1.add(this.cb_No);
        if (wizard.dbInfo instanceof QueryFileInfo) {
            this.cb_Yes.setEnabled(false);
        }
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new GridLayout(2, 1));
        gridpanel.add(this.cb_No);
        gridpanel.add(this.cb_Yes);
        bpanel.add("Center", gridpanel);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout(2));
        this.prevButton = new JButton(LanguageEncoder.getText("<< Back"));
        okpanel.add(this.prevButton);
        this.prevButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        okpanel.add(this.cancelButton);
        this.nextButton = new JButton(LanguageEncoder.getText("Next >>"));
        okpanel.add(this.nextButton);
        this.cancelButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.nextButton.requestFocus();
        bpanel.add("South", okpanel);
        this.setLayout(new BorderLayout());
        this.add("Center", bpanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.nextButton) {
            if (this.cb_Yes.isSelected()) {
                this.addColData();
                this.wizard.colData = null;
                this.wizard.newChart(false, this);
            } else if (this.wizard.colDataList.size() <= 0) {
                if (this.wizard instanceof ModifyWizard) {
                    ((ModifyWizard)this.wizard).redoDataMapping(this);
                } else {
                    this.wizard.newchartType(true, this);
                }
            } else {
                ColData[] colData = null;
                try {
                    this.addColData();
                    colData = ColData.merge(this.wizard.colDataList, true);
                    this.wizard.colData = colData;
                    this.prevSourceData = this.wizard.sourceData;
                    this.wizard.sourceData = 3;
                    this.wizard.displayMergeResult(this);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Error initializing next wizard step", ex);
                    new MessageDialog((Frame)this.wizard.chartmain, LanguageEncoder.getText("Error")).show(ex.toString());
                    this.wizard.cancel();
                    return;
                }
            }
        } else if (source == this.prevButton) {
            if (this.wizard.sourceData == 3) {
                this.wizard.sourceData = this.prevSourceData;
                int lastIndex = this.wizard.colDataList.size() - 1;
                if (lastIndex >= 0) {
                    this.wizard.colData = this.wizard.colDataList.elementAt(lastIndex);
                    this.wizard.colDataList.removeElementAt(lastIndex);
                    this.wizard.doTranspose.removeElementAt(lastIndex);
                    this.wizard.transposeColList.removeElementAt(lastIndex);
                    this.wizard.sourceInfo.removeElementAt(lastIndex);
                    this.wizard.sourceType.removeElementAt(lastIndex);
                }
            }
            this.wizard.getStep3(this);
        } else {
            this.wizard.cancel();
        }
    }

    private void addColData() {
        if (this.wizard.colData != null && this.wizard.sourceData != 3 && (this.wizard.colDataList.size() <= 0 || this.wizard.colData != this.wizard.colDataList.lastElement())) {
            this.wizard.colDataList.addElement(this.wizard.colData);
            this.wizard.doTranspose.addElement(this.wizard.isTransposed);
            this.wizard.transposeColList.addElement(this.wizard.transposeCol);
            if (this.wizard.sourceData == 1) {
                this.wizard.sourceInfo.addElement(this.wizard.dbInfo);
            } else if (this.wizard.sourceData == 2 || this.wizard.sourceData == 6 || this.wizard.sourceData == 4) {
                this.wizard.sourceInfo.addElement(this.wizard.sourceFile);
            } else if (this.wizard.sourceData == 5) {
                this.wizard.sourceInfo.addElement(new EJBInfo(this.wizard.jndiName, this.wizard.homeName, this.wizard.remoteName, this.wizard.selectedMethodName, this.wizard.selectedMethodParamVal, this.wizard.environment));
            } else if (this.wizard.sourceData == 7) {
                this.wizard.sourceInfo.addElement(this.wizard.xmlFileQueryInfo);
            }
            this.wizard.sourceType.addElement(this.wizard.sourceData);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension defaultDim = super.getPreferredSize();
        int defaultWidth = defaultDim.width;
        return new Dimension(Math.max(defaultWidth, 220), defaultDim.height);
    }
}

