/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.ImageData;
import quadbase.util.internal.ImageResample;

public class YAImageCanvas
extends Canvas {
    private static final Logger LOGGER = Logger.getLogger(YAImageCanvas.class.getName());
    private Image image;
    private Image oldimage = null;
    private Image sizeimage = null;
    private int display_option = 1;

    public YAImageCanvas(URL url) {
        this.image = ImageData.retrieveImage(url, (Component)this);
    }

    public YAImageCanvas(Image image) {
        this.image = image;
    }

    public YAImageCanvas() {
        this.image = null;
    }

    public void setImage(URL url) {
        this.image = ImageData.retrieveImage(url, (Component)this);
        this.repaint();
    }

    public Dimension getImageSize() {
        if (this.image == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setDisplayOption(int option) {
        this.display_option = option;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        int w = super.getSize().width;
        int h = super.getSize().height;
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, w, h);
        if (this.image == null) {
            g.setColor(Color.black);
            g.drawString(LanguageEncoder.getText("No Image"), w / 2 - 30, h / 2);
        } else {
            YAImageCanvas cv;
            int w2 = this.image.getWidth(null);
            int h2 = this.image.getHeight(null);
            if (this.image != this.oldimage && (w2 > w || h2 > h) && this.display_option != 1) {
                try {
                    int new_w;
                    int new_h;
                    if (w2 <= w || w2 >= w && h2 >= h && h2 * w >= w2 * h) {
                        new_h = h;
                        new_w = h * w2 / h2;
                    } else {
                        new_w = w;
                        new_h = w * h2 / w2;
                    }
                    this.image = this.oldimage = new ImageResample(this.image).resample(new_w, new_h);
                    cv = null;
                    w2 = new_w;
                    h2 = new_h;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to resample image", ex);
                    cv = this;
                }
            } else {
                cv = this;
            }
            switch (this.display_option) {
                case 0: {
                    g.drawImage(this.image, (w - w2) / 2, (h - h2) / 2, w2, h2, cv);
                    break;
                }
                case 1: {
                    try {
                        if (this.sizeimage != this.image) {
                            this.oldimage = new ImageResample(this.image).resample(w, h);
                            this.sizeimage = this.image;
                        }
                        g.drawImage(this.oldimage, 0, 0, w, h, null);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to resample image", ex);
                        g.drawImage(this.image, (w - w2) / 2, (h - h2) / 2, w2, h2, cv);
                    }
                    break;
                }
                case 2: {
                    ImageData.imageTile(g, 0, 0, w, h, this.image, cv);
                    break;
                }
            }
        }
    }
}

