/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.JPanel;
import quadbase.chart.designer.Alarm;
import quadbase.chart.designer.AlarmTarget;
import quadbase.common.swing.CanShowHint;

public class YAStatusBar
extends JPanel
implements AlarmTarget,
CanShowHint {
    private static final Logger LOGGER = Logger.getLogger(YAStatusBar.class.getName());
    String label = "";
    Alarm alarm;
    int d_height = 20;
    boolean lock = false;
    Image image = lightBulb;

    public YAStatusBar() {
        this(false);
    }

    public YAStatusBar(boolean toExpand) {
        this.alarm = new Alarm(4000L, this);
        this.alarm.start();
        this.setLayout(null);
        Font f = new Font("Default", 0, 12);
        FontMetrics fm = this.getFontMetrics(f);
        if (fm.getHeight() > 10) {
            this.d_height = toExpand ? fm.getHeight() * 2 + 1 : fm.getHeight() + 5;
        }
        this.d_height = this.d_height < 20 ? 20 : this.d_height;
    }

    public void setDelay(long mills) {
        this.alarm.setSleepTime(mills);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets i = this.getParent().getInsets();
        return new Dimension(this.getParent().getSize().width - (i.left + i.right), this.d_height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void doLayout() {
        this.getSize();
        this.getInsets();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Dimension dim = this.getMinimumSize();
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(this.getForeground());
        if (!this.label.equals("")) {
            g.drawString(this.label, 28, 15);
            g.drawImage(this.image, 5, 3, this);
        }
    }

    private void showText(String text) {
        if (!this.lock) {
            this.label = text == null ? "" : text;
            this.alarm.restart();
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public void showHint(String s) {
        this.image = lightBulb;
        this.showText(s);
    }

    @Override
    public void clearHint() {
        this.clear();
    }

    @Override
    public void clear() {
        this.onAlarm(null);
    }

    @Override
    public void lockHint(String text) {
        LOGGER.finest("lockHint");
        this.lock = true;
        this.alarm.cancelSleep();
        this.label = text == null ? "" : text;
        this.invalidate();
        this.repaint();
    }

    @Override
    public void unlockHint(String text) {
        this.lock = false;
        this.label = text == null ? "" : text;
    }

    @Override
    public void onAlarm(Alarm a) {
        this.label = "";
    }

    @Override
    public void showMessage(Image im, String text) {
        this.image = im != null ? im : lightBulb;
        this.showText(text);
    }

    @Override
    public void lockMessage(Image im, String text) {
        this.image = im != null ? im : lightBulb;
        this.lockHint(text);
    }

    @Override
    public void unlockMessage(Image im, String text) {
        this.image = im != null ? im : lightBulb;
        this.unlockHint(text);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.alarm.pleaseStop();
    }
}

