/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.PreprocInfo;
import quadbase.chart.designer.ChartMain;
import quadbase.chartviewer.swing.ZoomOptions;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ZoomDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(ZoomDialog.class.getName());
    ZoomOptions zoomOpts = null;
    ChartMain chartMain = null;
    boolean isForDrillDown = false;
    boolean enableItemStateChanged = false;
    boolean isCancelled = false;

    public ZoomDialog(ChartMain chartMain, int categoryType) {
        this(chartMain, categoryType, false, LanguageEncoder.getText("Zoom Options..."), false);
    }

    public ZoomDialog(ChartMain chartMain, int categoryType, boolean setEnableZoom) {
        this(chartMain, categoryType, false, LanguageEncoder.getText("Zoom Options..."), setEnableZoom);
    }

    public ZoomDialog(ChartMain chartMain, int categoryType, boolean isForDrillDown, String dialogTitle, boolean setEnableZoom) {
        super(chartMain, dialogTitle, true);
        this.chartMain = chartMain;
        this.isForDrillDown = isForDrillDown;
        boolean isLinearEnabled = true;
        if (chartMain.chart.isCircularChart()) {
            isLinearEnabled = false;
        }
        this.zoomOpts = new ZoomOptions(LanguageEncoder.getText("Enter data range"), categoryType, true, isForDrillDown, isLinearEnabled);
        this.zoomOpts.extractPreprocInfo(chartMain.chart);
        this.zoomOpts.addActionListener(this);
        this.zoomOpts.addItemListener(this);
        BorderPanel mainPanel = new BorderPanel(LanguageEncoder.getText("Enter data range"));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("Center", this.zoomOpts);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", mainPanel);
        cop.setBackground(Color.lightGray);
        this.setSize(this.getPreferredSize());
        if (setEnableZoom) {
            this.zoomOpts.enableZoom.setSelected(true);
        }
        if (isForDrillDown) {
            this.zoomOpts.enableZoom.setSelected(true);
            Chart chart = chartMain.chart;
            boolean secondaryAxis = false;
            int catType = chart.getCategoryType();
            int subValueMap = chart.getSubValueMap();
            secondaryAxis = subValueMap >= 0;
            boolean b = chartMain.launchAggregateDialog(secondaryAxis, catType, false, false, isForDrillDown);
            if (!b) {
                this.isCancelled = true;
            }
        }
        this.enableItemStateChanged = true;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        this.isCancelled = true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public ZoomOptions getZoomOptions() {
        return this.zoomOpts;
    }

    public Timestamp getRangeValue(int index) {
        return this.zoomOpts.getRangeValue(index);
    }

    public String getScaleValue() {
        return this.zoomOpts.getScaleValue();
    }

    public int getScaleUnit() {
        return this.zoomOpts.getScaleUnit();
    }

    public boolean isLinearScale() {
        return this.zoomOpts.isLinearScale();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.enableItemStateChanged) {
            return;
        }
        this.enableItemStateChanged = false;
        Object target = e.getSource();
        Chart chart = this.chartMain.chart;
        boolean secondaryAxis = false;
        int subValueMap = -1;
        int categoryType = chart.getCategoryType();
        if (target == this.zoomOpts.enableZoom) {
            subValueMap = chart.getSubValueMap();
            secondaryAxis = subValueMap >= 0;
            if (((JCheckBox)target).isSelected()) {
                this.chartMain.launchAggregateDialog(secondaryAxis, categoryType, false, false, this.isForDrillDown);
                this.zoomOpts.enableZoom.setSelected(true);
            }
            this.zoomOpts.enableOptions(((JCheckBox)target).isSelected());
        }
        this.enableItemStateChanged = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        Chart chart = this.chartMain.chart;
        PreprocInfo tsInfo = chart.getPreprocInfo();
        boolean secondaryAxis = false;
        int subValueMap = -1;
        if (target == this.zoomOpts.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            return;
        }
        if (target == this.zoomOpts.aggregateButton) {
            subValueMap = chart.getSubValueMap();
            int categoryType = chart.getCategoryType();
            secondaryAxis = subValueMap >= 0;
            this.chartMain.launchAggregateDialog(secondaryAxis, categoryType, false, false, this.isForDrillDown);
            return;
        }
        if (target == this.zoomOpts.okButton) {
            if (!this.zoomOpts.checkBounds()) {
                MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("The lower bound value should be chronologically less than the upper bound value"));
                return;
            }
            if (!this.isForDrillDown) {
                if (this.zoomOpts.isValidScale(chart)) {
                    this.setVisible(false);
                    this.zoomOpts.fillPreprocInfo(chart);
                    this.chartMain.do_Reload();
                    this.chartMain.setModifiedOnly();
                } else {
                    LOGGER.finest("Invalid scale");
                    String msg = LanguageEncoder.getText("Invalid Scale: \nScale must be between maximum scale and minimum scale\n");
                    msg = msg + LanguageEncoder.getText("Minimum allowable scale: \n\t");
                    msg = msg + this.zoomOpts.getStringScale(tsInfo.lInterval, tsInfo.lUnit) + " \n ";
                    msg = msg + LanguageEncoder.getText("Maximum allowable scale: \n\t");
                    msg = msg + this.zoomOpts.getStringScale(tsInfo.uInterval, tsInfo.uUnit) + " \n ";
                    MessageDialog.showError(this.chartMain, true, msg);
                }
            } else {
                this.setVisible(false);
                this.zoomOpts.fillPreprocInfo(chart);
                this.chartMain.setModifiedOnly();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 250);
    }
}

