/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.message;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.ColMetaData;
import quadbase.chart.IOUtil2;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.util.internal.Coder;
import quadbase.util.internal.IOUtil;

public class ReadDataFileMeta {
    private static final Logger LOGGER = Logger.getLogger(ReadDataFileMeta.class.getName());

    public static Vector getMeta(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType) throws Exception {
        return ReadDataFileMeta.getMeta(dataFilename, transposeData, transposeCol, dataType, null);
    }

    public static Vector getMeta(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDataFileMeta.sendMessage(socket, dataFilename, transposeData, transposeCol, dataType, inSet);
        return ReadDataFileMeta.receiveReply(socket);
    }

    private static void sendMessage(IConnection socket, String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(25367);
        IOUtil.writeString(dout, Coder.encode(dataFilename));
        dout.writeBoolean(transposeData);
        IOUtil.writeBooleans(dout, transposeCol);
        dout.writeInt(dataType);
        dout.writeBoolean(inSet != null);
        if (inSet != null) {
            inSet.write(dout);
        }
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            LOGGER.log(Level.FINEST, "Failed to send message as a byte array", ex);
            throw ex;
        }
    }

    private static Vector receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int nInfo = dstream.readInt();
            Vector<ColMetaData> output = new Vector<ColMetaData>();
            for (int i = 0; i < nInfo; ++i) {
                ColMetaData value = ColMetaData.read(dstream, 6612);
                output.addElement(value);
            }
            dstream.close();
            socket.close();
            return output;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
            }
            LOGGER.log(Level.FINE, "Failed to receive reply", ex);
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
            }
            LOGGER.log(Level.FINE, "Failed to receive reply", err);
            throw new Exception(err.getMessage());
        }
    }
}

