/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.xml;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.chart.Area;
import quadbase.chart.CAnnotation;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DataAttribute;
import quadbase.chart.DrillDownNode;
import quadbase.chart.GraphicsTable;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.LoadChart;
import quadbase.chart.PieChart;
import quadbase.chart.Point3D;
import quadbase.chart.ReadDataFile;
import quadbase.chart.Ticker;
import quadbase.chart.ValueTable;
import quadbase.chart.chart3d.FaceHyperLink;
import quadbase.chart.xml.SaveChartToXML;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.QbPattern;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.ColorSpectrum;
import quadbase.util.ControlRange;
import quadbase.util.DateTimeFormat;
import quadbase.util.HyperLink;
import quadbase.util.IAnnotation;
import quadbase.util.IFormat;
import quadbase.util.IReferenceObj;
import quadbase.util.LocaleDateTimeFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.LogicalFormat;
import quadbase.util.NumericFormat;
import quadbase.util.Point_2D;
import quadbase.util.Point_3D;
import quadbase.util.PolyLine;

public class XMLChart
extends LoadChart {
    private static final Logger LOGGER = Logger.getLogger(XMLChart.class.getName());
    public static final String SHOW_SHADOW_ON_POINT = "showShadowOnPoint";
    final int ELEMENT_TYPE = 1;
    final int ATTR_TYPE = 2;
    final int TEXT_TYPE = 3;
    final int CDATA_TYPE = 4;
    final int ENTITYREF_TYPE = 5;
    final int ENTITY_TYPE = 6;
    final int PROCINSTR_TYPE = 7;
    final int COMMENT_TYPE = 8;
    final int DOCUMENT_TYPE = 9;
    final int DOCTYPE_TYPE = 10;
    final int DOCFRAG_TYPE = 11;
    final int NOTATION_TYPE = 12;
    Component component;
    Document document;
    private int defaultLineThickness = 2;
    private boolean isEntServer = false;

    public XMLChart(String uri, Component component) throws Exception {
        this.component = component;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(uri);
    }

    public XMLChart(File file, Component component) throws Exception {
        this.component = component;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(file);
    }

    public XMLChart(InputStream xmlStream, Component component) throws Exception {
        this.component = component;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(xmlStream);
    }

    public Chart createChart() throws Exception {
        return this.createChart(this.document);
    }

    public Chart createChart(Boolean isServerSide) throws Exception {
        this.isEntServer = isServerSide;
        return this.createChart(this.document);
    }

    public Chart createChart(boolean isServerSide) throws Exception {
        this.isEntServer = isServerSide;
        return this.createChart(this.document);
    }

    public Chart createChart(Chart originalChart) throws Exception {
        return this.createChart(this.document, originalChart);
    }

    private Chart createChart(Node domNode) throws Exception {
        return this.createChart(domNode, null);
    }

    private Chart createChart(Node domNode, Chart originalChart) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase("EspressChartAttr")) {
                return this.parseChart(node, originalChart);
            }
            Chart chart = this.createChart(node);
            if (chart == null) continue;
            return chart;
        }
        return null;
    }

    private int findChartType(String type, int oldType) {
        for (int i = 0; i < 21; ++i) {
            if (!Chart.CHARTTYPENAME[i].equalsIgnoreCase(type)) continue;
            return i;
        }
        return oldType;
    }

    private int findComboType(String type, int oldType) {
        for (int i = 0; i < Chart.COMBOTYPENAME.length; ++i) {
            if (!Chart.COMBOTYPENAME[i].equalsIgnoreCase(type)) continue;
            return i;
        }
        return oldType;
    }

    private Chart initChart(String chartLocation, Node domNode) throws Exception {
        Boolean transpose = null;
        String tmp = this.getAttribute(domNode, "transpose");
        if (tmp != null && !tmp.equals("")) {
            transpose = Boolean.valueOf(tmp);
        }
        boolean[] transposeCol = this.getTransposeColumn(this.getAttribute(domNode, "transposedColumn"));
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        if (count <= 0) {
            return null;
        }
        boolean[] doTranspose = new boolean[count];
        String[] dataSource = new String[count];
        Object[] transposeColList = new Object[count];
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("DataSource");
            if (node == null) continue;
            doTranspose[i] = Boolean.valueOf(this.getAttribute(node, "transpose"));
            transposeColList[i] = this.getTransposeColumn(this.getAttribute(node, "transposedColumn"));
            dataSource[i] = this.getData(node);
        }
        if (transpose == null) {
            transpose = doTranspose[0];
        }
        return this.loadChartFromFile(chartLocation, transpose, transposeCol, doTranspose, transposeColList, dataSource);
    }

    private Chart parseChart(Node domNode, Chart originalChart) throws Exception {
        boolean applyTemplate = originalChart != null;
        XMLNode xmlNode = new XMLNode(domNode);
        Chart chart = null;
        String chartLocation = null;
        Node node = xmlNode.getNextElement("ChartLocation");
        if (node != null) {
            chartLocation = this.getData(node);
        }
        if ((node = xmlNode.getNextElement("DRILLDOWNTREE")) != null) {
            this.loadTree(node);
        } else {
            this.drillDownNode = new DrillDownNode("ROOT");
        }
        this.backupColData = null;
        if (!applyTemplate) {
            ColData[] colData = null;
            Vector parameter = null;
            node = xmlNode.getNextElement("DATABACKUP");
            if (node != null) {
                this.backupColData = this.getColDataList(node, null);
            }
            if ((node = xmlNode.getNextElement("DATASOURCECOUNT")) != null) {
                int i;
                Vector<Node> datasources = new Vector<Node>();
                Vector<Node> multiTranspose = new Vector<Node>();
                NodeList nodeList = domNode.getChildNodes();
                for (i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeName().equalsIgnoreCase("DATASOURCE")) {
                        datasources.addElement(node2);
                    }
                    if (!node2.getNodeName().equalsIgnoreCase("MULTI_TRANSPOSE")) continue;
                    multiTranspose.addElement(node2);
                }
                this.loadDataHeader(datasources);
                if (multiTranspose.size() > 0) {
                    this.transposeColList = new Object[multiTranspose.size()];
                    this.transposeCol = new boolean[multiTranspose.size()];
                    for (i = 0; i < multiTranspose.size(); ++i) {
                        node = (Node)multiTranspose.elementAt(i);
                        String tmp = this.getAttribute(node, "transpose");
                        this.doTranspose[i] = tmp != null && tmp.equalsIgnoreCase("true");
                        this.transposeColList[i] = this.getTransposeColumn(this.getAttribute(node, "transposedColumn"));
                    }
                }
                if ((node = xmlNode.getNextElement("TRANSPOSE")) != null) {
                    String tmp = this.getAttribute(node, "transpose");
                    this.isTransposed = tmp != null && tmp.equalsIgnoreCase("true");
                    this.transposeCol = this.getTransposeColumn(this.getAttribute(node, "transposedColumn"));
                }
                colData = this.processColData(colData, true, this.isEntServer, false, false, false, null, parameter, true);
                if (chartLocation != null) {
                    try {
                        chart = this.loadChartFromFile(chartLocation);
                        chart.setXMLChartLocation(chartLocation);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Cannot find chart", ex);
                    }
                }
            } else {
                LOGGER.finest("Old version");
                node = xmlNode.getNextElement("DataSourceList");
                if (node != null) {
                    chart = this.initChart(chartLocation, node);
                }
                if (chart == null) {
                    chart = this.loadChartFromFile(chartLocation);
                }
                chart.setXMLChartLocation(chartLocation);
            }
            if (chart != null && chart.getQueryFileInfo() != null) {
                chart.getQueryFileInfo().setParameter(parameter);
            }
            node = xmlNode.getNextElement("ParameterPrompt");
            if (chart != null && node != null) {
                chart.setPrevParamPrompt(this.readBoolean(node));
            }
            node = xmlNode.getNextElement("ChartType");
            int chartType = 0;
            boolean is2DimChart = true;
            int comboType = 0;
            if (chart != null) {
                chartType = chart.getChartType();
                is2DimChart = chart.is2DimChart();
            }
            if (node != null) {
                chartType = this.findChartType(this.getAttribute(node, "type"), chartType);
                is2DimChart = Boolean.valueOf(this.getAttribute(node, "is2DimChart"));
                comboType = this.findComboType(this.getAttribute(node, "comboType"), comboType);
            }
            if ((node = xmlNode.getNextElement("DrawNullColumn")) != null) {
                if (chart != null) {
                    chart.setDrawNullColumn(this.readBoolean(node));
                } else if (colData != null) {
                    boolean tmp1 = this.readBoolean(node);
                    for (ColData element : colData) {
                        element.setDrawNullColumn(tmp1);
                    }
                }
            }
            if ((node = xmlNode.getNextElement("DrawColumnName")) != null) {
                if (chart != null) {
                    chart.setNullColumnName(this.getData(node));
                } else if (colData != null) {
                    String tmp2 = this.getData(node);
                    for (ColData element : colData) {
                        element.setNullColumnName(tmp2);
                    }
                }
            }
            if (chart == null && colData != null) {
                chart = this.processChart(colData, ServerMessage.getComponent(), chartType, is2DimChart, false, false, false, null, parameter);
                chart.setXMLChartLocation(chartLocation);
            } else {
                LOGGER.finest("Old version 2");
                if (chartType != chart.getChartType() || is2DimChart != chart.is2DimChart()) {
                    chart = this.changeChartType(chart, chartType, is2DimChart);
                }
            }
            chart.setComboType(comboType);
        } else {
            chart = originalChart;
        }
        node = xmlNode.getNextElement("CanvasSize");
        if (node != null) {
            Dimension d = this.getDimension(node);
            if (chart.showTable()) {
                chart.gt.x = (int)((double)chart.gt.x * ((double)d.width / (double)chart.winWidth));
                chart.gt.y = (int)((double)chart.gt.y * ((double)d.height / (double)chart.winHeight));
            }
            chart.setSize(d);
        }
        if ((node = xmlNode.getNextElement("ScrollBarOption")) != null) {
            chart.setScrollBarOption(this.getIndex(node, SaveChartToXML.SCROLLOPTION, chart.getScrollBarOption()));
        }
        if ((node = xmlNode.getNextElement("AdjustViewerFont")) != null) {
            chart.setAdjustFont(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("PopupMenuEnabled")) != null) {
            chart.setPopupMenuEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("DimMenuEnabled")) != null) {
            chart.setDimMenuEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("TypeMenuEnabled")) != null) {
            chart.setTypeMenuEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Title")) != null) {
            this.getCString(node, chart.mainTitle);
        }
        switch (chart.getChartType()) {
            case 6: 
            case 20: {
                node = xmlNode.getNextElement("PieAttr");
                if (node == null) break;
                this.getPieAttr(node, chart);
                break;
            }
            case 12: {
                node = xmlNode.getNextElement("SurfaceAttr");
                if (node == null) break;
                this.getSurfaceAttr(node, chart);
                break;
            }
            case 13: {
                node = xmlNode.getNextElement("BubbleAttr");
                if (node == null) break;
                this.getBubbleAttr(node, chart);
                break;
            }
            case 3: {
                node = xmlNode.getNextElement("LineAttr");
                if (node == null) break;
                this.getLineAttr(node, chart);
                break;
            }
            case 16: {
                node = xmlNode.getNextElement("RadarAttr");
                if (node == null) break;
                this.getRadarAttr(node, chart);
                break;
            }
            case 19: {
                node = xmlNode.getNextElement("PolarAttr");
                if (node == null) break;
                this.getPolarAttr(node, chart);
                break;
            }
            case 17: {
                node = xmlNode.getNextElement("DialAttr");
                if (node == null) break;
                this.getDialAttr(node, chart);
                break;
            }
            case 15: {
                node = xmlNode.getNextElement("BoxAttr");
                if (node == null) break;
                this.getBoxAttr(node, chart);
                break;
            }
            case 18: {
                node = xmlNode.getNextElement("GanttAttr");
                if (node == null) break;
                this.getGanttAttr(node, chart);
                break;
            }
            case 2: {
                node = xmlNode.getNextElement("ScatterAttr");
                if (node == null) break;
                this.getScatterAttr(node, chart);
                break;
            }
        }
        node = xmlNode.getNextElement("AxisAttr");
        if (node != null) {
            this.getAxisAttr(node, chart);
        }
        if ((node = xmlNode.getNextElement("Legend")) != null) {
            this.getLegend(node, chart.legend);
        }
        if ((node = xmlNode.getNextElement("SecLegend")) != null) {
            this.getLegend(node, chart.legend2);
        }
        if ((node = xmlNode.getNextElement("TopLabel")) != null) {
            this.getTopLabelAttr(node, chart);
        }
        if ((node = xmlNode.getNextElement("Position")) != null) {
            this.getPosition(node, chart);
        }
        if ((node = xmlNode.getNextElement("PlotAreaBackground")) != null) {
            this.getArea(node, chart.getBackground());
        }
        if ((node = xmlNode.getNextElement("PlotAreaBorder")) != null) {
            this.getArea(node, chart.getBorder());
        }
        if ((node = xmlNode.getNextElement("DeskTopArea")) != null) {
            this.getArea(node, chart.getDesktopArea());
        }
        if ((node = xmlNode.getNextElement("LineThickness")) != null) {
            this.defaultLineThickness = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("BorderThickness")) != null) {
            chart.setBorderThickness(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("ShowArea")) != null) {
            chart.setAreaState(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ShowPoint")) != null) {
            chart.setPointState(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ShowPointBorder")) != null) {
            chart.setDrawPointBorder(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("BlackPointBorderColor")) != null) {
            chart.setDrawPointBorderColor(this.readBoolean(node) ? Color.black : Color.yellow);
        }
        if ((node = xmlNode.getNextElement("ShowLine")) != null) {
            chart.setLineState(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ShowSecPoint")) != null) {
            chart.setPointState2(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ShowSecPointBorder")) != null) {
            chart.setDrawPointBorder2(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("SecBlackPointBorderColor")) != null) {
            chart.setDrawPointBorderColor2(this.readBoolean(node) ? Color.black : Color.yellow);
        }
        if ((node = xmlNode.getNextElement("ShowSecLine")) != null) {
            chart.setLineState2(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("AntiAliasEnabled")) != null) {
            chart.setAntiAliasEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("AntiAliasForChartOnly")) != null) {
            chart.setAntiAliasForChartOnly = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("ShowShadowOnLine")) != null) {
            chart.setShowShadowOnLine(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement(SHOW_SHADOW_ON_POINT)) != null) {
            chart.setShowShadowOnPoint(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Translucent")) != null) {
            chart.setTranslucent(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("TranslucentValue")) != null) {
            chart.setTranslucentValue(this.readFloat(node));
        }
        if ((node = xmlNode.getNextElement("Java2DRotateText")) != null) {
            chart.setJ2DRotateEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("DisableJava2DForStraightText")) != null) {
            chart.setDisableJava2DForStraightText(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("IsGradientEnabled")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Is3DShadingEnabled")) != null) {
            chart.getPrimaryDataGradientSupport().set3DShadingEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("IsApplyGradientToChartDataOnly")) != null) {
            chart.getPrimaryDataGradientSupport().setApplyGradientToChartDataOnly(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("GradientStartX")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientStartX(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientStartY")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientStartY(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientEndX")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientEndX(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientEndY")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientEndY(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientDesColor")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientDesColor(this.readColor(node));
        }
        if ((node = xmlNode.getNextElement("GradientShade")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientShade(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("GradientCyclic")) != null) {
            chart.getPrimaryDataGradientSupport().setGradientCyclic(this.readBoolean(node));
        }
        if (node != null) {
            chart.getSecondaryDataGradientSupport().setGradientEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Is3DShadingEnabledForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().set3DShadingEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("GradientStartXForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().setGradientStartX(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientStartYForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().setGradientStartY(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientEndXForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().setGradientEndX(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientEndYForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().setGradientEndY(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientDesColorForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().setGradientDesColor(this.readColor(node));
        }
        if ((node = xmlNode.getNextElement("GradientShadeForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().setGradientShade(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("GradientCyclicForSecondaryData")) != null) {
            chart.getSecondaryDataGradientSupport().setGradientCyclic(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("MaxDisplayCharactersForText")) != null) {
            chart.setCutOffThresholdForText(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("GIFBackgroundTransparent")) != null) {
            chart.setBackgroundTransparent(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("DrawDataBorder")) != null) {
            chart.setDataBorder(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("DrawBlackBorderForWhiteArea")) != null) {
            chart.setDrawBorderForWhiteArea(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("DataBorderColor")) != null) {
            chart.setDataBorderColor(this.readColor(node));
        }
        if ((node = xmlNode.getNextElement("DataBorderThickness")) != null) {
            chart.setDataBorderThickness(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("BarWidthRatio")) != null) {
            chart.setBarwidthRatio(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("ShowNullDataLine")) != null) {
            chart.setNullDataLine(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ApplyLineStyleToNullData")) != null) {
            chart.applyLineStyleToNullData(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ShowNullInScatter")) != null) {
            chart.setShowNullInScatter(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ShowNullDataAsZero")) != null) {
            chart.setNullDataAsZero(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("CandleStick")) != null) {
            chart.setCandleStick(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("LineXOffset")) != null) {
            chart.set_xshift(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("EndToEnd")) != null) {
            chart.setOffsetTicker(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("FormatHintData")) != null) {
            chart.setFormatHint(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("FlashHintFont")) != null) {
            chart.flashHintFont = this.readFont(node);
        }
        if ((node = xmlNode.getNextElement("FlashHintFontColor")) != null) {
            chart.flashHintFontColor = this.readColor(node);
        }
        if ((node = xmlNode.getNextElement("FlashHintBgColor")) != null) {
            chart.flashHintBgColor = this.readColor(node);
        }
        if ((node = xmlNode.getNextElement("FlashHintBorderColor")) != null) {
            chart.flashHintBorderColor = this.readColor(node);
        }
        if (!chart.is2DimChart() && (node = xmlNode.getNextElement("Set3DAttr")) != null) {
            this.get3DAttr(node, chart);
        }
        if (!applyTemplate) {
            node = xmlNode.getNextElement("DataAttribute");
            if (node != null) {
                this.getDataAttribute(node, chart.is2DimChart(), chart.getChartType(), chart.dataDim).loadAttribute(chart.mData, chart.is2DimChart(), chart.getChartType());
            }
            if (chart.getSubValueMap() >= 0 && (node = xmlNode.getNextElement("SecDataAttribute")) != null) {
                int secChartType = chart.getChartType();
                int secDim = chart.dataDim;
                if (chart.getComboType() == 3) {
                    secChartType = 14;
                    secDim = 2;
                }
                this.getDataAttribute(node, chart.is2DimChart(), secChartType, secDim).loadAttribute(chart.mData2, chart.mData2.chart.is2DimChart(), chart.mData2.chart.getChartType());
            }
        }
        if ((node = xmlNode.getNextElement("TopNValue")) != null) {
            chart.maxDataLen = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("RefreshInterval")) != null) {
            chart.refreshInterval = this.readLong(node);
        }
        if ((node = xmlNode.getNextElement("DisableSchedule")) != null) {
            chart.disableSchedule = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("BackgroundImage")) != null) {
            this.getBackgroundImage(node, chart);
        }
        if ((node = xmlNode.getNextElement("FloatingLineList")) != null) {
            this.getFloatingLineList(node, chart);
        }
        if ((node = xmlNode.getNextElement("ColDataList")) != null) {
            this.getColDataList(node, chart);
        }
        if ((node = xmlNode.getNextElement("SecondaryAxisFormat")) != null) {
            this.getSecondaryAxisFormat(node, chart);
        }
        if ((node = xmlNode.getNextElement("HyperLinkList")) != null) {
            this.getHyperLinkList(node, chart);
        }
        if ((node = xmlNode.getNextElement("ControlRangeList")) != null) {
            this.getControlRangeList(node, chart);
        }
        if ((node = xmlNode.getNextElement("AnnotationList")) != null) {
            this.getAnnotationList(node, chart);
        }
        if ((node = xmlNode.getNextElement("ValueSubstitutionList")) != null) {
            this.getValueSubstitutionList(node, chart);
        }
        if ((node = xmlNode.getNextElement("ColorSpectrum")) != null) {
            chart.setColorSpectrum(this.getColorSpectrum(node));
        }
        if ((node = xmlNode.getNextElement("ValueOrder")) != null) {
            chart.setSortValue(this.getSortValue(node));
        }
        if ((node = xmlNode.getNextElement("CHILD_DRILLDOWNNODES")) != null && chart.currentNode == null) {
            this.readDrillDownNodes(node);
            try {
                DrillDownNode root = new DrillDownNode("ROOT");
                if (this.childDrillDownNodes != null) {
                    for (int j = 0; j < this.childDrillDownNodes.size(); ++j) {
                        root.add((DrillDownNode)this.childDrillDownNodes.elementAt(j));
                    }
                }
                chart.currentNode = root;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed parse drill-down nodes", ex);
            }
        }
        return chart;
    }

    private void getPosition(Node domNode, Chart chart) throws Exception {
        XMLNode posNode = new XMLNode(domNode);
        Node node = posNode.getNextElement("Legend_X");
        if (node != null) {
            chart.legend_XProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("Legend_Y")) != null) {
            chart.legend_YProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("SecLegend_X")) != null) {
            chart.legend2_XProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("SecLegend_Y")) != null) {
            chart.legend2_YProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("Title_X")) != null) {
            chart.title_XProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("Title_Y")) != null) {
            chart.title_YProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("Chart_X")) != null) {
            chart.chart_XProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("Chart_Y")) != null) {
            chart.chart_YProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("Chart_Width")) != null) {
            chart.chart_widthProp = this.readFloat(node);
        }
        if ((node = posNode.getNextElement("Chart_Height")) != null) {
            chart.chart_heightProp = this.readFloat(node);
        }
    }

    private void getBackgroundImage(Node domNode, Chart chart) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        chart.setBackgroundImage(new URL(this.getData(xmlNode.getNextElement("Url"))), this.getData(xmlNode.getNextElement("RelativeUrl")), this.readInt(xmlNode.getNextElement("Option")));
    }

    private int getSortValue(Node domNode) {
        String tmp = this.getData(domNode);
        for (int i = 0; i < SaveChartToXML.SORTORDER.length; ++i) {
            if (!SaveChartToXML.SORTORDER[i].equals(tmp)) continue;
            return i;
        }
        return 0;
    }

    private void getAnnotationList(Node domNode, Chart chart) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        Vector<IAnnotation> annoList = chart.annotationSet.getAnnotationList();
        if (annoList != null) {
            annoList.removeAllElements();
        }
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("Annotation");
            if (node == null) continue;
            CAnnotation anno = this.readCAnnotation(node, chart);
            chart.annotationSet.addAnnotation(anno);
        }
    }

    private ColData[] getColDataList(Node domNode, Chart chart) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        if (chart != null && count > chart.colData.length) {
            count = chart.colData.length;
        }
        ColData[] colData = new ColData[count];
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("ColData");
            if (node == null) continue;
            colData[i] = this.getColData(node, chart == null ? null : chart.colData[i], count);
        }
        return colData;
    }

    private ColData getColData(Node domNode, ColData colData, int noOfCol) throws Exception {
        Node node3;
        XMLNode xmlNode3;
        XMLNode xmlNode2;
        int count;
        IFormat dataFormat;
        Node node;
        XMLNode xmlNode = new XMLNode(domNode);
        if (colData == null && (node = xmlNode.getNextElement("COLUMN")) != null) {
            NamedNodeMap attrmap = node.getAttributes();
            int dtype = -1;
            String name = null;
            boolean typecheck = false;
            for (int j = 0; j < attrmap.getLength(); ++j) {
                Node attr = attrmap.item(j);
                if (attr.getNodeName().equalsIgnoreCase("Type")) {
                    dtype = DataType.findType(attr.getNodeValue());
                    typecheck = true;
                    break;
                }
                if (!attr.getNodeName().equalsIgnoreCase("Name")) continue;
                name = attr.getNodeValue();
            }
            if (typecheck && name != null) {
                int j;
                Vector<Object> data = new Vector<Object>();
                NodeList dataList = node.getChildNodes();
                for (j = 0; j < dataList.getLength(); ++j) {
                    if (!dataList.item(j).getNodeName().equalsIgnoreCase("DATA")) continue;
                    String datatext = this.getData(dataList.item(j));
                    data.addElement(DataType.read(datatext));
                }
                colData = new ColData(name, dtype, data.size(), noOfCol);
                for (j = 0; j < data.size(); ++j) {
                    colData.add(data.elementAt(j));
                }
            }
        }
        if ((node = xmlNode.getNextElement("LabelStepInterval")) != null) {
            colData.sepSize = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("GridStepInterval")) != null) {
            colData.tickerSepSize = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("LabelIntervalUnit")) != null) {
            colData.sepUnit = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("MaxNumOfTickerAndLabel")) != null) {
            colData.maxNumOfTickerAndLabel = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("StartDate")) != null) {
            colData.setStartingDate(new Date(this.readLong(node)));
        }
        if ((node = xmlNode.getNextElement("EndDate")) != null) {
            colData.setEndingDate(new Date(this.readLong(node)));
        }
        if ((node = xmlNode.getNextElement("Ascending")) != null) {
            colData.isAscending = this.readBoolean(node);
        }
        if ((dataFormat = this.getDataFormat(xmlNode, colData.getDataType())) != null) {
            colData.dataFormat = dataFormat;
        }
        if ((node = xmlNode.getNextElement("DataAttrList")) != null) {
            count = Integer.parseInt(this.getAttribute(node, "qbCount"));
            xmlNode2 = new XMLNode(node);
            boolean[] hideLegend = colData.getHideLegend();
            boolean[] hideData = colData.getHideData();
            if (hideLegend != null) {
                for (int i = 0; i < count && i < hideLegend.length; ++i) {
                    Node node2 = xmlNode2.getNextElement("DataAttr");
                    if (node2 == null) continue;
                    xmlNode3 = new XMLNode(node2);
                    node3 = xmlNode3.getNextElement("HideLegend");
                    if (node3 != null) {
                        hideLegend[i] = this.readBoolean(node3);
                    }
                    if ((node3 = xmlNode3.getNextElement("HideData")) == null) continue;
                    hideData[i] = this.readBoolean(node3);
                }
                colData.setHideLegend(hideLegend);
                colData.setHideData(hideData);
            }
        }
        if ((node = xmlNode.getNextElement("OverlayDataAttrList")) != null) {
            count = Integer.parseInt(this.getAttribute(node, "qbCount"));
            xmlNode2 = new XMLNode(node);
            int[] layerType = colData.getFieldType();
            int[] axisPosition = colData.getAxisPosition();
            if (layerType != null) {
                for (int i = 0; i < count && i < layerType.length; ++i) {
                    Node node2 = xmlNode2.getNextElement("OverlayDataAttr");
                    if (node2 == null) continue;
                    xmlNode3 = new XMLNode(node2);
                    node3 = xmlNode3.getNextElement("LayerType");
                    if (node3 != null) {
                        layerType[i] = this.getIndex(node3, Chart.CHARTTYPENAME, -1);
                    }
                    if ((node3 = xmlNode3.getNextElement("AxisPosition")) == null) continue;
                    axisPosition[i] = this.readInt(node3);
                }
                colData.setFieldType(layerType);
                colData.setAxisPosition(axisPosition);
            }
        }
        if ((node = xmlNode.getNextElement("DialDataAttrList")) != null) {
            count = Integer.parseInt(this.getAttribute(node, "qbCount"));
            xmlNode2 = new XMLNode(node);
            double[] needleLen = colData.getHandLength();
            if (needleLen != null) {
                for (int i = 0; i < count && i < needleLen.length; ++i) {
                    XMLNode xmlNode32;
                    Node node32;
                    Node node2 = xmlNode2.getNextElement("DialDataAttr");
                    if (node2 == null || (node32 = (xmlNode32 = new XMLNode(node2)).getNextElement("NeedleLength")) == null) continue;
                    needleLen[i] = this.readDouble(node32);
                }
                colData.setHandLength(needleLen);
            }
        }
        return colData;
    }

    private IFormat getDataFormat(XMLNode xmlNode, int dataType) throws Exception {
        IFormat dataFormat = null;
        Node node = xmlNode.getNextElement("NumericFormat");
        if (node != null) {
            dataFormat = this.getNumericFormat(node);
        } else {
            node = xmlNode.getNextElement("DateTimeFormat");
            if (node != null) {
                dataFormat = this.getDateTimeFormat(node);
            } else {
                node = xmlNode.getNextElement("LogicalFormat");
                if (node != null) {
                    dataFormat = this.getLogicalFormat(node);
                } else {
                    node = xmlNode.getNextElement("LocaleNumericFormat");
                    if (node != null) {
                        dataFormat = this.getLocaleNumericFormat(node);
                    } else {
                        node = xmlNode.getNextElement("LocaleDateTimeFormat");
                        if (node != null) {
                            dataFormat = this.getLocaleDateTimeFormat(node);
                        }
                    }
                }
            }
        }
        if (dataFormat == null) {
            return null;
        }
        int type = dataFormat.getFormatType();
        switch (dataType) {
            case 9: {
                if (type != 3 && (type != 4 || ((LocaleDateTimeFormat)dataFormat).getInstanceType() != LocaleDateTimeFormat.TIME)) break;
                return dataFormat;
            }
            case 8: {
                if (type != 3 && (type != 4 || ((LocaleDateTimeFormat)dataFormat).getInstanceType() != LocaleDateTimeFormat.DATE)) break;
                return dataFormat;
            }
            case 10: {
                if (type != 3 && (type != 4 || ((LocaleDateTimeFormat)dataFormat).getInstanceType() != LocaleDateTimeFormat.DATETIME)) break;
                return dataFormat;
            }
            case 0: {
                if (type != 0) break;
                return dataFormat;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                if (type != 1 && type != 2) break;
                return dataFormat;
            }
        }
        return null;
    }

    private NumericFormat getNumericFormat(Node domNode) throws Exception {
        NumericFormat dataFormat = new NumericFormat();
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement("CurrencySymbol");
        if (node != null) {
            dataFormat.currencySymbol = (char)this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("OneSymPerPage")) != null) {
            dataFormat.oneSymPerPage = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("CurrencyPosition")) != null) {
            dataFormat.currencyPos = this.getIndex(node, SaveChartToXML.CURRENCYPOS);
        }
        if ((node = xmlNode.getNextElement("Decimal")) != null) {
            dataFormat.decimal = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("Rounding")) != null) {
            dataFormat.rounding = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("NegativePosition")) != null) {
            dataFormat.negative = this.getIndex(node, SaveChartToXML.NEGATIVEPOS);
        }
        if ((node = xmlNode.getNextElement("DecimalSeparator")) != null) {
            dataFormat.decimalSep = (char)this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("ThousandSeparator")) != null) {
            dataFormat.thousandSep = (char)this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("LeadingZero")) != null) {
            dataFormat.leadingZero = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("SciExp")) != null && this.readBoolean(node)) {
            dataFormat.setScientifExp(dataFormat.decimal);
        }
        return dataFormat;
    }

    private DateTimeFormat getDateTimeFormat(Node domNode) throws Exception {
        DateTimeFormat dataFormat = new DateTimeFormat();
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement("YearSymbol");
        if (node != null) {
            dataFormat.yearSymbol = (short)this.getIndex(node, SaveChartToXML.YEARSYMBOL);
        }
        if ((node = xmlNode.getNextElement("MonthSymbol")) != null) {
            dataFormat.monthSymbol = (short)this.getIndex(node, SaveChartToXML.MONTHSYMBOL);
        }
        if ((node = xmlNode.getNextElement("OrderSymbol")) != null) {
            dataFormat.orderSymbol = (short)this.getIndex(node, SaveChartToXML.ORDERSYMBOL);
        }
        if ((node = xmlNode.getNextElement("DateSeparator1")) != null) {
            dataFormat.separator1 = this.getData(node);
        }
        if ((node = xmlNode.getNextElement("DateSeparator2")) != null) {
            dataFormat.separator2 = this.getData(node);
        }
        if ((node = xmlNode.getNextElement("Hour24")) != null) {
            dataFormat.hour24 = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("ShowMinute")) != null) {
            dataFormat.showMinute = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("ShowSecond")) != null) {
            dataFormat.showSecond = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("HourMinuteSeparator")) != null) {
            dataFormat.hourMinuteSep = this.getData(node);
        }
        if ((node = xmlNode.getNextElement("MinuteSecondSeparator")) != null) {
            dataFormat.minuteSecondSep = this.getData(node);
        }
        if ((node = xmlNode.getNextElement("NanoDecimal")) != null) {
            dataFormat.nanoDecimal = (short)this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("TimeBeforeDate")) != null) {
            dataFormat.timeBeforeDate = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("TimeDateSeparator")) != null) {
            dataFormat.timeDateSep = this.getData(node);
        }
        if ((node = xmlNode.getNextElement("HideDate")) != null) {
            dataFormat.hidedate = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("HideMonth")) != null) {
            dataFormat.hidemonth = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("HideYear")) != null) {
            dataFormat.hideyear = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("HideTimestampTime")) != null) {
            dataFormat.hideTimestampTime = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("FixDigitLength")) != null) {
            dataFormat.fixDigitLen = this.readBoolean(node);
        }
        return dataFormat;
    }

    private LogicalFormat getLogicalFormat(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        return new LogicalFormat(this.getIndex(xmlNode.getNextElement("LogicalType"), SaveChartToXML.LOGICALFORMAT));
    }

    private LocaleNumericFormat getLocaleNumericFormat(Node domNode) throws Exception {
        LocaleNumericFormat result;
        XMLNode xmlNode = new XMLNode(domNode);
        int type = this.getIndex(xmlNode.getNextElement("LocaleNumericType"), SaveChartToXML.LOCALENUMERICFORMAT);
        if (type == 0) {
            result = LocaleNumericFormat.getCurrencyInstance();
        } else if (type == 1) {
            result = LocaleNumericFormat.getNumberInstance();
        } else if (type == 2) {
            result = LocaleNumericFormat.getPercentInstance();
        } else {
            throw new IOException("Illegal LocaleNumericFormat: " + type);
        }
        NumberFormat nf = result.getNumberFormat();
        Node node = xmlNode.getNextElement("MaximumFractionDigits");
        if (node != null) {
            nf.setMaximumFractionDigits(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("MaximumIntegerDigits")) != null) {
            nf.setMaximumIntegerDigits(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("MinimumFractionDigits")) != null) {
            nf.setMinimumFractionDigits(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("MinimumIntegerDigits")) != null) {
            nf.setMinimumIntegerDigits(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("GroupingUsed")) != null) {
            nf.setGroupingUsed(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ParseIntegerOnly")) != null) {
            nf.setParseIntegerOnly(this.readBoolean(node));
        }
        return result;
    }

    private LocaleDateTimeFormat getLocaleDateTimeFormat(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        int type = this.getIndex(xmlNode.getNextElement("LocaleDateTimeType"), SaveChartToXML.LOCALEDATETIMEFORMAT);
        int dateStyle = 2;
        int timeStyle = 2;
        Node node = xmlNode.getNextElement("DateStyle");
        if (node != null) {
            dateStyle = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("TimeStyle")) != null) {
            timeStyle = this.readInt(node);
        }
        if (type == LocaleDateTimeFormat.DATE) {
            return LocaleDateTimeFormat.getDateInstance(dateStyle);
        }
        if (type == LocaleDateTimeFormat.TIME) {
            return LocaleDateTimeFormat.getTimeInstance(timeStyle);
        }
        if (type == LocaleDateTimeFormat.DATETIME) {
            return LocaleDateTimeFormat.getDateTimeInstance(dateStyle, timeStyle);
        }
        throw new IOException("Illegal LocaleDateTimeFormat: " + type);
    }

    private void getSecondaryAxisFormat(Node domNode, Chart chart) throws Exception {
        IFormat dataFormat;
        Node node;
        XMLNode xmlNode = new XMLNode(domNode);
        if (chart.secData == null) {
            chart.secData = new ColData(chart.colData[chart.valueCol].getName(), chart.colData[chart.valueCol].getOriginalDataType(), chart.colData.length);
            chart.secData.copyAttributes(chart.colData[chart.valueCol]);
        }
        if ((node = xmlNode.getNextElement("LabelStepInterval")) != null) {
            chart.secData.sepSize = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("GridStepInterval")) != null) {
            chart.secData.tickerSepSize = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("MaxNumOfTickerAndLabel")) != null) {
            chart.secData.maxNumOfTickerAndLabel = this.readInt(node);
        }
        if ((dataFormat = this.getDataFormat(xmlNode, chart.secData.getDataType())) != null) {
            chart.secData.dataFormat = dataFormat;
        }
    }

    private void getFloatingLineList(Node domNode, Chart chart) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("FloatingLine");
            if (node == null) continue;
            chart.addLine(this.readPolyLine(node));
        }
    }

    private Vector getPoint_3DList(Node domNode) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        Vector<Point_3D> list = new Vector<Point_3D>();
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("Point_3D");
            if (node == null) continue;
            list.addElement(this.getPoint_3D(node));
        }
        return list;
    }

    private Vector getPoint_2DList(Node domNode) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        Vector<Point_2D> list = new Vector<Point_2D>();
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("Point_2D");
            if (node == null) continue;
            list.addElement(this.getPoint_2D(node));
        }
        return list;
    }

    private Dimension[] getDimensionArray(Node domNode, String elt) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        Dimension[] dim = new Dimension[count];
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement(elt);
            if (node == null) continue;
            dim[i] = this.getDimension(node);
        }
        return dim;
    }

    private void getValueSubstitutionList(Node domNode, Chart chart) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("ValueSubstitution");
            if (node == null) continue;
            XMLNode xmlNode2 = new XMLNode(node);
            String key = this.getData(xmlNode2.getNextElement("OriginalValue"));
            String val = this.getData(xmlNode2.getNextElement("SubstitutedValue"));
            chart.valueTable.addUniqueKeyValue(key, val);
        }
    }

    private void getLabelSubstitutionList(Node domNode, Ticker ticker) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        if (count <= 0) {
            return;
        }
        String[] tmp = new String[count];
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("LabelSubstitution");
            if (node == null) continue;
            tmp[i] = this.getData(node);
        }
        ticker.setTickerLabels(tmp);
    }

    private void getControlRangeList(Node domNode, Chart chart) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        Vector<ControlRange> rangeList = new Vector<ControlRange>();
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("ControlRange");
            if (node == null) continue;
            rangeList.addElement(this.readControlRange(node));
        }
        chart.setControlRangeList(rangeList);
    }

    private void getHyperLinkList(Node domNode, Chart chart) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        Vector<HyperLink> hyperList = chart.getHyperLinkList();
        if (hyperList != null) {
            hyperList.removeAllElements();
        }
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("HyperLink");
            if (node == null) continue;
            chart.updateHyperLink(this.readHyperLink(node));
        }
    }

    private void getSurfaceHyperLinkList(Node domNode, Chart chart) throws Exception {
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        Vector<FaceHyperLink> hyperList = chart.getSurfaceHyperLinkList();
        if (hyperList != null) {
            hyperList.removeAllElements();
        }
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("SurfaceHyperLink");
            if (node == null) continue;
            this.getSurfaceHyperLink(node, chart);
        }
    }

    private void getSurfaceHyperLink(Node domNode, Chart chart) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        String xValue = this.getData(xmlNode.getNextElement("ValueX"));
        String zValue = this.getData(xmlNode.getNextElement("ValueZ"));
        chart.addNewSurfaceLink(this.getData(xmlNode.getNextElement("Link")), this.getData(xmlNode.getNextElement("Target")), this.getData(xmlNode.getNextElement("Hint")), xValue, zValue);
    }

    private void getPieLabelList(Node domNode, PieChart chart) throws Exception {
        int pieCount = 1;
        String str = this.getAttribute(domNode, "pieCount");
        if (str != null) {
            try {
                pieCount = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Pie count - Invalid number, using 1", ex);
                pieCount = 1;
            }
        }
        int count = Integer.parseInt(this.getAttribute(domNode, "qbCount"));
        XMLNode xmlNode = new XMLNode(domNode);
        chart.allocateLabel(pieCount, count);
        for (int j = 0; j < pieCount; ++j) {
            for (int i = 0; i < count; ++i) {
                Node node = xmlNode.getNextElement("PieLabel");
                if (node == null) continue;
                this.getPieLabel(node, chart, j, i);
            }
        }
    }

    private void getPieLabel(Node domNode, PieChart pieChart, int pieIdx, int i) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement("LabelX");
        if (node != null) {
            pieChart.pieLabel[pieIdx][i].xoffset = this.readFloat(node);
        }
        if ((node = xmlNode.getNextElement("LabelY")) != null) {
            pieChart.pieLabel[pieIdx][i].yoffset = this.readFloat(node);
        }
        if ((node = xmlNode.getNextElement("ValueX")) != null) {
            pieChart.pieValue[pieIdx][i].xoffset = this.readFloat(node);
        }
        if ((node = xmlNode.getNextElement("ValueY")) != null) {
            pieChart.pieValue[pieIdx][i].yoffset = this.readFloat(node);
        }
        if ((node = xmlNode.getNextElement("PercentX")) != null) {
            pieChart.piePercent[pieIdx][i].xoffset = this.readFloat(node);
        }
        if ((node = xmlNode.getNextElement("PercentY")) != null) {
            pieChart.piePercent[pieIdx][i].yoffset = this.readFloat(node);
        }
    }

    private void get3DAttr(Node domNode, Chart chart) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement("AutoRotate");
        if (node != null) {
            chart.setAutoRotate(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ThickRatio")) != null) {
            chart.setThickRatio(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("WallBackground")) != null) {
            this.getArea(node, chart.getWallBackground());
        }
        if ((node = xmlNode.getNextElement("ShowWallFrame")) != null) {
            chart.setWallFrame(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Set3DDrawType")) != null) {
            chart.set3DDrawType(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("ZoomFactor")) != null) {
            chart.setZoomfactor(this.readFloat(node));
        }
        if ((node = xmlNode.getNextElement("AnimateSpeed")) != null) {
            chart.setAnimateSpeed(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("Is3DApproximationUsed")) != null) {
            chart.is3DApproximationUsed = this.readBoolean(node);
        }
        if ((node = xmlNode.getNextElement("ApproximationThreshold")) != null) {
            chart.approximationThreshold = this.readInt(node);
        }
        if ((node = xmlNode.getNextElement("DrawSeriesOnCategoryAxis")) != null) {
            chart.setDrawSeriesOnCategoryAxis(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("ViewDirection")) != null) {
            chart.setViewPoint(this.getViewDirection(node));
        }
        if ((node = xmlNode.getNextElement("ViewTranslation")) != null) {
            chart.setViewTranslate(this.getFloatArray(node));
        }
        if ((node = xmlNode.getNextElement("LightPosition")) != null) {
            chart.setLightPos(this.getFloatArray(node));
        }
        if ((node = xmlNode.getNextElement("Ambient")) != null) {
            chart.setAmbient(this.getFloatArray(node));
        }
        if ((node = xmlNode.getNextElement("Intensity")) != null) {
            chart.setIntensity(this.getFloatArray(node));
        }
        if ((node = xmlNode.getNextElement("Scale3D")) != null) {
            float[] scale = this.getFloatArray(node);
            chart.scaleSpace(scale[0], scale[1], scale[2]);
        }
    }

    private float[] getViewDirection(Node domNode) throws Exception {
        float[] dir = new float[6];
        XMLNode xmlNode = new XMLNode(domNode);
        XMLNode fNode = new XMLNode(xmlNode.getNextElement("From"));
        dir[0] = this.readFloat(fNode.getNextElement("ValueX"));
        dir[1] = this.readFloat(fNode.getNextElement("ValueY"));
        dir[2] = this.readFloat(fNode.getNextElement("ValueZ"));
        XMLNode tNode = new XMLNode(xmlNode.getNextElement("To"));
        dir[3] = this.readFloat(tNode.getNextElement("ValueX"));
        dir[4] = this.readFloat(tNode.getNextElement("ValueY"));
        dir[5] = this.readFloat(tNode.getNextElement("ValueZ"));
        return dir;
    }

    private float[] getFloatArray(Node domNode) throws Exception {
        float[] dir = new float[3];
        XMLNode xmlNode = new XMLNode(domNode);
        dir[0] = this.readFloat(xmlNode.getNextElement("ValueX"));
        dir[1] = this.readFloat(xmlNode.getNextElement("ValueY"));
        dir[2] = this.readFloat(xmlNode.getNextElement("ValueZ"));
        return dir;
    }

    private ColorSpectrum getColorSpectrum(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        int count = this.readInt(xmlNode.getNextElement("CountSpectrumSeparator"));
        double[] value = new double[count];
        Color[] color = new Color[count + 1];
        for (int i = 0; i < count; ++i) {
            Node node = xmlNode.getNextElement("SpectrumSeparator");
            if (node != null) {
                XMLNode xmlNode2 = new XMLNode(node);
                color[i] = this.readColor(xmlNode2.getNextElement("ColorBefore"));
                value[i] = this.readDouble(xmlNode2.getNextElement("SeparatorValue"));
                continue;
            }
            if (i > 0) {
                color[i] = color[i - 1];
                value[i] = value[i - 1];
                continue;
            }
            color[i] = Color.yellow;
            value[i] = 0.0;
        }
        color[count] = this.readColor(xmlNode.getNextElement("ColorAfter"));
        return new ColorSpectrum(color, value);
    }

    private void getTopLabelAttr(Node domNode, Chart chart) throws Exception {
        XMLNode labelNode = new XMLNode(domNode);
        Node node = labelNode.getNextElement("PrimaryTopLabel");
        if (node != null) {
            this.getPrimaryTopLabel(node, chart);
        }
        if ((node = labelNode.getNextElement("SecondaryTopLabel")) != null) {
            this.getSecondaryTopLabel(node, chart);
        }
        if ((node = labelNode.getNextElement("LabelOnPositiveSide")) != null) {
            chart.setLabelOnPositiveSide(this.readBoolean(node));
        }
        if ((node = labelNode.getNextElement("LabelOnNegativeSide")) != null) {
            chart.setLabelOnNegativeSide(this.readBoolean(node));
        }
        if ((node = labelNode.getNextElement("ShowSeriesInTopLabel")) != null) {
            chart.showSeriesInTopLabel(this.readBoolean(node));
        }
        if ((node = labelNode.getNextElement("ShowStackLabel")) != null) {
            chart.setStackLabelState(this.readBoolean(node));
        }
        if ((node = labelNode.getNextElement("ShowStackTotalLabel")) != null) {
            chart.setStackTotalLabelState(this.readBoolean(node));
        }
        if ((node = labelNode.getNextElement("ShowStackLabelAlignment")) != null) {
            chart.stackLabel_Alignment = this.readInt(node);
        }
    }

    private void getPrimaryTopLabel(Node domNode, Chart chart) throws Exception {
        XMLNode labelNode = new XMLNode(domNode);
        Node node = labelNode.getNextElement("Visible");
        if (node != null) {
            chart.setTopValueState(this.readBoolean(node));
        }
        if ((node = labelNode.getNextElement("Font")) != null) {
            chart.topvalueLabel_font = this.readFont(node);
        }
        if ((node = labelNode.getNextElement("Color")) != null) {
            chart.topvalueLabel_color = this.readColor(node);
        }
        if ((node = labelNode.getNextElement("ColorForNegativeValue")) != null) {
            chart.topvalueNegativeLabel_color = this.readColor(node);
        }
        if ((node = labelNode.getNextElement("Angle")) != null) {
            chart.topvalueLabel_angle = this.readInt(node);
        }
        if ((node = labelNode.getNextElement("Alignmen")) != null) {
            chart.topLabel_Alignment = this.readInt(node);
        }
    }

    private void getSecondaryTopLabel(Node domNode, Chart chart) throws Exception {
        XMLNode labelNode = new XMLNode(domNode);
        Node node = labelNode.getNextElement("Visible");
        if (node != null) {
            chart.setTopValueState2(this.readBoolean(node));
        }
        if ((node = labelNode.getNextElement("Font")) != null) {
            chart.topvalueLabel2_font = this.readFont(node);
        }
        if ((node = labelNode.getNextElement("Color")) != null) {
            chart.topvalueLabel2_color = this.readColor(node);
        }
        if ((node = labelNode.getNextElement("Angle")) != null) {
            chart.topvalueLabel2_angle = this.readInt(node);
        }
    }

    private DataAttribute getDataAttribute(Node domNode, boolean is2DChart, int chartType, int dataDim) throws Exception {
        Color rootColor = Color.black;
        int rootShape = 0;
        int rootSize = 0;
        int rootLineThickness = this.defaultLineThickness;
        Color[] dataColor = null;
        int[] dataShape = null;
        int[] dataSize = null;
        int[] lineThickness = null;
        String[] name = null;
        boolean[] sliceExplode = null;
        XMLNode dataNode = new XMLNode(domNode);
        Node node = dataNode.getNextElement("RootDataAttr");
        if (node != null) {
            XMLNode rootNode = new XMLNode(node);
            rootColor = this.readColor(rootNode.getNextElement("Color"));
            rootShape = this.getIndex(rootNode.getNextElement("Shape"), SaveChartToXML.SHAPE);
            rootShape = this.readInt(rootNode.getNextElement("LineStyle")) * 256 + rootShape;
            rootSize = this.readInt(rootNode.getNextElement("Size"));
            node = rootNode.getNextElement("LineThickness");
            rootLineThickness = node != null ? this.readInt(node) : this.defaultLineThickness;
        }
        if ((node = dataNode.getNextElement("DataColumnAttrList")) != null) {
            int count = Integer.parseInt(this.getAttribute(node, "qbCount"));
            dataColor = new Color[count];
            dataShape = new int[count];
            dataSize = new int[count];
            lineThickness = new int[count];
            name = new String[count];
            XMLNode listNode = new XMLNode(node);
            for (int i = 0; i < count; ++i) {
                Node node2 = listNode.getNextElement("DataColumnAttr");
                if (node2 == null) continue;
                XMLNode colNode = new XMLNode(node2);
                dataColor[i] = this.readColor(colNode.getNextElement("Color"));
                int patternID = 0;
                try {
                    patternID = this.readInt(colNode.getNextElement("PatternID"));
                    if (patternID > 0) {
                        Color c = dataColor[i];
                        dataColor[i] = new QbPattern(c, patternID);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Failed to use a pattern", e);
                }
                dataShape[i] = this.getIndex(colNode.getNextElement("Shape"), SaveChartToXML.SHAPE);
                dataShape[i] = this.readInt(colNode.getNextElement("LineStyle")) * 256 + dataShape[i];
                dataSize[i] = this.readInt(colNode.getNextElement("Size"));
                Node node3 = colNode.getNextElement("LineThickness");
                lineThickness[i] = node3 != null ? this.readInt(node3) : this.defaultLineThickness;
                node3 = colNode.getNextElement("Name");
                name[i] = this.getData(node3);
                node3 = colNode.getNextElement("SliceExplode");
                if (node3 == null) continue;
                if (sliceExplode == null) {
                    sliceExplode = new boolean[count];
                }
                sliceExplode[i] = this.readBoolean(node3);
            }
        }
        return new DataAttribute(is2DChart, chartType, dataDim, rootColor, rootShape, rootSize, rootLineThickness, dataColor, dataShape, dataSize, lineThickness, sliceExplode, name);
    }

    private void getLegend(Node domNode, Legend legend) throws Exception {
        XMLNode legendNode = new XMLNode(domNode);
        Font font = legend.getFont();
        int angle = legend.getAngle();
        int ptSizeRatio = legend.getPointSizeRatio();
        Node node = legendNode.getNextElement("Font");
        if (node != null) {
            font = this.readFont(node);
        }
        if ((node = legendNode.getNextElement("Angle")) != null) {
            angle = this.readInt(node);
        }
        legend.setFont(font, angle);
        node = legendNode.getNextElement("PointSizeRatio");
        if (node != null) {
            ptSizeRatio = this.readInt(node);
        }
        legend.setPointSizeRatio(ptSizeRatio);
        node = legendNode.getNextElement("FontColor");
        if (node != null) {
            legend.setfontColor(this.readColor(node));
        }
        if ((node = legendNode.getNextElement("Background")) != null) {
            this.getArea(node, legend.getBackground());
        }
        if ((node = legendNode.getNextElement("Border")) != null) {
            this.getArea(node, legend.getBorder());
        }
        if ((node = legendNode.getNextElement("Appearance")) != null) {
            legend.area.appearance = this.readInt(node);
        }
        if ((node = legendNode.getNextElement("Depth")) != null) {
            legend.area.depth = this.readInt(node);
        }
        if ((node = legendNode.getNextElement("Vertical")) != null) {
            legend.setLayout(this.readBoolean(node) ? 1 : 0);
        }
        if ((node = legendNode.getNextElement("Layout")) != null) {
            legend.setLayout(this.readInt(node));
        }
        if ((node = legendNode.getNextElement("Fixed_Column")) != null) {
            legend.setLayout(this.readInt(node));
        }
        if ((node = legendNode.getNextElement("Visible")) != null) {
            legend.showLegend = this.readBoolean(node);
        }
        if ((node = legendNode.getNextElement("OneLegend")) != null) {
            legend.useOneLegendSet = this.readBoolean(node);
        }
        if ((node = legendNode.getNextElement("Reverse")) != null) {
            legend.reverse = this.readBoolean(node);
        }
        if ((node = legendNode.getNextElement("DrawSymbol")) != null) {
            legend.drawSymbols(this.readBoolean(node));
        }
    }

    private void getPieAttr(Node domNode, Chart chart) throws Exception {
        PieChart pieChart = ((IPieChart)((Object)chart)).getPieChart();
        XMLNode pieNode = new XMLNode(domNode);
        Node node = pieNode.getNextElement("ConcentricDoughnut");
        if (node != null) {
            pieChart.concentricDoughnut = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("PieSectors")) != null) {
            pieChart.pieSectors = this.readInt(node);
        }
        if ((node = pieNode.getNextElement("FontDistance")) != null) {
            pieChart.fontdistance = this.readDouble(node);
        }
        if ((node = pieNode.getNextElement("SliceDistance")) != null) {
            pieChart.sliceDistance = this.readDouble(node);
        }
        if ((node = pieNode.getNextElement("InitAngle")) != null) {
            pieChart.initangle = this.readInt(node);
        }
        if ((node = pieNode.getNextElement("LabelFont")) != null) {
            pieChart.pieLabelFont = this.readFont(node);
        }
        if ((node = pieNode.getNextElement("ValueFont")) != null) {
            pieChart.pieValueFont = this.readFont(node);
        }
        if ((node = pieNode.getNextElement("PercentFont")) != null) {
            pieChart.piePercentFont = this.readFont(node);
        }
        if ((node = pieNode.getNextElement("LabelColor")) != null) {
            pieChart.pieLabelColor = this.readColor(node);
        }
        if ((node = pieNode.getNextElement("ValueColor")) != null) {
            pieChart.pieValueColor = this.readColor(node);
        }
        if ((node = pieNode.getNextElement("PercentColor")) != null) {
            pieChart.piePercentColor = this.readColor(node);
        }
        if ((node = pieNode.getNextElement("LabelAngle")) != null) {
            pieChart.pieLabelAngle = this.readDouble(node);
        }
        if ((node = pieNode.getNextElement("ValueAngle")) != null) {
            pieChart.pieValueAngle = this.readDouble(node);
        }
        if ((node = pieNode.getNextElement("PercentAngle")) != null) {
            pieChart.piePercentAngle = this.readDouble(node);
        }
        if ((node = pieNode.getNextElement("ShowLabel")) != null) {
            pieChart.showLabel = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("ShowValue")) != null) {
            pieChart.showValue = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("ShowPercent")) != null) {
            pieChart.showPercent = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("ShowPercentInLegend")) != null) {
            pieChart.smartlabel = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("ShowValueInLegend")) != null) {
            pieChart.valInLegend = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("SectorGapEnabled")) != null) {
            pieChart.setSectorGapEnabled(this.readBoolean(node));
        }
        if ((node = pieNode.getNextElement("PieExtendLine")) != null) {
            pieChart.pieExtendLine = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("PieLabelAtTheSide")) != null) {
            pieChart.labelAtTheSide = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("CategoryLabelDistance")) != null) {
            pieChart.catLabelDistance = this.readDouble(node);
        }
        if ((node = pieNode.getNextElement("CategoryLabelFont")) != null) {
            pieChart.catLabelFont = this.readFont(node);
        }
        if ((node = pieNode.getNextElement("CategoryLabelColor")) != null) {
            pieChart.catLabelColor = this.readColor(node);
        }
        if ((node = pieNode.getNextElement("CategoryLabelAngle")) != null) {
            pieChart.catLabelAngle = this.readDouble(node);
        }
        if ((node = pieNode.getNextElement("CategoryLabelState")) != null) {
            pieChart.showCategory = this.readBoolean(node);
        }
        if ((node = pieNode.getNextElement("BestFit")) != null) {
            pieChart.setBestFit(this.readBoolean(node));
        }
        if ((node = pieNode.getNextElement("DrawLinearly")) != null) {
            pieChart.setDrawLinearly(this.readBoolean(node));
        }
        if ((node = pieNode.getNextElement("PiePerRow")) != null) {
            pieChart.piePerRow = this.readInt(node);
        }
        if ((node = pieNode.getNextElement("GapRatioBetweenPies")) != null) {
            pieChart.setGapRatioBetweenPies(this.readDouble(node));
        }
        if ((node = pieNode.getNextElement("PieLabelList")) != null) {
            this.getPieLabelList(node, pieChart);
        }
    }

    private void getSurfaceAttr(Node domNode, Chart chart) throws Exception {
        XMLNode surNode = new XMLNode(domNode);
        Node node = surNode.getNextElement("Color");
        if (node != null) {
            chart.set3DSurfaceColor(this.readColor(node));
        }
        if ((node = surNode.getNextElement("SurfaceHyperLinkList")) != null) {
            this.getSurfaceHyperLinkList(node, chart);
        }
    }

    private void getBubbleAttr(Node domNode, Chart chart) throws Exception {
        XMLNode bulNode = new XMLNode(domNode);
        Node node = bulNode.getNextElement("BubbleDrawMode");
        if (node != null) {
            chart.bubbleDrawMode = this.getIndex(node, SaveChartToXML.BUBBLEDRAWMODE);
        }
        if ((node = bulNode.getNextElement("AxisUnitToRadiusRatio")) != null) {
            chart.axisUnitToRadiusRatio = this.readDouble(node);
        }
    }

    private void getLineAttr(Node domNode, Chart chart) throws Exception {
        XMLNode lineNode = new XMLNode(domNode);
        Node node = lineNode.getNextElement("StepLineState");
        if (node != null) {
            chart.setStepLineState(this.readBoolean(node));
        }
        if ((node = lineNode.getNextElement("StepLineRatio")) != null) {
            chart.setStepLineRatio(this.readDouble(node));
        }
        if ((node = lineNode.getNextElement("PlotSecDataWithPriAxis")) != null) {
            chart.setShowDoubleValueForLine(this.readBoolean(node));
        }
        if ((node = lineNode.getNextElement("SetPointsUniform")) != null) {
            chart.setSyncPointColorForLine(this.readBoolean(node));
        }
        if ((node = lineNode.getNextElement("DropBar")) != null) {
            this.getDropBar(node, chart);
        }
        if ((node = lineNode.getNextElement("Vertical")) != null) {
            chart.setLayout(this.readBoolean(node) ? 1 : 0);
        }
    }

    private void getRadarAttr(Node domNode, Chart chart) throws Exception {
        XMLNode radNode = new XMLNode(domNode);
        Node node = radNode.getNextElement("LabelOffsetList");
        if (node != null) {
            chart.setLabelOffset(this.getDimensionArray(node, "LabelOffset"));
        }
    }

    private void getBoxAttr(Node domNode, Chart chart) throws Exception {
        XMLNode radNode = new XMLNode(domNode);
        Node node = radNode.getNextElement("Vertical");
        if (node != null) {
            chart.setLayout(this.readBoolean(node) ? 1 : 0);
        }
    }

    private void getGanttAttr(Node domNode, Chart chart) throws Exception {
        XMLNode ganttNode = new XMLNode(domNode);
        Node node = ganttNode.getNextElement("DisplayInTime");
        if (node != null) {
            chart.setLabelDateTimeDisplay(0, this.readBoolean(node));
        }
        if ((node = ganttNode.getNextElement("DisplayByWeek")) != null) {
            chart.setDisplayByWeek(0, this.readBoolean(node));
        }
    }

    private void getScatterAttr(Node domNode, Chart chart) throws Exception {
        XMLNode scatterNode = new XMLNode(domNode);
        Node node = scatterNode.getNextElement("DisplayXAxisInTime");
        if (node != null) {
            chart.setLabelDateTimeDisplay(0, this.readBoolean(node));
        }
        if ((node = scatterNode.getNextElement("DisplayYAxisInTime")) != null) {
            chart.setLabelDateTimeDisplay(1, this.readBoolean(node));
        }
        if ((node = scatterNode.getNextElement("DisplayZAxisInTime")) != null) {
            chart.setLabelDateTimeDisplay(2, this.readBoolean(node));
        }
        if ((node = scatterNode.getNextElement("DisplayXAxisByWeek")) != null) {
            chart.setDisplayByWeek(0, this.readBoolean(node));
        }
        if ((node = scatterNode.getNextElement("DisplayYAxisByWeek")) != null) {
            chart.setDisplayByWeek(1, this.readBoolean(node));
        }
        if ((node = scatterNode.getNextElement("DisplayZAxisByWeek")) != null) {
            chart.setDisplayByWeek(2, this.readBoolean(node));
        }
        if ((node = scatterNode.getNextElement("DRAW_LINES_IN_DATASOURCE_ORDER")) != null) {
            chart.setLineInOriginalOrder(this.readBoolean(node));
        }
        if ((node = scatterNode.getNextElement("DRAW_CONNECT_LINE_ARROWS")) != null) {
            chart.setDrawConnectLineArrows(this.readBoolean(node));
        }
    }

    private void getPolarAttr(Node domNode, Chart chart) throws Exception {
        XMLNode polarNode = new XMLNode(domNode);
        Node node = polarNode.getNextElement("SectorCount");
        if (node != null) {
            chart.setNoSectionForPolar(this.readInt(node));
        }
        if ((node = polarNode.getNextElement("StartAngle")) != null) {
            chart.setStartAngleForPolar(this.readDouble(node));
        }
        if ((node = polarNode.getNextElement("IsRadian")) != null) {
            chart.setRadianForPolar(this.readBoolean(node));
        }
        if ((node = polarNode.getNextElement("IsClockwise")) != null) {
            chart.setClockWiseForPolar(this.readBoolean(node));
        }
        if ((node = polarNode.getNextElement("LabelOffsetList")) != null) {
            chart.setLabelOffset(this.getDimensionArray(node, "LabelOffset"));
        }
    }

    private void getDialAttr(Node domNode, Chart chart) throws Exception {
        XMLNode dialNode = new XMLNode(domNode);
        Node node = dialNode.getNextElement("LabelOffsetList");
        if (node != null) {
            chart.setLabelOffset(this.getDimensionArray(node, "LabelOffset"));
        }
        if ((node = dialNode.getNextElement("StartAngle")) != null) {
            chart.setStartAngleForDial(this.readDouble(node));
        }
        if ((node = dialNode.getNextElement("EndAngle")) != null) {
            chart.setEndAngleForDial(this.readDouble(node));
        }
        if ((node = dialNode.getNextElement("RadiusForInternalDial")) != null) {
            chart.setRadiusForInternalDial(this.readDouble(node));
        }
        if ((node = dialNode.getNextElement("CenterColor")) != null) {
            chart.setCenterColorForDial(this.readColor(node));
        }
        if ((node = dialNode.getNextElement("FullCircle")) != null) {
            chart.setDrawFullCircleForDial(this.readBoolean(node));
        }
        if ((node = dialNode.getNextElement("SubTickerLength")) != null) {
            chart.setSubTickerLength(this.readInt(node));
        }
        if ((node = dialNode.getNextElement("TickerLength")) != null) {
            chart.setTickerLength(this.readInt(node));
        }
        if ((node = dialNode.getNextElement("Is3DShadowForTickerOn")) != null) {
            chart.set3DShadowForTickerOn(this.readBoolean(node));
        }
        if ((node = dialNode.getNextElement("SubTickerCount")) != null) {
            chart.setSubTickerCount(this.readInt(node));
        }
        if ((node = dialNode.getNextElement("SubTickerThickness")) != null) {
            chart.setSubTickerThickness(this.readInt(node));
        }
        if ((node = dialNode.getNextElement("IsPointerUsed")) != null) {
            chart.setPointerUsed(this.readBoolean(node));
        }
        if ((node = dialNode.getNextElement("NeedleOption")) != null) {
            chart.setNeedleOption(this.readInt(node));
        }
    }

    private void getDropBar(Node domNode, Chart chart) throws Exception {
        XMLNode barNode = new XMLNode(domNode);
        Node node = barNode.getNextElement("Visible");
        if (node != null) {
            chart.setShowDropBarForLine(this.readBoolean(node));
        }
        if ((node = barNode.getNextElement("DrawBorder")) != null) {
            chart.setDropBarBorderState(this.readBoolean(node));
        }
        if ((node = barNode.getNextElement("UpBarColor")) != null) {
            chart.setDropBarColor(this.readColor(node));
        }
        if ((node = barNode.getNextElement("DownBarColor")) != null) {
            chart.setDropBarColor2(this.readColor(node));
        }
        if ((node = barNode.getNextElement("SeriesA")) != null) {
            chart.setDropBarSeries1(this.readInt(node));
        }
        if ((node = barNode.getNextElement("SeriesB")) != null) {
            chart.setDropBarSeries2(this.readInt(node));
        }
    }

    private void getAxisAttr(Node domNode, Chart chart) throws Exception {
        XMLNode axisNode = new XMLNode(domNode);
        Node node = axisNode.getNextElement("Color");
        if (node != null) {
            chart.setAxisColor(this.readColor(node));
        }
        if ((node = axisNode.getNextElement("Thickness")) != null) {
            chart.axisThickness = this.readInt(node);
        }
        if ((node = axisNode.getNextElement("ShowArrow")) != null) {
            chart.setArrowState(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("XAxisLabelRow")) != null) {
            chart.set_xlabelrow(this.readInt(node));
        }
        if ((node = axisNode.getNextElement("SwapAxis")) != null) {
            chart.setSwapAxis(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("JoinAxis")) != null) {
            chart.setJoinAxis(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("SynchronizeRadarAxes")) != null) {
            chart.setSynchronizeRadarAxis(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("DrawCircularGrid")) != null) {
            chart.setDrawCircularGrid(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("AreaCutOffPoint")) != null) {
            chart.setAreaCutOffPoint(this.readDouble(node));
        }
        if ((node = axisNode.getNextElement("AlignGridWithTicker")) != null) {
            chart.setGridAlignedWithTicker(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("GridInFront")) != null) {
            chart.setGridInFront(this.readBoolean(node));
        }
        String[] axisType = new String[]{"X", "Y", "Z", "S"};
        for (int i = 0; i < 4; ++i) {
            node = axisNode.getNextElement("Axis_" + axisType[i]);
            if (node == null) continue;
            this.getAxis(node, chart, i);
        }
    }

    private void getAxis(Node domNode, Chart chart, int i) throws Exception {
        XMLNode axisNode = new XMLNode(domNode);
        Node node = axisNode.getNextElement("Visible");
        if (node != null) {
            chart.setAxisState(i, this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("Title")) != null) {
            this.getCString(node, chart.axis[i].title);
        }
        if ((node = axisNode.getNextElement("Grid")) != null) {
            this.getGrid(node, chart, i);
        }
        if ((node = axisNode.getNextElement("LogScale")) != null) {
            chart.axis[i].logScale = this.readBoolean(node);
        }
        if ((node = axisNode.getNextElement("ShowLogValue")) != null) {
            chart.axis[i].setShowLogValue(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("LogBase")) != null) {
            chart.axis[i].setBaseForLog(this.readDouble(node));
        }
        if ((node = axisNode.getNextElement("ShowLogSubTickers")) != null) {
            chart.axis[i].setShowSubTickers(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("AutoScale")) != null) {
            chart.axis[i].autoscale = this.readBoolean(node);
        }
        if ((node = axisNode.getNextElement("AutoOrigin")) != null) {
            chart.axis[i].autoOrigin = this.readBoolean(node);
        }
        if ((node = axisNode.getNextElement("AxisPadding")) != null) {
            chart.axis[i].addAxisPadding = this.readBoolean(node);
        }
        if ((node = axisNode.getNextElement("LabelOutsidePlotArea")) != null) {
            chart.axis[i].setLabelOutsidePlotArea(this.readBoolean(node));
        }
        if ((node = axisNode.getNextElement("MaxScale")) != null) {
            chart.axis[i].maxScale = this.readDouble(node);
        }
        if ((node = axisNode.getNextElement("MinScale")) != null) {
            chart.axis[i].minScale = this.readDouble(node);
        }
        if ((node = axisNode.getNextElement("StepScale")) != null) {
            chart.axis[i].stepScale = this.readDouble(node);
        }
        if ((node = axisNode.getNextElement("StepScaleMonth")) != null) {
            chart.axis[i].stepScaleMonth = this.readInt(node);
        }
        if ((node = axisNode.getNextElement("Ticker")) != null) {
            this.getTicker(node, chart, i);
        }
    }

    private void getGrid(Node domNode, Chart chart, int i) throws Exception {
        XMLNode gridNode = new XMLNode(domNode);
        Node node = gridNode.getNextElement("Visible");
        if (node != null) {
            chart.setGridState(i, this.readBoolean(node));
        }
        if ((node = gridNode.getNextElement("Color")) != null) {
            chart.setGridColor(i, this.readColor(node));
        }
        if ((node = gridNode.getNextElement("Thickness")) != null) {
            chart.setGridThickness(i, this.readInt(node));
        }
        if ((node = gridNode.getNextElement("LineStyle")) != null) {
            chart.setGridLineStyle(i, this.readInt(node));
        }
    }

    private void getTicker(Node domNode, Chart chart, int i) throws Exception {
        XMLNode tickerNode = new XMLNode(domNode);
        Node node = tickerNode.getNextElement("ShowLabel");
        if (node != null) {
            chart.setTickerLabelState(i, this.readBoolean(node));
        }
        if ((node = tickerNode.getNextElement("Color")) != null) {
            chart.setTickerColor(i, this.readColor(node));
        }
        if ((node = tickerNode.getNextElement("LabelColor")) != null) {
            chart.setLabelColor(i, this.readColor(node));
        }
        Font font = chart.getTickerFont(i);
        node = tickerNode.getNextElement("Font");
        if (node != null) {
            font = this.readFont(node);
        }
        int angle = chart.getTickerAngle(i);
        node = tickerNode.getNextElement("Angle");
        if (node != null) {
            angle = this.readInt(node);
        }
        chart.setTickerFont(i, font, angle);
        node = tickerNode.getNextElement("Visible");
        if (node != null) {
            chart.axis[i].ticker.showline = this.readBoolean(node);
        }
        if ((node = tickerNode.getNextElement("Inward")) != null) {
            chart.axis[i].ticker.tickerInward = this.readBoolean(node);
        }
        if ((node = tickerNode.getNextElement("RadarXOffset")) != null) {
            chart.axis[i].ticker.radarXOffset = this.readInt(node);
        }
        if ((node = tickerNode.getNextElement("RadarYOffset")) != null) {
            chart.axis[i].ticker.radarYOffset = this.readInt(node);
        }
        if ((node = tickerNode.getNextElement("LabelSubstitutionList")) != null) {
            this.getLabelSubstitutionList(node, chart.axis[i].ticker);
        }
    }

    private void getCString(Node domNode, CString str) throws Exception {
        XMLNode strNode = new XMLNode(domNode);
        Node node = strNode.getNextElement("Text");
        if (node != null) {
            str.setText(this.getData(node));
        }
        if ((node = strNode.getNextElement("Font")) != null) {
            str.setFont(this.readFont(node));
        }
        Point3D pt = str.pos;
        int direction = str.direction;
        boolean setNewPosition = false;
        node = strNode.getNextElement("Point3D");
        if (node != null) {
            pt = this.getPoint3D(node);
            setNewPosition = true;
        }
        if ((node = strNode.getNextElement("Color")) != null) {
            str.setColor(this.readColor(node));
        }
        if ((node = strNode.getNextElement("Direction")) != null) {
            direction = this.getIndex(node, SaveChartToXML.DIRECTION);
            setNewPosition = true;
        }
        if (setNewPosition) {
            str.setpos(pt, direction);
        }
        if ((node = strNode.getNextElement("Angle")) != null) {
            str.setAngle(this.readDouble(node));
        }
        if ((node = strNode.getNextElement("Visible")) != null) {
            str.bshow = this.readBoolean(node);
        }
        if ((node = strNode.getNextElement("Placement")) != null) {
            str.placement = this.getIndex(node, SaveChartToXML.PLACEMENT);
        }
        if ((node = strNode.getNextElement("Automatic")) != null) {
            str.automatic = this.readBoolean(node);
        }
    }

    private boolean[] getTransposeColumn(String s) {
        try {
            int ttype;
            if (s == null || s.equals("")) {
                return null;
            }
            Vector<Integer> vec = new Vector<Integer>();
            int max = -1;
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            while ((ttype = st.nextToken()) != 10 && ttype != -1) {
                if (ttype == -2) {
                    if (st.nval > (double)max) {
                        max = (int)st.nval;
                    }
                    vec.addElement((int)st.nval);
                    continue;
                }
                throw new IllegalArgumentException("Format shall be \"n1 n2 n3 n4 ...\" where n1, n2..  . are integers");
            }
            if (max < 0) {
                return null;
            }
            boolean[] tmp = new boolean[max + 1];
            for (int j = 0; j < vec.size(); ++j) {
                tmp[((Integer)vec.elementAt((int)j)).intValue()] = true;
            }
            return tmp;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot get transpose column", ex);
            return null;
        }
    }

    private Chart loadChartFromFile(String urlname) throws IOException {
        return this.loadChartFromFile(urlname, null, null, null, null, null);
    }

    private Chart loadChartFromFile(String urlname, Boolean transpose, boolean[] transposeCol, boolean[] doTranspose, Object[] transposeColList, String[] dataSource) throws IOException {
        try {
            ReadDataFile readFile = new ReadDataFile();
            DataInputStream din = readFile.getInputStream(urlname);
            LoadChart loadChart = new LoadChart();
            loadChart.setParameterField(this.preSetParams);
            loadChart.modifyDataSource(transpose, transposeCol, doTranspose, transposeColList, dataSource);
            Chart newchart = loadChart.load(this.component, din, urlname.endsWith(".tpl"), null, this.isEntServer);
            try {
                din.close();
                readFile.close();
            }
            catch (IOException io) {
                LOGGER.log(Level.FINEST, "Can't close file", io);
            }
            return newchart;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot load chart from file", ex);
            throw new IOException(ex.toString());
        }
    }

    private Chart changeChartType(Chart chart, int chartType, boolean is2DimChart) throws Exception {
        Chart newChart = chart;
        ValueTable valueTable = chart.valueTable;
        GraphicsTable.recoverTableSize(chart);
        newChart.gt.tableWidth = chart.gt.tableWidth;
        newChart.gt.tableHeight = chart.gt.tableHeight;
        newChart = Chart.createChart(this.component, chartType, is2DimChart, chart, null, chart.usedColumns);
        if (valueTable != null) {
            newChart.valueTable = new ValueTable(newChart, valueTable);
        }
        if (!newChart.is2DimChart()) {
            newChart.validatePosition();
        }
        return newChart;
    }

    private String getAttribute(Node domNode, String attr) {
        NamedNodeMap nodeMap = domNode.getAttributes();
        Node node = nodeMap.getNamedItem(attr);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private Dimension getDimension(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        return new Dimension(this.readInt(xmlNode.getNextElement("Width")), this.readInt(xmlNode.getNextElement("Height")));
    }

    private int getIndex(Node node, String[] itemList) {
        return this.getIndex(node, itemList, 0);
    }

    private int getIndex(Node node, String[] itemList, int defaultValue) {
        String type = this.getAttribute(node, "state");
        for (int i = 0; i < itemList.length; ++i) {
            if (!itemList[i].equalsIgnoreCase(type)) continue;
            return i;
        }
        return defaultValue;
    }

    private int readInt(Node domNode) throws Exception {
        return Integer.parseInt(this.getData(domNode));
    }

    private double readDouble(Node domNode) throws Exception {
        return Double.valueOf(this.getData(domNode));
    }

    private float readFloat(Node domNode) throws Exception {
        return Float.valueOf(this.getData(domNode)).floatValue();
    }

    private long readLong(Node domNode) throws Exception {
        return Long.parseLong(this.getData(domNode));
    }

    private boolean readBoolean(Node domNode) {
        return Boolean.valueOf(this.getAttribute(domNode, "state"));
    }

    private Color readColor(Node domNode) throws Exception {
        XMLNode colorNode = new XMLNode(domNode);
        return new Color(this.readInt(colorNode.getNextElement("R")), this.readInt(colorNode.getNextElement("G")), this.readInt(colorNode.getNextElement("B")));
    }

    private CAnnotation readCAnnotation(Node domNode, Chart chart) throws Exception {
        XMLNode annoNode = new XMLNode(domNode);
        CAnnotation anno = new CAnnotation(chart, (IReferenceObj)(this.readBoolean(annoNode.getNextElement("ReferenceToChart")) ? chart : null), this.getData(annoNode.getNextElement("Text")));
        anno.setVisible(this.readBoolean(annoNode.getNextElement("Visible")));
        anno.setRelativePosition(new Point_2D(this.readFloat(annoNode.getNextElement("X_Pos")), this.readFloat(annoNode.getNextElement("Y_Pos"))));
        anno.setFont(this.readFont(annoNode.getNextElement("Font")));
        anno.setAngle(this.readInt(annoNode.getNextElement("Angle")));
        anno.setColor(this.readColor(annoNode.getNextElement("Color")));
        this.getArea(annoNode.getNextElement("Background"), anno.getBackground());
        this.getArea(annoNode.getNextElement("Border"), anno.getBorder());
        anno.area.appearance = this.readInt(annoNode.getNextElement("Appearance"));
        anno.area.depth = this.readInt(annoNode.getNextElement("Depth"));
        return anno;
    }

    private PolyLine readPolyLine(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        Vector points = new Vector();
        Node node = xmlNode.getNextElement("Point_2DList");
        if (node != null) {
            points = this.getPoint_2DList(node);
        } else {
            node = xmlNode.getNextElement("Point_3DList");
            if (node != null) {
                points = this.getPoint_3DList(node);
            }
        }
        PolyLine line = new PolyLine();
        line.set(points.elements(), this.readColor(xmlNode.getNextElement("Color")), this.readInt(xmlNode.getNextElement("Thickness")), this.readInt(xmlNode.getNextElement("LineStyle")), this.readBoolean(xmlNode.getNextElement("FillArea")), this.readBoolean(xmlNode.getNextElement("DrawStartArrow")), this.readBoolean(xmlNode.getNextElement("DrawEndArrow")));
        return line;
    }

    private HyperLink readHyperLink(Node domNode) throws Exception {
        XMLNode strNode = new XMLNode(domNode);
        HyperLink link = new HyperLink(this.getData(strNode.getNextElement("Series")), this.getData(strNode.getNextElement("Category")), this.getData(strNode.getNextElement("Sumby")), this.getData(strNode.getNextElement("Link")), this.getData(strNode.getNextElement("Target")));
        link.setHintValue(this.getData(strNode.getNextElement("Hint")));
        return link;
    }

    private ControlRange readControlRange(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        ControlRange range = new ControlRange(this.readDouble(xmlNode.getNextElement("StartScale")), this.readDouble(xmlNode.getNextElement("EndScale")), this.readColor(xmlNode.getNextElement("Color")), this.getData(xmlNode.getNextElement("TitleInLegend")), this.readBoolean(xmlNode.getNextElement("ShowTitleInLegend")));
        Node node = xmlNode.getNextElement("StartScale2");
        if (node != null) {
            range.setStartScale2(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("EndScale2")) != null) {
            range.setEndScale2(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("IsScale1Enabled")) != null) {
            range.setScale1Enabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("IsScale2Enabled")) != null) {
            range.setScale2Enabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Thickness")) != null) {
            range.setThickness(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("Offset")) != null) {
            range.setOffset(this.readInt(node));
        }
        node = xmlNode.getNextElement("CenterX");
        Node node2 = xmlNode.getNextElement("CenterY");
        if (node != null && node2 != null) {
            range.setCenter(new Point(this.readInt(node), this.readInt(node2)));
        }
        if ((node = xmlNode.getNextElement("DrawBorder")) != null) {
            range.setDrawBorder(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Appearance")) != null) {
            range.setAppearance(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("Depth")) != null) {
            range.setDepth(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("Vertical")) != null) {
            range.setDirection(this.readBoolean(node) ? 1 : 0);
        }
        if ((node = xmlNode.getNextElement("IsOverlapAreaHighlighted")) != null) {
            range.setOverlapAreaHighlighted(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("IsGradientEnabled")) != null) {
            range.setGradientEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("Is3DShadingEnabled")) != null) {
            range.set3DShadingEnabled(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("GradientStartX")) != null) {
            range.setGradientStartX(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientStartY")) != null) {
            range.setGradientStartY(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientEndX")) != null) {
            range.setGradientEndX(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientEndY")) != null) {
            range.setGradientEndY(this.readDouble(node));
        }
        if ((node = xmlNode.getNextElement("GradientDesColor")) != null) {
            range.setGradientDesColor(this.readColor(node));
        }
        if ((node = xmlNode.getNextElement("GradientShade")) != null) {
            range.setGradientShade(this.readInt(node));
        }
        if ((node = xmlNode.getNextElement("GradientCyclic")) != null) {
            range.setGradientCyclic(this.readBoolean(node));
        }
        if ((node = xmlNode.getNextElement("PERCENTAGE")) != null) {
            range.setGradientCyclic(this.readBoolean(node));
        }
        return range;
    }

    private Font readFont(Node domNode) throws Exception {
        XMLNode fontNode = new XMLNode(domNode);
        return new Font(this.getData(fontNode.getNextElement("Name")), this.readInt(fontNode.getNextElement("Style")), this.readInt(fontNode.getNextElement("Size")));
    }

    private Point_3D getPoint_3D(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        return new Point_3D(this.readFloat(xmlNode.getNextElement("X_Coord")), this.readFloat(xmlNode.getNextElement("Y_Coord")), this.readFloat(xmlNode.getNextElement("Z_Coord")));
    }

    private Point_2D getPoint_2D(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        return new Point_2D(this.readFloat(xmlNode.getNextElement("X_Coord")), this.readFloat(xmlNode.getNextElement("Y_Coord")));
    }

    private Point3D getPoint3D(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        Point3D pt = new Point3D(this.readInt(xmlNode.getNextElement("X_Coord")), this.readInt(xmlNode.getNextElement("Y_Coord")), this.readInt(xmlNode.getNextElement("Z_Coord")));
        pt.shape = this.getIndex(xmlNode.getNextElement("Shape"), SaveChartToXML.SHAPE);
        pt.color = this.readColor(xmlNode.getNextElement("Color"));
        pt.automatic = this.readBoolean(xmlNode.getNextElement("Automatic"));
        return pt;
    }

    private void getArea(Node domNode, Area area) throws Exception {
        XMLNode areaNode = new XMLNode(domNode);
        Node node = areaNode.getNextElement("Color");
        if (node != null) {
            area.areaColor = this.readColor(node);
        }
        if ((node = areaNode.getNextElement("DrawBorder")) != null) {
            area.drawBorder = this.readBoolean(node);
        }
        if ((node = areaNode.getNextElement("DrawArea")) != null) {
            area.drawArea = this.readBoolean(node);
        }
        if ((node = areaNode.getNextElement("Automatic")) != null) {
            area.automatic = this.readBoolean(node);
        }
        if ((node = areaNode.getNextElement("PointA")) != null) {
            area.p1 = this.getPoint3D(node);
        }
        if ((node = areaNode.getNextElement("PointB")) != null) {
            area.p2 = this.getPoint3D(node);
        }
        if ((node = areaNode.getNextElement("IsGradientEnabled")) != null) {
            area.setGradientEnabled(this.readBoolean(node));
        }
        if ((node = areaNode.getNextElement("Is3DShadingEnabled")) != null) {
            area.set3DShadingEnabled(this.readBoolean(node));
        }
        if ((node = areaNode.getNextElement("GradientStartX")) != null) {
            area.setGradientStartX(this.readDouble(node));
        }
        if ((node = areaNode.getNextElement("GradientStartY")) != null) {
            area.setGradientStartY(this.readDouble(node));
        }
        if ((node = areaNode.getNextElement("GradientEndX")) != null) {
            area.setGradientEndX(this.readDouble(node));
        }
        if ((node = areaNode.getNextElement("GradientEndY")) != null) {
            area.setGradientEndY(this.readDouble(node));
        }
        if ((node = areaNode.getNextElement("GradientDesColor")) != null) {
            area.setGradientDesColor(this.readColor(node));
        }
        if ((node = areaNode.getNextElement("GradientShade")) != null) {
            area.setGradientShade(this.readInt(node));
        }
        if ((node = areaNode.getNextElement("GradientCyclic")) != null) {
            area.setGradientCyclic(this.readBoolean(node));
        }
    }

    private String getData(Node domNode) {
        if (domNode == null) {
            return "";
        }
        NodeList nodeList = domNode.getChildNodes();
        String s = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                s = s + this.getData(node);
                continue;
            }
            if (type == 3) {
                s = s + node.getNodeValue();
                continue;
            }
            if (type == 5) {
                s = s + this.getData(node);
                continue;
            }
            if (type != 4) continue;
            s = s + node.getNodeValue();
        }
        return s;
    }

    private void loadDataHeader(Vector datasources) throws Exception {
        block85: {
            Node source;
            block92: {
                block91: {
                    block90: {
                        Node node;
                        int i;
                        block89: {
                            block88: {
                                NamedNodeMap map;
                                block86: {
                                    block87: {
                                        block84: {
                                            if (datasources.size() <= 1) break block84;
                                            this.sourceData = 3;
                                            this.sourceList = new Object[datasources.size()];
                                            this.sourceType = new int[datasources.size()];
                                            for (int k = 0; k < datasources.size(); ++k) {
                                                Node node2;
                                                int i2;
                                                Node node3;
                                                Node source2 = (Node)datasources.elementAt(k);
                                                NamedNodeMap map2 = source2.getAttributes();
                                                for (int i3 = 0; i3 <= map2.getLength(); ++i3) {
                                                    if (i3 == map2.getLength()) {
                                                        throw new Exception("Missing 'Type' attribute.");
                                                    }
                                                    Node node4 = map2.item(i3);
                                                    if (!node4.getNodeName().equalsIgnoreCase("Type")) continue;
                                                    if (node4.getNodeValue().equalsIgnoreCase("database")) {
                                                        this.sourceType[k] = 1;
                                                        break;
                                                    }
                                                    if (node4.getNodeValue().equalsIgnoreCase("file")) {
                                                        this.sourceType[k] = 2;
                                                        break;
                                                    }
                                                    if (node4.getNodeValue().equalsIgnoreCase("xml")) {
                                                        this.sourceType[k] = 4;
                                                        break;
                                                    }
                                                    if (node4.getNodeValue().equalsIgnoreCase("class")) {
                                                        this.sourceType[k] = 6;
                                                        break;
                                                    }
                                                    if (node4.getNodeValue().equalsIgnoreCase("xmlfilequery")) {
                                                        this.sourceType[k] = 7;
                                                        break;
                                                    }
                                                    if (node4.getNodeValue().equalsIgnoreCase("ejb")) {
                                                        this.sourceType[k] = 5;
                                                        break;
                                                    }
                                                    if (node4.getNodeValue().equalsIgnoreCase("olap")) {
                                                        this.sourceType[k] = 10;
                                                        break;
                                                    }
                                                    throw new Exception("Invalid datasource type: '" + node4.getNodeValue() + "'.");
                                                }
                                                if (this.sourceType[k] == 1) {
                                                    NodeList nodeList = source2.getChildNodes();
                                                    DBInfoBasic db = null;
                                                    for (int i4 = 0; i4 < nodeList.getLength(); ++i4) {
                                                        node3 = nodeList.item(i4);
                                                        if (this.dbInfo == null && node3.getNodeName().equalsIgnoreCase("DATABASE") && (db = DBInfoBasic.readXML(node3, this.version)) != null) break;
                                                    }
                                                    if (db == null) {
                                                        throw new Exception("Missing or invalid 'DATABASE' element.");
                                                    }
                                                    if (this.modDataSourceArr != null) {
                                                        db.setQuery(this.modDataSourceArr[k]);
                                                    }
                                                    this.sourceList[k] = db;
                                                    continue;
                                                }
                                                if (this.sourceType[k] == 2 || this.sourceType[k] == 4 || this.sourceType[k] == 6) {
                                                    String file = this.getData(source2);
                                                    if (this.modDataSourceArr != null) {
                                                        file = this.modDataSourceArr[k];
                                                    }
                                                    this.sourceList[k] = file;
                                                    continue;
                                                }
                                                if (this.sourceType[k] == 7) {
                                                    NodeList nodeList = source2.getChildNodes();
                                                    XMLFileQueryInfo xmlInfo = null;
                                                    for (int i5 = 0; i5 < nodeList.getLength(); ++i5) {
                                                        node3 = nodeList.item(i5);
                                                        if (xmlInfo != null || !node3.getNodeName().equalsIgnoreCase("XMLFILEQUERYINFO") || (xmlInfo = XMLFileQueryInfo.readXML(node3, this.version)) == null) continue;
                                                        return;
                                                    }
                                                    this.sourceList[k] = xmlInfo;
                                                    continue;
                                                }
                                                if (this.sourceType[k] == 10) {
                                                    NamedNodeMap attrMap = source2.getAttributes();
                                                    for (int i6 = 0; i6 < attrMap.getLength(); ++i6) {
                                                        Node node5 = attrMap.item(i6);
                                                        if (node5.getNodeName().equalsIgnoreCase("MondrianConnectionString")) {
                                                            this.mondrianConnectionString = node5.getNodeName();
                                                            continue;
                                                        }
                                                        if (node5.getNodeName().equalsIgnoreCase("MDXQuery")) {
                                                            this.MDXQuery = node5.getNodeValue();
                                                            continue;
                                                        }
                                                        if (node5.getNodeName().equalsIgnoreCase("XmlaURI")) {
                                                            this.xmlaURI = node5.getNodeValue();
                                                            continue;
                                                        }
                                                        if (node5.getNodeName().equalsIgnoreCase("XmlaDataSource")) {
                                                            this.xmlaDataSource = node5.getNodeValue();
                                                            continue;
                                                        }
                                                        if (node5.getNodeName().equalsIgnoreCase("XmlaCatalog")) {
                                                            this.xmlaCatalog = node5.getNodeValue();
                                                            continue;
                                                        }
                                                        if (!node5.getNodeName().equalsIgnoreCase("InputMethod")) continue;
                                                        this.inputMethod = Integer.parseInt(node5.getNodeValue());
                                                    }
                                                    continue;
                                                }
                                                if (this.sourceType[k] != 5) continue;
                                                NamedNodeMap attrMap = source2.getAttributes();
                                                Object[] vals = null;
                                                String[] paramTypes = null;
                                                int valSize = 0;
                                                int envsize = 0;
                                                String[] envKeys = null;
                                                String[] envValues = null;
                                                String thisJNDIName = null;
                                                String thisHomeName = null;
                                                String thisRemoteName = null;
                                                String thisSelectedMethodName = null;
                                                Object[] thisSelectedMethodParamVal = null;
                                                Hashtable<String, String> thisEnvironment = null;
                                                for (i2 = 0; i2 < attrMap.getLength(); ++i2) {
                                                    Node node6 = attrMap.item(i2);
                                                    if (node6.getNodeName().equalsIgnoreCase("Type")) {
                                                        if (node6.getNodeValue().equalsIgnoreCase("ejb")) continue;
                                                        LOGGER.warning("Wrong data source");
                                                        continue;
                                                    }
                                                    if (node6.getNodeName().equalsIgnoreCase("jndiName")) {
                                                        thisJNDIName = node6.getNodeValue();
                                                        continue;
                                                    }
                                                    if (node6.getNodeName().equalsIgnoreCase("homeName")) {
                                                        thisHomeName = node6.getNodeValue();
                                                        continue;
                                                    }
                                                    if (node6.getNodeName().equalsIgnoreCase("remoteName")) {
                                                        thisRemoteName = node6.getNodeValue();
                                                        continue;
                                                    }
                                                    if (node6.getNodeName().equalsIgnoreCase("selectedMethodName")) {
                                                        thisSelectedMethodName = node6.getNodeValue();
                                                        continue;
                                                    }
                                                    if (node6.getNodeName().equalsIgnoreCase("paramSize")) {
                                                        valSize = Integer.parseInt(node6.getNodeValue());
                                                        if (vals == null) {
                                                            vals = new Object[valSize];
                                                        }
                                                        if (paramTypes != null) continue;
                                                        paramTypes = new String[valSize];
                                                        continue;
                                                    }
                                                    if (!node6.getNodeName().equalsIgnoreCase("envsize")) continue;
                                                    envsize = Integer.parseInt(node6.getNodeValue());
                                                    if (envKeys == null) {
                                                        envKeys = new String[envsize];
                                                    }
                                                    if (envValues != null) continue;
                                                    envValues = new String[envsize];
                                                }
                                                for (i2 = 0; i2 < attrMap.getLength(); ++i2) {
                                                    for (int j = 1; j <= valSize; ++j) {
                                                        node2 = attrMap.item(i2);
                                                        if (node2.getNodeName().equalsIgnoreCase("paramValType_" + j)) {
                                                            paramTypes[j - 1] = node2.getNodeValue();
                                                            continue;
                                                        }
                                                        if (!node2.getNodeName().equalsIgnoreCase("paramValValue_" + j)) continue;
                                                        vals[j - 1] = EJBUtil.getRuntimeInputValue(paramTypes[j - 1], node2.getNodeValue());
                                                    }
                                                }
                                                thisSelectedMethodParamVal = vals;
                                                for (i2 = 0; i2 < attrMap.getLength(); ++i2) {
                                                    for (int j = 1; j <= envsize; ++j) {
                                                        node2 = attrMap.item(i2);
                                                        if (node2.getNodeName().equalsIgnoreCase("envKey_" + j)) {
                                                            envKeys[j - 1] = node2.getNodeValue();
                                                            continue;
                                                        }
                                                        if (!node2.getNodeName().equalsIgnoreCase("envValue_" + j)) continue;
                                                        envValues[j - 1] = node2.getNodeValue();
                                                    }
                                                }
                                                for (i2 = 0; i2 < envsize; ++i2) {
                                                    if (thisEnvironment == null) {
                                                        thisEnvironment = new Hashtable<String, String>();
                                                    }
                                                    thisEnvironment.put((String)envKeys[i2], (String)envValues[i2]);
                                                }
                                                EJBInfo ejbInfo = new EJBInfo(thisJNDIName, thisHomeName, thisRemoteName, thisSelectedMethodName, thisSelectedMethodParamVal, thisEnvironment);
                                                this.sourceList[k] = ejbInfo;
                                            }
                                            break block85;
                                        }
                                        if (datasources.size() != 1) break block85;
                                        source = (Node)datasources.elementAt(0);
                                        map = source.getAttributes();
                                        for (int i7 = 0; i7 <= map.getLength(); ++i7) {
                                            if (i7 == map.getLength()) {
                                                throw new Exception("Missing 'Type' attribute.");
                                            }
                                            Node node7 = map.item(i7);
                                            if (!node7.getNodeName().equalsIgnoreCase("Type")) continue;
                                            if (node7.getNodeValue().equalsIgnoreCase("database")) {
                                                this.sourceData = 1;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("file")) {
                                                this.sourceData = 2;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("xml")) {
                                                this.sourceData = 4;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("xmlfilequery")) {
                                                this.sourceData = 7;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("class")) {
                                                this.sourceData = 6;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("ejb")) {
                                                this.sourceData = 5;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("soap")) {
                                                this.sourceData = 12;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("salesforce")) {
                                                this.sourceData = 11;
                                                break;
                                            }
                                            if (node7.getNodeValue().equalsIgnoreCase("excel")) {
                                                this.sourceData = 13;
                                                break;
                                            }
                                            if (!node7.getNodeValue().equalsIgnoreCase("none")) continue;
                                            this.sourceData = 0;
                                            break;
                                        }
                                        if (this.sourceData != 1) break block86;
                                        NodeList nodeList = source.getChildNodes();
                                        this.dbInfo = null;
                                        for (int i8 = 0; i8 < nodeList.getLength(); ++i8) {
                                            Node node8 = nodeList.item(i8);
                                            if (this.dbInfo != null || !node8.getNodeName().equalsIgnoreCase("DATABASE")) continue;
                                            this.dbInfo = DBInfoBasic.readXML(node8, this.version);
                                            if (this.dbInfo != null) break;
                                        }
                                        if (this.dbInfo == null) {
                                            throw new Exception("Missing or invalid 'DATABASE' element.");
                                        }
                                        if (this.modDataSourceArr != null) {
                                            this.dbInfo.setQuery(this.modDataSourceArr[0]);
                                        }
                                        Vector<QueryInParam> params = new Vector<QueryInParam>();
                                        for (int i9 = 0; i9 < nodeList.getLength(); ++i9) {
                                            QueryInParam p;
                                            Node node9 = nodeList.item(i9);
                                            if (node9.getNodeName().equalsIgnoreCase("QUERYFILE")) {
                                                this.queryFilename = this.getData(node9);
                                                break;
                                            }
                                            if (!node9.getNodeName().equalsIgnoreCase("PARAMETER") || (p = QueryInParam.readXML(node9, 0)) == null) continue;
                                            params.addElement(p);
                                        }
                                        if (this.queryFilename != null || params.size() <= 0) break block87;
                                        this.queryFileInfo = null;
                                        QueryInParam[] pArray = new QueryInParam[params.size()];
                                        for (int i10 = 0; i10 < pArray.length; ++i10) {
                                            pArray[i10] = (QueryInParam)params.elementAt(i10);
                                        }
                                        this.dbInfo = new QueryFileInfo("", 0, this.dbInfo, new QueryInParamSet(pArray));
                                        break block85;
                                    }
                                    if (this.queryFilename == null || this.queryFilename.equals("")) break block85;
                                    this.queryFileInfo = QueryFileInfo.readFile(this.queryFilename);
                                    this.dbInfo = this.queryFileInfo;
                                    break block85;
                                }
                                if (this.sourceData != 2 && this.sourceData != 4 && this.sourceData != 6) break block88;
                                this.sourceFile = this.getData(source);
                                if (this.modDataSourceArr != null) {
                                    this.sourceFile = this.modDataSourceArr[0];
                                }
                                boolean isParameterized = false;
                                Node attr = map.getNamedItem("isParameterized");
                                if (attr != null) {
                                    isParameterized = Boolean.valueOf(attr.getNodeValue());
                                }
                                if (!isParameterized) break block85;
                                this.dbInfo = new QueryClassFileInfo(this.sourceFile);
                                break block85;
                            }
                            if (this.sourceData != 7) break block89;
                            NodeList nodeList = source.getChildNodes();
                            XMLFileQueryInfo xmlInfo = null;
                            for (int i11 = 0; i11 < nodeList.getLength(); ++i11) {
                                Node node10 = nodeList.item(i11);
                                if (xmlInfo == null && node10.getNodeName().equalsIgnoreCase("XMLFILEQUERYINFO")) {
                                    xmlInfo = XMLFileQueryInfo.readXML(node10, this.version);
                                }
                                if (!node10.getNodeName().equalsIgnoreCase("ISPARAMQUERY")) continue;
                                boolean isParamQuery = this.readBoolean(node10);
                                if (xmlInfo == null) continue;
                                if (!isParamQuery) break;
                                this.dbInfo = new QueryXMLFileInfo(xmlInfo);
                                break;
                            }
                            this.sourceFile = xmlInfo.getFileName();
                            this.xmlFileQueryInfo = xmlInfo;
                            break block85;
                        }
                        if (this.sourceData != 5) break block90;
                        NamedNodeMap attrMap = source.getAttributes();
                        Object[] vals = null;
                        String[] paramTypes = null;
                        int valSize = 0;
                        int envsize = 0;
                        String[] envKeys = null;
                        String[] envValues = null;
                        for (i = 0; i < attrMap.getLength(); ++i) {
                            Node node11 = attrMap.item(i);
                            if (node11.getNodeName().equalsIgnoreCase("Type")) {
                                if (node11.getNodeValue().equalsIgnoreCase("ejb")) continue;
                                LOGGER.warning("Wrong data source");
                                continue;
                            }
                            if (node11.getNodeName().equalsIgnoreCase("jndiName")) {
                                this.jndiName = node11.getNodeValue();
                                continue;
                            }
                            if (node11.getNodeName().equalsIgnoreCase("homeName")) {
                                this.homeName = node11.getNodeValue();
                                continue;
                            }
                            if (node11.getNodeName().equalsIgnoreCase("remoteName")) {
                                this.remoteName = node11.getNodeValue();
                                continue;
                            }
                            if (node11.getNodeName().equalsIgnoreCase("selectedMethodName")) {
                                this.selectedMethodName = node11.getNodeValue();
                                continue;
                            }
                            if (node11.getNodeName().equalsIgnoreCase("paramSize")) {
                                valSize = Integer.parseInt(node11.getNodeValue());
                                if (vals == null) {
                                    vals = new Object[valSize];
                                }
                                if (paramTypes != null) continue;
                                paramTypes = new String[valSize];
                                continue;
                            }
                            if (!node11.getNodeName().equalsIgnoreCase("envsize")) continue;
                            envsize = Integer.parseInt(node11.getNodeValue());
                            if (envKeys == null) {
                                envKeys = new String[envsize];
                            }
                            if (envValues != null) continue;
                            envValues = new String[envsize];
                        }
                        for (i = 0; i < attrMap.getLength(); ++i) {
                            for (int j = 1; j <= valSize; ++j) {
                                node = attrMap.item(i);
                                if (node.getNodeName().equalsIgnoreCase("paramValType_" + j)) {
                                    paramTypes[j - 1] = node.getNodeValue();
                                    continue;
                                }
                                if (!node.getNodeName().equalsIgnoreCase("paramValValue_" + j)) continue;
                                vals[j - 1] = EJBUtil.getRuntimeInputValue(paramTypes[j - 1], node.getNodeValue());
                            }
                        }
                        this.selectedMethodParamVal = vals;
                        for (i = 0; i < attrMap.getLength(); ++i) {
                            for (int j = 1; j <= envsize; ++j) {
                                node = attrMap.item(i);
                                if (node.getNodeName().equalsIgnoreCase("envKey_" + j)) {
                                    envKeys[j - 1] = node.getNodeValue();
                                    continue;
                                }
                                if (!node.getNodeName().equalsIgnoreCase("envValue_" + j)) continue;
                                envValues[j - 1] = node.getNodeValue();
                            }
                        }
                        for (i = 0; i < envsize; ++i) {
                            if (this.environment == null) {
                                this.environment = new Hashtable();
                            }
                            this.environment.put(envKeys[i], envValues[i]);
                        }
                        break block85;
                    }
                    if (this.sourceData != 12) break block91;
                    this.soapInfo = SOAPQueryFileInfo.readSOAPQueryFileInfoXML(source);
                    if (!this.soapInfo.isParameterized()) break block85;
                    this.dbInfo = this.soapInfo;
                    break block85;
                }
                if (this.sourceData != 11) break block92;
                this.sfQueryInfo = SalesForceQueryFileInfo.readSalesForceQueryInfoXML(source);
                if (!this.sfQueryInfo.isParameterized()) break block85;
                this.dbInfo = this.sfQueryInfo;
                break block85;
            }
            if (this.sourceData == 13) {
                this.excelInfo = ExcelFileInfo.readXML(source);
            } else if (this.sourceData == 0) {
                NodeList nodeList = source.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!node.getNodeName().equalsIgnoreCase("COLDATALIST")) continue;
                    this.originalColDataFromMemSource = this.getColDataList(node, null);
                }
            }
        }
    }

    private void loadTree(Node node) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase("DRILLDOWNTREE")) {
            return;
        }
        this.drillDownNode = this.loadTreeNode(XMLChart.getFirstElement(node), true);
    }

    private DrillDownNode loadTreeNode(Node node, boolean loadChildren) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase("DRILLDOWNNODE")) {
            return null;
        }
        String nodename = null;
        String filename = null;
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            if (map.item(i).getNodeName().equalsIgnoreCase("Name")) {
                nodename = map.item(i).getNodeValue();
                continue;
            }
            if (!map.item(i).getNodeName().equalsIgnoreCase("Filename")) continue;
            filename = map.item(i).getNodeValue();
        }
        if (nodename == null || filename == null) {
            throw new Exception("Invalid 'DRILLDOWNNODE' element. Missing 'Name' or 'Filename' attributes.");
        }
        DrillDownNode drilldownnode = new DrillDownNode(nodename);
        drilldownnode.setFileName(filename);
        Vector<Integer> mappingvector = new Vector<Integer>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("MAPPING")) {
                mappingvector.addElement(Integer.valueOf(this.getData(nodeList.item(i))));
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("DRILLDOWNNODE") || !loadChildren) continue;
            drilldownnode.add(this.loadTreeNode(nodeList.item(i), true));
        }
        int[] mapping = new int[mappingvector.size()];
        for (int i = 0; i < mappingvector.size(); ++i) {
            mapping[i] = (Integer)mappingvector.elementAt(i);
        }
        drilldownnode.setColumnMapping(mapping);
        return drilldownnode;
    }

    private static Node getFirstElement(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return nodeList.item(i);
        }
        return null;
    }

    private void readDrillDownNodes(Node node) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase("CHILD_DRILLDOWNNODES")) {
            return;
        }
        this.childDrillDownNodes = new Vector();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("DRILLDOWNNODE")) continue;
            this.childDrillDownNodes.addElement(this.loadTreeNode(nodeList.item(i), false));
        }
    }

    private class XMLNode {
        Node domNode;
        int idx = 0;

        XMLNode(Node domNode) {
            this.domNode = domNode;
        }

        Node getNextElement(String element) throws Exception {
            if (this.domNode == null) {
                return null;
            }
            NodeList nodeList = this.domNode.getChildNodes();
            for (int j = 0; j < 2; ++j) {
                while (this.idx < nodeList.getLength()) {
                    Node node = nodeList.item(this.idx);
                    short type = node.getNodeType();
                    if (type == 1 && node.getNodeName().equalsIgnoreCase(element)) {
                        ++this.idx;
                        return node;
                    }
                    ++this.idx;
                }
                this.idx = 0;
            }
            return null;
        }
    }
}

