/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import quadbase.awt.ArrowSlideBar;
import quadbase.awt.BorderPanel;
import quadbase.awt.ImageToggle;
import quadbase.awt.NavigatePanel;
import quadbase.awt.YASpeedMeter;
import quadbase.awt.ZoomMeter;
import quadbase.chart.Chart;
import quadbase.chart.chart3d.lib3d.HiddenSurface;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chartviewer.ViewPanel;
import quadbase.chartviewer.Viewer3DPanel;
import quadbase.common.client.ServerMessage;

public class ControlPanel
extends BorderPanel
implements ActionListener {
    static final int INIT_ZOOM = 20;
    double increment = 0.10471975511965977;
    int movement = 33;
    boolean rotateMode = true;
    Panel buttonPanel;
    Panel navzoomPanel;
    ImageToggle animateButton;
    ImageToggle frameButton;
    ImageToggle flatframeButton;
    ImageToggle gouraudButton;
    ImageToggle inLineSeriesButton;
    ArrowSlideBar xscale_bar;
    ArrowSlideBar yscale_bar;
    ArrowSlideBar zscale_bar;
    ArrowSlideBar xlight_bar;
    ArrowSlideBar ylight_bar;
    ArrowSlideBar zlight_bar;
    ArrowSlideBar thickness_bar;
    NavigatePanel navigatePanel;
    ZoomMeter zoomMeter;
    YASpeedMeter speedMeter;
    ArrowSlideBar slideBar;
    private boolean showToolTip = true;
    ViewPanel viewPanel;
    Viewer3DPanel v3DPanel;

    public ControlPanel(Viewer3DPanel vp3d, ViewPanel vp) {
        this.viewPanel = vp;
        this.v3DPanel = vp3d;
        this.setBackground(Color.lightGray);
        this.setGap(0);
        this.navzoomPanel = new Panel();
        this.navzoomPanel.setLayout(new FlowLayout());
        Chart chart = this.v3DPanel.getChart();
        Panel scalePanel = new Panel();
        scalePanel.setLayout(new GridLayout(4, 1));
        this.xscale_bar = new ArrowSlideBar(0.01, 5.0, 0.5, true);
        scalePanel.add(this.xscale_bar);
        this.yscale_bar = new ArrowSlideBar(0.01, 5.0, 0.5, true);
        scalePanel.add(this.yscale_bar);
        this.zscale_bar = new ArrowSlideBar(0.01, 5.0, 0.5, true);
        scalePanel.add(this.zscale_bar);
        this.thickness_bar = new ArrowSlideBar(0.333, 3.0, 0.1, true);
        scalePanel.add(this.thickness_bar);
        this.xscale_bar.addActionListener(this);
        this.yscale_bar.addActionListener(this);
        this.zscale_bar.addActionListener(this);
        this.thickness_bar.addActionListener(this);
        this.setXScale();
        this.setZScale();
        this.setYScale();
        this.setThickScale();
        this.slideBar = new ArrowSlideBar(0.0, 1000.0, 50.0, false);
        this.navzoomPanel.add(this.slideBar);
        this.xlight_bar = new ArrowSlideBar(-1000.0, 1000.0, 50.0, false);
        this.navzoomPanel.add(this.xlight_bar);
        this.ylight_bar = new ArrowSlideBar(-1000.0, 1000.0, 50.0, false);
        this.navzoomPanel.add(this.ylight_bar);
        this.zlight_bar = new ArrowSlideBar(-1000.0, 1000.0, 50.0, false);
        this.navzoomPanel.add(this.zlight_bar);
        this.slideBar.addActionListener(this);
        this.xlight_bar.addActionListener(this);
        this.ylight_bar.addActionListener(this);
        this.zlight_bar.addActionListener(this);
        this.xlight_bar.setValue(chart.getlightpos_x());
        this.ylight_bar.setValue(chart.getlightpos_y());
        this.zlight_bar.setValue(chart.getlightpos_z());
        this.navigatePanel = new NavigatePanel(50, 50);
        this.navzoomPanel.add(this.navigatePanel);
        this.navigatePanel.addActionListener(this);
        this.zoomMeter = new ZoomMeter(80, 40, 0.0, 100.0, 20);
        this.navzoomPanel.add(this.zoomMeter);
        this.zoomMeter.addActionListener(this);
        this.navzoomPanel.add(scalePanel);
        this.speedMeter = new YASpeedMeter(0.0017453292519943296, 0.3141592653589793);
        this.navzoomPanel.add(this.speedMeter);
        this.speedMeter.addActionListener(this);
        this.slideBar.setValue(1000.0 * (this.increment - 0.002) / 0.3121592653589793);
        this.setZoomMeter();
        this.setSpeedMeter();
        this.setLayout(new BorderLayout());
        this.add("West", this.navzoomPanel);
        this.frameButton = new ImageToggle(this.getImage("nav_frame"));
        this.frameButton.addActionListener(this);
        this.animateButton = new ImageToggle(this.getImage("nav_animate"));
        this.animateButton.addActionListener(this);
        this.flatframeButton = new ImageToggle(this.getImage("nav_flatFrame"));
        this.flatframeButton.addActionListener(this);
        this.gouraudButton = new ImageToggle(this.getImage("nav_gouraud"));
        this.gouraudButton.addActionListener(this);
        this.inLineSeriesButton = new ImageToggle(this.getImage("nav_inLineSeries"));
        this.inLineSeriesButton.addActionListener(this);
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new GridLayout(1, 5));
        this.buttonPanel.add(this.frameButton);
        this.buttonPanel.add(this.flatframeButton);
        if (this.isInLineSeriesEnabled(chart)) {
            this.buttonPanel.add(this.inLineSeriesButton);
            this.inLineSeriesButton.setState(chart.isDrawSeriesOnCategoryAxis());
        }
        this.buttonPanel.add(this.animateButton);
        this.add("East", this.buttonPanel);
        Applet applet = ServerMessage.getApplet();
        if (applet != null && this.isToolTipEnabled()) {
            AppletContext context = applet.getAppletContext();
            this.xscale_bar.setHint(context, "Scaling in X dimension");
            this.yscale_bar.setHint(context, "Scaling in Y dimension");
            this.zscale_bar.setHint(context, "Scaling in Z dimension");
            this.xlight_bar.setHint(context, "Light X position");
            this.ylight_bar.setHint(context, "Light Y position");
            this.zlight_bar.setHint(context, "Light Z position");
            this.thickness_bar.setHint(context, "Thickness of shape");
            this.slideBar.setHint(context, "Adjust step size of navigation");
            this.navigatePanel.setHint(context, "Navigation - Press the center button to toggle between rotation and translation");
            this.zoomMeter.setHint(context, "Zoom in / Zoom out");
            this.speedMeter.setHint(context, "Speed of Animation");
            this.frameButton.setHint(context, "Toggle between wireframe and solid mode");
            this.flatframeButton.setHint(context, "Toggle on/off border drawing");
            this.inLineSeriesButton.setHint(context, "Toggle on/off draw series in-line");
            this.gouraudButton.setHint(context, "Toggle on/off Gouraud Shading");
            this.animateButton.setHint(context, "Toggle on/off animation");
        }
        this.setDrawMode();
    }

    private Image getImage(String imageName) {
        InputStream is = this.getClass().getResourceAsStream("/" + ServerMessage.imagesPath + imageName + ".gif");
        try {
            return ImageIO.read(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setToolTipEnabled(boolean show) {
        this.showToolTip = show;
    }

    public boolean isToolTipEnabled() {
        return this.showToolTip;
    }

    private boolean isInLineSeriesEnabled(Chart chart) {
        int i = chart.getChartType();
        int dataDim = chart.getDataDimension();
        return (i == 0 || i == 1) && dataDim > 1 || (i == 4 || i == 5 || i == 11) && dataDim > 2;
    }

    void updatePanel() {
        boolean isButtonExisted = ControlPanel.findComponent(this.buttonPanel, this.inLineSeriesButton);
        if (this.isInLineSeriesEnabled(this.v3DPanel.getChart())) {
            if (!isButtonExisted) {
                boolean bG;
                boolean bA = this.getAnimateButton();
                if (bA) {
                    this.buttonPanel.remove(this.animateButton);
                }
                if (bG = this.getGouraudButton()) {
                    this.buttonPanel.remove(this.gouraudButton);
                }
                this.buttonPanel.add(this.inLineSeriesButton);
                if (bG) {
                    this.buttonPanel.add(this.gouraudButton);
                }
                if (bA) {
                    this.buttonPanel.add(this.animateButton);
                }
            }
            this.inLineSeriesButton.setState(this.v3DPanel.getChart().isDrawSeriesOnCategoryAxis());
        } else if (isButtonExisted) {
            this.buttonPanel.remove(this.inLineSeriesButton);
        } else {
            return;
        }
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    public void setAnimateButton(boolean show) {
        if (show != this.getAnimateButton()) {
            if (show) {
                this.buttonPanel.add(this.animateButton);
            } else {
                this.buttonPanel.remove(this.animateButton);
            }
            this.buttonPanel.validate();
            this.buttonPanel.repaint();
        }
    }

    public boolean getAnimateButton() {
        return ControlPanel.findComponent(this.buttonPanel, this.animateButton);
    }

    public void setSpeedControl(boolean show) {
        if (show != this.getSpeedControl()) {
            if (show) {
                this.navzoomPanel.add(this.speedMeter);
            } else {
                this.navzoomPanel.remove(this.speedMeter);
            }
            this.navzoomPanel.validate();
            this.navzoomPanel.repaint();
        }
    }

    public boolean getSpeedControl() {
        return ControlPanel.findComponent(this.navzoomPanel, this.speedMeter);
    }

    public void setGouraudButton(boolean show) {
        if (show) {
            boolean b = this.getAnimateButton();
            if (b) {
                this.buttonPanel.remove(this.animateButton);
            }
            this.buttonPanel.add(this.gouraudButton);
            if (b) {
                this.buttonPanel.add(this.animateButton);
            }
        } else {
            this.buttonPanel.remove(this.gouraudButton);
        }
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    static boolean findComponent(Panel container, Component comp) {
        Component[] comps;
        for (Component comp2 : comps = container.getComponents()) {
            if (comp2 != comp) continue;
            return true;
        }
        return false;
    }

    public boolean getGouraudButton() {
        return ControlPanel.findComponent(this.buttonPanel, this.gouraudButton);
    }

    public void setDrawMode() {
        int tp = this.v3DPanel.getChart().get3DDrawType();
        this.frameButton.setState(tp == 0);
        this.flatframeButton.setState(tp == 4 || tp == 2);
        this.gouraudButton.setState(tp == 3 || tp == 4);
    }

    public void setZoomMeter() {
        this.zoomMeter.setValue(20.0);
    }

    public void setSpeedMeter() {
        this.speedMeter.setValue(this.v3DPanel.getChart().getAnimateSpeed());
    }

    public void setXScale() {
        this.xscale_bar.setValue(this.v3DPanel.getChart().getX_scale());
    }

    public void setYScale() {
        this.yscale_bar.setValue(this.v3DPanel.getChart().getY_scale());
    }

    public void setZScale() {
        this.zscale_bar.setValue(this.v3DPanel.getChart().getZ_scale());
    }

    public void setThickScale() {
        this.thickness_bar.setValue(this.v3DPanel.getChart().thickRatio);
    }

    public void setEnableNavControl(boolean state) {
        this.navigatePanel.setEnabled(state);
        this.zoomMeter.setEnabled(state);
        this.xscale_bar.setEnabled(state);
        this.yscale_bar.setEnabled(state);
        this.zscale_bar.setEnabled(state);
        this.xlight_bar.setEnabled(state);
        this.ylight_bar.setEnabled(state);
        this.zlight_bar.setEnabled(state);
        this.thickness_bar.setEnabled(state);
        this.frameButton.setEnabled(state);
        this.flatframeButton.setEnabled(state);
        this.inLineSeriesButton.setEnabled(state);
        this.gouraudButton.setEnabled(state);
        this.setZoomMeter();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Chart chart = this.v3DPanel.getChart();
        Object target = e.getSource();
        if (target == this.slideBar) {
            if (this.rotateMode) {
                this.increment = 0.002 + this.slideBar.getValue() * 0.3121592653589793 / 1000.0;
            } else {
                this.movement = (int)(5.0 + this.slideBar.getValue() * 995.0 / 1000.0);
            }
        } else if (target == this.thickness_bar) {
            this.viewPanel.redoOffScreenImage();
            if (e.getID() == 0) {
                if (chart.isCircularChart() && !chart.is2DimChart()) {
                    chart.thickRatio = 1.0;
                    float zScale = (float)(this.thickness_bar.getValue() / 3.0 * 5.0);
                    chart.scaleSpace((float)this.xscale_bar.getValue(), (float)this.yscale_bar.getValue(), zScale);
                } else {
                    chart.thickRatio = this.thickness_bar.getValue();
                }
                ((HiddenSurface)chart.gethiddenSurface()).reset();
                this.viewPanel.repaint();
            }
        } else if (target == this.xlight_bar || target == this.ylight_bar || target == this.zlight_bar) {
            float[] f = new float[]{(float)this.xlight_bar.getValue(), (float)this.ylight_bar.getValue(), (float)this.zlight_bar.getValue()};
            chart.setLightPos(f);
            this.viewPanel.repaint();
        } else if (target == this.xscale_bar || target == this.yscale_bar || target == this.zscale_bar) {
            chart.scaleSpace((float)this.xscale_bar.getValue(), (float)this.yscale_bar.getValue(), (float)this.zscale_bar.getValue());
            this.viewPanel.redoOffScreenImage();
            if (e.getID() == 0) {
                ((HiddenSurface)chart.gethiddenSurface()).reset();
                this.viewPanel.repaint();
            } else {
                this.viewPanel.repaint();
            }
        } else if (target == this.gouraudButton) {
            if (!this.gouraudButton.getState()) {
                if (this.flatframeButton.getState()) {
                    chart.set3DDrawType(4);
                } else {
                    chart.set3DDrawType(3);
                }
            } else if (this.flatframeButton.getState()) {
                chart.set3DDrawType(2);
            } else {
                chart.set3DDrawType(1);
            }
            this.setDrawMode();
            this.viewPanel.repaint();
        } else if (target == this.flatframeButton) {
            if (this.flatframeButton.getState()) {
                if (this.gouraudButton.getState()) {
                    chart.set3DDrawType(3);
                } else {
                    chart.set3DDrawType(1);
                }
            } else if (this.gouraudButton.getState()) {
                chart.set3DDrawType(4);
            } else {
                chart.set3DDrawType(2);
            }
            this.setDrawMode();
            this.viewPanel.repaint();
        } else if (target == this.frameButton) {
            if (!this.frameButton.getState()) {
                chart.set3DDrawType(0);
            } else if (this.flatframeButton.getState()) {
                if (this.gouraudButton.getState()) {
                    chart.set3DDrawType(4);
                } else {
                    chart.set3DDrawType(2);
                }
            } else if (this.gouraudButton.getState()) {
                chart.set3DDrawType(3);
            } else {
                chart.set3DDrawType(1);
            }
            this.setDrawMode();
            this.viewPanel.repaint();
        } else if (target == this.inLineSeriesButton) {
            boolean state = !this.inLineSeriesButton.getState();
            chart.setDrawSeriesOnCategoryAxis(state);
            this.inLineSeriesButton.setState(state);
            this.viewPanel.repaint();
        } else if (target == this.animateButton) {
            this.setAnimationButtonOn(!this.animateButton.getState());
        } else if (target == this.navigatePanel) {
            int argument = e.getID();
            if (argument == 0 || argument == 1 || argument == 2 || argument == 3) {
                this.navigate(argument);
            } else if (argument == 4) {
                this.rotateMode = false;
                this.slideBar.setValue(1000 * (this.movement - 5) / 995);
            } else if (argument == 9) {
                this.slideBar.setValue(1000.0 * (this.increment - 0.002) / 0.3121592653589793);
                this.rotateMode = true;
            }
        } else if (target == this.zoomMeter) {
            this.v3DPanel.zooming(this.zoomMeter.getValue());
        } else if (target == this.speedMeter) {
            chart.setAnimateSpeed(this.speedMeter.getValue());
        }
    }

    public void setAnimationButtonOn(boolean b) {
        if (b) {
            this.v3DPanel.hideText();
            this.animateButton.setState(true);
            this.viewPanel.animation = true;
            this.viewPanel.stop();
            this.viewPanel.start();
            this.setEnableNavControl(false);
        } else {
            this.animateButton.setState(false);
            this.v3DPanel.stopAnimation();
        }
    }

    public void navigate(int direction) {
        this.navigate(this.rotateMode, direction, this.increment, this.movement);
        this.viewPanel.repaint();
    }

    public void navigate(boolean rotateMode, int step, int direction) {
        double inc = 0.0;
        int mov = 0;
        if (rotateMode) {
            inc = 0.002 + (double)step * 0.3121592653589793 / 1000.0;
        } else {
            mov = 5 + step * 995 / 1000;
        }
        this.navigate(rotateMode, direction, inc, mov);
    }

    public void navigate(boolean rotateMode, int direction, double increment, int movement) {
        Chart chart = this.v3DPanel.getChart();
        Space space = (Space)chart.getSpace();
        float scale = space.spaceScale;
        double alpha = Math.atan2(-space.viewVec.k, -space.viewVec.i);
        double theta = Math.asin(-space.viewVec.j);
        switch (direction) {
            case 0: {
                if (rotateMode) {
                    if (!((theta -= increment) < -1.5707963267948966)) break;
                    theta = -1.5702963267948966;
                    break;
                }
                chart.translateSpace(0.0f, movement, 0.0f);
                break;
            }
            case 1: {
                if (rotateMode) {
                    if (!((theta += increment) > 1.5707963267948966)) break;
                    theta = 1.5702963267948966;
                    break;
                }
                chart.translateSpace(0.0f, -movement, 0.0f);
                break;
            }
            case 2: {
                if (rotateMode) {
                    alpha -= increment;
                    break;
                }
                chart.translateSpace(-movement, 0.0f, 0.0f);
                break;
            }
            case 3: {
                if (rotateMode) {
                    alpha += increment;
                    break;
                }
                chart.translateSpace(movement, 0.0f, 0.0f);
                break;
            }
        }
        double t = Math.cos(theta) * (double)scale;
        double t2 = Math.sin(theta) * (double)scale;
        chart.setlookfrom_x((float)(t * Math.cos(alpha) + (double)chart.getlookto_x()));
        chart.setlookfrom_y((float)(t2 + (double)chart.getlookto_y()));
        chart.setlookfrom_z((float)(t * Math.sin(alpha) + (double)chart.getlookto_z()));
        space.lookat(chart.getlookfrom_x(), chart.getlookfrom_y(), chart.getlookfrom_z(), chart.getlookto_x(), chart.getlookto_y(), chart.getlookto_z());
    }
}

