/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import quadbase.chartviewer.EnterInParamPanel;
import quadbase.chartviewer.OurDialog;
import quadbase.common.paramquery.IEnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;

public class EnterInParamDialog
extends OurDialog
implements ActionListener,
WindowListener,
IEnterInParamDialog {
    private transient ActionListener listener;
    EnterInParamPanel enterPanel;
    boolean showCancelButton;
    boolean isCancelled = false;

    public EnterInParamDialog(Object frame, QueryFileInfo fileInfo, boolean showCancelButton) {
        super(frame, "Enter Dialog", true);
        if (fileInfo.getInParam().length > 1) {
            this.setBorder("Please enter values");
        } else {
            this.setBorder("Please enter value");
        }
        this.showCancelButton = showCancelButton;
        this.addWindowListener(this);
        try {
            this.enterPanel = new EnterInParamPanel(fileInfo, true, showCancelButton);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enterPanel.addActionListener(this);
        this.add("Center", this.enterPanel);
        Dimension screensize = this.getToolkit().getScreenSize();
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.setVisible(false);
            this.dispose();
            this.fireEvent(this, 0, e.getActionCommand());
        } else if (e.getActionCommand().equals("Cancel")) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public QueryInParam[] getInParamValue() {
        return this.enterPanel.getInParamValue();
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    protected final void fireEvent(Component c, int id, String cmd) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(c, id, cmd));
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.isCancelled = true;
        if (this.showCancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
    }
}

