/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.chart.DrillDownNode;
import quadbase.chart.DrillHistory;
import quadbase.chart.FaceData;
import quadbase.chart.GraphicsTable;
import quadbase.chart.HintInterface;
import quadbase.chart.IOUtil2;
import quadbase.chart.Legend;
import quadbase.chart.LoadChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.PreprocInfo;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chart.Ticker;
import quadbase.chart.ValueTable;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chartviewer.CPopupMenu;
import quadbase.chartviewer.CScrollPane;
import quadbase.chartviewer.MouseThread;
import quadbase.chartviewer.OurMessageDialog;
import quadbase.chartviewer.PanelAction;
import quadbase.chartviewer.Viewer;
import quadbase.chartviewer.Viewer3DPanel;
import quadbase.chartviewer.ZoomFrame;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.HyperLink;
import quadbase.util.PickData;
import quadbase.util.internal.DateTime;
import quadbase.util.internal.IOUtil;

public class ViewPanel
extends PanelAction
implements Runnable,
HintInterface,
KeyListener {
    public Chart chart;
    public Image offScreenImage;
    public Image offScreenImage2;
    Graphics backbuffer;
    Graphics backbuffer2;
    public int prefWidth = 400;
    public int prefHeight = 300;
    public int width;
    public int height;
    public Chart firstChart;
    static final String NONAME = "EspressChartV1.3.abc.xyz.noname";
    boolean please_stop;
    boolean repaintflag = true;
    Thread animator = null;
    boolean animation = false;
    MouseThread mouseThread = null;
    boolean dragResizeInit = false;
    Object dragtarget = null;
    int lastx;
    int lasty;
    int dx;
    int dy;
    int firstX;
    int firstY;
    int previousX;
    int previousY;
    int lastX;
    int lastY;
    int drillX;
    int drillY;
    float old_XProp;
    float old_YProp;
    boolean isResizeOp;
    boolean isDragOp;
    boolean isResizeCanvasOp;
    boolean isNextDrillOp = false;
    boolean isNextFieldDrillOp = false;
    boolean isPrevDrillOp = false;
    boolean isPopupMenuOp = false;
    boolean isPopupTrigger = false;
    int axisDim;
    HyperLink selecthyperLink;
    Viewer3DPanel panel3d;
    public boolean btogglepanel = true;
    boolean dragChart = true;
    boolean resizeChart = true;
    boolean resizeCanvas = true;
    boolean goForwLink = true;
    boolean goBackLink = true;
    AppletContext appletcontext;
    Applet applet;
    public Object eventArg;
    public boolean showLink = true;
    public Color linkFontColor = Color.black;
    public Color linkBgColor = Color.yellow;
    public Color linkBorderColor = null;
    public Color dataFontColor = Color.black;
    public Color dataBgColor = Color.yellow;
    public Color dataBorderColor = null;
    public Font dataFont = CString.defaultFontForViewer;
    public Font linkFont = CString.defaultFontForViewer;
    public boolean printing = true;
    public boolean refreshData = true;
    boolean firstTime = true;
    public int mouseModifier;
    CScrollPane pane;
    int scrollBarOption = 0;
    Adjustable vAdjust;
    Adjustable hAdjust;
    boolean isZoomOp = false;
    PickData startZoom = null;
    PickData endZoom = null;
    boolean origChartProcessed = false;
    int hintX = 0;
    int hintY = 0;
    int linkX = 0;
    int linkY = 0;
    public boolean isDrillDownDefined = false;
    boolean handleZEvents = true;
    private int dragMask = 0;
    private int dragClickCount = 1;
    private int zoomMask = 2;
    private int zoomClickCount = 1;
    private int resizeMask = IOUtil.getRightMouseClickMask();
    private int resizeClickCount = 1;
    private int resizeCanvasMask = 12;
    private int resizeCanvasClickCount = 1;
    private int forwLinkMask = 0;
    private int forwLinkClickCount = 1;
    private int backLinkMask = IOUtil.getRightMouseClickMask();
    private int backLinkClickCount = 1;
    private int drillDownClickCount = 1;
    private int undoZoomMask = 6;
    private int undoZoomClickCount = 1;
    boolean dataPointSelected = false;
    float newChartWidth;
    float newChartHeight;
    CPopupMenu popupMenu;
    boolean changeTableSize = false;
    boolean changeTabSize = false;
    boolean changeTablePosition = false;
    int cell;
    int tabNum;
    private boolean showScrollPane = true;
    int oldZoom = 20;

    public ViewPanel(Viewer3DPanel viewer3DPanel, Chart chart) {
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.chart = chart;
        this.panel3d = viewer3DPanel;
        try {
            if (chart != null) {
                this.scrollBarOption = chart.getScrollBarOption();
            }
            if (this.scrollBarOption == 2) {
                this.showScrollPane = false;
            } else {
                this.pane = new CScrollPane(this, this.scrollBarOption);
                this.setPane(this.pane);
            }
            this.applet = ServerMessage.getApplet();
            if (this.applet != null) {
                this.appletcontext = this.applet.getAppletContext();
            }
            this.isDrillDownDefined = this.panel3d.parentChart.drillDownVector != null && this.panel3d.parentChart.drillDownVector.size() > 0;
            this.mouseThread = new MouseThread(this);
            this.addMouseMotionListener(this.mouseThread);
            this.mouseThread.setPriority(1);
            this.mouseThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disposeObject() {
        this.removeViewPanelListener();
        this.chart = null;
        this.firstChart = null;
        this.applet = null;
        this.appletcontext = null;
        this.pane = null;
        this.panel3d = null;
    }

    public void removeViewPanelListener() {
        if (this.mouseThread != null) {
            this.removeMouseMotionListener(this.mouseThread);
            this.mouseThread.pleaseStop();
            this.mouseThread = null;
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (!this.firstTime) {
            this.removeKeyListener(this);
        }
    }

    public void setPane(CScrollPane p) {
        this.pane = p;
        this.vAdjust = this.pane.getVAdjustable();
        this.hAdjust = this.pane.getHAdjustable();
        this.vAdjust.setUnitIncrement(5 * this.vAdjust.getUnitIncrement());
        this.hAdjust.setUnitIncrement(5 * this.hAdjust.getUnitIncrement());
        this.setSize(this.chart.getSize());
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.showScrollPane) {
            return super.getPreferredSize();
        }
        if (this.chart == null) {
            return new Dimension(this.prefWidth, this.prefHeight);
        }
        if (this.panel3d != null && this.panel3d.orgChartSize != null) {
            return new Dimension(Math.max(this.panel3d.orgChartSize.width, this.prefWidth), Math.max(this.panel3d.orgChartSize.height, this.prefHeight));
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.showScrollPane) {
            return super.getPreferredSize();
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int w, int h) {
        Dimension oldSize = this.chart.getSize();
        if (oldSize.width != w || oldSize.height != h) {
            this.chart.setSize(w, h);
        }
        if (!this.showScrollPane) {
            super.setSize(w, h);
            return;
        }
        if (this.panel3d != null && !this.panel3d.navexist) {
            Dimension size = this.panel3d.getSize();
            this.prefWidth = Math.max(size.width, w);
            this.prefHeight = Math.max(size.height, h);
        } else {
            this.prefWidth = w;
            this.prefHeight = h;
        }
        super.setSize(this.prefWidth, this.prefHeight);
    }

    public Component getChartComponent() {
        if (this.showScrollPane) {
            return this.pane;
        }
        return this;
    }

    @Override
    public void setPanelBorder(Object border) {
        super.setPanelBorder(border);
        if (this.pane != null) {
            this.pane.setPanelBorder(border);
        }
    }

    @Override
    public void setOpaque(boolean b) {
        super.setOpaque(b);
        if (this.pane != null) {
            this.pane.setOpaque(b);
        }
    }

    public void paint() {
        if (this.getGraphics() != null) {
            this.paint(this.getGraphics());
        }
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    public void repaint(Rectangle r) {
        super.repaint();
    }

    @Override
    public void update(Graphics g) {
        if (g == null || this.chart == null) {
            return;
        }
        int oldwidth = this.width;
        int oldheight = this.height;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        if (this.showScrollPane) {
            this.pane.doLayout();
            g = this.pane.getClippedGraphics(g);
        }
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        try {
            if (this.offScreenImage == null || oldwidth != this.width || oldheight != this.height || this.repaintflag) {
                this.flushImage();
                this.offScreenImage = this.createImage(this.width, this.height);
                this.backbuffer = this.offScreenImage.getGraphics();
            }
            this.repaintflag = false;
            this.chart.draw(this.backbuffer, this, this.width, this.height);
            g.drawImage(this.offScreenImage, 0, 0, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        if (this.applet instanceof Viewer) {
            ((Viewer)this.applet).startThread();
        }
    }

    public void setrepaint(Chart chart) {
        this.chart = chart;
        this.repaintflag = true;
        this.setSize(chart.getSize());
    }

    public void redoOffScreenImage() {
        this.offScreenImage = null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.animation && this.backbuffer != null) {
            return;
        }
        if (this.firstTime) {
            this.addKeyListener(this);
            this.firstTime = false;
        }
        this.update(g);
        this.panel3d.repaintRulerPanels(this.getScrollCoord());
    }

    public synchronized void threadPaint(Graphics g) {
        this.backbuffer.setColor(this.getBackground());
        this.backbuffer.fillRect(0, 0, this.width, this.height);
        this.chart.draw(this.backbuffer);
        if (this.showScrollPane) {
            g = this.pane.getClippedGraphics(g);
        }
        g.drawImage(this.offScreenImage, 0, 0, this);
    }

    public synchronized void start() {
        if (this.showScrollPane) {
            this.pane.setScrollingEnabled(false);
        }
        this.please_stop = false;
        if (this.animator == null) {
            this.animator = new Thread(this);
        }
        this.animator.setPriority(1);
        this.animator.start();
    }

    public synchronized void stop() {
        if (this.showScrollPane) {
            this.pane.setScrollingEnabled(true);
        }
        if (this.animator != null) {
            this.please_stop = true;
            this.animator.interrupt();
            this.animator = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void do_Zoom() {
        int categoryType = this.chart.getCategoryType();
        ZoomFrame zFrame = null;
        if (this.chart.showTable()) {
            GraphicsTable.recoverTableSize(this.chart);
        }
        zFrame = new ZoomFrame(this.panel3d, categoryType);
        if (this.panel3d.zoomHistVector.size() == 0) {
            this.origChartProcessed = this.chart.isTimeChart();
        }
        this.panel3d.zoomHistVector.addElement(new ZoomHistory(zFrame.zoomOpts.getRangeValue(0), zFrame.zoomOpts.getRangeValue(1), zFrame.zoomOpts.getScaleValue(), zFrame.zoomOpts.getScaleUnit(), zFrame.zoomOpts.isLinearScale()));
        zFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        int categoryType = this.chart.getCategoryType();
        int key = e.getKeyCode();
        Object zFrame = null;
        if (this.handleZEvents && e.isAltDown() && key == 90 && (categoryType == 91 || categoryType == 92 || categoryType == 93) && this.chart.isTimeChart() && !this.isDrillDownDefined) {
            this.do_Zoom();
        }
        if (e.isControlDown() && this.printing && (key == 80 || key == 74 || key == 71) && this.applet != null) {
            try {
                String base;
                String s = this.panel3d.filename != null ? this.panel3d.filename : this.applet.getDocumentBase() + "";
                s = s.replace('\\', '/');
                int idx = s.lastIndexOf(47);
                if (idx >= 0) {
                    s = s.substring(idx + 1);
                }
                if ((idx = s.lastIndexOf(46)) >= 0) {
                    s = s.substring(0, idx);
                }
                if ((idx = (base = this.applet.getDocumentBase() + "").lastIndexOf(47)) >= 0) {
                    base = base.substring(0, idx);
                }
                base = base + "/" + s;
                this.appletcontext.showStatus("Exporting... Please wait...");
                int exportType = 5;
                String extension = ".gif";
                if (key == 80) {
                    exportType = 4;
                    extension = "_PNG.html";
                } else if (key == 74) {
                    exportType = 3;
                    extension = ".jpg";
                }
                IOUtil2.exportToServer(exportType, this.offScreenImage, base, true, 99);
                this.appletcontext.showDocument(new URL(base + extension), "chart");
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            finally {
                this.appletcontext.showStatus("");
            }
        } else if (e.isControlDown() && key == 82 && this.refreshData) {
            this.do_Refresh();
        } else if (e.isControlDown() && key == 69 && this.chart.getQueryFileInfo() != null) {
            this.do_Query();
        } else if (key == 36 && this.chart.checkZoomStatus()) {
            if (this.chart.isXZoomed) {
                this.chart.setXZoom(0.0f, 1.0f, false);
            }
            if (this.chart.isYZoomed) {
                this.chart.setYZoom(0.0f, 1.0f, false);
            }
            this.flushImage();
            this.flushImage2();
            this.update(this.getGraphics());
            this.redoOffScreenImage();
            this.initBackImage(true);
            this.repaint();
        }
    }

    void do_Refresh() {
        if (this.appletcontext != null) {
            this.appletcontext.showStatus("Refresh Data...");
        }
        try {
            this.panel3d.do_Reload();
            this.repaint();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        finally {
            if (this.appletcontext != null) {
                this.appletcontext.showStatus("");
            }
        }
    }

    void do_Query() {
        Vector<QueryInParamSet> parameter = null;
        try {
            parameter = this.chart.queryFilename != null ? QueryFileInfo.getParameter(this.chart.dbInfo.getQuery(), this.chart.queryFilename, true) : QueryFileInfo.getParameter(this.chart.getQueryFileInfo(), true, false, true, false, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (parameter != null) {
            this.chart.getQueryFileInfo().setParameter(parameter);
            this.chart.usedColumns = null;
            this.chart = ReloadChart.reloadData(this.chart, true);
            this.panel3d.setChart(this.chart);
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
            this.repaint();
        }
    }

    @Override
    public void run() {
        Space space;
        if (this.chart == null || this.chart.is2DimChart()) {
            return;
        }
        if (!this.please_stop && this.animation && this.backbuffer == null) {
            while (this.backbuffer == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        if ((space = (Space)this.chart.getSpace()) == null) {
            return;
        }
        float scale = space.spaceScale;
        double alpha = Math.atan2(-space.viewVec.k, -space.viewVec.i);
        double pheta = Math.asin(-space.viewVec.j);
        double pi2 = Math.PI * 2;
        double t = Math.cos(pheta) * (double)scale;
        double t2 = Math.sin(pheta) * (double)scale;
        while (!this.please_stop && this.animation) {
            double d;
            this.chart.setlookfrom_x((float)(t * Math.cos(alpha) + (double)this.chart.getlookto_x()));
            this.chart.setlookfrom_y((float)(t2 + (double)this.chart.getlookto_y()));
            this.chart.setlookfrom_z((float)(t * Math.sin(alpha) + (double)this.chart.getlookto_z()));
            space.lookat(this.chart.getlookfrom_x(), this.chart.getlookfrom_y(), this.chart.getlookfrom_z(), this.chart.getlookto_x(), this.chart.getlookto_y(), this.chart.getlookto_z());
            try {
                this.threadPaint(this.getGraphics());
            }
            catch (Exception ex) {
                return;
            }
            alpha += this.chart.getAnimateSpeed();
            if (!(d > pi2)) continue;
            alpha -= pi2;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.chart != null && this.chart.showTable() && !this.chart.gt.clear) {
            if (this.chart.showLegend2() && this.chart.gt.atAxisTab(x, y) >= 0) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (this.chart.gt.tabPanel && this.chart.gt.atSeriesTab(x, y) >= 0) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (this.chart.gt.atCBorder(x, y) >= 0 || this.chart.gt.atTBorder(x, y) >= 0) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isPopupTrigger) {
            this.isPopupTrigger = e.isPopupTrigger();
        }
    }

    protected void finalize() throws Throwable {
        this.removeViewPanelListener();
    }

    public void showDataBox(int x, int y) {
        CGraphics cg;
        Object selectobj;
        if (this.animation) {
            return;
        }
        if (this.chart == null) {
            this.removeViewPanelListener();
            return;
        }
        Graphics g = this.getGraphics();
        if (this.showScrollPane) {
            g = this.pane.getClippedGraphics(g);
        }
        if (((selectobj = this.chart.select(cg = new CGraphics(g, this, this.height, this.width, this.chart), x, y)) instanceof MultiDimData || selectobj instanceof CString || selectobj instanceof Ticker) && (this.popupMenu == null || !this.popupMenu.isVisible())) {
            this.initBackImage(true);
            if (selectobj instanceof MultiDimData) {
                this.dataPointSelected = true;
                this.eventArg = this.chart.pickdata;
                if (this.chart.getShowDataState()) {
                    this.displayHint(this.chart.pickdata, this.dataBgColor, this.dataBorderColor, this.dataFontColor, this.dataFont, x + this.hintX, y + this.hintY);
                }
            } else if (selectobj instanceof CString && this.chart.getShowDataState()) {
                String str = ((CString)selectobj).getRunTimeValue(cg);
                this.displayHint(str, this.dataBgColor, this.dataBorderColor, this.dataFontColor, this.dataFont, x + this.hintX, y + this.hintY);
            }
            g.drawImage(this.offScreenImage2, 0, 0, this);
        }
    }

    public void removeDataBox(int x, int y) {
        CGraphics cg;
        Object selectobj;
        if (this.animation) {
            return;
        }
        if (this.chart == null) {
            this.removeViewPanelListener();
            return;
        }
        Graphics g = this.getGraphics();
        if (this.showScrollPane) {
            g = this.pane.getClippedGraphics(g);
        }
        if (!((selectobj = this.chart.select(cg = new CGraphics(g, this, this.height, this.width, this.chart), x, y)) instanceof MultiDimData) && this.dataPointSelected) {
            this.repaint();
            this.dataPointSelected = false;
        }
    }

    public PickData getPickData(int x, int y) {
        CGraphics cg;
        Object selectobj;
        Graphics g = this.getGraphics();
        if (this.showScrollPane) {
            g = this.pane.getClippedGraphics(g);
        }
        if ((selectobj = this.chart.select(cg = new CGraphics(g, this, this.height, this.width, this.chart), x, y)) instanceof MultiDimData && this.chart.pickdata != null) {
            PickData tmp = new PickData(this.chart.pickdata);
            this.chart.pickdata.clear();
            return tmp;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mousePressed(MouseEvent e) {
        Object selectobj;
        int y;
        int x;
        Graphics g;
        int mouseMask;
        block67: {
            CGraphics cg;
            block68: {
                mouseMask = e.getModifiers() & 0xFFFFFFEF;
                if (this.animation) {
                    if (mouseMask == 0 && e.getClickCount() >= 2) {
                        this.toggle3DControlPanel();
                    }
                    return;
                }
                g = this.getGraphics();
                if (this.showScrollPane) {
                    g = this.pane.getClippedGraphics(g);
                }
                x = e.getX();
                y = e.getY();
                this.firstX = this.previousX = x;
                this.firstY = this.previousY = y;
                this.isPopupTrigger = false;
                this.isPopupMenuOp = false;
                this.isPrevDrillOp = false;
                this.isNextFieldDrillOp = false;
                this.isNextDrillOp = false;
                cg = new CGraphics(g, this, this.height, this.width, this.chart);
                if (this.chart.showTable()) {
                    int axisTab = this.chart.gt.atAxisTab(x, y);
                    if (this.chart.showLegend2() && axisTab >= 0) {
                        if (axisTab == 0) {
                            this.chart.gt.setData(this.chart, this.chart.mData);
                        } else {
                            this.chart.gt.setData(this.chart, this.chart.mData2);
                        }
                        this.chart.gt.select_axis = axisTab;
                        this.chart.gt.cBorder = null;
                        this.chart.gt.paint();
                        this.paint();
                    }
                    int seriesTab = this.chart.gt.atSeriesTab(x, y);
                    if (this.chart.gt.tabPanel && seriesTab >= 0) {
                        this.chart.gt.select_tab = seriesTab;
                        this.chart.gt.paint();
                        this.paint();
                    }
                    this.cell = this.chart.gt.atCBorder(x, y);
                    if (this.cell >= 0) {
                        this.changeTableSize = true;
                    }
                    if (this.chart.gt.atHead(x, y)) {
                        this.setCursor(Cursor.getPredefinedCursor(13));
                        this.changeTablePosition = true;
                    }
                    this.tabNum = this.chart.gt.atTBorder(x, y);
                    if (this.tabNum >= 0) {
                        this.changeTabSize = true;
                        this.chart.gt.dragged = true;
                    }
                }
                this.dragtarget = null;
                this.mouseModifier = IOUtil.isRightMouseClicked(e) ? 1 : 0;
                boolean bl = this.isDragOp = !(this.chart.getZoomOption() == -1 && !this.dragChart || mouseMask != this.dragMask && this.chart.getZoomOption() == -1 || e.getClickCount() != this.dragClickCount);
                if (this.isDragOp) {
                    if (this.chart.legend.select(cg, x, y) != null) {
                        this.old_XProp = this.chart.getLegendXOffset();
                        this.old_YProp = this.chart.getLegendYOffset();
                        this.dragtarget = this.chart.legend;
                        this.chart.setLegendState(false);
                        this.initBackImage(false);
                        this.chart.setLegendState(true);
                    } else if (this.chart.showLegend2() && this.chart.legend2.select(cg, x, y) != null) {
                        this.old_XProp = this.chart.getLegendXOffset2();
                        this.old_YProp = this.chart.getLegendYOffset2();
                        this.dragtarget = this.chart.legend2;
                        this.chart.setLegendState2(false);
                        this.initBackImage(false);
                        this.chart.setLegendState2(true);
                    }
                    if (this.chart.showTable()) {
                        int dy = this.chart.gt.y;
                        if (this.chart.gt.tabPanel) {
                            dy += this.chart.gt.tab_height;
                        }
                        if (x > this.chart.gt.x && x < this.chart.gt.x + this.chart.gt.totalLength && y > dy && y < dy + this.chart.gt.getHeight() - this.chart.gt.tInterval) {
                            this.dragtarget = this.chart.gt;
                            this.initBackImage(false);
                        }
                    }
                    if (this.dragtarget == null && this.chart.inside(x, y)) {
                        this.old_XProp = this.chart.getChart_XProp();
                        this.old_YProp = this.chart.getChart_YProp();
                        this.dragtarget = this.chart;
                        this.initBackImage(false);
                    }
                    if (this.dragtarget == null && (this.chart.getZoomOption() == 0 || this.chart.getZoomOption() == 2) && new Rectangle(this.chart.chartxorigin, this.chart.winHeight - this.chart.chartyorigin, this.chart.chartwidth, 9).contains(x, y)) {
                        this.dragtarget = "XSCROLLBAR";
                        this.initBackImage(false);
                    }
                    if (this.dragtarget == null && (this.chart.getZoomOption() == 1 || this.chart.getZoomOption() == 2) && new Rectangle(this.chart.chartxorigin - 11, this.chart.winHeight - this.chart.chartyorigin - this.chart.chartheight, 9, this.chart.chartheight).contains(x, y)) {
                        this.dragtarget = "YSCROLLBAR";
                        this.initBackImage(false);
                    }
                }
                if (this.dragtarget == null && this.chart.inside(x, y)) {
                    this.isResizeOp = mouseMask == this.resizeMask && this.resizeChart && e.getClickCount() == this.resizeClickCount;
                    boolean bl2 = this.isResizeCanvasOp = !this.isResizeOp && this.showScrollPane && mouseMask == this.resizeCanvasMask && this.resizeCanvas && e.getClickCount() == this.resizeCanvasClickCount;
                    if (this.isResizeOp || this.isResizeCanvasOp) {
                        this.old_XProp = this.chart.getChartWidthProp();
                        this.old_YProp = this.chart.getChartHeightProp();
                        this.dragtarget = this.chart;
                        this.initBackImage(false);
                    }
                }
                if (this.dragtarget != null && (this.isDragOp || this.isResizeOp || this.isResizeCanvasOp)) {
                    this.dragResizeInit = true;
                    this.lastx = x;
                    this.lasty = y;
                }
                selectobj = this.chart.select(cg, x, y);
                if (mouseMask == this.zoomMask && e.getClickCount() == this.zoomClickCount && this.handleZEvents) {
                    if (this.chart.isTimeChart() && !this.isDrillDownDefined) {
                        this.isZoomOp = true;
                    }
                    this.initBackImage(true);
                    if (selectobj instanceof MultiDimData) {
                        this.eventArg = this.chart.pickdata;
                        this.startZoom = new PickData((PickData)this.eventArg);
                    } else {
                        this.startZoom = null;
                    }
                    this.fireEvent(this, 0);
                    return;
                }
                if (selectobj instanceof DataLine && (this.popupMenu == null || !this.popupMenu.isVisible())) {
                    this.initBackImage(true);
                    if (mouseMask == 0 && this.chart.getShowDataState()) {
                        Vector<String> vec = new Vector<String>();
                        vec.addElement(this.chart.targetName);
                        DataLine dLine = (DataLine)selectobj;
                        if (dLine.getShowHintValue()) {
                            vec.addElement(dLine.getValueHint() + " " + dLine.getLineValue());
                        }
                        this.displayHint(vec, this.dataBgColor, this.dataBorderColor, this.dataFontColor, this.dataFont, x + this.hintX, y + this.hintY);
                    }
                    g.drawImage(this.offScreenImage2, 0, 0, this);
                    this.eventArg = this.chart.targetName;
                    this.fireEvent(this, 0);
                    return;
                }
                if (this.goForwLink && mouseMask == this.forwLinkMask) {
                    if (selectobj instanceof MultiDimData && e.getClickCount() == this.drillDownClickCount && this.isDrillDownDefined && this.panel3d.parentChart != null && this.panel3d.parentChart.isDrillDownDefined()) {
                        this.drillX = x;
                        this.drillY = y;
                        this.isNextDrillOp = true;
                    } else if (selectobj instanceof MultiDimData && e.getClickCount() == this.drillDownClickCount && this.isFieldDrillDownEnabled()) {
                        this.drillX = x;
                        this.drillY = y;
                        this.isNextFieldDrillOp = true;
                    } else if (e.getClickCount() == this.forwLinkClickCount && this.gotoHyperLink(this.chart.select(cg, x, y), x, y)) {
                        this.fireEvent(this, 0);
                        return;
                    }
                }
                if (!this.goBackLink || mouseMask != this.backLinkMask || e.getClickCount() != this.drillDownClickCount) break block67;
                this.drillX = x;
                this.drillY = y;
                if (!this.isDrillDownDefined || this.panel3d.parentChart == null || this.panel3d.parentChart.getDrillNumber() <= 0) break block68;
                if (!this.chart.isPopupMenuEnabled()) {
                    this.isPrevDrillOp = true;
                    break block67;
                } else if (selectobj instanceof MultiDimData) {
                    this.isPrevDrillOp = true;
                    break block67;
                } else {
                    if (!this.isPopupTrigger) {
                        this.isPopupTrigger = e.isPopupTrigger();
                    }
                    this.isPopupMenuOp = true;
                }
                break block67;
            }
            if (selectobj instanceof MultiDimData) {
                if (e.getClickCount() == this.backLinkClickCount && this.goBackHyperLink()) {
                    this.fireEvent(this, 0);
                    return;
                }
                if (!this.isHyperLinkExisted(this.chart.select(cg, x, y)) && this.chart.isPopupMenuEnabled()) {
                    if (!this.isPopupTrigger) {
                        this.isPopupTrigger = e.isPopupTrigger();
                    }
                    this.isPopupMenuOp = true;
                }
            } else if (this.chart.isPopupMenuEnabled()) {
                if (!this.isPopupTrigger) {
                    this.isPopupTrigger = e.isPopupTrigger();
                }
                this.isPopupMenuOp = true;
            } else if (e.getClickCount() == this.backLinkClickCount && this.goBackHyperLink()) {
                this.fireEvent(this, 0);
                return;
            }
        }
        if (!(!(selectobj instanceof MultiDimData) && !(selectobj instanceof FaceData) || this.popupMenu != null && this.popupMenu.isVisible())) {
            this.initBackImage(true);
            if (mouseMask == 0) {
                if (!(selectobj instanceof MultiDimData)) {
                    this.fireEvent(this, 0);
                    return;
                }
                this.dataPointSelected = true;
                this.eventArg = this.chart.pickdata;
                if (this.chart.getShowDataState()) {
                    this.displayHint(this.chart.pickdata, this.dataBgColor, this.dataBorderColor, this.dataFontColor, this.dataFont, x + this.hintX, y + this.hintY);
                }
            } else if (mouseMask == IOUtil.getRightMouseClickMask()) {
                String link = null;
                String hyperHint = null;
                if (selectobj instanceof MultiDimData) {
                    HyperLink lnk = this.getLink();
                    if (lnk == null) {
                        this.fireEvent(this, 0);
                        return;
                    }
                    link = lnk.link;
                    hyperHint = lnk.getHintValue();
                } else {
                    FaceData faceData = (FaceData)selectobj;
                    if (faceData == null || faceData.getHyperLink() == null || faceData.getHyperLink().trim().equals("")) {
                        this.fireEvent(this, 0);
                        return;
                    }
                    link = faceData.getHyperLink();
                    hyperHint = faceData.getHint();
                }
                Vector<String> svec = new Vector<String>();
                if (hyperHint == null || hyperHint.trim().equals("")) {
                    svec.addElement(link);
                } else {
                    svec.addElement(hyperHint);
                }
                this.eventArg = this.selecthyperLink;
                if (this.showLink) {
                    this.displayHint(svec, this.linkBgColor, this.linkBorderColor, this.linkFontColor, this.linkFont, x + this.linkX, y + this.linkY);
                }
            }
            g.drawImage(this.offScreenImage2, 0, 0, this);
            this.fireEvent(this, 0);
        }
        if (selectobj != null && !(selectobj instanceof String)) {
            this.eventArg = this.chart.targetName;
            this.fireEvent(this, 0);
        }
        if (this.zoomUndo(e)) {
            return;
        }
        if (mouseMask == 0 && e.getClickCount() >= 2) {
            this.toggle3DControlPanel();
        }
    }

    private void toggle3DControlPanel() {
        if (this.btogglepanel && !this.chart.is2DimChart()) {
            this.panel3d.hidepanel = !this.panel3d.hidepanel;
            this.panel3d.toggleNavControl();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (Math.abs(this.lastx - x) < 5 && Math.abs(this.lasty - y) < 5 || x <= 5 || x >= this.width - 5 || y <= 5 || y >= this.height - 5) {
            return;
        }
        if (this.chart.showTable()) {
            if (this.changeTableSize) {
                int change = x - this.lastx;
                this.chart.gt.cBorder[this.cell] = Math.max(0, this.chart.gt.cBorder[this.cell] + change);
                this.update(this.getGraphics());
                this.lastx = x;
                return;
            }
            if (this.changeTablePosition) {
                int changex = this.chart.gt.ox + x - this.lastx;
                int changey = this.chart.gt.oy + y - this.lasty;
                this.chart.gt.rect = true;
                this.chart.gt.ox = changex;
                this.chart.gt.oy = changey;
                this.lastx = x;
                this.lasty = y;
            }
        }
        if (this.isDragOp) {
            if (this.dragtarget == this.chart && this.chart.getZoomOption() == -1) {
                this.chart.setChart_XProp(this.old_XProp + (float)(x - this.lastx) / (float)this.width);
                this.chart.setChart_YProp(this.old_YProp + (float)(y - this.lasty) / (float)this.height);
                if (this.chart.gt.direction == 2) {
                    this.chart.gt.x = (int)((float)this.chart.winWidth * this.chart.chart_XProp + (float)this.chart.aTCX);
                    this.chart.gt.y = (int)((float)this.chart.winHeight * (this.chart.chart_YProp + this.chart.chart_heightProp) + (float)this.chart.aTCY);
                } else {
                    this.chart.gt.x = (int)((float)this.chart.winWidth * (this.chart.chart_XProp + this.chart.chart_widthProp) + (float)this.chart.aTCX);
                    this.chart.gt.y = (int)((float)this.chart.winHeight * this.chart.chart_YProp + (float)this.chart.aTCY);
                }
            } else if (this.dragtarget == this.chart.legend) {
                this.chart.setLegendXOffset(this.old_XProp + (float)(x - this.lastx) / (float)this.width);
                if (!this.chart.isReferenceAtTop()) {
                    this.chart.setLegendYOffset(this.old_YProp - (float)(y - this.lasty) / (float)this.height);
                } else {
                    this.chart.setLegendYOffset(this.old_YProp + (float)(y - this.lasty) / (float)this.height);
                }
            } else if (this.dragtarget == this.chart.legend2) {
                this.chart.setLegendXOffset2(this.old_XProp + (float)(x - this.lastx) / (float)this.width);
                if (!this.chart.isReferenceAtTop()) {
                    this.chart.setLegendYOffset2(this.old_YProp - (float)(y - this.lasty) / (float)this.height);
                } else {
                    this.chart.setLegendYOffset2(this.old_YProp + (float)(y - this.lasty) / (float)this.height);
                }
            } else {
                this.dx = x - this.lastx;
                this.dy = y - this.lasty;
            }
            this.drawFrame();
            return;
        }
        this.isResizeOp = this.isResizeOp && e.getModifiers() == this.resizeMask;
        boolean bl = this.isResizeCanvasOp = this.isResizeCanvasOp && !this.isResizeOp && e.getModifiers() == this.resizeCanvasMask;
        if (this.isResizeOp || this.isResizeCanvasOp) {
            if (this.dragtarget == this.chart) {
                float tempHeight;
                float tempWidth = (this.chart.chart_widthProp * (float)this.width + (float)(x - this.lastx)) / (float)this.width;
                if ((double)tempWidth > 0.1 && tempWidth < 1.0f) {
                    this.newChartWidth = tempWidth;
                }
                if ((double)(tempHeight = (this.chart.chart_heightProp * (float)this.height + (float)(y - this.lasty)) / (float)this.height) > 0.1 && tempWidth < 1.0f) {
                    this.newChartHeight = tempHeight;
                }
            }
            this.drawFrame();
            return;
        }
        if (this.isZoomOp) {
            boolean bl2 = this.isZoomOp = this.isZoomOp && (e.getModifiers() & 0xFFFFFFEF) == this.zoomMask;
            if (this.isZoomOp) {
                this.previousX = x;
                this.previousY = y;
                this.drawRubberBandLine();
                return;
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.chart.showTable()) {
            if (this.changeTablePosition) {
                this.chart.gt.rect = false;
                this.chart.gt.x = this.chart.gt.ox;
                this.chart.gt.y = this.chart.gt.oy;
                this.paint();
            }
            this.changeTableSize = false;
            this.changeTabSize = false;
            this.changeTablePosition = false;
            this.setCursor(new Cursor(0));
        }
        if (this.isNextDrillOp && x == this.drillX && y == this.drillY) {
            this.isNextDrillOp = false;
            this.nextDrillDown();
            return;
        }
        if (this.isNextFieldDrillOp && x == this.drillX && y == this.drillY) {
            this.isNextFieldDrillOp = false;
            this.nextFieldDrillDown();
            return;
        }
        if (this.isPrevDrillOp && x == this.drillX && y == this.drillY) {
            this.isPrevDrillOp = false;
            this.previousDrillDown();
            return;
        }
        if (this.isPopupMenuOp && x == this.drillX && y == this.drillY) {
            this.isPopupMenuOp = false;
            if (!this.isPopupTrigger) {
                this.isPopupTrigger = e.isPopupTrigger();
            }
            if (this.isPopupTrigger) {
                this.removeDataBox(x, y);
                this.popupMenu = new CPopupMenu(this.panel3d);
                if (this.popupMenu.getItemCount() > 0) {
                    this.add(this.popupMenu);
                    this.popupMenu.show(this, x, y);
                }
                return;
            }
        }
        if (this.dragResizeInit) {
            this.dragResizeInit = false;
            if (this.isResizeOp) {
                this.isResizeOp = false;
                if (this.newChartWidth != 0.0f && this.newChartHeight != 0.0f) {
                    this.chart.reCalculateAnnotationTextPosition(this.chart.chart_widthProp, this.newChartWidth, this.chart.chart_heightProp, this.newChartHeight);
                    this.chart.chart_widthProp = this.newChartWidth;
                    this.chart.chart_heightProp = this.newChartHeight;
                    this.redoOffScreenImage();
                }
            } else if (this.isResizeCanvasOp) {
                this.isResizeCanvasOp = false;
                if (this.showScrollPane) {
                    this.setSize(this.width + (x - this.lastx), this.height + (y - this.lasty));
                    this.redoOffScreenImage();
                }
            } else if (this.isDragOp && this.dragtarget != null) {
                this.isDragOp = false;
                if (this.dragtarget == this.chart) {
                    if (this.chart.getZoomOption() == 0) {
                        this.processZoomX(x, !e.isControlDown());
                    } else if (this.chart.getZoomOption() == 1) {
                        this.processZoomY(y, !e.isControlDown());
                    } else if (this.chart.getZoomOption() == 2) {
                        this.processZoomY(y, !e.isControlDown());
                        this.processZoomX(x, !e.isControlDown());
                    }
                } else if (this.dragtarget.toString().equals("XSCROLLBAR")) {
                    this.chart.setXZoom((float)this.dx / (float)this.chart.chartwidth / this.chart.xratio, 1.0f, true);
                } else if (this.dragtarget.toString().equals("YSCROLLBAR")) {
                    this.chart.setYZoom(-((float)this.dy) / (float)this.chart.chartheight / this.chart.yratio, 1.0f, true);
                }
                this.update(this.getGraphics());
                this.redoOffScreenImage();
            }
            this.repaint();
            this.dragtarget = null;
            return;
        }
        ZoomFrame zFrame = null;
        Timestamp ts1 = null;
        Timestamp ts2 = null;
        int categoryType = this.chart.getCategoryType();
        if (this.isZoomOp && (categoryType == 91 || categoryType == 92 || categoryType == 93)) {
            Graphics g = this.getGraphics();
            if (this.showScrollPane) {
                g = this.pane.getClippedGraphics(g);
            }
            this.lastX = x;
            this.lastY = y;
            CGraphics cgraphics = new CGraphics(g, this, this.height, this.width, this.chart);
            Object selectobj = this.chart.select(cgraphics, x, y);
            this.endZoom = selectobj instanceof MultiDimData ? new PickData(this.chart.pickdata) : null;
            ts1 = this.startZoom != null ? this.getZoomBound(this.startZoom) : this.getClosestBound(0);
            ts2 = this.endZoom != null ? this.getZoomBound(this.endZoom) : this.getClosestBound(1);
            if (ts1 != null && ts2 != null && !ts1.after(ts2)) {
                zFrame = new ZoomFrame(this.panel3d, this.chart.getCategoryType());
                if (this.panel3d.zoomHistVector.size() == 0) {
                    this.origChartProcessed = this.chart.isTimeChart();
                }
                this.panel3d.zoomHistVector.addElement(new ZoomHistory(zFrame.zoomOpts.getRangeValue(0), zFrame.zoomOpts.getRangeValue(1), zFrame.zoomOpts.getScaleValue(), zFrame.zoomOpts.getScaleUnit(), zFrame.zoomOpts.isLinearScale()));
                if (ts1.before(ts2)) {
                    zFrame.zoomOpts.setRangeValue(0, ts1);
                    zFrame.zoomOpts.setRangeValue(1, ts2);
                    zFrame.zoomOpts.setScaleUnit(DateTime.getAutoScaleUnit(ts1, ts2));
                } else {
                    zFrame.zoomOpts.setRangeValue(0, ts2);
                    zFrame.zoomOpts.setRangeValue(1, ts1);
                    zFrame.zoomOpts.setScaleUnit(DateTime.getAutoScaleUnit(ts2, ts1));
                }
                zFrame.zoomOpts.disableLowerBound.setState(false);
                zFrame.zoomOpts.disableUpperBound.setState(false);
                zFrame.performZoom(true);
            }
        }
        if (this.isZoomOp) {
            this.isZoomOp = false;
            this.repaint();
            return;
        }
        if (this.dataPointSelected) {
            this.repaint();
            this.dataPointSelected = false;
        }
    }

    Timestamp getZoomBound(PickData pdObject) {
        int categoryType = this.chart.getCategoryType();
        Timestamp tsValue = null;
        switch (categoryType) {
            case 93: {
                tsValue = Timestamp.valueOf(pdObject.category);
                break;
            }
            case 92: {
                tsValue = new Timestamp(Time.valueOf(pdObject.category).getTime());
                break;
            }
            case 91: {
                tsValue = new Timestamp(Date.valueOf(pdObject.category).getTime());
            }
        }
        return tsValue;
    }

    Timestamp getClosestBound(int highBound) {
        Timestamp tsValue = null;
        java.util.Date lValue = null;
        int categoryType = this.chart.getCategoryType();
        int smallX = this.firstX;
        int bigX = this.lastX;
        lValue = highBound == 1 ? (java.util.Date)this.chart.a_x.ticker.getGLBound(bigX) : (java.util.Date)this.chart.a_x.ticker.getLUBound(smallX);
        if (lValue == null) {
            return null;
        }
        String lString = lValue.toString();
        switch (categoryType) {
            case 93: {
                tsValue = Timestamp.valueOf(lString);
                break;
            }
            case 92: {
                tsValue = new Timestamp(Time.valueOf(lString).getTime());
                break;
            }
            case 91: {
                tsValue = new Timestamp(Date.valueOf(lString).getTime());
            }
        }
        return tsValue;
    }

    void setZoom(int value) {
        int delta = 4 * (value - this.oldZoom);
        this.setSize(this.width + delta, this.height + delta * this.height / this.width);
        this.oldZoom = value;
    }

    public final Object getValue() {
        return this.eventArg;
    }

    public final int getModifier() {
        return this.mouseModifier;
    }

    void initBackImage(boolean copy) {
        if (this.offScreenImage2 == null || this.offScreenImage2.getHeight(null) != this.height || this.offScreenImage2.getWidth(null) != this.width) {
            this.flushImage2();
            this.offScreenImage2 = this.createImage(this.width, this.height);
            this.backbuffer2 = this.offScreenImage2.getGraphics();
        }
        if (copy && this.offScreenImage != null) {
            this.backbuffer2.drawImage(this.offScreenImage, 0, 0, this);
        } else {
            this.chart.draw(this.backbuffer2);
        }
    }

    void drawRubberBandLine() {
        if (this.chart.isCircularChart() || this.chart.chartType == 8 || this.chart.chartType == 1 || this.chart.chartType == 5 || this.chart.chartType == 2 || this.chart.chartType == 17 || this.chart.chartType == 16 || this.chart.chartType == 19) {
            this.isZoomOp = false;
            return;
        }
        this.backbuffer.drawImage(this.offScreenImage2, 0, 0, this);
        if (this.chart.border.areaColor.equals(this.chart.desktopArea.areaColor)) {
            Color c = this.chart.desktopArea.areaColor;
            this.backbuffer.setColor(new Color(255 - c.getRed(), 255 - c.getGreen(), 55 - c.getBlue()));
        } else {
            this.backbuffer.setColor(this.chart.border.areaColor);
        }
        this.backbuffer.drawLine(this.firstX, 0, this.firstX, this.height);
        this.backbuffer.drawOval(this.firstX - 5, this.firstY - 5, 9, 9);
        if (this.previousX > this.firstX) {
            this.backbuffer.drawLine(this.previousX, 0, this.previousX, this.height);
            this.backbuffer.drawOval(this.previousX - 5, this.previousY - 5, 9, 9);
        }
        Graphics graphics = this.getGraphics();
        if (this.showScrollPane) {
            graphics = this.pane.getClippedGraphics(graphics);
        }
        graphics.drawImage(this.offScreenImage, 0, 0, this);
        this.panel3d.repaintRulerPanels(this.getScrollCoord());
    }

    void drawFrame() {
        if (this.dragtarget == null) {
            return;
        }
        if (this.dragtarget != this.chart && !(this.dragtarget instanceof String)) {
            CGraphics g = new CGraphics(this.backbuffer, this, this.height, this.width, this.chart);
            g.chart = this.chart;
            this.backbuffer.drawImage(this.offScreenImage2, 0, 0, this);
            if (this.dragtarget instanceof Legend) {
                this.chart.legend.draw(g);
                this.chart.legend2.draw(g);
            } else if (this.chart.showTable() && this.dragtarget instanceof GraphicsTable) {
                int adx = 0;
                if (!this.chart.gt.clear && this.chart.gt.tabPanel) {
                    adx = this.chart.gt.tab_height;
                }
                this.backbuffer.setColor(Color.black);
                this.backbuffer.drawRect(this.chart.gt.ox, this.chart.gt.oy + adx, this.chart.gt.totalLength, this.chart.gt.rrow * this.chart.gt.heightPerCell);
            }
        } else if (this.dragtarget instanceof String) {
            if (this.dragtarget.toString().equals("XSCROLLBAR")) {
                int xMin = this.chart.chartxorigin;
                int cwidth = this.chart.chartwidth;
                int yMin = this.chart.winHeight - this.chart.chartyorigin;
                int newX = xMin + 1 + (int)((float)cwidth * this.chart.xmin) + this.dx;
                int newW = (int)((float)cwidth * this.chart.xratio);
                if (newX < xMin + 1) {
                    newX = xMin + 1;
                } else if (newX + newW > xMin + cwidth) {
                    newX = xMin + cwidth - newW;
                }
                this.backbuffer.drawImage(this.offScreenImage2, 0, 0, this);
                this.backbuffer.setColor(Color.black);
                this.backbuffer.drawRect(xMin + 1, yMin, cwidth, 9);
                this.backbuffer.setColor(Color.white);
                this.backbuffer.fillRect(xMin + 2, yMin + 1, cwidth - 2, 7);
                this.backbuffer.setColor(Color.black);
                this.backbuffer.fillRect(newX, yMin + 2, newW, 5);
            } else if (this.dragtarget.toString().equals("YSCROLLBAR")) {
                int yMin = this.chart.winHeight - this.chart.chartyorigin - this.chart.chartheight;
                int cheight = this.chart.chartheight;
                int xMin = this.chart.chartxorigin;
                int newY = 0;
                newY = yMin + 1 + (int)((float)cheight * (1.0f - this.chart.ymin - this.chart.yratio)) + this.dy;
                int newH = (int)((float)cheight * this.chart.yratio);
                if (newY < yMin) {
                    newY = yMin;
                } else if (newY + newH > yMin + cheight) {
                    newY = yMin + cheight - newH;
                }
                this.backbuffer.drawImage(this.offScreenImage2, 0, 0, this);
                this.backbuffer.setColor(Color.black);
                this.backbuffer.drawRect(xMin - 11, yMin, 9, cheight);
                this.backbuffer.setColor(Color.white);
                this.backbuffer.fillRect(xMin - 10, yMin + 1, 7, cheight - 2);
                this.backbuffer.setColor(Color.black);
                this.backbuffer.fillRect(xMin - 9, newY, 5, newH);
            }
        } else {
            this.backbuffer.drawImage(this.offScreenImage2, 0, 0, this);
            if (this.chart.border.areaColor.equals(this.chart.desktopArea.areaColor)) {
                Color c = this.chart.desktopArea.areaColor;
                this.backbuffer.setColor(new Color(255 - c.getRed(), 255 - c.getGreen(), 55 - c.getBlue()));
            } else {
                this.backbuffer.setColor(this.chart.border.areaColor);
            }
            if (this.chart.is2DChart) {
                if (this.isResizeOp || this.isResizeCanvasOp) {
                    int h = (int)((float)this.height * this.newChartHeight);
                    int w = (int)((float)this.width * this.newChartWidth);
                    this.backbuffer.drawRect((int)((float)this.width * this.chart.chart_XProp), (int)((float)this.height * this.chart.chart_YProp), w, h);
                } else if (this.chart.getZoomOption() == -1) {
                    int h = (int)((float)this.height * this.chart.chart_heightProp);
                    int w = (int)((float)this.width * this.chart.chart_widthProp);
                    this.backbuffer.drawRect((int)((float)this.width * this.chart.chart_XProp), (int)((float)this.height * this.chart.chart_YProp), w, h);
                } else {
                    this.backbuffer.drawRect(this.dx < 0 ? this.lastx + this.dx : this.lastx, this.dy < 0 ? this.lasty + this.dy : this.lasty, this.dx < 0 ? -this.dx : this.dx, this.dy < 0 ? -this.dy : this.dy);
                }
            } else if (this.isResizeOp || this.isResizeCanvasOp) {
                int newWidth = this.chart.xboundmax - this.chart.xboundmin + (int)((this.newChartWidth - this.chart.chart_widthProp) * (float)this.width);
                int newHeight = this.chart.yboundmax - this.chart.yboundmin + (int)((this.newChartHeight - this.chart.chart_heightProp) * (float)this.height);
                float newRatio = (float)newWidth / (float)newHeight;
                int oldWidth = this.chart.xboundmax - this.chart.xboundmin;
                int oldHeight = this.chart.yboundmax - this.chart.yboundmin;
                float oldRatio = (float)oldWidth / (float)oldHeight;
                if (newRatio > oldRatio) {
                    newWidth = (int)((float)(oldWidth * newHeight) / (float)oldHeight);
                } else if (newRatio < oldRatio) {
                    newHeight = (int)((float)(oldHeight * newWidth) / (float)oldWidth);
                }
                this.backbuffer.drawRect(this.chart.xboundmin, this.chart.yboundmin, newWidth, newHeight);
            } else {
                this.chart.computeBoundingBox();
                this.backbuffer.drawRect(this.chart.xboundmin, this.chart.yboundmin, this.chart.xboundmax - this.chart.xboundmin, this.chart.yboundmax - this.chart.yboundmin);
            }
            this.chart.validatePosition();
        }
        Graphics graphics = this.getGraphics();
        if (this.showScrollPane) {
            graphics = this.pane.getClippedGraphics(graphics);
        }
        if (this.offScreenImage != null) {
            graphics.drawImage(this.offScreenImage, 0, 0, this);
        }
        graphics.dispose();
        this.panel3d.repaintRulerPanels(this.getScrollCoord());
    }

    private boolean isHyperLinkExisted(Object selectobj) {
        if (selectobj instanceof MultiDimData) {
            HyperLink lnk = this.getLink();
            if (lnk == null) {
                return false;
            }
        } else if (selectobj instanceof FaceData) {
            FaceData faceData = (FaceData)selectobj;
            if (faceData.getHyperLink() == null || faceData.getHyperLink().trim().equals("")) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    boolean gotoHyperLink(Object selectobj) {
        return this.gotoHyperLink(selectobj, -1, -1);
    }

    boolean gotoHyperLink(Object selectobj, int x, int y) {
        if (this.chart.cgraphics == null) {
            return false;
        }
        if (this.chart.cgraphics.maplist == null && this.chart.getHyperLinkList() != null && this.chart.getHyperLinkList().size() > 0) {
            this.chart.draw(this.getGraphics());
        }
        String link = null;
        String target = null;
        if (selectobj instanceof MultiDimData) {
            HyperLink lnk = this.getLink();
            if (lnk == null) {
                return false;
            }
            link = lnk.link;
            target = lnk.target;
        } else if (selectobj instanceof FaceData) {
            FaceData faceData = (FaceData)selectobj;
            if (faceData.getHyperLink() == null || faceData.getHyperLink().trim().equals("")) {
                return false;
            }
            link = faceData.getHyperLink().trim();
            target = faceData.getTarget();
        } else if (this.chart.cgraphics.imagemap) {
            String[] lnkInfo = this.chart.cgraphics.findLinkContaining(x, y);
            if (lnkInfo == null) {
                return false;
            }
            link = lnkInfo[0].trim();
            target = lnkInfo[1];
        } else {
            return false;
        }
        String string2 = this.panel3d.filename;
        if (string2 == null) {
            this.firstChart = this.chart;
            string2 = NONAME;
        }
        if (this.panel3d.do_openChart(link, target)) {
            this.panel3d.linkhistory.addElement(string2);
            this.panel3d.zoomHistVector.removeAllElements();
        }
        return true;
    }

    boolean goBackHyperLink() {
        if (this.panel3d.linkhistory.size() > 0) {
            if (this.panel3d.linkhistory.lastElement() instanceof Chart) {
                Chart tmpCht = (Chart)this.panel3d.linkhistory.lastElement();
                this.panel3d.linkhistory.removeElement(tmpCht);
                this.panel3d.do_openChart(tmpCht);
            } else {
                String string = (String)this.panel3d.linkhistory.lastElement();
                this.panel3d.linkhistory.removeElement(string);
                this.panel3d.zoomHistVector.removeAllElements();
                if (string.equals(NONAME)) {
                    this.panel3d.do_openChart(this.firstChart);
                } else {
                    this.panel3d.do_openChart(string, "");
                }
            }
            return true;
        }
        return false;
    }

    HyperLink getLink() {
        this.selecthyperLink = new HyperLink(this.chart.pickdata).findNewLink(this.chart.getHyperLinkList());
        if (this.selecthyperLink == null) {
            return null;
        }
        String s = this.selecthyperLink.link.trim();
        if (s.equals("")) {
            return null;
        }
        return this.selecthyperLink;
    }

    @Override
    public void displayHint(String s) {
        if (this.appletcontext != null) {
            this.appletcontext.showStatus(s);
        }
    }

    public void flushImage() {
        if (this.offScreenImage != null) {
            this.offScreenImage.flush();
            this.offScreenImage = null;
        }
    }

    public void flushImage2() {
        if (this.offScreenImage2 != null) {
            this.offScreenImage2.flush();
            this.offScreenImage2 = null;
        }
    }

    private void displayHint(PickData pd, Color bgColor, Color borderColor, Color fnColor, Font font, int x, int y) {
        if (this.panel3d.getHintBoxInfo() != null && this.panel3d.getHintBoxInfo().getHint(pd) != null) {
            this.displayHint(this.panel3d.getHintBoxInfo().getHint(pd), bgColor, borderColor, fnColor, this.dataFont, x, y);
        } else {
            this.displayHint(pd.toVec(), bgColor, borderColor, fnColor, this.dataFont, x, y);
        }
    }

    private void displayHint(String str, Color bgColor, Color borderColor, Color fnColor, Font font, int x, int y) {
        StringTokenizer st = new StringTokenizer(str, "\n\r");
        Vector<String> vec = new Vector<String>();
        while (st.hasMoreTokens()) {
            vec.addElement(st.nextToken());
        }
        this.displayHint(vec, bgColor, borderColor, fnColor, this.dataFont, x, y);
    }

    public Dimension getHintBoxOffset() {
        return new Dimension(this.hintX, this.hintY);
    }

    public void setHintBoxOffset(Dimension dimension) {
        this.hintX = dimension.width;
        this.hintY = dimension.height;
    }

    public Dimension getHyperLinkOffset() {
        return new Dimension(this.linkX, this.linkY);
    }

    public void setHyperLinkOffset(Dimension dimension) {
        this.linkX = dimension.width;
        this.linkY = dimension.height;
    }

    private void displayHint(Vector svec, Color bgColor, Color borderColor, Color fnColor, Font font, int x, int y) {
        int w = 0;
        FontMetrics fm = this.backbuffer2.getFontMetrics(font);
        int cw = fm.stringWidth("A");
        for (int i = 0; i < svec.size(); ++i) {
            w = Math.max(w, fm.stringWidth((String)svec.elementAt(i)));
        }
        int txtheight = fm.getMaxAscent() + fm.getMaxDescent();
        int h = txtheight * svec.size() + 4;
        if (x + (w += 2 * cw) > this.width) {
            x = this.width - w;
        }
        if (y + h > this.height) {
            y = this.height - h;
        }
        if (borderColor != null) {
            this.backbuffer2.setColor(bgColor);
            this.backbuffer2.fillRect(x - 2, y, w, h);
            this.backbuffer2.setColor(borderColor);
            this.backbuffer2.drawRect(x - 2, y, w, h);
        } else {
            this.backbuffer2.setColor(bgColor);
            this.backbuffer2.fill3DRect(x - 2, y, w, h, true);
        }
        this.backbuffer2.setColor(fnColor);
        this.backbuffer2.setFont(font);
        if (this.chart != null) {
            this.chart.doChartRendering(this.backbuffer2);
        }
        for (int i = 0; i < svec.size(); ++i) {
            this.backbuffer2.drawString(svec.elementAt(i).toString(), x + cw, y + (i + 1) * txtheight);
        }
    }

    Dimension getScrollCoord() {
        Dimension d = new Dimension();
        if (this.showScrollPane) {
            double delta = (double)this.vAdjust.getValue() / (double)(this.vAdjust.getMaximum() - this.vAdjust.getMinimum());
            d.height = (int)(delta * (double)this.getSize().height);
            delta = (double)this.hAdjust.getValue() / (double)(this.hAdjust.getMaximum() - this.hAdjust.getMinimum());
            d.width = (int)(delta * (double)this.getSize().width);
            return d;
        }
        return d;
    }

    final boolean zoomUndo(MouseEvent e) {
        if (this.handleZEvents && this.undoZoomMask == e.getModifiers() && e.getClickCount() == this.undoZoomClickCount) {
            return this.zoomUndo();
        }
        return false;
    }

    final boolean zoomUndo() {
        ZoomFrame zFrame = null;
        if (this.panel3d.zoomHistVector.size() == 0) {
            return false;
        }
        zFrame = new ZoomFrame(this.panel3d, this.chart.getCategoryType());
        if (1 == this.panel3d.zoomHistVector.size() && !this.origChartProcessed) {
            zFrame.zoomOpts.cancelZoom(true);
        }
        ZoomHistory lastZoom = (ZoomHistory)this.panel3d.zoomHistVector.lastElement();
        zFrame.zoomOpts.setRangeValue(0, lastZoom.ts1);
        zFrame.zoomOpts.setRangeValue(1, lastZoom.ts2);
        zFrame.zoomOpts.setScaleValue(lastZoom.scaleValue);
        zFrame.zoomOpts.setScaleUnit(lastZoom.scaleUnit);
        zFrame.zoomOpts.setLinearScale(lastZoom.linearScale);
        zFrame.performZoom();
        this.panel3d.zoomHistVector.removeElement(lastZoom);
        return true;
    }

    public void previousDrillDown() {
        String tplName = null;
        if (this.panel3d.parentChart == null) {
            return;
        }
        this.panel3d.parentChart.decrementDrillNumber();
        if (this.panel3d.parentChart.getDrillNumber() <= 0) {
            this.panel3d.parentChart.usedColumns = null;
            if (this.panel3d.parentChart.showTable()) {
                GraphicsTable.recoverTableSize(this.panel3d.parentChart);
            }
            this.panel3d.parentChart = ReloadChart.reloadData(this.panel3d.parentChart, true);
            this.panel3d.drillHistory = null;
            this.chart.valueTable.setDrillHistory(null);
            this.panel3d.do_openChart(this.panel3d.parentChart);
            return;
        }
        if (!this.panel3d.parentChart.isDrillDownDefined()) {
            return;
        }
        if (this.panel3d.drillHistory == null) {
            return;
        }
        if (this.panel3d.originalMetaData == null) {
            this.panel3d.originalMetaData = ReloadChart.getMetaDataInfo(this.panel3d.parentChart);
        }
        this.panel3d.parentChart.decrementDrillNumber();
        int[] map = this.panel3d.parentChart.getDrillDownMap();
        int dim = this.panel3d.parentChart.getDrillDownDimension();
        int cType = this.panel3d.parentChart.getDrillDownType();
        boolean dType = this.panel3d.parentChart.isDrillDown2D();
        this.panel3d.parentChart.incrementDrillNumber();
        int valCol = this.panel3d.parentChart.getValueMap();
        int subvalCol = this.panel3d.parentChart.getSubValueMap();
        if (this.panel3d.parentChart.summaryChart) {
            valCol = this.panel3d.parentChart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = this.panel3d.parentChart.originalMap[subvalCol];
            }
        }
        PreprocInfo tsInfo = this.panel3d.drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, this.panel3d.parentChart.primaryAggregate, this.panel3d.parentChart.secondaryAggregate);
        ValueTable valueTableSave = this.chart.valueTable;
        this.chart = Chart.createChart(this, cType, dType, null, this.panel3d.drillHistory.previousDrill(tsInfo), null);
        this.chart.setSubFilesTable(this.panel3d.parentChart.getSubFilesTable());
        this.panel3d.drillHistory.setChartType(this.chart, tsInfo);
        if (valueTableSave != null) {
            this.chart.valueTable = new ValueTable(this.chart, valueTableSave);
        }
        if (this.doesTemplateFileExist(tplName = this.createDrillTemplateName())) {
            this.do_loadTemplate(tplName);
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
        } else {
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
            this.panel3d.do_openChart(this.chart);
        }
    }

    boolean isFieldDrillDownEnabled() {
        if (this.chart.currentNode == null) {
            return false;
        }
        return this.chart.currentNode.getChildCount() > 0;
    }

    void nextFieldDrillDown() {
        DrillDownNode cNode = this.chart.currentNode.getChildAt(0);
        int[] mapping = cNode.getColumnMapping();
        if (mapping == null) {
            System.out.println("MAPPING IS NULL");
        }
        Object[] value = new Object[mapping.length];
        for (int i = 0; i < mapping.length; ++i) {
            String param = this.chart.colData[mapping[i]].getName();
            if (param.equals(this.chart.pickdata.valueName)) {
                try {
                    value[i] = DataType.createObject(this.chart.pickdata.value + "", this.chart.colData[mapping[i]].getDataType());
                }
                catch (Exception ex) {
                    System.out.println("VIEWPANEL:  CANNOT GET FIELD DATA!");
                    value[i] = "";
                }
                continue;
            }
            if (param.equals(this.chart.pickdata.seriesName)) {
                value[i] = this.chart.pickdata.series;
                continue;
            }
            if (!param.equals(this.chart.pickdata.categoryName)) continue;
            value[i] = this.chart.pickdata.category;
        }
        Object obj = this.panel3d.do_openChart(cNode.getFileName(), value);
        if (obj != null) {
            this.panel3d.linkhistory.addElement(obj);
            this.panel3d.zoomHistVector.removeAllElements();
        }
    }

    public void nextDrillDown() {
        String tplName;
        if (this.panel3d.parentChart == null) {
            this.panel3d.parentChart = this.chart;
        }
        if (!this.panel3d.parentChart.isDrillDownDefined()) {
            return;
        }
        if (this.panel3d.drillHistory == null) {
            if (this.panel3d.originalMetaData == null) {
                this.panel3d.originalMetaData = ReloadChart.getMetaDataInfo(this.panel3d.parentChart);
            }
            this.panel3d.drillHistory = new DrillHistory(this.panel3d.parentChart, this.panel3d.originalMetaData);
            this.chart.valueTable.setDrillHistory(this.panel3d.drillHistory);
        }
        this.isDrillDownDefined = this.panel3d.parentChart.drillDownVector.size() > 0;
        int[] map = this.panel3d.parentChart.getDrillDownMap();
        int dim = this.panel3d.parentChart.getDrillDownDimension();
        int cType = this.panel3d.parentChart.getDrillDownType();
        boolean dType = this.panel3d.parentChart.isDrillDown2D();
        int valCol = this.panel3d.parentChart.getValueMap();
        int subvalCol = this.panel3d.parentChart.getSubValueMap();
        if (this.panel3d.parentChart.summaryChart) {
            valCol = this.panel3d.parentChart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = this.panel3d.parentChart.originalMap[subvalCol];
            }
        }
        PreprocInfo tsInfo = this.panel3d.drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, this.panel3d.parentChart.primaryAggregate, this.panel3d.parentChart.secondaryAggregate);
        ValueTable valueTableSave = this.chart.valueTable;
        Chart tempChart = Chart.createChart(this, cType, dType, null, this.panel3d.drillHistory.nextDrill(this.chart.pickdata, tsInfo), null);
        tempChart.setSubFilesTable(this.panel3d.parentChart.getSubFilesTable());
        if (tempChart.notEnoughData()) {
            OurMessageDialog.showWarning(this, true, "Not enough data available to plot");
            this.panel3d.drillHistory.removeLastDrill();
            return;
        }
        this.chart = tempChart;
        this.panel3d.drillHistory.setChartType(this.chart, tsInfo);
        this.panel3d.parentChart.incrementDrillNumber();
        if (valueTableSave != null) {
            this.chart.valueTable = new ValueTable(this.chart, valueTableSave);
        }
        if (this.doesTemplateFileExist(tplName = this.createDrillTemplateName())) {
            this.do_loadTemplate(tplName);
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
        } else {
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
            this.panel3d.do_openChart(this.chart);
        }
    }

    public void do_loadTemplate(String file) {
        if (file == null) {
            return;
        }
        if (!file.endsWith(".tpl")) {
            file = file + ".tpl";
        }
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream din = null;
        try {
            din = readfile.getInputStream(this.chart, file);
        }
        catch (Exception ex) {
            System.out.println(LanguageEncoder.getText("Error") + ex.toString());
            return;
        }
        Chart newChart = null;
        try {
            newChart = new LoadChart().loadTemplate(this.chart, din);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                readfile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Error err) {
            try {
                readfile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            readfile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chart = newChart;
        this.panel3d.do_openChart(this.chart);
    }

    public String createDrillTemplateName() {
        if (this.panel3d.parentChart == null) {
            this.panel3d.parentChart = this.chart;
        }
        this.isDrillDownDefined = this.panel3d.parentChart.drillDownVector.size() > 0;
        if (this.panel3d.parentChart.drillDownVector.size() <= 0) {
            return null;
        }
        int num = this.panel3d.parentChart.getDrillNumber() - 1;
        if (num < 0) {
            num = 0;
        }
        int index = this.panel3d.parentChart.drillTemplateName.indexOf(58);
        String drillTName = null;
        if (this.panel3d.parentChart.isDynamicDrillDown) {
            drillTName = index < 0 ? this.panel3d.parentChart.drillTemplatePath + this.panel3d.parentChart.drillTemplateName : this.panel3d.parentChart.drillTemplateName;
            if (!drillTName.endsWith(".tpl")) {
                drillTName = drillTName + ".tpl";
            }
        } else {
            drillTName = index < 0 ? this.panel3d.parentChart.drillTemplatePath + this.panel3d.parentChart.drillTemplateName + num + ".tpl" : this.panel3d.parentChart.drillTemplateName + num + ".tpl";
        }
        return drillTName;
    }

    public boolean doesTemplateFileExist(String file) {
        if (file == null) {
            return false;
        }
        if (!file.endsWith(".tpl")) {
            file = file + ".tpl";
        }
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream din = null;
        try {
            din = readfile.getInputStream(this.chart, file);
        }
        catch (Exception ex) {
            try {
                readfile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        try {
            readfile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public final int getDragModifier() {
        return this.dragMask;
    }

    public final int getDragClickCount() {
        return this.dragClickCount;
    }

    public final int getZoomModifier() {
        return this.zoomMask;
    }

    public final int getZoomClickCount() {
        return this.zoomClickCount;
    }

    public final int getResizeModifier() {
        return this.resizeMask;
    }

    public final int getResizeClickCount() {
        return this.resizeClickCount;
    }

    public final int getResizeCanvasModifier() {
        return this.resizeCanvasMask;
    }

    public final int getResizeCanvasClickCount() {
        return this.resizeCanvasClickCount;
    }

    public final int getForwardLinkModifier() {
        return this.forwLinkMask;
    }

    public final int getForwardLinkClickCount() {
        return this.forwLinkClickCount;
    }

    public final int getBackLinkModifier() {
        return this.backLinkMask;
    }

    public final int getBackLinkClickCount() {
        return this.backLinkClickCount;
    }

    public final int getUndoZoomModifier() {
        return this.undoZoomMask;
    }

    public final int getUndoZoomClickCount() {
        return this.undoZoomClickCount;
    }

    public final boolean areZoomEventsEnabled() {
        return this.handleZEvents;
    }

    public final boolean isDragEnabled() {
        return this.dragChart;
    }

    public final boolean isResizeEnabled() {
        return this.resizeChart;
    }

    public final boolean isResizeCanvasEnabled() {
        return this.resizeCanvas;
    }

    public final boolean isForwardLinkEnabled() {
        return this.goForwLink;
    }

    public final boolean isBackLinkEnabled() {
        return this.goBackLink;
    }

    public final void setDragModifier(int m) {
        this.dragMask = m;
    }

    public final void setDragClickCount(int c) {
        this.dragClickCount = c;
    }

    public final void setZoomModifier(int m) {
        this.zoomMask = m;
    }

    public final void setZoomClickCount(int c) {
        this.zoomClickCount = c;
    }

    public final void setResizeModifier(int m) {
        this.resizeMask = m;
    }

    public final void setResizeClickCount(int c) {
        this.resizeClickCount = c;
    }

    public final void setResizeCanvasModifier(int m) {
        this.resizeCanvasMask = m;
    }

    public final void setResizeCanvasClickCount(int c) {
        this.resizeCanvasClickCount = c;
    }

    public final void setForwardLinkModifier(int m) {
        this.forwLinkMask = m;
    }

    public final void setForwardLinkClickCount(int c) {
        this.forwLinkClickCount = c;
    }

    public final void setBackLinkModifier(int m) {
        this.backLinkMask = m;
    }

    public final void setBackLinkClickCount(int c) {
        this.backLinkClickCount = c;
    }

    public final void setUndoZoomModifier(int m) {
        this.undoZoomMask = m;
    }

    public final void setUndoZoomClickCount(int c) {
        this.undoZoomClickCount = c;
    }

    public final void setZoomEventsEnabled(boolean b) {
        this.handleZEvents = b;
    }

    public final void setDragEnabled(boolean b) {
        this.dragChart = b;
    }

    public final void setResizeEnabled(boolean b) {
        this.resizeChart = b;
    }

    public final void setResizeCanvasEnabled(boolean b) {
        this.resizeCanvas = b;
    }

    public final void setForwardLinkEnabled(boolean b) {
        this.goForwLink = b;
    }

    public final void setBackLinkEnabled(boolean b) {
        this.goBackLink = b;
    }

    void processZoomX(int currX, boolean isZoomIn) {
        int minXPix = this.chart.chartxorigin;
        int deltaXPix = this.chart.chartwidth;
        int maxXPix = minXPix + deltaXPix;
        if (currX < minXPix) {
            this.dx = this.lastx - minXPix;
            this.lastx = minXPix;
        } else if (currX > maxXPix) {
            this.dx = maxXPix - this.lastx;
        }
        if (this.dx < 0) {
            this.lastx = currX;
            this.dx = -this.dx;
        }
        float startX = (float)(this.lastx - minXPix) / (float)deltaXPix;
        float ratio = (float)this.dx / (float)deltaXPix;
        this.chart.setXZoom(startX, ratio, isZoomIn);
    }

    void processZoomY(int currY, boolean isZoomIn) {
        int maxYPix = this.chart.winHeight - this.chart.chartyorigin;
        int deltaYPix = this.chart.chartheight;
        int minYPix = maxYPix - deltaYPix;
        if (currY < minYPix) {
            this.dy = this.lasty - minYPix;
        } else if (currY > maxYPix) {
            this.dy = maxYPix - this.lasty;
            this.lasty = maxYPix;
        }
        if (this.dy < 0) {
            this.dy = -this.dy;
        } else {
            this.lasty = currY;
        }
        float ratio = (float)this.dy / (float)deltaYPix;
        float startY = 0.0f;
        startY = (float)(maxYPix - this.lasty) / (float)deltaYPix;
        this.chart.setYZoom(startY, ratio, isZoomIn);
    }

    private class ZoomHistory {
        Timestamp ts1 = null;
        Timestamp ts2 = null;
        String scaleValue = null;
        int scaleUnit = 0;
        boolean linearScale = false;

        ZoomHistory(Timestamp lb, Timestamp ub, String sValue, int sUnit, boolean lScale) {
            if (lb.before(ub)) {
                this.ts1 = lb;
                this.ts2 = ub;
            } else {
                this.ts1 = ub;
                this.ts2 = lb;
            }
            this.scaleValue = sValue;
            this.scaleUnit = sUnit;
            this.linearScale = lScale;
        }
    }
}

