/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.IOUtil2;
import quadbase.chart.LoadChart;
import quadbase.chart.ReadDataFile;
import quadbase.chartviewer.OurApplet;
import quadbase.chartviewer.ParamThread;
import quadbase.chartviewer.ReloadThread;
import quadbase.chartviewer.ViewPanel;
import quadbase.chartviewer.Viewer3DPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.QbUtil;
import quadbase.util.internal.TransposeRS;

public class Viewer
extends OurApplet {
    private static final Logger LOGGER = Logger.getLogger(Viewer.class.getName());
    int ctype;
    boolean is2DChart;
    String dburl;
    String username;
    String driver;
    String password;
    String query;
    String JNDIName;
    Hashtable<String, String> env;
    int source = 0;
    boolean loading = false;
    ReloadThread rThread = null;
    public Viewer3DPanel v3DPanel = null;
    long reloadTime = -1L;
    boolean binit = false;
    String filename = null;
    Socket serverSocket = null;
    int serverportno;
    InetAddress paramserver = null;
    ParamThread pThread = null;
    String sourceFile;
    public static final int LEFT_SINGLECLICK = 0;
    public static final int RIGHT_SINGLECLICK = 1;
    public static final int LEFT_DOUBLECLICK = 2;
    public static final int RIGHT_DOUBLECLICK = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void init() {
        Viewer.initJNLP();
        if (this.binit) {
            return;
        }
        this.binit = true;
        ServerMessage.setCheckMachineName(false);
        ChartServerUsed = this.getParameter("ChartServerUsed");
        if (ChartServerUsed != null) {
            ServerMessage.useServer = Viewer.getboolean(ChartServerUsed);
        }
        if ((EspressManagerUsed = this.getParameter("EspressManagerUsed")) != null) {
            ServerMessage.useServer = Viewer.getboolean(EspressManagerUsed);
        }
        if ((c_proto = this.getParameter("comm_protocol")) != null) {
            if (c_proto.equalsIgnoreCase("http")) {
                ServerMessage.useHttp();
            } else if (c_proto.equalsIgnoreCase("servlet")) {
                ServerMessage.useServlet();
            }
        }
        if ((comm_url = this.getParameter("comm_url")) != null) {
            if (ServerMessage.isServlet()) {
                ServerMessage.setConnectServlet(comm_url);
            } else {
                ServerMessage.setConnectURL(comm_url);
            }
        }
        if ((servletContext = this.getParameter("servlet_context")) != null) {
            ServerMessage.setServletContext(servletContext);
        }
        if ((address = this.getParameter("server_address")) != null) {
            try {
                ServerMessage.setAddress(address);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
        }
        if ((portno = this.getParameter("server_port_number")) != null) {
            try {
                portnumber = Integer.parseInt(portno);
                ServerMessage.setPortNumber(portnumber);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
        }
        if ((hosts = this.getParameter("server_hosts")) != null) {
            ServerMessage.setHosts(QbUtil.readMultiValues(hosts));
        }
        filename = this.getParameter("file");
        enc = this.getParameter("enc");
        if (filename != null && enc != null) {
            try {
                LanguageEncoder.loadFromServer(filename, enc);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        ServerMessage.setApplet(this);
        this.setBorderLayout();
        url = this.getParameter("filename");
        chartData = this.getParameter("ChartData");
        filename = url;
        navpanel = this.getParameter("navpanel");
        xRuler = this.getParameter("xAxisRuler");
        yRuler = this.getParameter("yAxisRuler");
        sRuler = this.getParameter("sAxisRuler");
        if (xRuler == null) {
            xRuler = "f";
        }
        if (yRuler == null) {
            yRuler = "f";
        }
        if (sRuler == null) {
            sRuler = "f";
        }
        sourceData = this.getParameter("sourceData");
        this.sourceFile = this.getParameter("sourceFile");
        sourceDB = this.getParameter("sourceDB");
        sourceJNDI = this.getParameter("sourceJNDI");
        dataMap = this.getParameter("dataMap");
        chartType = this.getParameter("chartType");
        mainTitle = this.getParameter("mainTitle");
        xTitle = this.getParameter("xTitle");
        yTitle = this.getParameter("yTitle");
        zTitle = this.getParameter("zTitle");
        reloadstr = this.getParameter("RefreshInterval");
        serverPortnoStr = this.getParameter("ParameterServer");
        transposeData = this.getParameter("transposeData");
        if (transposeData == null) {
            transposeData = "f";
        }
        dataHint = this.getParameter("ShowDataHint");
        showpanel = Viewer.getboolean(navpanel);
        showXRuler = Viewer.getboolean(xRuler);
        showYRuler = Viewer.getboolean(yRuler);
        showSRuler = Viewer.getboolean(sRuler);
        doTranspose = Viewer.getboolean(transposeData);
        transposeCol = this.getTransposeColumn(this.getParameter("transposedColumn"));
        if (transposeCol != null) {
            doTranspose = true;
        }
        colData = null;
        map = null;
        dbInfo = null;
        if (serverPortnoStr != null) {
            idx = serverPortnoStr.lastIndexOf(58);
            if (idx < 0) {
                this.error("No port no specify for the server !");
                return;
            }
            try {
                this.serverportno = Integer.parseInt(serverPortnoStr.substring(idx + 1));
                if (this.serverportno <= 0) {
                    throw new Exception("");
                }
            }
            catch (Exception ex) {
                this.error("Invalid value for ServerPortno. It must be an interger > 0.");
                return;
            }
            s = serverPortnoStr.substring(0, idx).trim();
            try {
                this.paramserver = s.equals("") ? InetAddress.getByName(this.getCodeBase().getHost()) : InetAddress.getByName(s);
            }
            catch (Exception ex) {
                this.error("Invalid parameter server name. \n" + IOUtil.getStackTrace(ex));
                return;
            }
        }
        if (reloadstr != null) {
            try {
                this.reloadTime = Long.parseLong(reloadstr);
                if (this.reloadTime <= 0L) {
                    throw new Exception("");
                }
            }
            catch (Exception ex) {
                this.error("Invalid value for RefreshInterval. It must be an integer > 0.");
                return;
            }
        }
        if (sourceData != null) {
            try {
                colData = IOUtil2.getColData(sourceData);
                if (!doTranspose) ** GOTO lbl167
                colData = ColData.getColData(TransposeRS.doTranspose(ColData.getResultSet(colData), transposeCol));
            }
            catch (Exception ex) {
                this.error("Failed to read data from parameter sourceData !\n" + IOUtil.getStackTrace(ex));
                return;
            }
        } else {
            if (this.sourceFile != null) {
                try {
                    colData = new DataFileInput().readProcessedData(this.sourceFile, doTranspose, transposeCol, null, null);
                    this.source = 2;
                }
                catch (Exception ex) {
                    this.error("Failed to read data from source data file !\n" + IOUtil.getStackTrace(ex));
                    return;
                }
            }
            if (sourceDB != null) {
                try {
                    this.getDataBaseInfo(sourceDB);
                }
                catch (Exception ex) {
                    this.error("Failed to get database connection information !\n" + IOUtil.getStackTrace(ex));
                    return;
                }
                try {
                    dbInfo = new DBInfoBasic(this.dburl, this.driver, this.username, this.password, this.query);
                    colData = DBAccess.retrieveResult(null, dbInfo, true, doTranspose, transposeCol, null, null);
                    this.source = 1;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.error("Failed to retrieve data from database !\n" + IOUtil.getStackTrace(ex));
                    return;
                }
            }
            if (sourceJNDI != null) {
                try {
                    this.getJNDIInfo(sourceJNDI);
                }
                catch (Exception ex) {
                    this.error("Failed to get JNDI DataSource information !\n" + IOUtil.getStackTrace(ex));
                    return;
                }
                try {
                    dbInfo = new DBInfoBasic(this.JNDIName, this.query, this.env);
                    colData = DBAccess.retrieveResult(null, dbInfo, true, doTranspose, transposeCol, null, null);
                    this.source = 1;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.error("Failed to retrieve data from database !\n" + IOUtil.getStackTrace(ex));
                    return;
                }
            }
        }
lbl167:
        // 7 sources

        if (colData != null) {
            if (dataMap == null) {
                this.error("Missing parameter dataMap !");
                return;
            }
            try {
                map = this.getDataMap(dataMap);
            }
            catch (Exception ex) {
                this.error("Incorrect dataMap parameters !\n" + IOUtil.getStackTrace(ex));
                return;
            }
            if (chartType == null) {
                this.error("Missing parameter chartType !");
                return;
            }
            try {
                this.getChartType(chartType);
            }
            catch (Exception ex) {
                this.error("Invalid chart Type !\n" + IOUtil.getStackTrace(ex));
                return;
            }
        }
        chart = null;
        readFile = new ReadDataFile();
        try {
            if (colData == null) {
                try {
                    chart = chartData != null ? new LoadChart().load(this, new DataInputStream(new ByteArrayInputStream(this.convertStringToByteArray(chartData))), false, null) : (IOUtil.isXMLFormat(url) ? readFile.createXMLChart(url, this) : new LoadChart().load(this, readFile.getInputStream(url), url.endsWith(".tpl"), null));
                }
                catch (Exception ex) {
                    this.error("Failed to load data from file " + url + ".\n" + IOUtil.getStackTrace(ex));
                    try {
                        readFile.close();
                    }
                    catch (Exception var43_61) {
                        // empty catch block
                    }
                    return;
                }
                this.source = chart.sourceData;
            } else {
                chart = Chart.createChart(this, this.ctype, this.is2DChart, null, colData);
                if (Chart.isCoordinateType(this.ctype)) {
                    chart.setDataColumn(map[0], -1, -1, -1, map[1], map[2], map[3], map[4], -1);
                } else if (chart.isHiLow()) {
                    chart.setDataColumn(map[0], map[1], -1, map[2], map[3], map[4], map[5], map[6], map[7]);
                } else {
                    chart.setDataColumn(map[0], map[1], map[2], map[3], -1, -1, -1, map[4], map[5]);
                }
                if (url != null) {
                    chart = chart.loadTemplate(url);
                }
                chart.sourceData = this.source;
                chart.sourceFile = this.sourceFile;
                chart.dbInfo = dbInfo;
            }
            if (mainTitle != null) {
                chart.setTitle(mainTitle);
            }
            if (xTitle != null) {
                chart.setAxisTitle(xTitle, 0);
            }
            if (yTitle != null) {
                chart.setAxisTitle(yTitle, 1);
            }
            if (zTitle != null) {
                chart.setAxisTitle(zTitle, 2);
            }
            if (dataHint == null) {
                showDataHint = chart.getShowDataState();
            } else {
                showDataHint = Viewer.getboolean(dataHint);
                chart.setShowDataState(showDataHint);
            }
            drawmode = this.getParameter("drawmode");
            if (drawmode != null && !chart.is2DChart) {
                if (drawmode.equalsIgnoreCase("flat")) {
                    chart.set3DDrawType(1);
                } else if (drawmode.equalsIgnoreCase("wireframe")) {
                    chart.set3DDrawType(0);
                } else if (drawmode.equalsIgnoreCase("flat border")) {
                    chart.set3DDrawType(2);
                } else if (drawmode.equalsIgnoreCase("gouraud")) {
                    chart.set3DDrawType(3);
                } else if (drawmode.equalsIgnoreCase("gouraud border")) {
                    chart.set3DDrawType(4);
                }
            }
        }
        catch (Exception ex) {
            this.error("Failed to create chart.\n " + IOUtil.getStackTrace(ex));
            return;
        }
        finally {
            try {
                readFile.close();
            }
            catch (Exception var43_62) {}
        }
        this.v3DPanel = new Viewer3DPanel(chart);
        this.v3DPanel.filename = filename;
        this.v3DPanel.setNavControl(showpanel);
        ruler = this.v3DPanel.getRuler();
        ruler.setVisibleXRuler(showXRuler);
        ruler.setVisibleYRuler(showYRuler);
        ruler.setVisibleSRuler(showSRuler);
        this.v3DPanel.setRuler(ruler);
        this.v3DPanel.hidepanel = showpanel == false;
        vp = this.v3DPanel.viewPanel;
        vp.btogglepanel = this.getDragVal("Toggle3DPanel");
        vp.resizeChart = this.getDragVal("resizeChart");
        vp.resizeCanvas = this.getDragVal("resizeCanvas");
        vp.dragChart = this.getDragVal("dragChart");
        vp.showLink = this.getDragVal("ShowLinkHint");
        vp.dataBgColor = this.getColor("DataHintBgColor", vp.dataBgColor);
        vp.dataFontColor = this.getColor("DataHintFontColor", vp.dataFontColor);
        vp.dataBorderColor = this.getColor("DataHintBorderColor", vp.dataBorderColor);
        vp.linkBgColor = this.getColor("LinkHintBgColor", vp.linkBgColor);
        vp.linkFontColor = this.getColor("LinkHintFontColor", vp.linkFontColor);
        vp.linkBorderColor = this.getColor("LinkHintBorderColor", vp.linkBorderColor);
        vp.dataFont = this.getFont("DataHintFont", CString.defaultFontForViewer);
        vp.linkFont = this.getFont("LinkHintFont", CString.defaultFontForViewer);
        hintX = this.getParameter("DataHintOffsetX");
        hintY = this.getParameter("DataHintOffsetY");
        if (hintX != null && hintY != null) {
            vp.setHintBoxOffset(new Dimension(Integer.parseInt(hintX), Integer.parseInt(hintY)));
        }
        hintX = this.getParameter("LinkHintOffsetX");
        hintY = this.getParameter("LinkHintOffsetY");
        if (hintX != null && hintY != null) {
            vp.setHyperLinkOffset(new Dimension(Integer.parseInt(hintX), Integer.parseInt(hintY)));
        }
        vp.printing = this.getDragVal("Printing");
        vp.refreshData = this.getDragVal("RefreshData");
        chart.setPopupMenuEnabled(this.getPopupOption("PopupMenu", chart.isPopupMenuEnabled()));
        chart.setTypeMenuEnabled(this.getPopupOption("TypeMenu", chart.isTypeMenuEnabled()));
        chart.setDimMenuEnabled(this.getPopupOption("DimensionMenu", chart.isDimMenuEnabled()));
        drillTplPath = this.getParameter("DrillDownTemplatePath");
        if (drillTplPath != null) {
            chart.drillTemplatePath = drillTplPath;
        }
        if (!chart.is2DChart) {
            this.v3DPanel.getControlPanel().setBackground(this.getColor("NavColor", Color.lightGray));
            this.v3DPanel.getControlPanel().setGouraudButton(this.getDragVal("GouraudButton"));
            this.v3DPanel.getControlPanel().setAnimateButton(this.getDragVal("AnimateButton"));
            this.v3DPanel.getControlPanel().setSpeedControl(this.getDragVal("SpeedControl"));
            this.v3DPanel.getControlPanel().setToolTipEnabled(this.getDragVal("ShowToolTip"));
            if (chart.isAutoRotate()) {
                this.v3DPanel.getControlPanel().setAnimationButtonOn(true);
            }
        }
        this.add("Center", this.v3DPanel);
        if (this.reloadTime <= 0L && !chart.disableSchedule) {
            this.reloadTime = chart.refreshInterval / 1000L;
        }
    }

    private byte[] convertStringToByteArray(String the_string) throws Exception {
        StringTokenizer st = new StringTokenizer(the_string);
        int count = st.countTokens();
        byte[] byte_array = new byte[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            byte_array[i] = (byte)Integer.parseInt(st.nextToken());
            ++i;
        }
        return byte_array;
    }

    private final Font getFont(String s, Font f) {
        try {
            s = this.getParameter(s);
            int idx1 = s.indexOf(44);
            int idx2 = s.lastIndexOf(44);
            return new Font(s.substring(0, idx1).trim(), Integer.parseInt(s.substring(idx1 + 1, idx2).trim()), Integer.parseInt(s.substring(idx2 + 1).trim()));
        }
        catch (Exception ex) {
            return f;
        }
    }

    private final Color getColor(String s, Color c) {
        try {
            return new Color(Integer.parseInt(this.getParameter(s), 16));
        }
        catch (Exception ex) {
            return c;
        }
    }

    private boolean getPopupOption(String s, boolean b) {
        if ((s = this.getParameter(s)) == null) {
            return b;
        }
        return s.equalsIgnoreCase("true");
    }

    final boolean getDragVal(String s) {
        return Viewer.getboolean(this.getParameter(s));
    }

    static final boolean getboolean(String s) {
        return s == null || s.equalsIgnoreCase("true");
    }

    private boolean[] getTransposeColumn(String s) {
        try {
            int ttype;
            if (s == null || s.equals("")) {
                return null;
            }
            Vector<Integer> vec = new Vector<Integer>();
            boolean i = false;
            int max = -1;
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            while ((ttype = st.nextToken()) != 10 && ttype != -1) {
                if (ttype == -2) {
                    if (st.nval > (double)max) {
                        max = (int)st.nval;
                    }
                    vec.addElement((int)st.nval);
                    continue;
                }
                throw new IllegalArgumentException("Format shall be \"n1 n2 n3 n4 ...\" where n1, n2..  . are integers");
            }
            if (max < 0) {
                return null;
            }
            boolean[] tmp = new boolean[max + 1];
            for (int j = 0; j < vec.size(); ++j) {
                tmp[((Integer)vec.elementAt((int)j)).intValue()] = true;
            }
            return tmp;
        }
        catch (Exception ex) {
            return null;
        }
    }

    void error(String s) {
        this.add("Center", new Label(s));
        System.out.println(s);
    }

    @Override
    public void start() {
        if (!this.binit) {
            this.init();
        }
        if (this.paramserver != null) {
            try {
                this.serverSocket = new Socket(this.paramserver, this.serverportno);
            }
            catch (Exception ex) {
                this.error("Failed to open socket for parameter server ! \n" + IOUtil.getStackTrace(ex));
                return;
            }
        }
        if (this.reloadTime > 0L && this.source != 0) {
            this.rThread = new ReloadThread(this);
            this.rThread.setTime(this.reloadTime * 1000L);
            this.rThread.start();
        }
        if (this.serverSocket != null) {
            this.pThread = new ParamThread(this.serverSocket, this.v3DPanel);
            this.pThread.start();
        }
    }

    @Override
    public void destroy() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        if (this.rThread != null) {
            this.rThread.pleaseStop();
            this.rThread = null;
        }
        if (this.v3DPanel != null) {
            this.v3DPanel.stopAnimation();
            ViewPanel vpanel = this.v3DPanel.viewPanel;
            vpanel.chart = null;
            vpanel.flushImage();
            vpanel.flushImage2();
        }
        if (this.pThread != null) {
            this.pThread.pleaseStop();
            this.pThread = null;
        }
        this.binit = false;
    }

    int[] getDataMap(String s) throws Exception {
        int ttype;
        int i;
        int[] val = new int[8];
        for (i = 0; i < 8; ++i) {
            val[i] = -1;
        }
        i = 0;
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        while ((ttype = st.nextToken()) != 10) {
            if (ttype == -1) {
                return val;
            }
            if (ttype == -2) {
                if (i >= 8) continue;
                val[i++] = (int)st.nval;
                continue;
            }
            throw new IllegalArgumentException("Format shall be \"n1 n2 n3 n4 ...\" where n1, n2... are integers");
        }
        return val;
    }

    void getChartType(String s) throws Exception {
        if ((s = s.trim()).length() < 6) {
            throw new IllegalArgumentException("No such type " + s);
        }
        String dim = s.substring(0, 2);
        if (dim.equalsIgnoreCase("2d")) {
            this.is2DChart = true;
        } else if (dim.equalsIgnoreCase("3d")) {
            this.is2DChart = false;
        } else {
            throw new IllegalArgumentException("Chart type must start with '2D'or '3D'");
        }
        String s2 = s.substring(3).trim();
        for (int i = 0; i < 21; ++i) {
            if (!s2.equalsIgnoreCase(Chart.stypeName[i])) continue;
            this.ctype = i;
            return;
        }
        throw new IllegalArgumentException("No such type " + s2);
    }

    void getDataBaseInfo(String info) throws IllegalArgumentException {
        int idx1 = info.indexOf(44);
        if (idx1 < 0) {
            throw new IllegalArgumentException("url name not find");
        }
        this.dburl = info.substring(0, idx1).trim();
        int idx2 = info.indexOf(44, idx1 + 1);
        if (idx2 < 0) {
            throw new IllegalArgumentException("driver name not find");
        }
        this.driver = info.substring(idx1 + 1, idx2).trim();
        idx1 = info.indexOf(44, idx2 + 1);
        if (idx1 < 0) {
            throw new IllegalArgumentException("user name not find");
        }
        this.username = info.substring(idx2 + 1, idx1).trim();
        idx2 = info.indexOf(44, idx1 + 1);
        if (idx2 < 0) {
            throw new IllegalArgumentException("password not find");
        }
        this.password = info.substring(idx1 + 1, idx2).trim();
        this.query = info.substring(idx2 + 1).trim();
    }

    void getJNDIInfo(String info) throws IllegalArgumentException {
        int idx1 = info.indexOf(44);
        if (idx1 < 0) {
            throw new IllegalArgumentException("JNDI name not find");
        }
        this.JNDIName = info.substring(0, idx1).trim();
        int idx2 = info.indexOf(44, idx1 + 1);
        if (idx2 < 0) {
            throw new IllegalArgumentException("INITIAL_CONTEXT_FACTORY not find");
        }
        String ctxFactory = info.substring(idx1 + 1, idx2).trim();
        idx1 = info.indexOf(44, idx2 + 1);
        if (idx1 < 0) {
            throw new IllegalArgumentException("PROVIDER_URL not find");
        }
        this.query = info.substring(idx1 + 1).trim();
        this.env = new Hashtable();
        this.env.put("java.naming.factory.initial", ctxFactory);
        this.env.put("java.naming.provider.url", ctxFactory);
    }

    void startThread() {
        if (this.pThread == null && this.serverSocket != null) {
            this.pThread = new ParamThread(this.serverSocket, this.v3DPanel);
            this.pThread.start();
        }
    }

    private static void initJNLP() {
        if (ServerMessage.isJnlp()) {
            Viewer.deleteJNLPFile();
            Viewer.registerJNLPSingleton();
        }
    }

    private static void deleteJNLPFile() {
        File jnlpFile;
        String jnlpPath = System.getProperty("jnlpx.origFilenameArg");
        if (jnlpPath != null && !(jnlpFile = new File(jnlpPath)).delete()) {
            LOGGER.warning("Failed to delete JNLP file " + jnlpPath);
        }
    }

    private static void registerJNLPSingleton() {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(new SingleInstanceListener(){

                public void newActivation(String[] strings) {
                    Viewer.deleteJNLPFile();
                }
            });
        }
        catch (UnavailableServiceException e) {
            LOGGER.log(Level.WARNING, "Failed to register SingleInstanceService", e);
        }
    }
}

