/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.chart.DrillDownInfo;
import quadbase.chart.GraphicsTable;
import quadbase.chart.PreprocInfo;
import quadbase.chart.ValueTable;
import quadbase.chartviewer.swing.DrillDownMenu;
import quadbase.chartviewer.swing.OurCheckboxMenuItem;
import quadbase.chartviewer.swing.OurMenu;
import quadbase.chartviewer.swing.OurMenuItem;
import quadbase.chartviewer.swing.OurMessageDialog;
import quadbase.chartviewer.swing.OurPopupMenu;
import quadbase.chartviewer.swing.Viewer3DPanel;
import quadbase.common.util.internal.LanguageEncoder;

class CPopupMenu
extends OurPopupMenu
implements ActionListener,
ItemListener {
    Viewer3DPanel panel3d;
    OurMenu dimMenu;
    OurMenu chartTypeMenu;
    OurMenu zoomScrollMenu;
    int[] typeMap;
    DrillDownMenu drillMenu;
    private boolean isReady = false;

    public CPopupMenu(Viewer3DPanel vp) {
        this.panel3d = vp;
        this.addMenu(vp.viewPanel.chart);
    }

    public void addMenu(Chart chart) {
        this.isReady = false;
        if (this.isDimMenuEnabled(chart)) {
            this.addDimMenu(chart);
        }
        if (this.isTypeMenuEnabled(chart)) {
            this.addTypeMenu(chart);
        }
        if (this.isZoomScrollMenuEnabled(chart)) {
            this.addZoomScrollMenu(chart);
        }
        this.drillMenu = new DrillDownMenu(this.panel3d);
        if (this.drillMenu.addDrillDownMenu()) {
            this.add(this.drillMenu);
        }
        this.addQueryMenuItem(chart);
        this.addZoomMenuItem(chart);
        this.addRefreshMenuItem();
        this.addBackMenuItem();
        if (this.getItemCount() == 1) {
            this.addSeparator();
        }
        this.isReady = true;
    }

    boolean isNonChangedType(int i) {
        return i == 10 || i == 9 || i == 2 || i == 12 || i == 13 || i == 18;
    }

    boolean isTypeMenuEnabled(Chart chart) {
        if (chart.isCatZoom() || chart.isValueZoom()) {
            return false;
        }
        if (this.isNonChangedType(chart.getChartType())) {
            return false;
        }
        return chart.isTypeMenuEnabled();
    }

    boolean isDimMenuEnabled(Chart chart) {
        if (chart.chartType == 14 || chart.chartType == 15 || chart.chartType == 17 || chart.chartType == 16 || chart.chartType == 13 || chart.chartType == 12 || chart.chartType == 18 || chart.chartType == 19) {
            return false;
        }
        return chart.isDimMenuEnabled();
    }

    boolean isZoomScrollMenuEnabled(Chart chart) {
        return chart.isZoomScrollEnabled();
    }

    void addTypeMenu(Chart chart) {
        int i;
        this.chartTypeMenu = new OurMenu("Type");
        Vector<Integer> typeVec = new Vector<Integer>();
        if (!this.panel3d.viewPanel.isDrillDownDefined && !this.panel3d.parentChart.isDynamicDrillDown && this.panel3d.zoomHistVector.size() == 0) {
            for (i = 0; i < Chart.stypeName.length; ++i) {
                if (this.isNonChangedType(i) || !chart.is2DimChart() && (i == 14 || i == 15 || i == 16 || i == 17 || i == 18 || i == 19) || chart.dataDim == 1 && Chart.stackType(i) || chart.dataDim > 2 && (!Chart.stackType(i) || i == 8)) continue;
                typeVec.addElement(i);
                this.chartTypeMenu.add(this.newCheckboxMenuItem(Chart.stypeName[i]));
            }
        } else if (this.panel3d.zoomHistVector.size() != 0 || chart.isTimeChart()) {
            for (i = 0; i < Chart.stypeName.length; ++i) {
                if (i == 1 || i == 5 || Chart.isCircularChart(i) || i == 8 || i == 2 || i == 15 || i == 17 || i == 16 || i == 18 || i == 19 || !chart.is2DimChart() && i == 14 || this.isNonChangedType(i) || chart.dataDim == 1 && Chart.stackType(i) || chart.dataDim > 2 && (!Chart.stackType(i) || i == 8)) continue;
                typeVec.addElement(i);
                this.chartTypeMenu.add(this.newCheckboxMenuItem(Chart.stypeName[i]));
            }
        } else if (this.panel3d.parentChart.getDrillNumber() > 0) {
            for (i = 0; i < Chart.stypeName.length; ++i) {
                if (!chart.is2DimChart() && (i == 14 || i == 16 || i == 17 || i == 19) || !DrillDownInfo.checkDrillDownType(i)) continue;
                typeVec.addElement(i);
                this.chartTypeMenu.add(this.newCheckboxMenuItem(Chart.stypeName[i]));
            }
        } else if (this.panel3d.parentChart.dataDim == 1) {
            for (i = 0; i < Chart.stypeName.length; ++i) {
                if (!chart.is2DimChart() && (i == 14 || i == 16 || i == 17 || i == 19) || !DrillDownInfo.checkDrillDownType(i) || Chart.stackType(i)) continue;
                typeVec.addElement(i);
                this.chartTypeMenu.add(this.newCheckboxMenuItem(Chart.stypeName[i]));
            }
        } else if (this.panel3d.parentChart.dataDim == 2) {
            for (i = 0; i < Chart.stypeName.length; ++i) {
                if (!chart.is2DimChart() && (i == 14 || i == 16 || i == 17 || i == 19) || !DrillDownInfo.checkDrillDownType(i) || i == 17) continue;
                typeVec.addElement(i);
                this.chartTypeMenu.add(this.newCheckboxMenuItem(Chart.stypeName[i]));
            }
        } else if (this.panel3d.parentChart.dataDim == 3) {
            for (i = 0; i < Chart.stypeName.length; ++i) {
                if (!chart.is2DimChart() && (i == 14 || i == 16 || i == 17 || i == 19) || !DrillDownInfo.checkDrillDownType(i) || !Chart.stackType(i)) continue;
                typeVec.addElement(i);
                this.chartTypeMenu.add(this.newCheckboxMenuItem(Chart.stypeName[i]));
            }
        }
        this.typeMap = new int[typeVec.size()];
        for (i = 0; i < typeVec.size(); ++i) {
            this.typeMap[i] = (Integer)typeVec.elementAt(i);
        }
        this.setChartTypeMenu(Chart.stypeName[chart.chartType]);
        this.add(this.chartTypeMenu);
    }

    void setChartTypeMenu(String newType) {
        for (int i = 0; i < this.typeMap.length; ++i) {
            if (newType.equals(Chart.stypeName[this.typeMap[i]])) {
                ((OurCheckboxMenuItem)this.chartTypeMenu.getItem(i)).setState(true);
                continue;
            }
            ((OurCheckboxMenuItem)this.chartTypeMenu.getItem(i)).setState(false);
        }
    }

    int findChartType(String newType) {
        for (int element : this.typeMap) {
            if (!newType.equals(Chart.stypeName[element])) continue;
            return element;
        }
        return 0;
    }

    void addDimMenu(Chart chart) {
        this.dimMenu = new OurMenu("2D/3D");
        this.dimMenu.add(this.newCheckboxMenuItem("2D"));
        this.dimMenu.add(this.newCheckboxMenuItem("3D"));
        this.setDimMenu(chart.is2DimChart());
        this.add(this.dimMenu);
    }

    void setDimMenu(boolean is2DChart) {
        ((OurCheckboxMenuItem)this.dimMenu.getItem(0)).setState(is2DChart);
        ((OurCheckboxMenuItem)this.dimMenu.getItem(1)).setState(!is2DChart);
    }

    void addZoomScrollMenu(Chart chart) {
        this.zoomScrollMenu = new OurMenu("Enable Zoom");
        this.zoomScrollMenu.add(this.newCheckboxMenuItem("X-Axis"));
        this.zoomScrollMenu.add(this.newCheckboxMenuItem("Y-Axis"));
        this.zoomScrollMenu.add(this.newCheckboxMenuItem("Both Axis"));
        this.setZoomScrollMenu(chart.getZoomOption());
        this.add(this.zoomScrollMenu);
    }

    void setZoomScrollMenu(int option) {
        ((OurCheckboxMenuItem)this.zoomScrollMenu.getItem(0)).setState(option == 0);
        ((OurCheckboxMenuItem)this.zoomScrollMenu.getItem(1)).setState(option == 1);
        ((OurCheckboxMenuItem)this.zoomScrollMenu.getItem(2)).setState(option == 2);
    }

    void addQueryMenuItem(Chart chart) {
        if (chart.getQueryFileInfo() == null) {
            return;
        }
        this.add(this.newMenuItem("Query Parameter"));
    }

    void addZoomMenuItem(Chart chart) {
        int categoryType = chart.getCategoryType();
        if (!(categoryType != 91 && categoryType != 92 && categoryType != 93 || !chart.isTimeChart() || this.panel3d.viewPanel.isDrillDownDefined || this.panel3d.parentChart.isDynamicDrillDown)) {
            this.add(this.newMenuItem("Zoom"));
        }
    }

    void addBackMenuItem() {
        if (this.panel3d.viewPanel.isDrillDownDefined && this.panel3d.parentChart.getDrillNumber() > 0 || this.panel3d.linkhistory.size() > 0 || this.panel3d.zoomHistVector.size() > 0) {
            this.addSeparator();
            this.add(this.newMenuItem("Back"));
        }
    }

    void addRefreshMenuItem() {
        if (this.panel3d.viewPanel.refreshData) {
            this.addSeparator();
            this.add(this.newMenuItem("Refresh"));
        }
    }

    OurMenuItem newMenuItem(String s) {
        OurMenuItem m = new OurMenuItem(s);
        m.addActionListener(this);
        return m;
    }

    OurCheckboxMenuItem newCheckboxMenuItem(String s) {
        OurCheckboxMenuItem m = new OurCheckboxMenuItem(s);
        m.addItemListener(this);
        return m;
    }

    void changeChartType(int newchartType, boolean isnew2DChart) {
        if (newchartType != this.panel3d.viewPanel.chart.chartType && (Chart.isCircularChart(newchartType) || Chart.isCircularChart(this.panel3d.viewPanel.chart.chartType) || newchartType == 17 || this.panel3d.viewPanel.chart.chartType == 17) && !OurMessageDialog.showYesNoDialog(this.panel3d.viewPanel, true, LanguageEncoder.getText("Warning"), "Attributes of chart may be lost, continue?")) {
            return;
        }
        this.panel3d.viewPanel.chart.gt.keepPosition = true;
        this.panel3d.viewPanel.chart.gt.cBorder = null;
        if (this.panel3d.viewPanel.isDrillDownDefined && this.panel3d.parentChart.getDrillNumber() > 0) {
            this.changeDrillDownChartType(newchartType, isnew2DChart);
        } else {
            try {
                ValueTable valueTableSave = this.panel3d.viewPanel.chart.valueTable;
                GraphicsTable.recoverTableSize(this.panel3d.viewPanel.chart);
                int w = 0;
                int h = 0;
                this.panel3d.viewPanel.chart = Chart.createChart(this.panel3d.viewPanel, newchartType, isnew2DChart, this.panel3d.viewPanel.chart, null, this.panel3d.viewPanel.chart.usedColumns);
                w = this.panel3d.viewPanel.chart.gt.tableWidth;
                h = this.panel3d.viewPanel.chart.gt.tableHeight;
                if (this.panel3d.viewPanel.chart.showTable()) {
                    Dimension k = this.panel3d.viewPanel.chart.getSize();
                    this.panel3d.viewPanel.chart.gt.clear = true;
                    this.panel3d.viewPanel.chart.gt.shift = false;
                    this.panel3d.viewPanel.chart.gt.select_axis = 0;
                    this.panel3d.viewPanel.chart.gt.setData(this.panel3d.viewPanel.chart, this.panel3d.viewPanel.chart.mData);
                    if (this.panel3d.viewPanel.chart.gt.direction == 2) {
                        this.panel3d.viewPanel.chart.gt.height = 10000;
                    } else {
                        this.panel3d.viewPanel.chart.gt.width = 10000;
                    }
                    this.panel3d.viewPanel.chart.gt.tableWidth = w;
                    this.panel3d.viewPanel.chart.gt.tableHeight = h;
                    this.panel3d.viewPanel.chart.gt.draw = false;
                    this.panel3d.viewPanel.chart.gt.firstShown = true;
                    this.panel3d.viewPanel.chart.gt.paint();
                    this.panel3d.viewPanel.chart.gt.draw = true;
                    this.panel3d.viewPanel.setSize(k);
                    this.panel3d.viewPanel.chart.setSize(k);
                }
                if (valueTableSave != null) {
                    this.panel3d.viewPanel.chart.valueTable = new ValueTable(this.panel3d.viewPanel.chart, valueTableSave);
                }
            }
            catch (IllegalArgumentException e) {
                String message = e.getMessage() == null ? "Not enough data to plot" : e.getMessage();
                OurMessageDialog.showWarning(this.panel3d.viewPanel, true, message);
                return;
            }
            this.panel3d.parentChart = this.panel3d.viewPanel.chart;
            if (this.panel3d.chartHolder != null) {
                this.panel3d.chartHolder.setChartHolder(this.panel3d.viewPanel.chart);
            }
            this.panel3d.do_openChart(this.panel3d.viewPanel.chart);
        }
        this.panel3d.viewPanel.repaint();
    }

    void changeDrillDownChartType(int newchartType, boolean isnew2DChart) {
        this.panel3d.parentChart.decrementDrillNumber();
        int[] map = this.panel3d.parentChart.getDrillDownMap();
        int[] oldMap = this.panel3d.parentChart.getDrillDownMap();
        int dim = this.panel3d.parentChart.getDrillDownDimension();
        int oldDim = this.panel3d.parentChart.getDrillDownDimension();
        int oldType = this.panel3d.parentChart.getDrillDownType();
        boolean isDrillDown2D = this.panel3d.parentChart.isDrillDown2D();
        String tplName = null;
        if (newchartType != this.panel3d.viewPanel.chart.chartType) {
            if (dim == 1 && Chart.stackType(newchartType)) {
                if (map.length >= 3) {
                    dim = 3;
                } else if (map.length == 2) {
                    dim = 2;
                    if (this.panel3d.viewPanel.chart.chartType == 17) {
                        int tempMap = map[0];
                        map[0] = map[1];
                        map[1] = tempMap;
                    }
                } else {
                    dim = 2;
                    int[] map2 = new int[]{map[0], map[0]};
                    map = map2;
                }
            } else if (newchartType == 17) {
                dim = 1;
                if (this.panel3d.viewPanel.chart.isStackType() && map.length == 2) {
                    if (map[0] == map[1]) {
                        int[] map2 = new int[]{map[0]};
                        map = map2;
                    } else {
                        int tempMap = map[0];
                        map[0] = map[1];
                        map[1] = tempMap;
                    }
                }
            } else if (this.panel3d.viewPanel.chart.isStackType() != Chart.stackType(newchartType)) {
                if (dim == 2 && map.length >= 3 && !this.panel3d.viewPanel.chart.isStackType()) {
                    dim = 3;
                } else if (dim == 2) {
                    if (map[0] == map[1]) {
                        dim = 1;
                        int[] map2 = new int[]{map[0]};
                        map = map2;
                    } else {
                        int tempMap = map[0];
                        map[0] = map[1];
                        map[1] = tempMap;
                    }
                } else if (dim == 3) {
                    dim = 2;
                }
            } else if (dim == 1 && map.length >= 2) {
                dim = 2;
            }
        }
        this.panel3d.parentChart.modifyDrillDown(this.panel3d.parentChart.getDrillNumber(), newchartType, map, dim, isnew2DChart);
        int cType = newchartType;
        boolean dType = isnew2DChart;
        int valCol = this.panel3d.parentChart.getValueMap();
        int subvalCol = this.panel3d.parentChart.getSubValueMap();
        if (this.panel3d.parentChart.summaryChart) {
            valCol = this.panel3d.parentChart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = this.panel3d.parentChart.originalMap[subvalCol];
            }
        }
        PreprocInfo tsInfo = this.panel3d.drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, this.panel3d.parentChart.primaryAggregate, this.panel3d.parentChart.secondaryAggregate);
        ValueTable valueTableSave = this.panel3d.viewPanel.chart.valueTable;
        Chart tempChart = Chart.createChart(this.panel3d.viewPanel, cType, dType, null, this.panel3d.drillHistory.currentDrill(tsInfo), null);
        tempChart.setSubFilesTable(this.panel3d.parentChart.getSubFilesTable());
        if (tempChart.notEnoughData()) {
            OurMessageDialog.showWarning(this.panel3d.viewPanel, true, "Not enough data available to plot");
            this.panel3d.parentChart.modifyDrillDown(this.panel3d.parentChart.getDrillNumber(), oldType, oldMap, oldDim, isDrillDown2D);
            this.panel3d.parentChart.incrementDrillNumber();
            return;
        }
        this.panel3d.viewPanel.chart = tempChart;
        this.panel3d.drillHistory.setChartType(this.panel3d.viewPanel.chart, tsInfo);
        this.panel3d.parentChart.incrementDrillNumber();
        if (valueTableSave != null) {
            this.panel3d.viewPanel.chart.valueTable = new ValueTable(this.panel3d.viewPanel.chart, valueTableSave);
        }
        if (this.panel3d.viewPanel.doesTemplateFileExist(tplName = this.panel3d.viewPanel.createDrillTemplateName())) {
            this.panel3d.viewPanel.do_loadTemplate(tplName);
        } else {
            this.panel3d.do_openChart(this.panel3d.viewPanel.chart);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String menustr = ((OurMenuItem)e.getSource()).getLabel();
        if (menustr.equals("Back")) {
            if (this.panel3d.parentChart.getDrillNumber() > 0) {
                this.panel3d.isBack = true;
                this.panel3d.viewPanel.previousDrillDown();
                this.panel3d.viewPanel.paint();
            } else if (this.panel3d.zoomHistVector.size() > 0) {
                this.panel3d.viewPanel.zoomUndo();
            } else if (this.panel3d.linkhistory.size() > 0) {
                this.panel3d.viewPanel.goBackHyperLink();
            }
        } else if (menustr.equals("Zoom")) {
            this.panel3d.viewPanel.do_Zoom();
        } else if (menustr.equals("Query Parameter")) {
            this.panel3d.viewPanel.do_Query();
        } else if (menustr.equals("Refresh")) {
            this.panel3d.viewPanel.do_Refresh();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isReady) {
            return;
        }
        String menustr = ((OurCheckboxMenuItem)e.getSource()).getLabel();
        int chartType = this.panel3d.viewPanel.chart.chartType;
        boolean is2D = this.panel3d.viewPanel.chart.is2DimChart();
        boolean menuState = ((OurCheckboxMenuItem)e.getSource()).getState();
        if (menustr.equals("2D")) {
            is2D = true;
        } else if (menustr.equals("3D")) {
            is2D = false;
        } else if (menustr.equals("X-Axis")) {
            this.panel3d.viewPanel.chart.setZoomOption(menuState ? 0 : -1);
        } else if (menustr.equals("Y-Axis")) {
            this.panel3d.viewPanel.chart.setZoomOption(menuState ? 1 : -1);
            this.panel3d.viewPanel.initBackImage(false);
            if (menuState) {
                this.panel3d.viewPanel.chart.setTickerWidth(1, 15);
            }
        } else if (menustr.equals("Both Axis")) {
            this.panel3d.viewPanel.chart.setZoomOption(menuState ? 2 : -1);
            if (menuState) {
                this.panel3d.viewPanel.chart.setTickerWidth(1, 15);
            }
        } else {
            chartType = this.findChartType(menustr);
        }
        this.changeChartType(chartType, is2D);
    }
}

