/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.chart.Chart;
import quadbase.chart.chart3d.lib3d.HiddenSurface;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chartviewer.swing.JDSlider;
import quadbase.chartviewer.swing.NavigatePanel;
import quadbase.chartviewer.swing.ViewPanel;
import quadbase.chartviewer.swing.Viewer3DPanel;
import quadbase.chartviewer.swing.YASpeedMeter;
import quadbase.chartviewer.swing.ZoomMeter;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class ControlPanel
extends JPanel
implements ActionListener,
ChangeListener {
    static final int INIT_ZOOM = 20;
    double increment = 0.10471975511965977;
    int movement = 33;
    boolean rotateMode = true;
    boolean showToolTip = true;
    JTabbedPane tabbedPane;
    JPanel buttonPanel;
    JPanel navzoomPanel;
    JToggleButton animateButton;
    JToggleButton frameButton;
    JToggleButton borderButton;
    JToggleButton gouraudButton;
    JToggleButton inLineSeriesButton;
    JDSlider xscale_bar;
    JDSlider yscale_bar;
    JDSlider zscale_bar;
    JDSlider thickness_bar;
    JSlider xlight_bar;
    JSlider ylight_bar;
    JSlider zlight_bar;
    NavigatePanel navigateButton;
    ZoomMeter zoomMeter;
    YASpeedMeter speedMeter;
    JDSlider slideBar;
    ViewPanel viewPanel;
    Viewer3DPanel v3DPanel;

    public ControlPanel(Viewer3DPanel vp3d, ViewPanel vp) {
        this.viewPanel = vp;
        this.v3DPanel = vp3d;
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.navzoomPanel = new JPanel();
        this.navzoomPanel.setLayout(new FlowLayout());
        Chart chart = this.v3DPanel.getChart();
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new GridLayout(1, 4));
        Dimension dim = new Dimension(20, 70);
        this.xscale_bar = new JDSlider(1, 0.01, 5.0, 1.0);
        scalePanel.add(this.xscale_bar);
        this.xscale_bar.setPreferredSize(dim);
        this.yscale_bar = new JDSlider(1, 0.01, 5.0, 1.0);
        scalePanel.add(this.yscale_bar);
        this.yscale_bar.setPreferredSize(dim);
        this.zscale_bar = new JDSlider(1, 0.01, 5.0, 1.0);
        scalePanel.add(this.zscale_bar);
        this.zscale_bar.setPreferredSize(dim);
        this.thickness_bar = new JDSlider(1, 0.333, 3.0, 1.0);
        scalePanel.add(this.thickness_bar);
        this.thickness_bar.setPreferredSize(dim);
        this.setXScale();
        this.setZScale();
        this.setYScale();
        this.setThickScale();
        this.slideBar = new JDSlider(1, 0.0, 1000.0, 0.0);
        this.navzoomPanel.add(this.slideBar);
        this.slideBar.setPreferredSize(dim);
        this.xlight_bar = new JSlider(1, -2000, 2000, 0);
        this.navzoomPanel.add(this.xlight_bar);
        this.xlight_bar.setPreferredSize(dim);
        this.ylight_bar = new JSlider(1, -2000, 2000, 0);
        this.navzoomPanel.add(this.ylight_bar);
        this.ylight_bar.setPreferredSize(dim);
        this.zlight_bar = new JSlider(1, -2000, 2000, 0);
        this.navzoomPanel.add(this.zlight_bar);
        this.zlight_bar.setPreferredSize(dim);
        this.xlight_bar.setValue((int)chart.getlightpos_x());
        this.ylight_bar.setValue((int)chart.getlightpos_y());
        this.zlight_bar.setValue((int)chart.getlightpos_z());
        this.navigateButton = new NavigatePanel(50, 50);
        this.navzoomPanel.add(this.navigateButton);
        this.navigateButton.addActionListener(this);
        this.zoomMeter = new ZoomMeter(80, 40, 0.0, 100.0, 20);
        this.navzoomPanel.add(this.zoomMeter);
        this.zoomMeter.addActionListener(this);
        this.navzoomPanel.add(scalePanel);
        this.speedMeter = new YASpeedMeter(0.0017453292519943296, 0.3141592653589793);
        this.speedMeter.addActionListener(this);
        this.setSpeedMeter();
        this.slideBar.setDValue(1000.0 * (this.increment - 0.002) / 0.3121592653589793);
        this.setZoomMeter();
        this.frameButton = new JToggleButton();
        this.addNewButton(this.frameButton, LanguageEncoder.getText("Toggle between wireframe and solid mode"), "nav_frame");
        this.animateButton = new JToggleButton();
        this.addNewButton(this.animateButton, LanguageEncoder.getText("Toggle on/off animation"), "nav_animate");
        this.borderButton = new JToggleButton();
        this.addNewButton(this.borderButton, LanguageEncoder.getText("Toggle on/off border drawing"), "nav_flatFrame");
        this.inLineSeriesButton = new JToggleButton();
        this.addNewButton(this.inLineSeriesButton, LanguageEncoder.getText("Toggle on/off draw series in-line"), "nav_inLineSeries");
        this.gouraudButton = new JToggleButton();
        this.addNewButton(this.gouraudButton, LanguageEncoder.getText("Toggle on/off gouraud shading"), "nav_gouraud");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 5));
        this.buttonPanel.add(this.frameButton);
        this.buttonPanel.add(this.borderButton);
        if (this.isInLineSeriesEnabled(chart)) {
            this.buttonPanel.add(this.inLineSeriesButton);
            this.inLineSeriesButton.setSelected(chart.isDrawSeriesOnCategoryAxis());
        }
        this.buttonPanel.add(this.animateButton);
        this.buttonPanel.add(this.speedMeter);
        this.tabbedPane = new JTabbedPane(2);
        this.tabbedPane.add("A", this.navzoomPanel);
        this.tabbedPane.add("B", this.buttonPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabbedPane);
        if (this.isToolTipEnabled()) {
            this.xscale_bar.setToolTipText("Scaling in X dimension");
            this.yscale_bar.setToolTipText("Scaling in Y dimension");
            this.zscale_bar.setToolTipText("Scaling in Z dimension");
            this.xlight_bar.setToolTipText("Light X position");
            this.ylight_bar.setToolTipText("Light Y position");
            this.zlight_bar.setToolTipText("Light Z position");
            this.thickness_bar.setToolTipText("Thickness of shape");
            this.slideBar.setToolTipText("Adjust step size of navigation");
            this.navigateButton.setToolTipText("Navigation - Press the center button to toggle between rotation and translation");
            this.zoomMeter.setToolTipText("Zoom in / Zoom out");
            this.speedMeter.setToolTipText("Speed of Animation");
            this.frameButton.setToolTipText("Toggle between wireframe and solid mode");
            this.borderButton.setToolTipText("Toggle on/off border drawing");
            this.inLineSeriesButton.setToolTipText("Toggle on/off draw series in-line");
            this.gouraudButton.setToolTipText("Toggle on/off Gouraud Shading");
            this.animateButton.setToolTipText("Toggle on/off animation");
        }
        this.slideBar.addChangeListener(this);
        this.xlight_bar.addChangeListener(this);
        this.ylight_bar.addChangeListener(this);
        this.zlight_bar.addChangeListener(this);
        this.xscale_bar.addChangeListener(this);
        this.yscale_bar.addChangeListener(this);
        this.zscale_bar.addChangeListener(this);
        this.thickness_bar.addChangeListener(this);
        this.setDrawMode();
    }

    public void setToolTipEnabled(boolean show) {
        this.showToolTip = show;
    }

    public boolean isToolTipEnabled() {
        return this.showToolTip;
    }

    private boolean isInLineSeriesEnabled(Chart chart) {
        int i = chart.getChartType();
        int dataDim = chart.getDataDimension();
        return (i == 0 || i == 1) && dataDim > 1 || (i == 4 || i == 5 || i == 11) && dataDim > 2;
    }

    void updatePanel() {
        boolean isButtonExisted = ControlPanel.findComponent(this.buttonPanel, this.inLineSeriesButton);
        if (this.isInLineSeriesEnabled(this.v3DPanel.getChart())) {
            if (!isButtonExisted) {
                boolean bG;
                boolean bA = this.getAnimateButton();
                if (bA) {
                    this.buttonPanel.remove(this.animateButton);
                }
                if (bG = this.getGouraudButton()) {
                    this.buttonPanel.remove(this.gouraudButton);
                }
                this.buttonPanel.add(this.inLineSeriesButton);
                if (bG) {
                    this.buttonPanel.add(this.gouraudButton);
                }
                if (bA) {
                    this.buttonPanel.add(this.animateButton);
                }
            }
            this.inLineSeriesButton.setSelected(this.v3DPanel.getChart().isDrawSeriesOnCategoryAxis());
        } else if (isButtonExisted) {
            this.buttonPanel.remove(this.inLineSeriesButton);
        } else {
            return;
        }
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    private void addNewButton(JToggleButton newBtn, String tip, String img) {
        img = ServerMessage.imagesPath + img + ".gif";
        try {
            this.setIcon(newBtn, img);
        }
        catch (Exception e) {
            System.out.println("error loading image icon [" + img + "], error [" + e.getMessage() + "]");
        }
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
    }

    void setIcon(AbstractButton b, String img) throws MalformedURLException {
        b.setIcon(IOUtil.getImageIcon(img));
    }

    public void setAnimateButton(boolean show) {
        if (show != this.getAnimateButton()) {
            if (show) {
                this.buttonPanel.add(this.animateButton);
            } else {
                this.buttonPanel.remove(this.animateButton);
            }
            this.buttonPanel.validate();
            this.buttonPanel.repaint();
        }
    }

    public boolean getAnimateButton() {
        return ControlPanel.findComponent(this.buttonPanel, this.animateButton);
    }

    public void setAnimationButtonOn(boolean on) {
        if (on) {
            this.v3DPanel.hideText();
            this.viewPanel.animation = true;
            this.viewPanel.stop();
            this.viewPanel.start();
            this.setEnableNavControl(false);
        } else {
            this.v3DPanel.stopAnimation();
        }
    }

    public void setSpeedControl(boolean show) {
        if (show != this.getSpeedControl()) {
            if (show) {
                this.navzoomPanel.add(this.speedMeter);
            } else {
                this.navzoomPanel.remove(this.speedMeter);
            }
            this.navzoomPanel.validate();
            this.navzoomPanel.repaint();
        }
    }

    public boolean getSpeedControl() {
        return ControlPanel.findComponent(this.navzoomPanel, this.speedMeter);
    }

    public void setGouraudButton(boolean show) {
        if (show) {
            boolean b = this.getAnimateButton();
            if (b) {
                this.buttonPanel.remove(this.animateButton);
            }
            this.buttonPanel.add(this.gouraudButton);
            if (b) {
                this.buttonPanel.add(this.animateButton);
            }
        } else {
            this.buttonPanel.remove(this.gouraudButton);
        }
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    static boolean findComponent(Container container, Component comp) {
        Component[] comps;
        for (Component comp2 : comps = container.getComponents()) {
            if (comp2 != comp) continue;
            return true;
        }
        return false;
    }

    public boolean getGouraudButton() {
        return ControlPanel.findComponent(this.buttonPanel, this.gouraudButton);
    }

    public void setDrawMode() {
        int tp = this.v3DPanel.getChart().get3DDrawType();
        this.frameButton.setSelected(tp == 0);
        this.borderButton.setSelected(tp == 4 || tp == 2);
        this.gouraudButton.setSelected(tp == 3 || tp == 4);
    }

    public void setZoomMeter() {
        this.zoomMeter.setValue(20.0);
    }

    public void setSpeedMeter() {
        this.speedMeter.setValue(this.v3DPanel.getChart().getAnimateSpeed());
    }

    public void setXScale() {
        this.xscale_bar.setDValue(this.v3DPanel.getChart().getX_scale());
    }

    public void setYScale() {
        this.yscale_bar.setDValue(this.v3DPanel.getChart().getY_scale());
    }

    public void setZScale() {
        this.zscale_bar.setDValue(this.v3DPanel.getChart().getZ_scale());
    }

    public void setThickScale() {
        this.thickness_bar.setDValue(this.v3DPanel.getChart().thickRatio);
    }

    public void setEnableNavControl(boolean state) {
        this.navigateButton.setEnabled(state);
        this.zoomMeter.setEnabled(state);
        this.xscale_bar.setEnabled(state);
        this.yscale_bar.setEnabled(state);
        this.zscale_bar.setEnabled(state);
        this.xlight_bar.setEnabled(state);
        this.ylight_bar.setEnabled(state);
        this.zlight_bar.setEnabled(state);
        this.thickness_bar.setEnabled(state);
        this.frameButton.setEnabled(state);
        this.borderButton.setEnabled(state);
        this.inLineSeriesButton.setEnabled(state);
        this.gouraudButton.setEnabled(state);
        this.setZoomMeter();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Chart chart = this.v3DPanel.getChart();
        Object target = e.getSource();
        if (target == this.navigateButton) {
            int argument = e.getID();
            if (argument == 0 || argument == 1 || argument == 2 || argument == 3) {
                this.navigate(argument);
            } else if (argument == 4) {
                this.rotateMode = false;
                this.slideBar.setDValue(1000 * (this.movement - 5) / 995);
            } else if (argument == 9) {
                this.slideBar.setDValue(1000.0 * (this.increment - 0.002) / 0.3121592653589793);
                this.rotateMode = true;
            }
        } else if (target == this.zoomMeter) {
            this.v3DPanel.zooming(this.zoomMeter.getValue());
        } else if (target == this.speedMeter) {
            chart.setAnimateSpeed(this.speedMeter.getValue());
        } else if (target == this.gouraudButton) {
            if (this.gouraudButton.isSelected()) {
                if (this.borderButton.isSelected()) {
                    chart.set3DDrawType(4);
                } else {
                    chart.set3DDrawType(3);
                }
            } else {
                chart.set3DDrawType(2);
            }
            this.setDrawMode();
            this.viewPanel.repaint();
        } else if (target == this.borderButton) {
            if (!this.borderButton.isSelected()) {
                if (this.gouraudButton.isSelected()) {
                    chart.set3DDrawType(3);
                } else {
                    chart.set3DDrawType(1);
                }
            } else if (this.gouraudButton.isSelected()) {
                chart.set3DDrawType(4);
            } else {
                chart.set3DDrawType(2);
            }
            this.setDrawMode();
            this.viewPanel.repaint();
        } else if (target == this.frameButton) {
            if (this.frameButton.isSelected()) {
                chart.set3DDrawType(0);
            } else if (this.borderButton.isSelected()) {
                if (this.gouraudButton.isSelected()) {
                    chart.set3DDrawType(4);
                } else {
                    chart.set3DDrawType(2);
                }
            } else if (this.gouraudButton.isSelected()) {
                chart.set3DDrawType(3);
            } else {
                chart.set3DDrawType(1);
            }
            this.setDrawMode();
            this.viewPanel.repaint();
        } else if (target == this.inLineSeriesButton) {
            chart.setDrawSeriesOnCategoryAxis(this.inLineSeriesButton.isSelected());
            this.viewPanel.repaint();
        } else if (target == this.animateButton) {
            this.setAnimationButtonOn(this.animateButton.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Chart chart = this.v3DPanel.getChart();
        Object target = e.getSource();
        if (target == this.slideBar) {
            if (this.rotateMode) {
                this.increment = 0.002 + this.slideBar.getDValue() * 0.3121592653589793 / 1000.0;
            } else {
                this.movement = (int)(5.0 + this.slideBar.getDValue() * 995.0 / 1000.0);
            }
        } else if (target == this.thickness_bar) {
            chart.thickRatio = (float)this.thickness_bar.getDValue();
            if (chart.gethiddenSurface() != null) {
                ((HiddenSurface)chart.gethiddenSurface()).reset();
            }
            this.viewPanel.redoOffScreenImage();
            this.viewPanel.repaint();
        } else if (target == this.xlight_bar || target == this.ylight_bar || target == this.zlight_bar) {
            float[] f = new float[]{this.xlight_bar.getValue(), this.ylight_bar.getValue(), this.zlight_bar.getValue()};
            chart.setLightPos(f);
            this.viewPanel.repaint();
        } else if (target == this.xscale_bar || target == this.yscale_bar || target == this.zscale_bar) {
            chart.scaleSpace((float)this.xscale_bar.getDValue(), (float)this.yscale_bar.getDValue(), (float)this.zscale_bar.getDValue());
            if (chart.gethiddenSurface() != null) {
                ((HiddenSurface)chart.gethiddenSurface()).reset();
            }
            this.viewPanel.redoOffScreenImage();
            this.viewPanel.repaint();
        }
    }

    public void navigate(int direction) {
        this.navigate(this.rotateMode, direction, this.increment, this.movement);
        this.viewPanel.repaint();
    }

    public void navigate(boolean rotateMode, int step, int direction) {
        double inc = 0.0;
        int mov = 0;
        if (rotateMode) {
            inc = 0.002 + (double)step * 0.3121592653589793 / 1000.0;
        } else {
            mov = 5 + step * 995 / 1000;
        }
        this.navigate(rotateMode, direction, inc, mov);
    }

    public void navigate(boolean rotateMode, int direction, double increment, int movement) {
        Chart chart = this.v3DPanel.getChart();
        Space space = (Space)chart.getSpace();
        float scale = space.spaceScale;
        double alpha = Math.atan2(-space.viewVec.k, -space.viewVec.i);
        double theta = Math.asin(-space.viewVec.j);
        switch (direction) {
            case 0: {
                if (rotateMode) {
                    if (!((theta -= increment) < -1.5707963267948966)) break;
                    theta = -1.5702963267948966;
                    break;
                }
                chart.translateSpace(0.0f, movement, 0.0f);
                break;
            }
            case 1: {
                if (rotateMode) {
                    if (!((theta += increment) > 1.5707963267948966)) break;
                    theta = 1.5702963267948966;
                    break;
                }
                chart.translateSpace(0.0f, -movement, 0.0f);
                break;
            }
            case 2: {
                if (rotateMode) {
                    alpha -= increment;
                    break;
                }
                chart.translateSpace(-movement, 0.0f, 0.0f);
                break;
            }
            case 3: {
                if (rotateMode) {
                    alpha += increment;
                    break;
                }
                chart.translateSpace(movement, 0.0f, 0.0f);
                break;
            }
        }
        double t = Math.cos(theta) * (double)scale;
        double t2 = Math.sin(theta) * (double)scale;
        chart.setlookfrom_x((float)(t * Math.cos(alpha) + (double)chart.getlookto_x()));
        chart.setlookfrom_y((float)(t2 + (double)chart.getlookto_y()));
        chart.setlookfrom_z((float)(t * Math.sin(alpha) + (double)chart.getlookto_z()));
        space.lookat(chart.getlookfrom_x(), chart.getlookfrom_y(), chart.getlookfrom_z(), chart.getlookto_x(), chart.getlookto_y(), chart.getlookto_z());
    }
}

