/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.chart.ColMetaData;
import quadbase.chart.DrillDownInfo;
import quadbase.chart.ReloadChart;
import quadbase.chartviewer.swing.OurCheckboxMenuItem;
import quadbase.chartviewer.swing.OurMenu;
import quadbase.chartviewer.swing.Viewer3DPanel;
import quadbase.common.util.internal.DataType;

class DrillDownMenu
extends OurMenu
implements ItemListener {
    Viewer3DPanel panel3d;
    int unusedCol = -1;
    int[] typeMap;
    int cType = -1;
    int[] map;
    int dim = -1;
    boolean dType;
    int currentType = 0;
    String selectedSeries = "None";
    String selectedCategory = "None";
    String selectedSumby = "None";
    String[] name;
    OurMenu drillTypeMenu;
    OurMenu seriesMenu;
    OurMenu categoryMenu;
    OurMenu sumbyMenu;
    private boolean isReady = false;

    public DrillDownMenu(Viewer3DPanel vp) {
        super("Drill-Down ");
        this.panel3d = vp;
    }

    public boolean addDrillDownMenu() {
        this.isReady = false;
        this.removeAll();
        if (!this.panel3d.parentChart.isDynamicDrillDown) {
            return false;
        }
        if (!this.init()) {
            return false;
        }
        if (this.unusedCol <= 0) {
            return false;
        }
        this.addDrillTypeMenu();
        this.addingMenu();
        this.disableMenu();
        this.isReady = true;
        return true;
    }

    boolean init() {
        if (this.panel3d.originalMetaData == null) {
            this.panel3d.originalMetaData = ReloadChart.getMetaDataInfo(this.panel3d.parentChart);
        }
        if (this.panel3d.originalMetaData == null) {
            return false;
        }
        this.name = new String[this.panel3d.originalMetaData.size()];
        for (int i = 0; i < this.name.length; ++i) {
            ColMetaData cData = (ColMetaData)this.panel3d.originalMetaData.elementAt(i);
            this.name[i] = cData.getColumnName();
        }
        if (this.panel3d.parentChart.isDrillDownDefined()) {
            this.cType = this.panel3d.parentChart.getDrillDownType();
            this.map = this.panel3d.parentChart.getDrillDownMap();
            this.dim = this.panel3d.parentChart.getDrillDownDimension();
            this.dType = this.panel3d.parentChart.isDrillDown2D();
        } else {
            this.dType = this.panel3d.parentChart.is2DimChart();
        }
        this.panel3d.parentChart.fillUsedColumns2(this.panel3d.originalMetaData, this.panel3d.parentChart.getDrillNumber());
        this.unusedCol = this.panel3d.parentChart.countUnusedCol;
        return true;
    }

    void disableMenu() {
        if (this.selectedCategory.equals("None")) {
            this.drillTypeMenu.setEnabled(false);
            this.seriesMenu.setEnabled(false);
            this.sumbyMenu.setEnabled(false);
        }
    }

    void addDrillTypeMenu() {
        int i;
        if (this.cType != -1) {
            this.currentType = this.cType;
        }
        this.drillTypeMenu = new OurMenu("Type:     " + Chart.stypeName[this.currentType]);
        Vector<Integer> typeVec = new Vector<Integer>();
        for (i = 0; i < Chart.stypeName.length; ++i) {
            if (!this.dType && (i == 14 || i == 16 || i == 17) || !DrillDownInfo.checkDrillDownType(i) || this.unusedCol < 2 && this.isStack(i)) continue;
            typeVec.addElement(i);
            this.drillTypeMenu.add(this.newCheckboxMenuItem(Chart.stypeName[i]));
        }
        this.typeMap = new int[typeVec.size()];
        for (i = 0; i < typeVec.size(); ++i) {
            this.typeMap[i] = (Integer)typeVec.elementAt(i);
        }
        this.setDrillTypeMenu();
        this.add(this.drillTypeMenu);
    }

    void setDrillTypeMenu() {
        for (int i = 0; i < this.drillTypeMenu.getItemCount(); ++i) {
            if (((OurCheckboxMenuItem)this.drillTypeMenu.getItem(i)).getLabel().equals(Chart.stypeName[this.currentType])) {
                ((OurCheckboxMenuItem)this.drillTypeMenu.getItem(i)).setState(true);
                continue;
            }
            ((OurCheckboxMenuItem)this.drillTypeMenu.getItem(i)).setState(false);
        }
    }

    void addingMenu() {
        if (this.dim == 1) {
            this.selectedCategory = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[0])).getColumnName();
        } else if (this.dim == 2) {
            if (this.isStack(this.cType)) {
                this.selectedCategory = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[0])).getColumnName();
                this.selectedSumby = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[1])).getColumnName();
            } else {
                this.selectedSeries = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[0])).getColumnName();
                this.selectedCategory = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[1])).getColumnName();
            }
        } else if (this.dim == 3) {
            this.selectedSeries = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[0])).getColumnName();
            this.selectedCategory = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[1])).getColumnName();
            this.selectedSumby = ((ColMetaData)this.panel3d.originalMetaData.elementAt(this.map[2])).getColumnName();
        }
        this.seriesMenu = new OurMenu("Series:   " + this.selectedSeries);
        this.categoryMenu = new OurMenu("Category: " + this.selectedCategory);
        this.sumbyMenu = new OurMenu("Sumby:    " + this.selectedSumby);
        this.addingMenuItem();
        if (this.unusedCol == 1) {
            this.add(this.categoryMenu);
        } else if (this.isStack(this.currentType)) {
            if (this.unusedCol == 2) {
                this.add(this.categoryMenu);
                this.add(this.sumbyMenu);
            } else if (this.unusedCol > 2) {
                this.add(this.categoryMenu);
                this.add(this.seriesMenu);
                this.add(this.sumbyMenu);
            }
        } else if (this.currentType == 17) {
            this.add(this.categoryMenu);
        } else if (this.unusedCol > 1) {
            this.add(this.categoryMenu);
            this.add(this.seriesMenu);
        }
    }

    void addingMenuItem() {
        int mType = -1;
        for (int i = 0; i < this.name.length; ++i) {
            mType = this.getMetaType(i);
            if (mType == -1 || this.panel3d.parentChart.usedColumns[i]) continue;
            if (!DataType.isNumeric(mType) || DataType.isInt(mType)) {
                this.seriesMenu.add(this.newCheckboxMenuItem(this.name[i], "SER"));
                this.sumbyMenu.add(this.newCheckboxMenuItem(this.name[i], "SUM"));
            }
            this.categoryMenu.add(this.newCheckboxMenuItem(this.name[i], "CAT"));
        }
        this.setMenuItem();
        this.seriesMenu.insert(this.newCheckboxMenuItem("None", "SER"), 0);
        if (((OurCheckboxMenuItem)this.seriesMenu.getItem(0)).getLabel().equals(this.selectedSeries)) {
            ((OurCheckboxMenuItem)this.seriesMenu.getItem(0)).setState(true);
        }
    }

    int getMetaType(int i) {
        ColMetaData cData;
        if (this.panel3d.originalMetaData == null) {
            this.panel3d.originalMetaData = ReloadChart.getMetaDataInfo(this.panel3d.parentChart);
        }
        if ((cData = (ColMetaData)this.panel3d.originalMetaData.elementAt(i)) != null) {
            return DataType.mapType(cData.getSQLType());
        }
        return -1;
    }

    void setMenuItem() {
        for (int i = 0; i < this.seriesMenu.getItemCount(); ++i) {
            ((OurCheckboxMenuItem)this.seriesMenu.getItem(i)).setState(false);
            ((OurCheckboxMenuItem)this.categoryMenu.getItem(i)).setState(false);
            ((OurCheckboxMenuItem)this.sumbyMenu.getItem(i)).setState(false);
            if (((OurCheckboxMenuItem)this.seriesMenu.getItem(i)).getLabel().equals(this.selectedSeries)) {
                ((OurCheckboxMenuItem)this.seriesMenu.getItem(i)).setState(true);
            }
            if (((OurCheckboxMenuItem)this.categoryMenu.getItem(i)).getLabel().equals(this.selectedCategory)) {
                ((OurCheckboxMenuItem)this.categoryMenu.getItem(i)).setState(true);
            }
            if (!((OurCheckboxMenuItem)this.sumbyMenu.getItem(i)).getLabel().equals(this.selectedSumby)) continue;
            ((OurCheckboxMenuItem)this.sumbyMenu.getItem(i)).setState(true);
        }
    }

    OurCheckboxMenuItem newCheckboxMenuItem(String s) {
        return this.newCheckboxMenuItem(s, null);
    }

    OurCheckboxMenuItem newCheckboxMenuItem(String s, String c) {
        OurCheckboxMenuItem m = new OurCheckboxMenuItem(s);
        if (c != null) {
            m.setActionCommand(c);
        }
        m.addItemListener(this);
        return m;
    }

    int findColIndex(String c) {
        for (int i = 0; i < this.name.length; ++i) {
            if (!c.equals(this.name[i])) continue;
            return i;
        }
        return -1;
    }

    int findChartType(String newType) {
        for (int element : this.typeMap) {
            if (!newType.equals(Chart.stypeName[element])) continue;
            return element;
        }
        return 0;
    }

    boolean isStack(int i) {
        return Chart.stackType(i);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isReady) {
            return;
        }
        int newIndex = 0;
        String menustr = ((OurCheckboxMenuItem)e.getSource()).getLabel();
        String command = ((OurCheckboxMenuItem)e.getSource()).getActionCommand();
        if (!this.selectedCategory.equals("None")) {
            int i;
            int[] map2;
            if (command.equals("SER")) {
                if (this.selectedSeries.equals(menustr)) {
                    return;
                }
                if (menustr.equals("None")) {
                    --this.dim;
                    map2 = new int[this.dim];
                    for (i = 0; i < this.dim; ++i) {
                        map2[i] = this.map[i + 1];
                    }
                    this.map = map2;
                } else if (this.selectedSeries.equals("None")) {
                    newIndex = this.findColIndex(menustr);
                    ++this.dim;
                    map2 = new int[this.dim];
                    map2[0] = newIndex;
                    map2[1] = this.map[0];
                    if (this.dim == 3) {
                        map2[2] = this.map[1];
                    }
                    this.map = map2;
                } else {
                    this.map[0] = newIndex = this.findColIndex(menustr);
                }
            } else if (command.equals("SUM")) {
                if (this.selectedSumby.equals(menustr)) {
                    return;
                }
                this.map[this.dim - 1] = newIndex = this.findColIndex(menustr);
            } else if (command.equals("CAT")) {
                if (this.selectedCategory.equals(menustr)) {
                    return;
                }
                newIndex = this.findColIndex(menustr);
                if (this.isStack(this.currentType)) {
                    if (this.dim == 2) {
                        this.map[0] = newIndex;
                    } else if (this.dim == 3) {
                        this.map[1] = newIndex;
                    }
                } else if (this.dim == 1) {
                    this.map[0] = newIndex;
                } else {
                    this.map[1] = newIndex;
                }
            } else {
                int tempMap;
                newIndex = this.findChartType(menustr);
                if (this.cType == newIndex) {
                    return;
                }
                if (newIndex == 17 && this.dim != 1) {
                    map2 = new int[1];
                    if (this.isStack(this.cType)) {
                        if (this.dim == 2) {
                            this.dim = 1;
                            map2[0] = this.map[0];
                        } else if (this.dim == 3) {
                            this.dim = 1;
                            map2[0] = this.map[1];
                        }
                    } else {
                        this.dim = 1;
                        map2[0] = this.map[1];
                    }
                    this.map = map2;
                } else if (!this.isStack(newIndex)) {
                    if (this.isStack(this.cType)) {
                        if (this.dim == 2) {
                            tempMap = this.map[0];
                            this.map[0] = this.map[1];
                            this.map[1] = tempMap;
                        } else if (this.dim == 3) {
                            this.dim = 2;
                            map2 = new int[]{this.map[0], this.map[1]};
                            this.map = map2;
                        }
                    } else if (this.dim == 1) {
                        map2 = new int[]{this.map[0]};
                        this.map = map2;
                    }
                } else if (this.dim == 1) {
                    this.dim = 2;
                    map2 = new int[]{this.map[0], this.map[0]};
                    this.map = map2;
                } else if (!this.isStack(this.cType)) {
                    tempMap = this.map[0];
                    this.map[0] = this.map[1];
                    this.map[1] = tempMap;
                }
                this.cType = newIndex;
            }
            this.panel3d.parentChart.reAssignDrillDownMap(this.panel3d.parentChart.getDrillNumber());
            this.panel3d.parentChart.modifyDrillDown(this.panel3d.parentChart.getDrillNumber(), this.cType, this.map, this.dim, this.dType);
            for (i = this.panel3d.parentChart.getDrillNumber() + 1; i < this.panel3d.parentChart.drillDownVector.size(); ++i) {
                this.panel3d.parentChart.removeDrillDown(i);
            }
        } else {
            newIndex = this.findColIndex(menustr);
            if (newIndex == -1) {
                return;
            }
            this.dim = 1;
            this.map = new int[1];
            this.map[0] = newIndex;
            this.cType = this.currentType;
            this.dType = this.panel3d.parentChart.is2DimChart();
            this.panel3d.parentChart.fillUsedColumns(this.map, this.dim);
            this.panel3d.parentChart.reAssignDrillDownMap(this.panel3d.parentChart.getDrillNumber());
            this.panel3d.parentChart.insertDrillDownAt(this.panel3d.parentChart.getDrillNumber(), this.cType, this.map, this.dim, this.dType);
            this.panel3d.viewPanel.isDrillDownDefined = true;
        }
    }
}

