/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import quadbase.chartviewer.swing.JBaseComponent;
import quadbase.common.swing.CanShowHint;

public class NavigatePanel
extends JBaseComponent {
    int width;
    int height;
    int[] xpoints;
    int[] ypoints;
    Color gray80;
    Color darkGreen;
    Color darkRed;
    Color[] carray;
    static final int DEPTH = 2;
    public static final int UP_ARROW_PRESS = 0;
    public static final int DOWN_ARROW_PRESS = 1;
    public static final int LEFT_ARROW_PRESS = 2;
    public static final int RIGHT_ARROW_PRESS = 3;
    public static final int CENTER_PRESS = 4;
    public static final int UP_ARROW_RELEASE = 5;
    public static final int DOWN_ARROW_RELEASE = 6;
    public static final int LEFT_ARROW_RELEASE = 7;
    public static final int RIGHT_ARROW_RELEASE = 8;
    public static final int CENTER_RELEASE = 9;
    boolean upArrow_press;
    boolean downArrow_press;
    boolean leftArrow_press;
    boolean rightArrow_press;
    boolean center_press;
    CanShowHint hint;
    String hintText;
    AppletContext app;

    public NavigatePanel(int width, int height) {
        this.width = width;
        this.height = height;
        this.xpoints = new int[4];
        this.ypoints = new int[4];
        this.carray = new Color[4];
        this.gray80 = new Color(80, 80, 80);
        this.darkGreen = new Color(0, 100, 0);
        this.darkRed = new Color(100, 0, 0);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int w2 = 4 * this.width / 15;
        int h2 = 4 * this.height / 15;
        int w = w2 / 2;
        int h = h2 / 2;
        int ww2 = this.width / 2;
        int hh2 = this.height / 2;
        int ww3 = w / 3;
        int hh3 = h / 3;
        int w22 = w / 2;
        int h22 = h / 2;
        if (this.width * this.height <= 0) {
            return;
        }
        Image offScreenImage = this.createImage(this.width, this.height);
        Graphics backbuffer = offScreenImage.getGraphics();
        backbuffer.setColor(this.getBackground());
        backbuffer.fillRect(0, 0, this.width, this.height);
        this.xpoints[0] = ww2;
        this.ypoints[0] = 0;
        this.xpoints[1] = ww2 + w;
        this.ypoints[1] = h2;
        this.xpoints[2] = ww2 - w;
        this.ypoints[2] = h2;
        if (!this.upArrow_press) {
            backbuffer.setColor(Color.lightGray);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 3);
            backbuffer.setColor(Color.white);
            backbuffer.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[2], this.ypoints[2]);
            backbuffer.setColor(Color.darkGray);
            this.xpoints[0] = ww2;
            this.ypoints[0] = 0;
            this.xpoints[1] = this.xpoints[0] + 2;
            this.ypoints[1] = this.ypoints[0] + 2;
            this.xpoints[3] = ww2 + w;
            this.ypoints[3] = h2;
            this.xpoints[2] = this.xpoints[3] + 2;
            this.ypoints[2] = this.ypoints[3] + 2;
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 4);
            backbuffer.setColor(this.gray80);
            this.xpoints[0] = ww2 - w;
            this.ypoints[0] = h2;
            this.xpoints[1] = this.xpoints[0] + 2;
            this.ypoints[1] = this.ypoints[0] + 2;
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 4);
            this.xpoints[0] = ww2;
            this.ypoints[0] = h * 2 / 3;
            this.xpoints[1] = ww2 + w22;
            this.ypoints[1] = h2 - hh3;
            this.xpoints[2] = ww2 - w22;
            this.ypoints[2] = this.ypoints[1];
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.green, Color.white, Color.white, this.darkGreen);
        } else {
            this.carray[0] = Color.white;
            this.carray[1] = Color.darkGray;
            this.carray[2] = Color.darkGray;
            this.drawButton(backbuffer, 3, this.carray);
            this.xpoints[0] = ww2 + 2;
            this.ypoints[0] = h * 2 / 3 + 2;
            this.xpoints[1] = ww2 + w22 + 2;
            this.ypoints[1] = h2 - hh3 + 2;
            this.xpoints[2] = ww2 - w22 + 2;
            this.ypoints[2] = this.ypoints[1];
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.red, Color.white, Color.white, this.darkRed);
        }
        this.xpoints[0] = ww2;
        this.ypoints[0] = this.height;
        this.xpoints[1] = ww2 - w;
        this.ypoints[1] = this.height - h2;
        this.xpoints[2] = ww2 + w;
        this.ypoints[2] = this.height - h2;
        if (!this.downArrow_press) {
            backbuffer.setColor(Color.lightGray);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 3);
            backbuffer.setColor(Color.gray);
            backbuffer.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[1], this.ypoints[1]);
            backbuffer.setColor(Color.white);
            backbuffer.drawLine(this.xpoints[1], this.ypoints[1], this.xpoints[2], this.ypoints[2]);
            this.xpoints[1] = this.xpoints[2];
            this.ypoints[1] = this.ypoints[2];
            this.xpoints[2] = this.xpoints[1] + 2;
            this.ypoints[2] = this.ypoints[1] + 2;
            this.xpoints[3] = this.xpoints[0] + 2;
            this.ypoints[3] = this.ypoints[0] + 2;
            backbuffer.setColor(Color.darkGray);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 4);
            this.xpoints[0] = ww2;
            this.ypoints[0] = this.height - hh3 * 2;
            this.xpoints[1] = ww2 - w22;
            this.ypoints[1] = this.height - h2 + hh3;
            this.xpoints[2] = ww2 + w22;
            this.ypoints[2] = this.ypoints[1];
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.green, this.darkGreen, this.darkGreen, Color.white);
        } else {
            this.carray[0] = Color.darkGray;
            this.carray[1] = Color.darkGray;
            this.carray[2] = Color.white;
            this.drawButton(backbuffer, 3, this.carray);
            this.xpoints[0] = ww2 + 2;
            this.ypoints[0] = this.height - hh3 * 2 + 2;
            this.xpoints[1] = ww2 - w22 + 2;
            this.ypoints[1] = this.height - h2 + hh3 + 2;
            this.xpoints[2] = ww2 + w22 + 2;
            this.ypoints[2] = this.ypoints[1];
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.red, this.darkRed, this.darkRed, Color.white);
        }
        this.xpoints[0] = 0;
        this.ypoints[0] = hh2;
        this.xpoints[1] = w2;
        this.ypoints[1] = hh2 - h;
        this.xpoints[2] = w2;
        this.ypoints[2] = hh2 + h;
        if (!this.leftArrow_press) {
            backbuffer.setColor(Color.lightGray);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 3);
            backbuffer.setColor(Color.white);
            backbuffer.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[1], this.ypoints[1]);
            this.xpoints[0] = this.xpoints[2];
            this.ypoints[0] = this.ypoints[2];
            this.xpoints[2] = this.xpoints[1] + 2;
            this.ypoints[2] = this.ypoints[1] + 2;
            this.xpoints[3] = this.xpoints[0] + 2;
            this.ypoints[3] = this.ypoints[0] + 2;
            backbuffer.setColor(Color.darkGray);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 4);
            this.xpoints[0] = 0;
            this.ypoints[0] = hh2;
            this.xpoints[1] = this.xpoints[3];
            this.ypoints[1] = this.ypoints[3];
            this.xpoints[2] = this.xpoints[1] + 2;
            this.ypoints[2] = this.ypoints[1] + 2;
            this.xpoints[3] = this.xpoints[0] + 2;
            this.ypoints[3] = this.ypoints[0] + 2;
            backbuffer.setColor(this.gray80);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 4);
            this.xpoints[0] = w * 2 / 3;
            this.ypoints[0] = hh2;
            this.xpoints[1] = w2 - ww3;
            this.ypoints[1] = hh2 - h22;
            this.xpoints[2] = w2 - ww3;
            this.ypoints[2] = hh2 + h22;
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.green, this.darkGreen, Color.white, Color.white);
        } else {
            this.carray[0] = Color.darkGray;
            this.carray[1] = Color.white;
            this.carray[2] = Color.darkGray;
            this.drawButton(backbuffer, 3, this.carray);
            this.xpoints[0] = ww3 * 2 + 2;
            this.ypoints[0] = hh2 + 2;
            this.xpoints[1] = w2 - ww3 + 2;
            this.ypoints[1] = hh2 - h22 + 2;
            this.xpoints[2] = this.xpoints[1];
            this.ypoints[2] = hh2 + h22 + 2;
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.red, this.darkRed, Color.white, Color.white);
        }
        this.xpoints[0] = this.width;
        this.ypoints[0] = hh2;
        this.xpoints[1] = this.width - w2;
        this.ypoints[1] = hh2 + h;
        this.xpoints[2] = this.width - w2;
        this.ypoints[2] = hh2 - h;
        if (!this.rightArrow_press) {
            backbuffer.setColor(Color.lightGray);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 3);
            backbuffer.setColor(Color.gray);
            backbuffer.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[2], this.ypoints[2]);
            backbuffer.setColor(Color.white);
            backbuffer.drawLine(this.xpoints[1], this.ypoints[1], this.xpoints[2], this.ypoints[2]);
            this.xpoints[2] = this.xpoints[1] + 2;
            this.ypoints[2] = this.ypoints[1] + 2;
            this.xpoints[3] = this.xpoints[0] + 2;
            this.ypoints[3] = this.ypoints[0] + 2;
            backbuffer.setColor(Color.darkGray);
            backbuffer.fillPolygon(this.xpoints, this.ypoints, 4);
            this.xpoints[0] = this.width - ww3 * 2;
            this.ypoints[0] = hh2;
            this.xpoints[1] = this.width - w2 + ww3;
            this.ypoints[1] = hh2 + h22;
            this.xpoints[2] = this.xpoints[1];
            this.ypoints[2] = hh2 - h22;
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.green, Color.white, this.darkGreen, this.darkGreen);
        } else {
            this.carray[0] = Color.white;
            this.carray[1] = Color.darkGray;
            this.carray[2] = Color.darkGray;
            this.drawButton(backbuffer, 3, this.carray);
            this.xpoints[0] = this.width - ww3 * 2 + 2;
            this.ypoints[0] = hh2 + 2;
            this.xpoints[1] = this.width - w2 + ww3 + 2;
            this.ypoints[1] = hh2 + h22 + 2;
            this.xpoints[2] = this.xpoints[1];
            this.ypoints[2] = hh2 - h22 + 2;
            this.drawTriangle(backbuffer, this.xpoints, this.ypoints, Color.red, Color.white, this.darkGreen, this.darkGreen);
        }
        this.xpoints[0] = ww2 - w;
        this.ypoints[0] = hh2 - w;
        if (!this.center_press) {
            backbuffer.setColor(Color.lightGray);
            for (int i = 0; i < 2; ++i) {
                backbuffer.draw3DRect(this.xpoints[0], this.ypoints[0], w2, h2, true);
                this.xpoints[0] = this.xpoints[0] + 1;
                this.ypoints[0] = this.ypoints[0] + 1;
            }
            this.drawRectangle(backbuffer, (this.width - w) / 2 + 1, (this.height - h) / 2 + 1, w, h, Color.green, this.darkGreen);
        } else {
            this.xpoints[1] = this.xpoints[0] + w2;
            this.ypoints[1] = this.ypoints[0];
            this.xpoints[2] = this.xpoints[1];
            this.ypoints[2] = this.ypoints[0] + h2;
            this.xpoints[3] = this.xpoints[0];
            this.ypoints[3] = this.ypoints[2];
            this.carray[0] = Color.darkGray;
            this.carray[1] = Color.white;
            this.carray[2] = Color.white;
            this.carray[3] = Color.darkGray;
            this.drawButton(backbuffer, 4, this.carray);
            this.drawRectangle(backbuffer, ww2 - w22 + 2, hh2 - h22 + 2, w, h, Color.red, this.darkRed);
        }
        g.drawImage(offScreenImage, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void drawButton(Graphics g, int n, Color[] carray) {
        int i = 0;
        while (i < n) {
            int n2 = i;
            this.xpoints[n2] = this.xpoints[n2] + 2;
            int n3 = i++;
            this.ypoints[n3] = this.ypoints[n3] + 2;
        }
        g.setColor(Color.lightGray);
        g.fillPolygon(this.xpoints, this.ypoints, n);
        g.setColor(Color.darkGray);
        for (i = 0; i < n - 1; ++i) {
            g.setColor(carray[i]);
            g.drawLine(this.xpoints[i], this.ypoints[i], this.xpoints[i + 1], this.ypoints[i + 1]);
            g.drawLine(this.xpoints[i] - 1, this.ypoints[i] - 1, this.xpoints[i + 1] - 1, this.ypoints[i + 1] - 1);
            g.drawLine(this.xpoints[i] - 1, this.ypoints[i] - 1, this.xpoints[i + 1], this.ypoints[i + 1]);
            g.drawLine(this.xpoints[i], this.ypoints[i], this.xpoints[i + 1] - 1, this.ypoints[i + 1] - 1);
        }
        g.setColor(carray[n - 1]);
        g.drawLine(this.xpoints[n - 1], this.ypoints[n - 1], this.xpoints[0], this.ypoints[0]);
        g.drawLine(this.xpoints[n - 1] - 1, this.ypoints[n - 1] - 1, this.xpoints[0] - 1, this.ypoints[0] - 1);
        g.drawLine(this.xpoints[n - 1] - 1, this.ypoints[n - 1] - 1, this.xpoints[0], this.ypoints[0]);
        g.drawLine(this.xpoints[n - 1], this.ypoints[n - 1], this.xpoints[0] - 1, this.ypoints[0] - 1);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.rightArrow_press) {
            this.rightArrow_press = false;
            this.fireEvent(this, 8);
        } else if (this.leftArrow_press) {
            this.leftArrow_press = false;
            this.fireEvent(this, 7);
        } else if (this.upArrow_press) {
            this.upArrow_press = false;
            this.fireEvent(this, 5);
        } else if (this.downArrow_press) {
            this.downArrow_press = false;
            this.fireEvent(this, 6);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        int w2 = 4 * this.width / 15;
        int h2 = 4 * this.height / 15;
        int w = w2 / 2;
        int h = h2 / 2;
        int ww2 = this.width / 2;
        int hh2 = this.height / 2;
        int x = e.getX();
        if (this.insideTriangle(ww2, 0, ww2 + w, h2, ww2 - w, h2, x, y = e.getY())) {
            this.upArrow_press = true;
            this.repaint();
            this.fireEvent(this, 0);
            return;
        }
        if (this.insideTriangle(ww2, this.height, ww2 - w, this.height - h2, ww2 + w, this.height - h2, x, y)) {
            this.downArrow_press = true;
            this.repaint();
            this.fireEvent(this, 1);
            return;
        }
        if (this.insideTriangle(0, hh2, w2, hh2 - h, w2, hh2 + h, x, y)) {
            this.leftArrow_press = true;
            this.repaint();
            this.fireEvent(this, 2);
            return;
        }
        if (this.insideTriangle(this.width, hh2, this.width - w2, ww2 + h, this.width - w2, hh2 - h, x, y)) {
            this.rightArrow_press = true;
            this.repaint();
            this.fireEvent(this, 3);
            return;
        }
        if (x > (ww2 -= w) && x < ww2 + w2 && y > (hh2 -= w) && y < hh2 + h2) {
            this.center_press = !this.center_press;
            this.repaint();
            this.fireEvent(this, this.center_press ? 4 : 9);
        }
    }

    final boolean insideTriangle(int x0, int y0, int x1, int y1, int x2, int y2, int x, int y) {
        return (x1 - x0) * (y - y0) >= (y1 - y0) * (x - x0) && (x2 - x1) * (y - y1) >= (y2 - y1) * (x - x1) && (x0 - x2) * (y - y2) >= (y0 - y2) * (x - x2);
    }

    void drawTriangle(Graphics g, int[] xpoints, int[] ypoints, Color background, Color c1, Color c2, Color c3) {
        g.setColor(background);
        g.fillPolygon(xpoints, ypoints, 3);
        g.setColor(c1);
        g.drawLine(xpoints[0], ypoints[0], xpoints[1], ypoints[1]);
        g.setColor(c2);
        g.drawLine(xpoints[1], ypoints[1], xpoints[2], ypoints[2]);
        g.setColor(c3);
        g.drawLine(xpoints[2], ypoints[2], xpoints[0], ypoints[0]);
    }

    void drawRectangle(Graphics g, int x, int y, int w, int h, Color background, Color c1) {
        g.setColor(background);
        this.xpoints[0] = x;
        this.ypoints[0] = y;
        this.xpoints[1] = this.xpoints[0] + w;
        this.ypoints[1] = this.ypoints[0];
        this.xpoints[2] = this.xpoints[0] + w;
        this.ypoints[2] = this.ypoints[0] + h;
        this.xpoints[3] = this.xpoints[0];
        this.ypoints[3] = this.ypoints[0] + h;
        g.fillPolygon(this.xpoints, this.ypoints, 4);
        g.setColor(c1);
        g.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[1], this.ypoints[1]);
        g.setColor(Color.white);
        g.drawLine(this.xpoints[1], this.ypoints[1], this.xpoints[2], this.ypoints[2]);
        g.setColor(Color.white);
        g.drawLine(this.xpoints[2], this.ypoints[2], this.xpoints[3], this.ypoints[3]);
        g.setColor(c1);
        g.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[3], this.ypoints[3]);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.hint != null) {
            this.hint.showHint(this.hintText);
        }
        if (this.app != null) {
            this.app.showStatus(this.hintText);
        }
    }

    public void mouseExited(Event e, int x, int y) {
        if (this.hint != null) {
            this.hint.showHint("");
        }
        if (this.app != null) {
            this.app.showStatus("");
        }
    }

    public void setHint(CanShowHint hint, String hintText) {
        this.hintText = hintText;
        this.hint = hint;
    }

    public void setHint(AppletContext app, String hintText) {
        this.hintText = hintText;
        this.app = app;
    }
}

