/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Point3D;
import quadbase.chart.Ticker;
import quadbase.chartviewer.swing.OurPanel;
import quadbase.chartviewer.swing.ViewPanel;

public class RulerPanel
extends OurPanel {
    static final int WIDTH = 28;
    static final int INSET = 4;
    static final int H_WIDTH = 28;
    static final int V_WIDTH = 28;
    int shift;
    Axis axis;
    Component pane;
    int scroll;
    ViewPanel viewPanel;
    Ticker ticker;
    boolean yAxisPresent;
    boolean sAxisPresent;
    boolean showLabels;
    Font f;
    int hLabel;
    int vLabel;
    int angle;
    boolean reverse;
    boolean auto;
    boolean showTicker;

    public RulerPanel(Axis a, Component p, ViewPanel vp, boolean bLabels) {
        this.axis = a;
        this.ticker = a.ticker;
        this.pane = p;
        this.viewPanel = vp;
        this.showLabels = bLabels;
    }

    public RulerPanel(Axis a, Component p, ViewPanel vp, boolean bLabels, boolean hasYAxis, boolean hasSAxis) {
        this(a, p, vp, bLabels);
        this.yAxisPresent = hasYAxis;
        this.sAxisPresent = hasSAxis;
    }

    public void setScroll(int value) {
        this.scroll = value;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.axis.orient == 0) {
            return new Dimension(this.pane.getSize().width, 28);
        }
        return new Dimension(28, this.pane.getSize().height);
    }

    void saveValues(int fontAngle, int insetVal, boolean reverseVal) {
        this.hLabel = this.ticker.displacement;
        this.vLabel = this.ticker.twidth;
        this.reverse = this.ticker.reverseSide;
        CString str = this.ticker.getString();
        this.angle = str.getAngle();
        this.f = str.getFont();
        this.auto = str.automatic;
        this.showTicker = this.axis.showTicker;
        this.ticker.displacement = 0;
        this.axis.showTicker = true;
        this.ticker.setFont(new Font("Helvetica", 0, 12), fontAngle, this.auto);
        this.ticker.twidth = insetVal;
        this.ticker.reverseSide = reverseVal;
    }

    void restoreValues() {
        this.ticker.displacement = this.hLabel;
        this.ticker.twidth = this.vLabel;
        this.ticker.reverseSide = this.reverse;
        this.ticker.setFont(this.f, this.angle, this.auto);
        this.axis.showTicker = this.showTicker;
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.axis.orient == 0) {
            int disp = -this.scroll;
            if (this.yAxisPresent) {
                disp += 28;
            }
            g.drawLine(0, 24, size.width, 24);
            Point3D[] oldPoint = this.ticker.getPoints();
            if (oldPoint != null) {
                Point3D[] point = new Point3D[oldPoint.length];
                for (int i = 0; i < point.length; ++i) {
                    point[i] = new Point3D(oldPoint[i].x + disp, -24);
                }
                CGraphics cg = new CGraphics(g, this, 0, 28, null);
                this.saveValues(0, 0, true);
                this.axis.showTicker = this.showLabels;
                this.ticker.draw(cg, point);
                this.restoreValues();
            }
            if (this.yAxisPresent) {
                g.clearRect(0, 0, 28, 28);
                g.fillRect(24, 24, 4, 4);
            }
            if (this.sAxisPresent) {
                g.clearRect(size.width - 28, size.height - 28, 28, 28);
                g.fillRect(size.width - 28, 24, 4, 4);
            }
        } else if (this.axis.orient == 1) {
            int disp = -this.scroll;
            g.drawLine(24, size.height, 24, 0);
            Point3D[] oldPoint = this.ticker.getPoints();
            if (oldPoint != null) {
                disp -= size.height - this.viewPanel.getSize().height;
                Point3D[] point = new Point3D[oldPoint.length];
                for (int i = 0; i < point.length; ++i) {
                    point[i] = new Point3D(24, oldPoint[i].y - disp);
                }
                CGraphics cg = new CGraphics(g, this, size.height, 0, null);
                this.saveValues(90, 4, false);
                this.axis.showTicker = this.showLabels;
                this.ticker.draw(cg, point);
                this.restoreValues();
            }
        } else if (this.axis.orient == 3) {
            int disp = -this.scroll;
            g.drawLine(3, size.height, 3, 0);
            Point3D[] oldPoint = this.ticker.getPoints();
            if (oldPoint != null) {
                disp -= size.height - this.viewPanel.getSize().height;
                Point3D[] point = new Point3D[oldPoint.length];
                for (int i = 0; i < point.length; ++i) {
                    point[i] = new Point3D(3, oldPoint[i].y - disp);
                }
                CGraphics cg = new CGraphics(g, this, size.height, 0, null);
                this.saveValues(90, 4, true);
                this.axis.showTicker = this.showLabels;
                this.ticker.draw(cg, point);
                this.restoreValues();
            }
        }
    }
}

