/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.net.URL;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.chart.DrillHistory;
import quadbase.chart.GraphicsTable;
import quadbase.chart.LoadChart;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chartviewer.swing.AxisRuler;
import quadbase.chartviewer.swing.ControlPanel;
import quadbase.chartviewer.swing.IChartHolder;
import quadbase.chartviewer.swing.OurPanel;
import quadbase.chartviewer.swing.RulerPanel;
import quadbase.chartviewer.swing.ViewPanel;
import quadbase.chartviewer.swing.Viewer;
import quadbase.common.client.ServerMessage;
import quadbase.util.IHintBoxInfo;

public class Viewer3DPanel
extends OurPanel {
    ControlPanel controlPanel;
    public ViewPanel viewPanel;
    public Chart chart;
    public Chart parentChart = null;
    public String filename = null;
    boolean loading = false;
    boolean[] oldTickerState = new boolean[3];
    boolean oldTopValueState;
    public boolean navexist = true;
    boolean hidepanel = false;
    RulerPanel xRulerPanel;
    RulerPanel yRulerPanel;
    RulerPanel sRulerPanel;
    boolean rulerExists;
    AxisRuler ruler;
    OurPanel fullPanel;
    IChartHolder chartHolder = null;
    IHintBoxInfo hintBoxInfo = null;
    Dimension orgChartSize = null;
    public DrillHistory drillHistory = null;
    public Vector originalMetaData = null;
    Vector zoomHistVector = null;
    Vector linkhistory = new Vector();
    boolean isBack = false;

    public Viewer3DPanel(Chart chart) {
        this(chart, null);
    }

    public Viewer3DPanel(Chart chart, IChartHolder chartHolder) {
        this.chart = chart;
        this.parentChart = chart;
        this.orgChartSize = chart.getSize();
        this.chartHolder = chartHolder;
        this.drillHistory = null;
        this.originalMetaData = null;
        this.zoomHistVector = new Vector(10);
        this.setLayout(new BorderLayout());
        this.viewPanel = new ViewPanel(this, chart);
        if ((this.parentChart.isDynamicDrillDown || this.viewPanel.isDrillDownDefined) && this.originalMetaData == null) {
            this.originalMetaData = ReloadChart.getMetaDataInfo(this.parentChart);
        }
        this.fullPanel = new OurPanel();
        this.fullPanel.setLayout(new BorderLayout());
        this.fullPanel.add("Center", this.viewPanel.getChartComponent());
        this.ruler = new AxisRuler();
        this.setRuler();
        if (!chart.is2DimChart()) {
            this.controlPanel = new ControlPanel(this, this.viewPanel);
            this.fullPanel.add("South", this.controlPanel);
        } else {
            this.navexist = false;
        }
        this.add("Center", this.fullPanel);
        this.setDrawMode();
        this.saveText();
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public Chart getChart() {
        return this.chart;
    }

    public AxisRuler getRuler() {
        return this.ruler;
    }

    final void setRuler() {
        this.setRuler(this.ruler);
    }

    public void setRuler(AxisRuler ruler) {
        this.ruler = ruler;
        if (this.xRulerPanel != null) {
            this.fullPanel.remove(this.xRulerPanel);
        }
        if (this.yRulerPanel != null) {
            this.fullPanel.remove(this.yRulerPanel);
        }
        if (this.sRulerPanel != null) {
            this.fullPanel.remove(this.sRulerPanel);
        }
        this.sRulerPanel = null;
        this.yRulerPanel = null;
        this.xRulerPanel = null;
        this.rulerExists = false;
        if (this.chart.is2DimChart() && !this.chart.isCircularChart()) {
            if (ruler.isVisibleXRuler()) {
                this.xRulerPanel = new RulerPanel(this.chart.axis[0], this.viewPanel.getChartComponent(), this.viewPanel, ruler.isVisibleXLabel(), ruler.isVisibleYRuler(), ruler.isVisibleSRuler());
                this.fullPanel.add("North", this.xRulerPanel);
                this.rulerExists = true;
            }
            if (ruler.isVisibleYRuler()) {
                this.yRulerPanel = new RulerPanel(this.chart.axis[1], this.viewPanel.getChartComponent(), this.viewPanel, ruler.isVisibleYLabel());
                this.fullPanel.add("West", this.yRulerPanel);
                this.rulerExists = true;
            }
            if (ruler.isVisibleSRuler()) {
                this.sRulerPanel = new RulerPanel(this.chart.axis[3], this.viewPanel.getChartComponent(), this.viewPanel, ruler.isVisibleSLabel());
                this.fullPanel.add("East", this.sRulerPanel);
                this.rulerExists = true;
            }
        }
        this.validate();
    }

    public void setHintBoxInfo(IHintBoxInfo info) {
        this.hintBoxInfo = info;
    }

    public IHintBoxInfo getHintBoxInfo() {
        return this.hintBoxInfo;
    }

    public void setChart(Chart chart) {
        if (this.chart != null && this.chart.is2DimChart() != chart.is2DimChart()) {
            this.chart = chart;
            this.setNavToggle(!chart.is2DimChart() && !this.hidepanel);
        } else {
            this.chart = chart;
        }
        if (this.controlPanel != null) {
            this.controlPanel.updatePanel();
        }
        this.setRuler();
        this.setDrawMode();
        if (this.parentChart.drillDownVector == null || this.parentChart.drillDownVector.size() <= 0) {
            this.viewPanel.setrepaint(chart);
        } else if (chart.getScrollBarOption() != this.viewPanel.scrollBarOption) {
            this.setViewPanel(chart);
        } else {
            this.viewPanel.setrepaint(chart);
        }
    }

    public void setViewPanel(Chart newChart) {
        this.fullPanel.remove(this.viewPanel.getChartComponent());
        this.viewPanel.disposeObject();
        this.viewPanel = null;
        this.viewPanel = new ViewPanel(this, newChart);
        System.gc();
        this.fullPanel.add("Center", this.viewPanel.getChartComponent());
        if (this.controlPanel != null) {
            this.controlPanel.viewPanel = this.viewPanel;
        }
        if (this.chartHolder != null) {
            this.chartHolder.setViewPanel(this.viewPanel);
        }
        this.validate();
    }

    public void setrepaint(Chart chart) {
        this.chart = chart;
        this.setRuler();
        this.viewPanel.setrepaint(chart);
        this.setDrawMode();
    }

    private void saveText() {
        for (int i = 0; i < 3; ++i) {
            this.oldTickerState[i] = this.chart.getTickerLabelState(i);
        }
        this.oldTopValueState = this.chart.getTopValueState();
    }

    private void restoreText() {
        for (int i = 0; i < 3; ++i) {
            this.chart.setTickerLabelState(i, this.oldTickerState[i]);
            this.chart.axis[i].title.bshow = true;
        }
        this.chart.setTopValueState(this.oldTopValueState);
        this.chart.doDrawAnnotation = true;
    }

    void hideText() {
        this.saveText();
        for (int i = 0; i < 3; ++i) {
            this.chart.setTickerLabelState(i, false);
            this.chart.axis[i].title.bshow = false;
        }
        this.chart.setTopValueState(false);
        this.chart.doDrawAnnotation = false;
    }

    public final Object getValue() {
        return this.viewPanel.getValue();
    }

    public final int getModifier() {
        return this.viewPanel.mouseModifier;
    }

    void stopAnimation() {
        this.viewPanel.animation = false;
        this.viewPanel.stop();
        this.restoreText();
        this.viewPanel.repaint();
        if (this.controlPanel != null) {
            this.controlPanel.setEnableNavControl(true);
        }
    }

    public void zooming(double value) {
        this.viewPanel.setZoom((int)value);
        this.viewPanel.repaint();
    }

    public void setNavControl(boolean enable) {
        if (enable && !this.navexist || !enable && this.navexist) {
            this.hidepanel = !this.hidepanel;
            this.toggleNavControl();
        }
    }

    private void setNavToggle(boolean enable) {
        if (enable && !this.navexist || !enable && this.navexist) {
            this.toggleNavControl();
        }
    }

    void toggleNavControl() {
        if (this.chart.is2DimChart() && !this.navexist) {
            return;
        }
        if (this.navexist) {
            this.fullPanel.remove(this.controlPanel);
        } else {
            if (this.controlPanel == null) {
                this.controlPanel = new ControlPanel(this, this.viewPanel);
            }
            this.addControlPanel();
        }
        this.navexist = !this.navexist;
        this.validate();
        this.viewPanel.repaint();
    }

    public void addControlPanel() {
        this.remove(this.fullPanel);
        this.fullPanel = new OurPanel();
        this.fullPanel.setLayout(new BorderLayout());
        this.fullPanel.add("Center", this.viewPanel.getChartComponent());
        this.fullPanel.add("South", this.controlPanel);
        this.add("Center", this.fullPanel);
        this.validate();
    }

    public void setDrawMode() {
        if (!this.chart.is2DChart && this.controlPanel != null) {
            this.controlPanel.setDrawMode();
        }
    }

    @Override
    public void repaint() {
        if (this.viewPanel == null) {
            return;
        }
        Dimension d = this.getSize();
        this.viewPanel.setSize(d.width - 10, d.height - 10);
        super.repaint();
        this.viewPanel.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public boolean do_openChart(Chart newchart) {
        this.setChart(newchart);
        this.filename = null;
        this.viewPanel.paint();
        return true;
    }

    boolean do_openChart(String s, String target) {
        if (s.endsWith(".cht") || s.endsWith(".tpl") || s.endsWith(".qch") || s.endsWith(".pac")) {
            Chart chart;
            if (this.viewPanel.isDrillDownDefined) {
                return false;
            }
            ReadDataFile readFile = new ReadDataFile();
            try {
                chart = new LoadChart().load(this.viewPanel, readFile.getInputStream(s), s.endsWith(".tpl"), null, true);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
                return false;
            }
            if (chart.drillDownVector != null && chart.drillDownVector.size() > 0) {
                return false;
            }
            this.setChart(chart);
            this.filename = s;
            this.viewPanel.paint();
            return true;
        }
        try {
            Applet applet = ServerMessage.getApplet();
            if (s.startsWith("http:") || s.startsWith("https:/")) {
                applet.getAppletContext().showDocument(new URL(s), target);
            } else {
                applet.getAppletContext().showDocument(new URL(applet.getDocumentBase(), s), target);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        return false;
    }

    Object do_openChart(String s, Object[] params) {
        Object object = null;
        String chartName = this.filename;
        try {
            Chart cht;
            if (params == null) {
                LoadChart lr = new LoadChart();
                lr.setSubFilesTable(this.chart.getSubFilesTable());
                cht = lr.loadChartFromFile(this.viewPanel, s, null);
                if (lr.getDrillDownNode() != null) {
                    cht.currentNode = lr.getDrillDownNode();
                }
            } else {
                chartName = this.chart.currentNode.getFileName();
                Vector<Object[]> vect = new Vector<Object[]>();
                vect.addElement(params);
                LoadChart lr = new LoadChart();
                lr.setSubFilesTable(this.chart.getSubFilesTable());
                cht = lr.loadChartFromFile(this, s, vect);
                cht.currentNode = this.chart.currentNode.getChildAt(0);
                object = this.chart;
            }
            if (object == null) {
                object = chartName == null || chartName.equals("") ? this.chart : chartName;
            }
            this.setChart(cht);
            this.viewPanel.paint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return object;
    }

    public void do_Reload() {
        boolean doAnimation;
        this.loading = true;
        this.setEnabled(false);
        Chart newchart = null;
        this.chart.gt.keepPosition = true;
        GraphicsTable.recoverTableSize(this.chart);
        if (this.chart.getTable() != null) {
            this.chart.getTable().clear();
        }
        try {
            this.chart.usedColumns = null;
            newchart = ReloadChart.reloadData(this.chart, false);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            Applet applet = ServerMessage.getApplet();
            if (applet instanceof Viewer) {
                ((Viewer)applet).rThread.pleaseStop();
            }
            this.doneReload();
            return;
        }
        this.doneReload();
        boolean bl = doAnimation = !this.viewPanel.please_stop && this.viewPanel.animation;
        if (doAnimation) {
            this.viewPanel.stop();
        }
        Viewer3DPanel prePanel = this.viewPanel.panel3d;
        this.viewPanel.panel3d = null;
        this.setrepaint(newchart);
        this.viewPanel.panel3d = prePanel;
        if (doAnimation) {
            Graphics g = this.viewPanel.getGraphics();
            this.viewPanel.update(g);
            this.viewPanel.start();
            return;
        }
        this.viewPanel.paint();
    }

    void doneReload() {
        this.loading = false;
        this.setEnabled(true);
    }

    void repaintRulerPanels(Dimension scroll) {
        if (!this.rulerExists || !this.chart.is2DimChart()) {
            return;
        }
        if (this.ruler.isVisibleXRuler()) {
            this.xRulerPanel.setScroll(scroll.width);
            this.xRulerPanel.invalidate();
            this.xRulerPanel.repaint();
        }
        if (this.ruler.isVisibleYRuler()) {
            this.yRulerPanel.setScroll(scroll.height);
            this.yRulerPanel.invalidate();
            this.yRulerPanel.repaint();
        }
        if (this.ruler.isVisibleSRuler()) {
            this.sRulerPanel.setScroll(scroll.height);
            this.sRulerPanel.invalidate();
            this.sRulerPanel.repaint();
        }
    }
}

