/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import quadbase.chartviewer.swing.JBaseComponent;
import quadbase.common.swing.CanShowHint;

public class YASpeedMeter
extends JBaseComponent {
    int width;
    int height;
    double lastx;
    double lastvalue;
    double max;
    double min;
    double value = 0.0;
    int margin;
    boolean dragmode;
    CanShowHint hint;
    AppletContext app;
    String hintText;
    Image offScreenImage;
    Graphics backbuffer;
    Color[] dgray;

    public YASpeedMeter(double min, double max) {
        this.max = Math.max(max, min);
        this.min = Math.min(max, min);
        this.dgray = new Color[4];
        this.dgray[0] = Color.white;
        this.dgray[1] = new Color(100, 100, 100);
        this.dgray[2] = new Color(150, 150, 150);
        this.dgray[3] = new Color(200, 200, 200);
    }

    public void setValue(double value) {
        this.value = Math.max(this.min, Math.min(value, this.max));
        this.paint(this.getGraphics());
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.width != this.getSize().width || this.height != this.getSize().height || this.offScreenImage == null) {
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            if (this.width * this.height < 0) {
                return;
            }
            this.offScreenImage = this.createImage(this.width, this.height);
            this.backbuffer = this.offScreenImage.getGraphics();
        }
        this.backbuffer.setColor(Color.lightGray);
        this.backbuffer.fillRect(0, 0, this.width, this.height);
        this.fillBorderRect(this.backbuffer, 0, 0, this.width, this.height);
        this.margin = 6;
        this.drawMeter(this.backbuffer, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin);
        g.drawImage(this.offScreenImage, 0, 0, this);
    }

    final double absoluteAngle(double angle) {
        return Math.PI * (1.0 - angle / 180.0);
    }

    void drawMeter(Graphics g, int xorigin, int yorigin, int width, int height) {
        int y;
        int x;
        double angle;
        int a = width / 2;
        int b = height / 2;
        g.setColor(Color.black);
        for (int i = 0; i < 5; ++i) {
            angle = Math.PI * (double)i / 4.0;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            x = (int)((double)a + (double)(a - 2) * cos + (double)xorigin);
            y = (int)((double)b - (double)(b - 2) * sin + (double)yorigin);
            int x2 = (int)((double)a + (double)(a - 5) * cos + (double)xorigin);
            int y2 = (int)((double)b - (double)(b - 5) * sin + (double)yorigin);
            YASpeedMeter.drawLine(g, x, y, x2, y2, 2, Color.lightGray);
        }
        angle = (this.max - this.value) * Math.PI / (this.max - this.min);
        x = (int)((double)a + (double)(a - 5) * Math.cos(angle) + (double)xorigin);
        y = (int)((double)b - (double)(b - 5) * Math.sin(angle) + (double)yorigin);
        YASpeedMeter.drawLine(g, xorigin + a, yorigin + height, x, y, 3, Color.black);
        g.setColor(Color.lightGray);
        g.fillOval(xorigin + a - 3, yorigin + height - 3, 6, 6);
        g.setColor(Color.white);
        g.drawArc(xorigin + a - 3, yorigin + height - 3, 5, 5, 60, 180);
        g.setColor(Color.darkGray);
        g.drawArc(xorigin + a - 3, yorigin + height - 3, 5, 5, 60, -180);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(60, 40);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x > this.margin && x < this.width - 2 * this.margin && y > this.margin && y < this.height - 2 * this.margin) {
            this.dragmode = true;
            this.lastx = x;
            this.lastvalue = this.value;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragmode) {
            this.setValue(this.lastvalue + (this.max - this.min) * ((double)e.getX() - this.lastx) / (double)(this.width - 2 * this.margin));
            this.repaint();
            this.fireEvent(this, 0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragmode = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.hint != null) {
            this.hint.showHint(this.hintText);
        }
        if (this.app != null) {
            this.app.showStatus(this.hintText);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hint != null) {
            this.hint.showHint("");
        }
        if (this.app != null) {
            this.app.showStatus("");
        }
    }

    public void setHint(CanShowHint hint, String hintText) {
        this.hintText = hintText;
        this.hint = hint;
    }

    public void setHint(AppletContext app, String hintText) {
        this.hintText = hintText;
        this.app = app;
    }

    void fillBorderRect(Graphics g, int cx, int cy, int w, int h) {
        for (int i = 3; i >= 0; --i) {
            g.setColor(this.dgray[i]);
            g.drawRect(cx + i, cy + i, w - 4, h - 4);
        }
    }

    public static final void drawLine(Graphics g, int x1, int y1, int x2, int y2, int thick, Color color) {
        g.setColor(color);
        double slope = x1 - x2;
        thick /= 2;
        int[] xcoord = new int[4];
        int[] ycoord = new int[4];
        if (slope == 0.0) {
            g.fill3DRect(x2 - thick, y2, 2 * thick, y1 - y2, true);
            return;
        }
        if ((slope = (double)(y1 - y2) / slope) == 0.0) {
            g.fill3DRect(x1, y1 - thick, x2 - x1, 2 * thick, true);
            return;
        }
        slope = -1.0 / slope;
        double s = (double)thick / Math.sqrt(1.0 + slope * slope);
        double s1 = slope * s;
        if (slope > 0.0) {
            xcoord[0] = (int)Math.round((double)x1 - s);
            ycoord[0] = (int)Math.round((double)y1 - s1);
            xcoord[1] = (int)Math.round((double)x1 + s);
            ycoord[1] = (int)Math.round((double)y1 + s1);
            xcoord[3] = (int)Math.round((double)x2 - s);
            ycoord[3] = (int)Math.round((double)y2 - s1);
            xcoord[2] = (int)Math.round((double)x2 + s);
            ycoord[2] = (int)Math.round((double)y2 + s1);
        } else {
            xcoord[1] = (int)Math.round((double)x1 - s);
            ycoord[1] = (int)Math.round((double)y1 - s1);
            xcoord[0] = (int)Math.round((double)x1 + s);
            ycoord[0] = (int)Math.round((double)y1 + s1);
            xcoord[2] = (int)Math.round((double)x2 - s);
            ycoord[2] = (int)Math.round((double)y2 - s1);
            xcoord[3] = (int)Math.round((double)x2 + s);
            ycoord[3] = (int)Math.round((double)y2 + s1);
        }
        g.setColor(color);
        g.fillPolygon(xcoord, ycoord, 4);
        g.setColor(color.brighter());
        g.drawLine(xcoord[0], ycoord[0], xcoord[3], ycoord[3]);
        g.setColor(color.darker());
        g.drawLine(xcoord[1], ycoord[1], xcoord[2], ycoord[2]);
        g.setColor(color);
    }
}

