/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import quadbase.chart.Chart;
import quadbase.chart.GraphicsTable;
import quadbase.chart.PreprocInfo;
import quadbase.chartviewer.swing.OurFrame;
import quadbase.chartviewer.swing.OurMessageDialog;
import quadbase.chartviewer.swing.Viewer3DPanel;
import quadbase.chartviewer.swing.ZoomOptions;

public class ZoomFrame
extends OurFrame
implements ActionListener {
    public ZoomOptions zoomOpts = null;
    Viewer3DPanel panel3d = null;

    public ZoomFrame(Viewer3DPanel panel3d, int categoryType) {
        super("Zoom Options");
        this.panel3d = panel3d;
        this.setBorder("Enter zoom options");
        this.zoomOpts = new ZoomOptions("Enter zoom options", categoryType, false);
        this.zoomOpts.extractPreprocInfo(panel3d.chart);
        this.zoomOpts.addActionListener(this);
        this.add("Center", this.zoomOpts);
        this.setBackground(Color.lightGray);
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        int x = (screensize.width - dim.width) / 2;
        int y = (screensize.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
        this.setSize(dim);
    }

    public ZoomOptions getZoomOptions() {
        return this.zoomOpts;
    }

    public void performZoom() {
        this.performZoom(false);
    }

    public void performZoom(boolean performDynamicZooming) {
        Chart chart = this.panel3d.chart;
        GraphicsTable.recoverTableSize(chart);
        GraphicsTable.recoverTableSize(this.panel3d.chart);
        PreprocInfo tsInfo = chart.getPreprocInfo();
        if (!this.zoomOpts.isValidRange()) {
            String msg = "Invalid Zoom Range\nLower Bound must be before Upper Bound.\nPlease correct and try again.";
            OurMessageDialog.showError(this, true, msg);
            return;
        }
        if (this.zoomOpts.isValidScale(chart)) {
            this.setVisible(false);
            this.zoomOpts.fillPreprocInfo(chart, performDynamicZooming);
            this.panel3d.do_Reload();
        } else {
            String msg = "Invalid Scale: \n";
            msg = msg + "Minimum allowable scale: \n\t";
            msg = msg + this.zoomOpts.getStringScale(tsInfo.lInterval, tsInfo.lUnit) + "  \n ";
            msg = msg + "Maximum allowable scale: \n\t";
            msg = msg + this.zoomOpts.getStringScale(tsInfo.uInterval, tsInfo.uUnit) + "  \n ";
            OurMessageDialog.showError(this, true, msg);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.zoomOpts.cancelButton) {
            this.panel3d.zoomHistVector.removeElement(this.panel3d.zoomHistVector.lastElement());
            this.setVisible(false);
            return;
        }
        if (target == this.zoomOpts.okButton) {
            this.performZoom();
        }
    }
}

