/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import quadbase.chartviewer.swing.JBaseComponent;
import quadbase.common.swing.CanShowHint;

public class ZoomMeter
extends JBaseComponent {
    int width;
    int height;
    int height2;
    int lastx;
    double max;
    double min;
    int step;
    double value;
    int[] xpoints;
    int[] ypoints;
    Color darkGreen;
    Color darkRed;
    boolean dragmode;
    CanShowHint hint;
    String hintText;
    AppletContext app;

    public ZoomMeter(int width, int height, double min, double max, int step) {
        this.width = width;
        this.height = height;
        this.height2 = height - 8;
        this.max = Math.max(max, min);
        this.min = Math.min(max, min);
        this.step = step;
        this.xpoints = new int[4];
        this.ypoints = new int[4];
        this.darkGreen = new Color(0, 100, 0);
        this.darkRed = new Color(100, 0, 0);
    }

    public void setValue(double value) {
        this.value = Math.max(this.min, Math.min(value, this.max));
        this.repaint();
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        int prev = 0;
        if (this.width * this.height <= 0) {
            return;
        }
        Image offScreenImage = this.createImage(this.width, this.height);
        Graphics backbuffer = offScreenImage.getGraphics();
        backbuffer.setColor(this.getBackground());
        backbuffer.fillRect(0, 0, this.width, this.height);
        for (int i = 1; i <= this.step; ++i) {
            int curr = i * this.width / this.step;
            this.drawTraz(backbuffer, prev + 3, curr, this.fn_y(prev + 3), this.fn_y(curr), this.fn_v(curr) > this.value);
            prev = curr;
        }
        backbuffer.setColor(Color.red);
        backbuffer.fill3DRect(0, this.height2 + 4, 6, 2, true);
        backbuffer.setColor(Color.green);
        backbuffer.fill3DRect(this.width - 6, this.height2 + 4, 6, 2, true);
        backbuffer.fill3DRect(this.width - 4, this.height2 + 2, 2, 6, true);
        g.drawImage(offScreenImage, 0, 0, this);
    }

    int fn_y(int x) {
        return this.height2 - x * this.height2 / this.width;
    }

    double fn_v(int x) {
        return this.min + (double)x * (this.max - this.min) / (double)this.width;
    }

    public void drawTraz(Graphics g, int x1, int x2, int y1, int y2, boolean greenColor) {
        this.xpoints[0] = x1;
        this.ypoints[0] = this.height2;
        this.xpoints[1] = x1;
        this.ypoints[1] = y1;
        this.xpoints[2] = x2;
        this.ypoints[2] = y2;
        this.xpoints[3] = x2;
        this.ypoints[3] = this.height2;
        g.setColor(greenColor ? Color.green : Color.red);
        g.fillPolygon(this.xpoints, this.ypoints, 4);
        g.setColor(Color.white);
        g.drawLine(this.xpoints[1], this.ypoints[1], this.xpoints[2], this.ypoints[2]);
        g.setColor(greenColor ? this.darkGreen : this.darkRed);
        g.drawLine(this.xpoints[3], this.ypoints[3], this.xpoints[2], this.ypoints[2]);
        g.drawLine(this.xpoints[3], this.ypoints[3], this.xpoints[0], this.ypoints[0]);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (y >= this.fn_y(x) && y <= this.height2 && x > 0 && x < this.width) {
            this.dragmode = true;
            this.lastx = x;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragmode) {
            int x = e.getX();
            this.value += this.fn_v(x - this.lastx) - this.min;
            if (this.value > this.max) {
                this.value = this.max;
            } else if (this.value < this.min) {
                this.value = this.min;
            }
            this.lastx = x;
            this.repaint();
            this.fireEvent(this, 0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragmode = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.hint != null) {
            this.hint.showHint(this.hintText);
        }
        if (this.app != null) {
            this.app.showStatus(this.hintText);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hint != null) {
            this.hint.showHint("");
        }
        if (this.app != null) {
            this.app.showStatus("");
        }
    }

    public void setHint(CanShowHint hint, String hintText) {
        this.hintText = hintText;
        this.hint = hint;
    }

    public void setHint(AppletContext app, String hintText) {
        this.hintText = hintText;
        this.app = app;
    }
}

