/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer.swing;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JLabel;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.PreprocInfo;
import quadbase.chartviewer.swing.OurButton;
import quadbase.chartviewer.swing.OurCheckbox;
import quadbase.chartviewer.swing.OurChoice;
import quadbase.chartviewer.swing.OurPanel;
import quadbase.chartviewer.swing.OurTextField;
import quadbase.chartviewer.swing.PanelAction;
import quadbase.chartviewer.swing.SpinBox;
import quadbase.util.internal.DateTime;

public class ZoomOptions
extends PanelAction
implements ItemListener {
    private SpinBox spinYear1 = null;
    private SpinBox spinYear2 = null;
    private SpinBox spinMonth1 = null;
    private SpinBox spinMonth2 = null;
    private SpinBox spinDay1 = null;
    private SpinBox spinDay2 = null;
    private SpinBox spinHour1 = null;
    private SpinBox spinHour2 = null;
    private SpinBox spinMin1 = null;
    private SpinBox spinMin2 = null;
    private SpinBox spinSec1 = null;
    private SpinBox spinSec2 = null;
    OurPanel rangePanel = new OurPanel();
    OurPanel buttonPanel = new OurPanel();
    OurPanel labelPanel = new OurPanel();
    OurPanel southPanel = new OurPanel();
    public OurCheckbox enableZoom = null;
    public OurCheckbox disableLowerBound = null;
    public OurCheckbox disableUpperBound = null;
    public OurButton aggregateButton = null;
    boolean enableAggregate = false;
    public OurButton okButton;
    public OurButton cancelButton;
    OurChoice unitChoice = null;
    OurTextField scaleValue = null;
    private int categoryType = 0;
    OurChoice linearChoice = null;
    boolean undoZoom = false;
    boolean isForDrillDown = false;
    boolean isLinearEnabled = true;

    public ZoomOptions(String message, int type, boolean enableAggregate) {
        this(message, type, enableAggregate, false);
    }

    public ZoomOptions(String message, int type, boolean enableAggregate, boolean isForDrillDown) {
        this(message, type, enableAggregate, isForDrillDown, true);
    }

    public ZoomOptions(String message, int type, boolean enableAggregate, boolean isForDrillDown, boolean isLinearEnabled) {
        this.categoryType = type;
        this.enableAggregate = enableAggregate;
        this.isForDrillDown = isForDrillDown;
        this.isLinearEnabled = isLinearEnabled;
        OurPanel centerPanel = new OurPanel();
        centerPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.southPanel.setLayout(new FlowLayout());
        this.initializeDialog(type);
        centerPanel.add("Center", this.rangePanel);
        centerPanel.add("South", this.southPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", centerPanel);
        this.add("South", this.buttonPanel);
    }

    public int getCategoryType() {
        return this.categoryType;
    }

    public boolean checkBounds() {
        long uTime;
        if (this.disableLowerBound.getState() || this.disableUpperBound.getState()) {
            return true;
        }
        Timestamp lowerTime = this.getRangeValue(0);
        Timestamp upperTime = this.getRangeValue(1);
        long lTime = lowerTime.getTime();
        return lTime <= (uTime = upperTime.getTime());
    }

    public Timestamp getRangeValue(int index) {
        Timestamp tsValue = null;
        if (this.categoryType != 93 && this.categoryType != 91 && this.categoryType != 92) {
            return null;
        }
        switch (this.categoryType) {
            case 91: {
                if (index == 0) {
                    tsValue = new Timestamp(this.spinYear1.getValue() - 1900, this.spinMonth1.getValue() - 1, this.spinDay1.getValue(), 0, 0, 0, 0);
                    break;
                }
                tsValue = new Timestamp(this.spinYear2.getValue() - 1900, this.spinMonth2.getValue() - 1, this.spinDay2.getValue(), 0, 0, 0, 0);
                break;
            }
            case 92: {
                if (index == 0) {
                    tsValue = new Timestamp(70, 0, 1, this.spinHour1.getValue(), this.spinMin1.getValue(), this.spinSec1.getValue(), 0);
                    break;
                }
                tsValue = new Timestamp(70, 0, 1, this.spinHour2.getValue(), this.spinMin2.getValue(), this.spinSec2.getValue(), 0);
                break;
            }
            case 93: {
                if (index == 0) {
                    tsValue = new Timestamp(this.spinYear1.getValue() - 1900, this.spinMonth1.getValue() - 1, this.spinDay1.getValue(), this.spinHour1.getValue(), this.spinMin1.getValue(), this.spinSec1.getValue(), 0);
                    break;
                }
                tsValue = new Timestamp(this.spinYear2.getValue() - 1900, this.spinMonth2.getValue() - 1, this.spinDay2.getValue(), this.spinHour2.getValue(), this.spinMin2.getValue(), this.spinSec2.getValue(), 0);
                break;
            }
            default: {
                System.out.println("Category Type: " + this.categoryType + " not yet supported");
            }
        }
        return tsValue;
    }

    public void resetRangeValues() {
        Timestamp ts1 = new Timestamp(70, 0, 1, 0, 0, 0, 0);
        Timestamp ts2 = new Timestamp(150, 11, 31, 23, 59, 59, 0);
        this.setRangeValue(0, ts1);
        this.setRangeValue(1, ts2);
    }

    public String getScaleValue() {
        return this.scaleValue.getText();
    }

    public int getScaleUnit() {
        String unitValue = this.unitChoice.getSelectedItem().toString();
        if (unitValue.equalsIgnoreCase("years")) {
            return 6;
        }
        if (unitValue.equalsIgnoreCase("months")) {
            return 5;
        }
        if (unitValue.equalsIgnoreCase("weeks")) {
            return 4;
        }
        if (unitValue.equalsIgnoreCase("days")) {
            return 3;
        }
        if (unitValue.equalsIgnoreCase("hours")) {
            return 2;
        }
        if (unitValue.equalsIgnoreCase("minutes")) {
            return 1;
        }
        if (unitValue.equalsIgnoreCase("seconds")) {
            return 0;
        }
        return 7;
    }

    public void setScaleUnit(int unit) {
        String target = null;
        switch (unit) {
            case 6: {
                target = "years";
                break;
            }
            case 5: {
                target = "months";
                break;
            }
            case 4: {
                target = "weeks";
                break;
            }
            case 3: {
                target = "days";
                break;
            }
            case 2: {
                target = "hours";
                break;
            }
            case 1: {
                target = "minutes";
                break;
            }
            case 0: {
                target = "seconds";
                break;
            }
        }
        int count = this.unitChoice.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!this.unitChoice.getItem(i).equals(target)) continue;
            this.unitChoice.select(i);
            break;
        }
    }

    public void disableBound(int index, boolean disable) {
        switch (this.categoryType) {
            case 91: 
            case 93: {
                if (index == 0) {
                    this.spinYear1.setEnabled(!disable);
                    this.spinMonth1.setEnabled(!disable);
                    this.spinDay1.setEnabled(!disable);
                } else {
                    this.spinYear2.setEnabled(!disable);
                    this.spinMonth2.setEnabled(!disable);
                    this.spinDay2.setEnabled(!disable);
                }
                if (this.categoryType == 91) break;
            }
            case 92: {
                if (index == 0) {
                    this.spinHour1.setEnabled(!disable);
                    this.spinMin1.setEnabled(!disable);
                    this.spinSec1.setEnabled(!disable);
                    break;
                }
                this.spinHour2.setEnabled(!disable);
                this.spinMin2.setEnabled(!disable);
                this.spinSec2.setEnabled(!disable);
            }
        }
    }

    public boolean isLinearScale() {
        String linearValue = this.linearChoice.getSelectedItem().toString();
        return linearValue.equalsIgnoreCase("true");
    }

    public void setLinearScale(boolean linearValue) {
        if (linearValue) {
            this.linearChoice.select(1);
        } else {
            this.linearChoice.select(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target instanceof OurButton) {
            this.fireEvent((OurButton)target, 1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object target = e.getSource();
        if (target == this.disableLowerBound) {
            if (this.disableLowerBound.getState()) {
                this.disableBound(0, true);
                if (this.disableUpperBound.getState()) {
                    // empty if block
                }
            } else {
                this.disableBound(0, false);
            }
        }
        if (target == this.disableUpperBound) {
            if (this.disableUpperBound.getState()) {
                this.disableBound(1, true);
                if (this.disableLowerBound.getState()) {
                    // empty if block
                }
            } else {
                this.disableBound(1, false);
            }
        }
    }

    private void initializeDialog(int type) {
        this.okButton = new OurButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new OurButton("Cancel");
        this.cancelButton.addActionListener(this);
        if (this.enableAggregate) {
            this.aggregateButton = new OurButton("Advanced");
            this.aggregateButton.addActionListener(this);
            this.buttonPanel.add(this.aggregateButton);
            this.enableZoom = new OurCheckbox("Enable Zooming");
            if (!this.isForDrillDown) {
                this.southPanel.add(this.enableZoom);
            }
        }
        this.disableLowerBound = new OurCheckbox("Disable Lower Bound");
        this.disableUpperBound = new OurCheckbox("Disable Upper Bound");
        this.disableLowerBound.addItemListener(this);
        this.disableUpperBound.addItemListener(this);
        this.southPanel.add(this.disableLowerBound);
        this.southPanel.add(this.disableUpperBound);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.unitChoice = new OurChoice();
        this.scaleValue = new OurTextField("", 4);
        this.linearChoice = new OurChoice();
        this.linearChoice.add("false");
        this.linearChoice.add("true");
        switch (type) {
            case 93: {
                this.unitChoice.add("years");
                this.unitChoice.add("months");
                this.unitChoice.add("weeks");
                this.unitChoice.add("days");
                this.unitChoice.add("hours");
                this.unitChoice.add("minutes");
                this.unitChoice.add("seconds");
                int totalRow = 3;
                if (!this.isForDrillDown) {
                    ++totalRow;
                }
                if (this.isLinearEnabled) {
                    ++totalRow;
                }
                this.rangePanel.setLayout(new GridLayout(totalRow, 7, 5, 5));
                this.rangePanel.add(new JLabel(""));
                this.rangePanel.add(new JLabel("year  "));
                this.rangePanel.add(new JLabel("month  "));
                this.rangePanel.add(new JLabel("day  "));
                this.rangePanel.add(new JLabel("hour  "));
                this.rangePanel.add(new JLabel("minute  "));
                this.rangePanel.add(new JLabel("second "));
                this.spinYear1 = new SpinBox(1970, 2050, 1);
                this.spinYear2 = new SpinBox(1970, 2050, 1);
                this.spinMonth1 = new SpinBox(1, 12, 1);
                this.spinMonth2 = new SpinBox(1, 12, 1);
                this.spinDay1 = new SpinBox(1, 31, 1);
                this.spinDay2 = new SpinBox(1, 31, 1);
                this.spinHour1 = new SpinBox(0, 23, 1);
                this.spinHour2 = new SpinBox(0, 23, 1);
                this.spinMin1 = new SpinBox(0, 59, 1);
                this.spinMin2 = new SpinBox(0, 59, 1);
                this.spinSec1 = new SpinBox(0, 59, 1);
                this.spinSec2 = new SpinBox(0, 59, 1);
                this.rangePanel.add(new JLabel("Lower Bound: "));
                this.rangePanel.add(this.spinYear1);
                this.rangePanel.add(this.spinMonth1);
                this.rangePanel.add(this.spinDay1);
                this.rangePanel.add(this.spinHour1);
                this.rangePanel.add(this.spinMin1);
                this.rangePanel.add(this.spinSec1);
                this.rangePanel.add(new JLabel("Upper Bound: "));
                this.rangePanel.add(this.spinYear2);
                this.rangePanel.add(this.spinMonth2);
                this.rangePanel.add(this.spinDay2);
                this.rangePanel.add(this.spinHour2);
                this.rangePanel.add(this.spinMin2);
                this.rangePanel.add(this.spinSec2);
                if (!this.isForDrillDown) {
                    this.rangePanel.add(new JLabel("Scale: "));
                    this.rangePanel.add(this.scaleValue);
                    this.rangePanel.add(this.unitChoice);
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                }
                if (this.isLinearEnabled) {
                    this.rangePanel.add(new JLabel("Linear: "));
                    this.rangePanel.add(this.linearChoice);
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                }
                this.selectUnit("days");
                break;
            }
            case 91: {
                this.unitChoice.add("years");
                this.unitChoice.add("months");
                this.unitChoice.add("weeks");
                this.unitChoice.add("days");
                int totalRow = 3;
                if (!this.isForDrillDown) {
                    ++totalRow;
                }
                if (this.isLinearEnabled) {
                    ++totalRow;
                }
                this.rangePanel.setLayout(new GridLayout(totalRow, 4, 5, 5));
                this.rangePanel.add(new JLabel(""));
                this.rangePanel.add(new JLabel("year  "));
                this.rangePanel.add(new JLabel("month  "));
                this.rangePanel.add(new JLabel("day  "));
                this.spinYear1 = new SpinBox(1970, 2050, 1);
                this.spinYear2 = new SpinBox(1970, 2050, 1);
                this.spinMonth1 = new SpinBox(1, 12, 1);
                this.spinMonth2 = new SpinBox(1, 12, 1);
                this.spinDay1 = new SpinBox(1, 31, 1);
                this.spinDay2 = new SpinBox(1, 31, 1);
                this.rangePanel.add(new JLabel("Lower Bound: "));
                this.rangePanel.add(this.spinYear1);
                this.rangePanel.add(this.spinMonth1);
                this.rangePanel.add(this.spinDay1);
                this.rangePanel.add(new JLabel("Upper Bound: "));
                this.rangePanel.add(this.spinYear2);
                this.rangePanel.add(this.spinMonth2);
                this.rangePanel.add(this.spinDay2);
                if (!this.isForDrillDown) {
                    this.rangePanel.add(new JLabel("Scale: "));
                    this.rangePanel.add(this.scaleValue);
                    this.rangePanel.add(this.unitChoice);
                    this.rangePanel.add(new JLabel(""));
                }
                if (this.isLinearEnabled) {
                    this.rangePanel.add(new JLabel("Linear: "));
                    this.rangePanel.add(this.linearChoice);
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                }
                this.selectUnit("days");
                break;
            }
            case 92: {
                this.unitChoice.add("hours");
                this.unitChoice.add("minutes");
                this.unitChoice.add("seconds");
                int totalRow = 3;
                if (!this.isForDrillDown) {
                    ++totalRow;
                }
                if (this.isLinearEnabled) {
                    ++totalRow;
                }
                this.rangePanel.setLayout(new GridLayout(totalRow, 4, 5, 5));
                this.rangePanel.add(new JLabel(""));
                this.rangePanel.add(new JLabel("hour  "));
                this.rangePanel.add(new JLabel("minute  "));
                this.rangePanel.add(new JLabel("second  "));
                this.spinHour1 = new SpinBox(0, 23, 1);
                this.spinHour2 = new SpinBox(0, 23, 1);
                this.spinMin1 = new SpinBox(0, 59, 1);
                this.spinMin2 = new SpinBox(0, 59, 1);
                this.spinSec1 = new SpinBox(0, 59, 1);
                this.spinSec2 = new SpinBox(0, 59, 1);
                this.rangePanel.add(new JLabel("Lower Bound: "));
                this.rangePanel.add(this.spinHour1);
                this.rangePanel.add(this.spinMin1);
                this.rangePanel.add(this.spinSec1);
                this.rangePanel.add(new JLabel("Upper Bound: "));
                this.rangePanel.add(this.spinHour2);
                this.rangePanel.add(this.spinMin2);
                this.rangePanel.add(this.spinSec2);
                if (!this.isForDrillDown) {
                    this.rangePanel.add(new JLabel("Scale: "));
                    this.rangePanel.add(this.scaleValue);
                    this.rangePanel.add(this.unitChoice);
                    this.rangePanel.add(new JLabel(""));
                }
                if (this.isLinearEnabled) {
                    this.rangePanel.add(new JLabel("Linear: "));
                    this.rangePanel.add(this.linearChoice);
                    this.rangePanel.add(new JLabel(""));
                    this.rangePanel.add(new JLabel(""));
                }
                this.selectUnit("hours");
            }
        }
        if (this.spinYear2 != null) {
            this.spinYear2.setValue(2050);
        }
        if (this.spinMonth2 != null) {
            this.spinMonth2.setValue(12);
        }
        if (this.spinDay2 != null) {
            this.spinDay2.setValue(31);
        }
        if (this.spinHour2 != null) {
            this.spinHour2.setValue(23);
        }
        if (this.spinMin2 != null) {
            this.spinMin2.setValue(59);
        }
        if (this.spinSec2 != null) {
            this.spinSec2.setValue(59);
        }
    }

    public void setYear(int index, int value) {
        if (index == 0) {
            this.spinYear1.setValue(value);
        } else {
            this.spinYear2.setValue(value);
        }
    }

    public void setMonth(int index, int value) {
        if (index == 0) {
            this.spinMonth1.setValue(value);
        } else {
            this.spinMonth2.setValue(value);
        }
    }

    public void setDay(int index, int value) {
        if (index == 0) {
            this.spinDay1.setValue(value);
        } else {
            this.spinDay2.setValue(value);
        }
    }

    public void setHour(int index, int value) {
        if (index == 0) {
            this.spinHour1.setValue(value);
        } else {
            this.spinHour2.setValue(value);
        }
    }

    public void setMinute(int index, int value) {
        if (index == 0) {
            this.spinMin1.setValue(value);
        } else {
            this.spinMin2.setValue(value);
        }
    }

    public void setSecond(int index, int value) {
        if (index == 0) {
            this.spinSec1.setValue(value);
        } else {
            this.spinSec2.setValue(value);
        }
    }

    public void setRangeValue(int index, Timestamp tsValue) {
        Object tsString = null;
        switch (index) {
            case 0: {
                if (this.categoryType == 93 || this.categoryType == 91) {
                    this.spinYear1.setValue(tsValue.getYear() + 1900);
                    this.spinMonth1.setValue(tsValue.getMonth() + 1);
                    this.spinDay1.setValue(tsValue.getDate());
                }
                if (this.categoryType != 93 && this.categoryType != 92) break;
                this.spinHour1.setValue(tsValue.getHours());
                this.spinMin1.setValue(tsValue.getMinutes());
                this.spinSec1.setValue(tsValue.getSeconds());
                break;
            }
            case 1: {
                if (this.categoryType == 93 || this.categoryType == 91) {
                    this.spinYear2.setValue(tsValue.getYear() + 1900);
                    this.spinMonth2.setValue(tsValue.getMonth() + 1);
                    this.spinDay2.setValue(tsValue.getDate());
                }
                if (this.categoryType != 93 && this.categoryType != 92) break;
                this.spinHour2.setValue(tsValue.getHours());
                this.spinMin2.setValue(tsValue.getMinutes());
                this.spinSec2.setValue(tsValue.getSeconds());
            }
        }
    }

    public void setScaleValue(String value) {
        this.scaleValue.setText(value);
    }

    public Timestamp getTimestamp(Chart chart, String value) {
        Object[] fName;
        Timestamp ts = null;
        ColData coldata = chart.colData[chart.getCategoryIndex()];
        for (Object element : fName = coldata.getFieldName()) {
            if (element == null || !value.equals(element.toString())) continue;
            ts = new Timestamp(((Date)element).getTime());
        }
        return ts;
    }

    public void extractPreprocInfo(Chart chart) {
        PreprocInfo tsInfo = chart.getPreprocInfo();
        int categoryType = chart.getCategoryType();
        ColData coldata = chart.colData[chart.getCategoryIndex()];
        Object[] fName = coldata.getFieldName();
        long lowerBound = 0L;
        long upperBound = 0L;
        if (fName != null && (tsInfo.lBound == null || tsInfo.uBound == null)) {
            Date min = null;
            Date max = null;
            for (Object element : fName) {
                if (element == null || !(element instanceof Date)) continue;
                if (min == null || min.after((Date)element)) {
                    min = (Date)element;
                }
                if (max != null && !max.before((Date)element)) continue;
                max = (Date)element;
            }
            String lowerVal = null;
            String upperVal = null;
            if (min != null) {
                lowerVal = min.toString();
                upperVal = max.toString();
            }
            for (int i = 0; i < fName.length; ++i) {
                if (fName[i] == null || fName[i].equals("") || !(fName[i] instanceof Date)) continue;
                if (lowerVal != null && lowerVal.equals(fName[i].toString())) {
                    lowerBound = ((Date)fName[i]).getTime();
                }
                if (upperVal == null || !upperVal.equals(fName[i].toString())) continue;
                upperBound = ((Date)fName[i]).getTime();
            }
        }
        if (tsInfo.lBound != null) {
            this.setRangeValue(0, (Timestamp)tsInfo.lBound);
        } else {
            this.setRangeValue(0, new Timestamp(lowerBound));
        }
        if (tsInfo.uBound != null) {
            this.setRangeValue(1, (Timestamp)tsInfo.uBound);
        } else {
            this.setRangeValue(1, new Timestamp(upperBound));
        }
        if (tsInfo.unit >= 0) {
            this.setScaleUnit(tsInfo.unit);
        } else {
            this.setScaleUnit(tsInfo.uUnit);
        }
        if (tsInfo.intervalNum.intValue() != 0) {
            this.scaleValue.setText(tsInfo.intervalNum.toString());
        } else {
            this.scaleValue.setText(Integer.toString(tsInfo.uInterval));
        }
        this.setLinearScale(tsInfo.isLinear);
        if (this.enableAggregate) {
            this.enableZoom.setState(chart.isTimeChart());
        }
        if (tsInfo.lBound == null) {
            this.disableLowerBound.setState(true);
            this.disableBound(0, true);
        }
        if (tsInfo.uBound == null) {
            this.disableUpperBound.setState(true);
            this.disableBound(1, true);
        }
    }

    public void cancelZoom(boolean cZoom) {
        this.undoZoom = cZoom;
    }

    public void fillPreprocInfo(Chart chart) {
        this.fillPreprocInfo(chart, false);
    }

    public void fillPreprocInfo(Chart chart, boolean performDynamicZooming) {
        PreprocInfo tsInfo = chart.getPreprocInfo();
        int categoryType = chart.getCategoryType();
        if (!this.enableAggregate) {
            if (!this.undoZoom) {
                chart.setTimeChart(true);
            } else {
                chart.setTimeChart(false);
            }
        } else if (this.enableZoom.getState()) {
            chart.setTimeChart(true);
        } else {
            chart.setTimeChart(false);
            chart.clearPreprocInfo();
        }
        tsInfo.aggrColIndex[0] = chart.getPrimaryIndex() + 1;
        if (chart.getSecondaryIndex() != -1) {
            tsInfo.aggrColIndex[1] = chart.getSecondaryIndex() + 1;
        }
        if (chart.getSeriesIndex() >= 0) {
            tsInfo.groupColIndex[0] = chart.getSeriesIndex() + 1;
        }
        if (chart.getSumByIndex() >= 0) {
            tsInfo.groupColIndex[1] = chart.getSumByIndex() + 1;
        }
        tsInfo.selectColIndex = chart.getCategoryIndex() + 1;
        tsInfo.lBound = this.disableLowerBound.getState() ? null : this.getRangeValue(0);
        tsInfo.uBound = this.disableUpperBound.getState() ? null : this.getRangeValue(1);
        if (!this.isForDrillDown) {
            tsInfo.intervalNum = Integer.parseInt(this.getScaleValue());
            tsInfo.unit = this.getScaleUnit();
            if (performDynamicZooming) {
                tsInfo.intervalNum = 1;
                tsInfo.lInterval = 1;
                tsInfo.uInterval = 1;
                tsInfo.unit = this.getScaleUnit();
            }
        } else {
            tsInfo.intervalNum = 1;
            tsInfo.lInterval = 1;
            tsInfo.uInterval = 1;
            if (categoryType == 91) {
                tsInfo.unit = 3;
                tsInfo.lUnit = 3;
                tsInfo.uUnit = 3;
            } else {
                tsInfo.unit = 0;
                tsInfo.lUnit = 0;
                tsInfo.uUnit = 0;
            }
        }
        tsInfo.bRounded = true;
        tsInfo.isLinear = this.isLinearScale();
        if (this.enableAggregate && !this.enableZoom.getState()) {
            chart.clearPreprocInfo();
        }
        if (!this.enableAggregate && this.undoZoom) {
            tsInfo.lBound = null;
            tsInfo.uBound = null;
            tsInfo.isLinear = false;
            tsInfo.bRounded = false;
        }
    }

    public boolean isValidScale(Chart chart) {
        long scaleVal;
        PreprocInfo tsInfo = chart.getPreprocInfo();
        if (this.enableAggregate && !this.enableZoom.getState()) {
            return true;
        }
        try {
            scaleVal = DateTime.getTotalSeconds(Integer.parseInt(this.getScaleValue()), this.getScaleUnit());
        }
        catch (Exception ex) {
            return false;
        }
        long minVal = DateTime.getTotalSeconds(tsInfo.lInterval, tsInfo.lUnit);
        long maxVal = DateTime.getTotalSeconds(tsInfo.uInterval, tsInfo.uUnit);
        return scaleVal >= minVal && scaleVal <= maxVal;
    }

    public String getStringScale(int value, int unit) {
        String output = null;
        output = Integer.toString(value);
        switch (unit) {
            case 6: {
                if (value > 1) {
                    output = output + "  years ";
                    break;
                }
                output = output + "  year ";
                break;
            }
            case 5: {
                if (value > 1) {
                    output = output + "  months ";
                    break;
                }
                output = output + "  month ";
                break;
            }
            case 4: {
                if (value > 1) {
                    output = output + "  weeks ";
                    break;
                }
                output = output + "  week ";
                break;
            }
            case 3: {
                if (value > 1) {
                    output = output + "  days ";
                    break;
                }
                output = output + "  day ";
                break;
            }
            case 2: {
                if (value > 1) {
                    output = output + "  hours ";
                    break;
                }
                output = output + "  hour ";
                break;
            }
            case 1: {
                if (value > 1) {
                    output = output + "  minutes ";
                    break;
                }
                output = output + "  minute ";
                break;
            }
            case 0: {
                output = value > 1 ? output + "  seconds " : output + "  second ";
            }
        }
        return output;
    }

    public synchronized void addItemListener(ItemListener l) {
        this.enableZoom.addItemListener(l);
    }

    private void selectUnit(String target) {
        int count = this.unitChoice.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!this.unitChoice.getItem(i).equals(target)) continue;
            this.unitChoice.select(i);
            break;
        }
    }

    public boolean isValidRange() {
        Timestamp end;
        if (this.disableLowerBound.getState() || this.disableUpperBound.getState()) {
            return true;
        }
        Timestamp start = this.getRangeValue(0);
        return !start.after(end = this.getRangeValue(1));
    }

    public void enableOptions(boolean enable) {
        boolean upperBoundEnabled;
        boolean lowerBoundEnabled = !this.disableLowerBound.isSelected();
        boolean bl = upperBoundEnabled = !this.disableUpperBound.isSelected();
        if (this.spinYear1 != null) {
            this.spinYear1.setEnabled(enable && lowerBoundEnabled);
            this.spinYear2.setEnabled(enable && upperBoundEnabled);
        }
        if (this.spinMonth1 != null) {
            this.spinMonth1.setEnabled(enable && lowerBoundEnabled);
            this.spinMonth2.setEnabled(enable && upperBoundEnabled);
        }
        if (this.spinDay1 != null) {
            this.spinDay1.setEnabled(enable && lowerBoundEnabled);
            this.spinDay2.setEnabled(enable && upperBoundEnabled);
        }
        if (this.spinHour1 != null) {
            this.spinHour1.setEnabled(enable && lowerBoundEnabled);
            this.spinHour2.setEnabled(enable && upperBoundEnabled);
        }
        if (this.spinMin1 != null) {
            this.spinMin1.setEnabled(enable && lowerBoundEnabled);
            this.spinMin2.setEnabled(enable && upperBoundEnabled);
        }
        if (this.spinSec1 != null) {
            this.spinSec1.setEnabled(enable && lowerBoundEnabled);
            this.spinSec2.setEnabled(enable && upperBoundEnabled);
        }
        this.unitChoice.setEnabled(enable);
        this.disableLowerBound.setEnabled(enable);
        this.disableUpperBound.setEnabled(enable);
        this.scaleValue.setEnabled(enable);
        this.linearChoice.setEnabled(enable);
        this.aggregateButton.setEnabled(enable);
    }
}

