/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.OLAP;

import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Result;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.internal.DataType;

public class MondrianResultSet
implements IOLAPResultSet {
    private Result result;

    public MondrianResultSet(String connectionString, String MDXQuery) {
        Connection connection = DriverManager.getConnection((String)connectionString, null, (boolean)false);
        Query query = connection.parseQuery(MDXQuery);
        this.result = connection.execute(query);
        if (this.result.getAxes().length < 2) {
            this.close();
            throw new IllegalArgumentException("The query has to have columns as well as rows!");
        }
    }

    @Override
    public int getColumnCount() {
        return this.getAxisMemberCount(0);
    }

    @Override
    public Object[] getColumnLabel(int index) {
        return this.getAxisNames(0, index);
    }

    @Override
    public int getRowCount() {
        return this.getAxisMemberCount(1);
    }

    @Override
    public Object[] getRowLabel(int index) {
        return this.getAxisNames(1, index);
    }

    @Override
    public Object getCell(int column, int row) {
        Cell cell = this.result.getCell(new int[]{column, row});
        return cell.isNull() ? null : cell.getValue();
    }

    @Override
    public int getColumnLabelDataType() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Object[] tmp = this.getColumnLabel(i);
            for (int j = 0; j < tmp.length; ++j) {
                if (tmp[j] == null) continue;
                return DataType.findType(tmp[j]);
            }
        }
        return 12;
    }

    @Override
    public int getRowLabelDataType() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object[] tmp = this.getRowLabel(i);
            for (int j = 0; j < tmp.length; ++j) {
                if (tmp[j] == null) continue;
                return DataType.findType(tmp[j]);
            }
        }
        return 12;
    }

    @Override
    public int getCellDataType() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            for (int j = 0; j < this.getRowCount(); ++j) {
                Object tmp = this.getCell(i, j);
                if (tmp == null) continue;
                return DataType.findType(tmp);
            }
        }
        return 8;
    }

    @Override
    public String[] getRowBreakColumnHeader() {
        return null;
    }

    public void close() {
        this.result.close();
    }

    @Override
    public int getColumnBreakCount() {
        return this.getAxisMemberLength(0);
    }

    @Override
    public int getRowBreakCount() {
        return this.getAxisMemberLength(1);
    }

    private int getAxisMemberCount(int index) {
        return this.result.getAxes()[index].positions.length;
    }

    private int getAxisMemberLength(int index) {
        return this.result.getAxes()[index].positions[0].members.length;
    }

    private Object[] getAxisNames(int axis, int index) {
        Member[] members = this.result.getAxes()[axis].positions[index].members;
        Object[] names = new Object[members.length];
        for (int i = 0; i < members.length; ++i) {
            String tmp;
            int idx;
            names[i] = members[i].getUniqueName();
            if (names[i] == null || !(names[i] instanceof String) || (idx = (tmp = (String)names[i]).lastIndexOf(".[")) <= 0 || tmp.charAt(tmp.length() - 1) != ']') continue;
            tmp = tmp.substring(idx + 2);
            tmp = tmp.substring(0, tmp.length() - 1);
            names[i] = tmp;
        }
        return names;
    }
}

